<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;

/**
 * Model\Entity\CashierExpense
 *
 * @ORM\Entity()
 * @ORM\Table(name="cashier_expense", indexes={@ORM\Index(name="fk_cashier_has_item_cashier1_idx", columns={"id_cashier"})})
 */
class CashierExpense extends AbstractEntity
{
    const ENTRADA = "e";
    const ENTRADA_CLIENTE = "ec";
    const SAIDA = "s";

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="`type`", type="string", length=2)
     */
    protected $type;

    /**
     * @ORM\Column(type="datetime")
     */
    protected $expenseDate;

    /**
     * @ORM\Column(type="string", length=100)
     */
    protected $description;

    /**
     * @ORM\ManyToOne(targetEntity="Cashier", inversedBy="cashierExpenses")
     * @ORM\JoinColumn(name="id_cashier", referencedColumnName="id", nullable=false)
     *
     * @JMS\Exclude()
     */
    protected $cashier;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $amount;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $price;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $total;

    /**
     * @ORM\Column(name="obs", type="string", nullable=true)
     */
    protected $obs;

    /**
     * @ORM\Column(name="longitude", type="decimal", precision=19, scale=8, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $longitude;

    /**
     * @ORM\Column(name="latitude", type="decimal", precision=19, scale=8, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $latitude;


    public function __construct()
    {
        parent::__construct();;
    }

    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    public function getType()
    {
        return $this->type;
    }

    public function setExpenseDate($expenseDate)
    {
        $this->expenseDate = $expenseDate;

        return $this;
    }

    public function getExpenseDate()
    {
        return $this->expenseDate;
    }

    public function getExpenseDateFormatted()
    {
        return $this->expenseDate ? $this->expenseDate->format('d/m/Y H:i') : "";
    }

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    public function getDescription()
    {
        return $this->description;
    }

    public function setCashier(Cashier $cashier = null)
    {
        $this->cashier = $cashier;

        return $this;
    }

    public function getCashier()
    {
        return $this->cashier;
    }

    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    public function getAmount()
    {
        return $this->amount;
    }

    public function getAmountRound()
    {
        return number_format($this->amount, 0);
    }

    public function setPrice($price)
    {
        $this->price = $price;

        return $this;
    }

    public function getPrice()
    {
        return $this->price;
    }

    public function getPriceCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->price);
    }

    public function getPriceCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->price);
    }

    public function setTotal($total)
    {
        $this->total = $total;

        return $this;
    }

    public function getTotal()
    {
        return $this->total;
    }
    
    public function getTotalCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->total);
    }
    
    public function getTotalCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->total);
    }

    public function getObs()
    {
        return $this->obs;
    }

    public function setObs($obs)
    {
        $this->obs = $obs;
    }

    public function getLatitude()
    {
        return $this->latitude;
    }

    public function setLatitude($latitude)
    {
        $this->latitude = $latitude;
    }

    public function getLongitude()
    {
        return $this->longitude;
    }

    public function setLongitude($longitude)
    {
        $this->longitude = $longitude;
    }

    public static function types(){
        return array(
            Cashier::INPUT => 'Entrada',
            Cashier::OUTPUT => 'Saída'
        );
    }

    public function getTypeDescription(){
        switch ($this->getType()) {
            case Cashier::INPUT:
                return "Entrada";
                break;
            case Cashier::OUTPUT:
                return "Saída";
                break;
            default:
                break;
        }
        return "";
    }

    public function __sleep()
    {
        return array('cashier', 'amount', 'price', 'total');
    }
}