<?php
namespace Model\Datatable;

class ProductDatatable extends \Commons\Datatable\DataTable {
    
    public function findAll(){
        
        if (! $this->getConfiguration()) {
            // Este array deve ser na ordem das colunas da listagem
            $configuration = array(
                'id',
                'name',
                'description',
            );
            $this->setConfiguration($configuration);
        }           

        /**
         * Irá montar os dados que serão exibidos no DataTable
         *
         * Neste tutorial, a sequencia da listagem está sendo: 'id', 'name', 'description'.
         * Desta forma, o array que será atribuido a variável DataTable::aaData deve estar
         * na mesma sequencia.
         */ 
        if (! $this->getAaData()) {
            $aaData = array();

            foreach ($this->getPaginator() as $product) {
                $data = array(
                    'id' => $product->id,
                    'name' => $product->name,
                    'description' => $product->description,
                    'options' => "<a class='btn' href='/product/edit/{$product->id}'>Editar</a> "
                        . "<a class='btn btn-danger' href='/product/delete/{$product->id}'>Excluir</a>",
                );

                $aaData[] = $data;
            }

            $this->setAaData($aaData);
        }
        
        // return $this->getJson();
        return $this->getArrayCopy();
        
    }
    
}