<?php

namespace Commons\Util;

/**
 * Description of Ghost script util
 *
 * @author Renato Peterman <renato.pet at gmail.com>
 */

class GhostScriptUtil
{
    const BINARY_PATH = '/usr/bin/gs';

    public static function generatePDFPreview($src, $dest)
    {
        // /usr/bin/gs -o out.jpg -sDEVICE=jpeg -r144 -dLastPage=1 arquivo.pdf
        $cmd = escapeshellcmd(static::BINARY_PATH . " -o '".$dest."' -sDEVICE=jpeg -r144 -dLastPage=1 '".$src."'");
        return shell_exec($cmd);
    }

    public static function isAvailable() {
        $returnVal = shell_exec("which " . static::BINARY_PATH);
        return (empty($returnVal) ? false : true);
    }

}

?>
