<?php
namespace Commons\Listener;

use Herrera\Phar\Update\Exception\Exception;
use Zend\EventManager\StaticEventManager;
use Zend\Crypt\Password\Bcrypt;
use Db\Entity\Media;
use Db\Entity\People;
use Db\Entity\Role;
use Db\Entity\Defect;
use Db\Entity\Part;
use Db\Entity\Solution;
use Db\Entity\MechanicService;
use Db\Entity\MechanicalRequestDefect;
use Db\Entity\MechanicalRequestPart;
use Db\Entity\MechanicalRequestSolution;
use Db\Entity\MeshTissueVariant;
use Db\Entity\EmployeeRole;
use Db\Entity\PeopleNotificationGroup;
use Doctrine\ORM\QueryBuilder;

class DoctrineResourceListener
{
    public function setupDoctrineResourceListeners($e)
    {

        $application = $e->getApplication();

        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'create.pre',
            function ($e)  {
                $objEntity = $e->getEntity();

                //$objManager = $e->getDoctrineResource()->getObjectManager();

                $content = $e->getResourceEvent()->getRequest()->getContent();
                if (empty($content) === false)
                    $content = json_decode($content, true);


                switch(get_class($objEntity)){
                    case 'Model\Entity\Product':
                        try {

                            if (isset($content['image64']) && empty($content['image64']) === false) {
                                $imageCode = trim($content['image64']);

                                if (strstr($imageCode, "image/png") !== false)
                                    $extension = "png";
                                else if (strstr($imageCode, "image/gif") !== false)
                                    $extension = "gif";
                                else
                                    $extension = "jpg";

                                if (strstr($imageCode, 'base64,') !== false) {
                                    $imageCode = explode('base64,', $imageCode);
                                    if (isset($imageCode[1]))
                                        $imageCode = $imageCode[1];
                                }

                                $objEntity->setFileResource($imageCode, true, $extension);
                            }

                        } catch(Exception $e) {
                            //throw new Exception($e->getMessage());
                        }
                    break;
                }
            }
        );
        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'create.post',
            function ($e)  {

                /*
                $objEntity = $e->getEntity();

                $objManager = $e->getDoctrineResource()->getObjectManager();

                $content = $e->getResourceEvent()->getRequest()->getContent();
                if (empty($content) === false)
                    $content = json_decode($content, true);

                switch(get_class($objEntity)){
                    case 'Model\Entity\Product':
                        try {

                            if (isset($content['image64']) && empty($content['image64']) === false) {
                                $imageCode = trim($content['image64']);
                                $objEntity->setFileResource($imageCode, true);
                                $objManager->persist($objEntity);
                                $objManager->flush($objEntity);
                            }

                        } catch(Exception $e) {
                            //throw new Exception($e->getMessage());
                        }
                    break;
                }
                */

            }
        );

        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'update.pre',
            function ($e)  {

                $objEntity = $e->getEntity();

                //$objManager = $e->getDoctrineResource()->getObjectManager();

                $content = $e->getResourceEvent()->getRequest()->getContent();
                if (empty($content) === false)
                    $content = json_decode($content, true);


                switch(get_class($objEntity)){
                    case 'Model\Entity\Product':
                        try {

                            if (isset($content['image64']) && empty($content['image64']) === false) {
                                $imageCode = trim($content['image64']);

                                if (strstr($imageCode, "image/png") !== false)
                                    $extension = "png";
                                else if (strstr($imageCode, "image/gif") !== false)
                                    $extension = "gif";
                                else
                                    $extension = "jpg";

                                if (strstr($imageCode, 'base64,') !== false) {
                                    $imageCode = explode('base64,', $imageCode);
                                    if (isset($imageCode[1]))
                                        $imageCode = $imageCode[1];
                                }

                                $objEntity->setFileResource($imageCode, true, $extension);
                            }

                        } catch(Exception $e) {
                            //throw new Exception($e->getMessage());
                        }
                    break;
                }
            }
        );
        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'update.post',
            function ($e) {

                /*
                $objEntity = $e->getEntity();

                $objManager = $e->getDoctrineResource()->getObjectManager();

                $content = $e->getResourceEvent()->getRequest()->getContent();
                if (empty($content) === false)
                    $content = json_decode($content, true);

                switch(get_class($objEntity)){
                    case 'Model\Entity\Product':
                        try {

                            if (isset($content['image64']) && empty($content['image64']) === false) {
                                $imageCode = trim($content['image64']);
                                $objEntity->setFileResource($imageCode, true);
                                $objManager->persist($objEntity);
                                $objManager->flush($objEntity);
                            }

                        } catch(Exception $e) {
                            //throw new Exception($e->getMessage());
                        }
                        break;
                }
                */
            }
        );

        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'fetch.post',
            function ($e)  {

            }
        );
        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'fetch-all.pre',
            function ($e) use ($application)  {

                /*
                $arrayMapR = function ($func, $arr, $arrayMapR) {
                    $newArr = array();
                    foreach($arr as $key => $value ) {
                        $newArr[$key] = (
                        is_array($value) ?
                            $arrayMapR($func, $value, $arrayMapR) :
                            (is_array($func) ? call_user_func_array($func, $value) : $func($value))
                        );
                    }
                    return $newArr;
                };

                // Fetch filter criteria
                $request = $application->getRequest()->getQuery()->toArray();

                if (!isset($request['query']) && !isset($request['orderByQuery'])) {
                    return;
                }

                if (isset($request['query']))
                    $request['query'] = json_decode($request['query'], true);
                if (isset($request['query']['type']))
                    $request['query'] = array($request['query']);

                $request['orderBy'] = array();

                if (isset($request['orderByQuery']))
                    $request['orderBy'] = json_decode($request['orderByQuery'], true);

                if (isset($request['orderBy']['type']))
                    $request['orderBy'] = array($request['orderBy']);

                if (is_array($request) && count($request) > 0)
                    $request = $arrayMapR('strip_tags', $request, $arrayMapR);

                //die(print_r($request['query']));
                //die(print_r($request['orderBy']));

                $objectManager = $application->getServiceManager()->get('doctrine.entitymanager.orm_default');

                if (isset($request['query']) && count($request['query']) > 0) {
                    $filterManagers = array();
                    $filterManagers[] = $application->getServiceManager()->get('ZfDoctrineQueryBuilderFilterManagerOrm');
                    foreach ($filterManagers as $filterManager) {
                        $filterManager->filter(
                            $e->getQueryBuilder(),
                            $objectManager->getMetadataFactory()->getAllMetadata()[0],
                            $request['query']
                        );
                    }
                }

                if (isset($request['orderBy']) && count($request['orderBy']) > 0) {
                    $orderByManagers = array();
                    $orderByManagers[] = $application->getServiceManager()->get('ZfDoctrineQueryBuilderOrderByManagerOrm');
                    foreach ($orderByManagers as $orderByManager) {
                        $orderByManager->orderBy(
                            $e->getQueryBuilder(),
                            $objectManager->getMetadataFactory()->getAllMetadata()[0],
                            $request['orderBy']
                        );
                    }
                }
                */
            }
        );
        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'fetch-all.post',
            function ($e)  use ($application)  {
                /*
                $resource = $e->getResourceEvent();
                if (is_object($resource)) {
                    //die(get_class($resource));
                }
                */
            }
        );

        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'patch.pre',
            function ($e)  {

            }
        );
        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'delete.pre',
            function ($e)  {

                /*
                $objEntity = $e->getEntity();

                $objManager = $e->getDoctrineResource()->getObjectManager();

                $content = $e->getResourceEvent()->getRequest()->getContent();
                if (empty($content) === false)
                    $content = json_decode($content, true);

                $arrayMapR = function ($func, $arr, $arrayMapR) {
                    $newArr = array();
                    foreach($arr as $key => $value ) {
                        $newArr[$key] = (
                        is_array($value) ?
                            $arrayMapR($func, $value, $arrayMapR) :
                            (is_array($func) ? call_user_func_array($func, $value) : $func($value))
                        );
                    }
                    return $newArr;
                };

                if (is_array($content) && count($content) > 0)
                    $content = $arrayMapR('strip_tags', $content, $arrayMapR);

                $rev = $e->getResourceEvent();
                if (is_object($rev->getIdentity()) && is_array($rev->getIdentity()->getAuthenticationIdentity())) {
                    $identity = $rev->getIdentity()->getAuthenticationIdentity();
                    $userAccess = $objManager->getRepository('\Db\Entity\UserAccess')->findOneBy(array("login" => trim($identity['user_id'])));
                    if (is_object($userAccess)) {
                        $log = new \Db\Entity\UserLog();
                        $log->setAction('delete.pre');
                        $log->setEntity(get_class($objEntity));
                        $log->setEntityId($objEntity->getId());
                        if (is_array($content) && count($content) > 0)
                            $log->setParams(serialize($content));
                        $log->setCreated(new \DateTime('now', new \DateTimeZone('America/Sao_Paulo')));
                        $log->setUpdated(new \DateTime('now', new \DateTimeZone('America/Sao_Paulo')));
                        $log->setUserAccess($userAccess);
                        $objManager->persist($log);
                        $objManager->flush();
                    }
                }
                */
            }
        );
        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'delete.post',
            function ($e)  {

                /*
                $objEntity = $e->getEntity();

                $objManager = $e->getDoctrineResource()->getObjectManager();

                $content = $e->getResourceEvent()->getRequest()->getContent();
                if (empty($content) === false)
                    $content = json_decode($content, true);

                $arrayMapR = function ($func, $arr, $arrayMapR) {
                    $newArr = array();
                    foreach($arr as $key => $value ) {
                        $newArr[$key] = (
                        is_array($value) ?
                            $arrayMapR($func, $value, $arrayMapR) :
                            (is_array($func) ? call_user_func_array($func, $value) : $func($value))
                        );
                    }
                    return $newArr;
                };

                if (is_array($content) && count($content) > 0)
                    $content = $arrayMapR('strip_tags', $content, $arrayMapR);

                $rev = $e->getResourceEvent();
                if (is_object($rev->getIdentity()) && is_array($rev->getIdentity()->getAuthenticationIdentity())) {
                    $identity = $rev->getIdentity()->getAuthenticationIdentity();
                    $userAccess = $objManager->getRepository('\Db\Entity\UserAccess')->findOneBy(array("login" => trim($identity['user_id'])));
                    if (is_object($userAccess)) {
                        $log = new \Db\Entity\UserLog();
                        $log->setAction('delete.post');
                        $log->setEntity(get_class($objEntity));
                        $log->setEntityId($objEntity->getId());
                        if (is_array($content) && count($content) > 0)
                            $log->setParams(serialize($content));
                        $log->setCreated(new \DateTime('now', new \DateTimeZone('America/Sao_Paulo')));
                        $log->setUpdated(new \DateTime('now', new \DateTimeZone('America/Sao_Paulo')));
                        $log->setUserAccess($userAccess);
                        $objManager->persist($log);
                        $objManager->flush();
                    }
                }
                */
            }
        );
        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'delete-list.pre',
            function ($e)  {

            }
        );
        StaticEventManager::getInstance()->attach('ZF\Apigility\Doctrine\DoctrineResource', 'delete-list.post',
            function ($e)  {

            }
        );

    }
}
