<?php

/**
 * Description of DefaultCrypt
 *
 * @author Renato Peterman <renato.pet at gmail.com>
 */

namespace Commons\Crypt;

use Zend\Crypt\BlockCipher;

class DefaultCrypt {
    
    /**
     * Encode a string using AES Algorithm
     *
     * @param  string $string
     * @return string
     */
    public static function encrypt($string, $urlSafe = true, $key = "29_0+6fke/sc)d*5") {
        $string = (string) $string;
	    $blockCipher = BlockCipher::factory('mcrypt', array('algo' => 'aes'));
        $blockCipher->setKey($key);
        $str = $blockCipher->encrypt($string);
        return $urlSafe ? strtr($str, '+/=', '-_,') : $str;
    }
    
    /**
     * Decode a string using AES Algorithm
     *
     * @param  string $string
     * @return string
     */
    public static function decrypt($string, $urlSafe = true, $key = "29_0+6fke/sc)d*5") {
        $string = (string) $string;
	    $blockCipher = BlockCipher::factory('mcrypt', array('algo' => 'aes'));
        $blockCipher->setKey($key);
        $res = $urlSafe ? strtr($string, '-_,', '+/=') : $string;
        return $blockCipher->decrypt($res);
    }

    public static function aes128_cbc_encrypt($data, $key = "29_0+6fke/sc)d*5", $iv = '0000000000000000') {
        if(16 !== strlen($key)) $key = hash('MD5', $key, true);
        if(16 !== strlen($iv)) $iv = hash('MD5', $iv, true);
        $padding = 16 - (strlen($data) % 16);
        $data .= str_repeat(chr($padding), $padding);
        //return base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $data, MCRYPT_MODE_CBC, null));
        return @base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $data, MCRYPT_MODE_CBC, null));
    }

    public static function aes256_cbc_encrypt($key, $data, $iv) {
        if(32 !== strlen($key)) $key = hash('SHA256', $key, true);
        if(16 !== strlen($iv)) $iv = hash('MD5', $iv, true);
        $padding = 16 - (strlen($data) % 16);
        $data .= str_repeat(chr($padding), $padding);
        return mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $data, MCRYPT_MODE_CBC, $iv);
    }

    public static function aes128_cbc_decrypt($key, $data, $iv) {
        if(16 !== strlen($key)) $key = hash('MD5', $key, true);
        if(16 !== strlen($iv)) $iv = hash('MD5', $iv, true);
        $data = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, $key, $data, MCRYPT_MODE_CBC, $iv);
        $padding = ord($data[strlen($data) - 1]);
        return substr($data, 0, -$padding);
    }

    public static function aes256_cbc_decrypt($key, $data, $iv) {
        if(32 !== strlen($key)) $key = hash('SHA256', $key, true);
        if(16 !== strlen($iv)) $iv = hash('MD5', $iv, true);
        $data = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, $key, $data, MCRYPT_MODE_CBC, $iv);
        $padding = ord($data[strlen($data) - 1]);
        return substr($data, 0, -$padding);
    }
    
}

?>
