<?php

namespace Commons\Apigility\Doctrine\Server\Resource;

/**
 * Class CustomDoctrineResource
 * @author Renato Peterman <renato.pet@gmail.com>
 * @description Added support to collection save
 */

class CustomDoctrineResource extends \ZF\Apigility\Doctrine\Server\Resource\DoctrineResource {

    /**
     * Create a resource
     *
     * @param  mixed $data
     * @return ApiProblem|mixed
     * @override
     */
    public function create($data)
    {
        if(!count(array_filter(array_keys((array)$data), 'is_string'))){ // if is_assoc function = multiple records

            $entityClass = $this->getEntityClass();

            $data = $this->getQueryCreateFilter()->filter($this->getEvent(), $entityClass, $data);
            if ($data instanceof ApiProblem) {
                return $data;
            }

            $entities = array();
            foreach($data as $entityData){

                $entity = new $entityClass;
                $hydrator = $this->getHydrator();
                $hydrator->hydrate((array) $entityData, $entity);

                $results = $this->triggerDoctrineEvent(DoctrineResourceEvent::EVENT_CREATE_PRE, $entity);
                if ($results->last() instanceof ApiProblem) {
                    return $results->last();
                }

                $this->getObjectManager()->persist($entity);
                $this->getObjectManager()->flush();
                $results = $this->triggerDoctrineEvent(DoctrineResourceEvent::EVENT_CREATE_POST, $entity);
                if ($results->last() instanceof ApiProblem) {
                    return $results->last();
                }

                $entities[] = $entity;
            }

            return $entities;

        }else{

            // Default call
            return parent::create($data);

        }
    }

}