<?php

/**
 * Description of Product Form

 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Application\Form;

use Zend\Form\Form;

class ProductForm extends Form {
    
    public function __construct($em) {
        parent::__construct('Product');
        
        $this->setAttributes(array(
            'novalidate' => 'novalidate',
            'name' => 'productForm',
            'role' => 'form',
            'class' => 'form-horizontal form-validate',
        ));

        $this->add(array(
            'name' => 'id',
            'type' => 'hidden',
        ));

        $this->add(array(
            'name' => 'imageFile',
            'type' => 'Zend\Form\Element\File',
            'attributes' => array(
                'id' => 'imageFile',
                'class' => 'form-control'
            )
        ));
        
        $this->add(array(
            'name' => 'name',
            'type' => 'Zend\Form\Element\Text',
            'options' => array(
                'label' => 'Nome'
            ),
            'attributes' => array(
                'class' => 'form-control',
                'placeholder' => 'Obrigatório',
                'required' => 'true',
                'data-ng-model' => "productTitle"
            )
        ));

        $this->add(array(
            'name' => 'description',
            'type' => 'Zend\Form\Element\Text',
            'options' => array(
                'label' => 'Descrição'
            ),
            'attributes' => array(
                'name' => 'description',
                'class' => 'form-control',
                'placeholder' => 'Descrição do Produto'
            )
        ));

        $this->add(array(
            'name' => 'reference',
            'type' => 'Zend\Form\Element\Text',
            'options' => array(
                'label' => 'Referência'
            ),
            'attributes' => array(
                'id' => 'reference',
                'class' => 'form-control',
                'placeholder' => 'Referência'
            )
        ));

        $this->add(array(
            'name' => 'cost',
            'type' => 'Zend\Form\Element\Text',
            'options' => array(
                'label' => 'Preço de Custo'
            ),
            'attributes' => array(
                'id' => 'cost',
                'class' => 'form-control mask-money',
                'placeholder' => 'Custo',
                'required' => true
            )
        ));

        $this->add(array(
            'name' => 'price',
            'type' => 'Zend\Form\Element\Text',
            'options' => array(
                'label' => 'Preço'
            ),
            'attributes' => array(
                'id' => 'price',
                'class' => 'form-control mask-money',
                'placeholder' => 'Preço',
                'required' => true
            )
        ));

        $this->add(array(
            'name' => 'priceMin',
            'type' => 'Zend\Form\Element\Text',
            'options' => array(
                'label' => 'Preço Mín.'
            ),
            'attributes' => array(
                'id' => 'priceMin',
                'class' => 'form-control mask-money',
                'placeholder' => 'Preço mínimo',
                'required' => true
            )
        ));

        $this->add(array(
            'name' => 'commission',
            'type' => 'Zend\Form\Element\Text',
            'options' => array(
                'label' => 'Comissão'
            ),
            'attributes' => array(
                'id' => 'commission',
                'class' => 'form-control mask-money',
                'placeholder' => 'Comissão'
            )
        ));

        $this->add(array(
            'name' => 'barcode',
            'type' => 'Zend\Form\Element\Text',
            'options' => array(
                'label' => 'Código de Barras'
            ),
            'attributes' => array(
                'id' => 'barcode',
                'class' => 'form-control',
                'placeholder' => 'Código de Barras'
            )
        ));

        $this->add(array(
            'name' => 'groupPrimary',
            'type' => 'Commons\Form\Element\OptionalObjectSelect',
            'options' => array(
                'label' => 'Grupo',
                'object_manager' => $em,
                'target_class' => 'Model\Entity\Group',
                'display_empty_item' => true,
                'empty_item_label' => '---',
                'empty_option' => '---'
            ),
            'attributes' => array(
                'id' => 'groupPrimary',
                'class' => 'form-control select2',
                'required' => false
            )
        ));

        $this->add(array(
            'name' => 'groupSecondary',
            'type' => 'Commons\Form\Element\OptionalObjectSelect',
            'options' => array(
                'label' => 'SubGrupo',
                'object_manager' => $em,
                'target_class' => 'Model\Entity\Group',
                'display_empty_item' => true,
                'empty_item_label' => '---',
                'empty_option' => '---'
            ),
            'attributes' => array(
                'id' => 'groupSecondary',
                'class' => 'form-control select2',
                'required' => false
            )
        ));

        $this->add(array(
            'name' => 'unit',
            'required' => 'false',
            'type' => 'Commons\Form\Element\OptionalObjectSelect',
            'options' => array(
                'label' => 'Unidade de Medida',
                'object_manager' => $em,
                'target_class' => 'Model\Entity\Unit',
                'display_empty_item' => true,
                'empty_item_label' => '---',
                'empty_option' => '---'
            ),
            'attributes' => array(
                'id' => 'unit',
                'class' => 'form-control select2'
            )
        ));

        $this->add(array(
            'name' => 'active',
            'type' => 'Zend\Form\Element\Checkbox',
            'options' => array(
                'label' => 'Ativo?'
            ),
            'attributes' => array(
                'id' => 'active',
                'class' => ''
            )
        ));

        $this->add(array(
            'name' => 'info',
            'type' => 'Zend\Form\Element\Text',
            'options' => array(
                'label' => 'Outras Informações'
            ),
            'attributes' => array(
                'id' => 'info',
                'class' => 'form-control',
                'placeholder' => 'Outras informações sobre o produto'
            )
        ));

        $this->add(array(
            'name' => 'representedCompanies',
            'required' => 'false',
            'type' => 'Commons\Form\Element\OptionalObjectSelect',
            'options' => array(
                'label' => 'Representadas',
                'object_manager' => $em,
                'target_class' => 'Model\Entity\RepresentedCompany',
                'display_empty_item' => false
            ),
            'attributes' => array(
                'class' => 'form-control select2',
                'multiple' => true,
            )
        ));

        $this->add(array(
            'name' => 'colors',
            'required' => 'false',
            'type' => 'Commons\Form\Element\OptionalObjectSelect',
            'options' => array(
                'label' => 'Cores',
                'object_manager' => $em,
                'target_class' => 'Model\Entity\Color',
                'display_empty_item' => false
            ),
            'attributes' => array(
                'class' => 'form-control select2',
                'multiple' => true,
            )
        ));

        $this->add(array(
            'name' => 'sizes',
            'required' => 'false',
            'type' => 'Commons\Form\Element\OptionalObjectSelect',
            'options' => array(
                'label' => 'Tamanhos',
                'object_manager' => $em,
                'target_class' => 'Model\Entity\Size',
                'display_empty_item' => false
            ),
            'attributes' => array(
                'class' => 'form-control select2',
                'multiple' => true,
            )
        ));

        /*
        $this->add(array(
            'name' => 'submit',
            'type' => 'submit',
            'attributes' => array(
                'value' => 'Entrar',
                'id' => 'submitbutton',
                'class' => 'btn btn-lg btn-primary btn-block'
            ),
        ));
        */

    }
    
}

?>
