<?php

/**
 * Description of LoginForm
 *
 * @author Renato Peterman <renato.pet at gmail.com>
 */

namespace Application\Form;

use Zend\Form\Form;

class LoginForm extends Form {
    
    public function __construct() {
        parent::__construct('Login');
        
        $this->setAttributes(array(
            /*
            'method' => 'post',
            'class' => 'form-signin',
            'id' => 'form-signin',
             */
            'novalidate' => 'novalidate',
            'name' => 'loginForm',
            'role' => 'form',
            'data-ng-submit' => 'submit(loginForm)'
        ));
        
        /* CSRF
        $this->add(array(
            'type' => 'Zend\Form\Element\Csrf',
            'name' => 'token',
            'options' => array(
                'csrf_options' => array(
                    'timeout' => 600
                )
            ),
            'attributes' => array(
                'data-ng-model' => 'data.token'
            )
        ));
        */
        
        $this->add(array(
            'name' => 'username',
            'type' => 'text',
            'attributes' => array(
                'class' => 'input-medium form-control',
                'placeholder' => 'Nome de Usuário',
                'required' => 'true',
                'data-ng-model' => 'data.username'
            )
        ));
        
        $this->add(array(
            'name' => 'password',
            'type' => 'password',
            'attributes' => array(
                'class' => 'input-medium form-control',
                'placeholder' => 'Senha',
                'required' => 'true',
                'data-ng-model' => 'data.password'
            )
        ));
        
        $this->add(array(
            'name' => 'remember',
            'type' => 'checkbox',
            'attributes' => array(
                'data-ng-model' => 'data.remember'
            )
        ));
        
        $this->add(array(
            'name' => 'submit',
            'type' => 'submit',
            'attributes' => array(
                'value' => 'Entrar',
                'id' => 'submitbutton',
                'class' => 'btn btn-lg btn-primary btn-block'
            ),
        ));
        
        /*
        $this->add(array(
            'name' => 'submit',
            'type' => 'Zend\Form\Element\Button',
            'options' => array(
                'label' => 'Entrar',
                'label_options' => array(
                    'disable_html_escape' => true,
                )
            ),
            'attributes' => array(
                'data-ng-click' => 'submit(loginForm)',
                'value' => 'Entrar',
                'id' => 'submitbutton',
                'class' => 'btn btn-lg btn-primary btn-block'
            ),
        ));
         *
         */
    }
    
}

?>
