<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2014 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Zend\View\Model\JsonModel;
use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class WarehouseTransactionGroupController extends AbstractApplicationController
{

    public function indexAction()
    {
        $qb = $this->getEntityManager()->createQueryBuilder($this->getEntityClass())
                ->select('obj')
                ->from($this->getEntityClass(), 'obj');
        
        if(!$this->identity()->isAdmin()){
            $qb->where('obj.user = :user')
                    ->setParameter('user', $this->identity());

            // Get Main Warehouses
            $mainWarehouses = $this->getEntityManager()->getRepository("Model\\Entity\\Warehouse")->findBy(array('main' => true, 'active' => true));

            // Get user Warehouses
            $userWarehouses = $this->getEntityManager()->createQueryBuilder()
                ->select('w')
                ->from('Model\Entity\Device','obj')
                //->join('Model\Entity\Warehouse AS w WITH obj.warehouse = w')
                ->innerJoin('Model\Entity\Warehouse','w')
                ->andWhere('obj.warehouse = w')
                ->andWhere('obj.user = :loggedUser')
                ->andWhere('w.main != true')
                ->setParameter('loggedUser', $this->identity())
                ->getQuery()->getResult();

            $warehouses = array_merge($mainWarehouses, $userWarehouses);

        }else{
            $warehouses = $this->getEntityManager()->getRepository("Model\\Entity\\Warehouse")->findAll();
        }

        $qb->orderBy('obj.id','DESC');
        
        //$data = $this->getEntityManager()->getRepository($this->getEntityClass())->findAll();
        $data = $qb->getQuery()->getResult();

        // $warehouses = $this->getEntityManager()->getRepository("Model\Entity\Warehouse")->findAll();
        return new ViewModel(array('data' => $data, 'warehouses' => $warehouses));
    }
    
    public function getProductsAction(){
        
        try{
            
            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new \Exception('Id inválido');
            }
            
            $obj = $this->getEntityManager()->find('Model\Entity\WarehouseTransactionGroup', $id);
            if(!$obj){
                throw new \Exception('Objeto não encontrado');
            }
            
            $retorno = array();
            foreach($obj->getWarehouseTransactions() as $tr){
                
                $whFrom = null;
                if($tr->getWarehouseFrom()){
                    $whFrom = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $tr->getProduct(), 'warehouse' => $tr->getWarehouseFrom()));
                }
                
                $whTo = null;
                if($tr->getWarehouseTo()){
                    $whTo = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $tr->getProduct(), 'warehouse' => $tr->getWarehouseTo()));
                }
                
                $retorno[] = array(
                    'id' => (string)$tr->getProduct()->getId(),
                    'product' => $tr->getProduct()->getName(),
                    'fromStock' => $whFrom ? $whFrom->getAmount() : "",
                    'toStock' => $whTo ? $whTo->getAmount() : "",
                    'amount' => round($tr->getAmount())
                );
            }
            
            return $this->createJsonResponse($retorno);
            
        }catch(\Exception $ex){
            return $this->createJsonResponse(array('error' => true, 'message' => $ex->getMessage()));
        }
        
    }
    
    public function formAction()
    {
        $type = $this->params()->fromQuery('type', false);
        $from = $this->params()->fromQuery('from', false);
        $to = $this->params()->fromQuery('to', false);

        $warehouseFrom = false;
        
        // Save for the first time
        if($this->getRequest()->isPost()){
            
            $action = $this->params()->fromPost('action', 'save');
            $id = $this->params()->fromPost('id', false);
            $type = $this->params()->fromPost('type', false);
            $from = $this->params()->fromPost('from', false);
            $to = $this->params()->fromPost('to', false);
            
            $products = $this->params()->fromPost('product');
            if(!$products){
                throw new \Exception('Lista de produtos inválida. Nenhum produto adicionado.');
            }

            // Save
            if(!$id){
                
                $obj = new \Model\Entity\WarehouseTransactionGroup();
                $obj->setTransactionType($type);
                $obj->setUser($this->identity());
                $obj->setStatus(false);
                $obj->setDescription($this->params()->fromPost('description',null));

                if($from){
                    $warehouseFrom = $this->getEntityManager()->find('Model\Entity\Warehouse', $from);
                    $obj->setWarehouseFrom($warehouseFrom);
                }

                $warehouseTo = null;
                if($to){
                    $warehouseTo = $this->getEntityManager()->find('Model\Entity\Warehouse', $to);
                    $obj->setWarehouseTo($warehouseTo);
                }

                $this->getEntityManager()->persist($obj);
                $this->getEntityManager()->flush();
                
                foreach($products as $key => $value){

                    $product = $this->getEntityManager()->find('Model\Entity\Product', $key);
                    if(!$product){
                        throw new \Exception('Erro ao adicionar produto');
                    }

                    if(!$value){
                        throw new \Exception("A quantidade precisa ser maior que zero");
                    }

                    $wt = new \Model\Entity\WarehouseTransaction();
                    $wt->setProduct($product);
                    $wt->setWarehouseTransactionGroup($obj);
                    $wt->setAmount($value);
                    $wt->setDescription($this->params()->fromPost('description',null));
                    $wt->setTransactionType($type);
                    $wt->setWarehouseFrom($warehouseFrom);
                    $wt->setWarehouseTo($warehouseTo);
                    $wt->setUser($this->identity());

                    // Admin e confirm action movimenta estoque
                    if($this->identity()->isAdmin() && $action == 'confirm'){

                        if($warehouseFrom){
                            $pwFrom = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $product, 'warehouse' => $warehouseFrom));
                            $pwFrom->subtract($wt->getAmount());
                            $this->getEntityManager()->merge($pwFrom);
                            $this->getEntityManager()->flush();
                        }

                        if($warehouseTo){
                            $pwTo = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $product, 'warehouse' => $warehouseTo));
                            $pwTo->increase($wt->getAmount());
                            $this->getEntityManager()->merge($pwTo);
                            $this->getEntityManager()->flush();
                        }

                    }

                    $this->getEntityManager()->persist($wt);
                    $this->getEntityManager()->flush();
                }

                if($this->identity()->isAdmin() && $action == 'confirm'){
                    $obj->setStatus(true);
                }else{
                    $obj->setStatus(false);
                }

                $this->getEntityManager()->merge($obj);
                $this->getEntityManager()->flush();

                $this->flashMessenger()->addSuccessMessage("Movimentação efetuada com sucesso!");
                return $this->redirectToDefaultRoute();
                
            }else{
                
                $obj = $this->getEntityManager()->find('Model\Entity\WarehouseTransactionGroup', $id);
                if(!$obj){
                    throw new \Exception('Transação não encontrada');
                }
                
                // check products list from form first
                // if not add product
                foreach($products as $key => $value){
                    
                    $hasProduct = false;
                    
                    foreach($obj->getWarehouseTransactions() as $wt){
                        
                        if($wt->getProduct()->getId() == intval($key)){                            
                            $hasProduct = true;
                            if($value > 0){
                                $wt->setAmount($value);
                                $this->getEntityManager()->merge($wt);
                            }else{
                                $this->getEntityManager()->remove($wt);
                            }
                        }
                    }
                    
                    if(!$hasProduct){

                        $product = $this->getEntityManager()->find('Model\Entity\Product', $key);
                        if(!$product){
                            throw new \Exception('Erro ao adicionar produto');
                        }

                        $wt = new \Model\Entity\WarehouseTransaction();
                        $wt->setProduct($product);
                        $wt->setWarehouseTransactionGroup($obj);
                        $wt->setAmount($value);
                        $wt->setDescription($obj->getDescription());
                        $wt->setTransactionType($obj->getTransactionType());
                        $wt->setWarehouseFrom($obj->getWarehouseFrom());
                        $wt->setWarehouseTo($obj->getWarehouseTo());
                        $wt->setUser($this->identity());

                        $this->getEntityManager()->persist($wt);

                    }
                    
                }
                
                $this->getEntityManager()->merge($obj);
                $this->getEntityManager()->flush();
                
                // Check for removed records
                foreach($obj->getWarehouseTransactions() as $wt){
                    
                    $hasProduct = false;
                    foreach($products as $key => $value){
                        if($wt->getProduct()->getId() == $key){
                            $hasProduct = true;
                        }
                    }
                    
                    if(!$hasProduct){
                        $this->getEntityManager()->remove($wt);
                    }
                    
                }
                
                // Admin e confirm action movimenta estoque
                if($this->identity()->isAdmin() && $action == 'confirm'){

                    foreach($obj->getWarehouseTransactions() as $wt){
                        
                        $product = $wt->getProduct();
                        
                        if($obj->getTransactionType() == \Model\Entity\WarehouseTransaction::TYPE_TRANSFERENCIA){
                            
                            $warehouseFrom = $wt->getWarehouseFrom();
                            if($warehouseFrom){
                                $pwFrom = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $product, 'warehouse' => $warehouseFrom));
                                $pwFrom->subtract($wt->getAmount());
                                $this->getEntityManager()->merge($pwFrom);
                                $this->getEntityManager()->flush();
                            }
                            
                        }

                        $warehouseTo = $wt->getWarehouseTo();
                        if($warehouseTo){
                            $pwTo = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $product, 'warehouse' => $warehouseTo));
                            $pwTo->increase($wt->getAmount());
                            $this->getEntityManager()->merge($pwTo);
                            $this->getEntityManager()->flush();
                        }
                        
                    }
                    
                    $obj->setStatus(true);

                }
                
                $this->getEntityManager()->merge($obj);
                $this->getEntityManager()->flush();
                
                $this->flashMessenger()->addSuccessMessage("Movimentação alterada com sucesso!");
                return $this->redirectToDefaultRoute();
                
            }
            
        }

        if($from){

            $warehouseFrom = $this->getEntityManager()->find('Model\Entity\Warehouse', $from);
            $listProductWarehouse = $this->getEntityManager()->createQueryBuilder('Model\Entity\ProductWarehouse')
                ->select("obj")
                ->from('Model\Entity\ProductWarehouse', 'obj')
                ->join('obj.product', 'pro')
                ->where('obj.warehouse = :wh AND obj.amount > 0 AND pro.active = 1')
                ->setParameter('wh', $warehouseFrom)
                ->getQuery()->getResult();

            $listProducts = array();
            foreach($listProductWarehouse as $pw){
                $listProducts[] = $pw->getProduct();
            }

        }else{
            $listProducts = $this->getEntityManager()->getRepository('Model\Entity\Product')->findByActive(true);
        }
        $warehouseTo = $this->getEntityManager()->find('Model\Entity\Warehouse', $to);

        $entity = null;
        $id = $this->params()->fromRoute('id',false);
        if($id){
           $entity = $this->getEntityManager()->find('Model\Entity\WarehouseTransactionGroup', $id);
           $type = $entity->getTransactionType();
           $warehouseFrom = $entity->getWarehouseFrom();
           $warehouseTo = $entity->getWarehouseTo();
        }

        return new ViewModel(array('warehouseFrom' => $warehouseFrom, 'warehouseTo' => $warehouseTo, 'type' => $type, 'listProducts' => $listProducts, 'entity' => $entity));
    }
    
    public function checkStockAction(){
        
        $from = $this->params()->fromPost('from', false);
        $to = $this->params()->fromPost('to', false);
        $product = $this->params()->fromPost('product', false);
        
        try{
            
            if(!$product){
                throw new \Exception('Produto inválido');
            }
            
            $productObj = $this->getEntityManager()->find('Model\Entity\Product', $product);
            if(!$productObj){
                throw new \Exception('Produto não encontrado');
            }
            
            $retorno = array();
            
            if($from){
                $warehouseFrom = $this->getEntityManager()->find('Model\Entity\Warehouse', $from);
                $fromPw = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $product, 'warehouse' => $warehouseFrom));
                $retorno['fromStock'] = is_object($fromPw) ? $fromPw->getAmount() : 0 ;
            }
            $warehouseTo = $this->getEntityManager()->find('Model\Entity\Warehouse', $to);
            $toPw = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $product, 'warehouse' => $warehouseTo));
            $retorno['toStock'] = is_object($toPw) ? $toPw->getAmount() : 0 ;
            $retorno['product'] = $productObj->getName();
            
            return $this->createJsonResponse($retorno);
            
        }catch(\Exception $ex){
            return $this->createJsonResponse(array('error' => true, 'message' => $ex->getMessage()));
        }
        
    }

    public function saveAction(){

        $responseData = array(
            'success' => false
        );

        try{

            // Save for the first time
            if(!$this->getRequest()->isPost()) {
                throw new \Exception("Requisição inválida");
            }

            $action = $this->params()->fromPost('action', 'save');
            $id = $this->params()->fromPost('id', false);
            $type = $this->params()->fromPost('type', false);
            $from = $this->params()->fromPost('from', false);
            $to = $this->params()->fromPost('to', false);
            $description = $this->params()->fromPost('description',null);

            $products = $this->params()->fromPost('product', array());
            if(is_array($products) === false || count($products) == 0){
                throw new \Exception('Lista de produtos inválida. Nenhum produto adicionado.');
            }

            // Save
            if(empty($id)){

                $obj = new \Model\Entity\WarehouseTransactionGroup();
                $obj->setTransactionType($type);
                $obj->setUser($this->identity());
                $obj->setStatus(false);
                $obj->setDescription($description);

                $warehouseFrom = null;
                if($from){
                    $warehouseFrom = $this->getEntityManager()->find('Model\Entity\Warehouse', $from);
                    if (is_object($warehouseFrom) === false)
                        throw new \Exception('Uma ou mais entidades não foram encontradas.');
                    $obj->setWarehouseFrom($warehouseFrom);
                }

                $warehouseTo = null;
                if($to){
                    $warehouseTo = $this->getEntityManager()->find('Model\Entity\Warehouse', $to);
                    if (is_object($warehouseTo) === false)
                        throw new \Exception('Uma ou mais entidades não foram encontradas.');
                    $obj->setWarehouseTo($warehouseTo);
                }

                if($this->identity()->isAdmin() && $action == 'confirm'){
                    $obj->setStatus(true);
                }else{
                    $obj->setStatus(false);
                }

                $this->getEntityManager()->persist($obj);

                foreach($products as $key => $value){

                    $product = $this->getEntityManager()->find('Model\Entity\Product', $key);
                    if(is_object($product) === false){
                        throw new \Exception('Erro ao adicionar produto');
                    }

                    if(is_numeric($value) === false || $value <= 0){
                        throw new \Exception("A quantidade precisa ser maior que zero");
                    }

                    $wt = new \Model\Entity\WarehouseTransaction();
                    $wt->setProduct($product);
                    $wt->setWarehouseTransactionGroup($obj);
                    $wt->setAmount($value);
                    $wt->setDescription($description);
                    $wt->setTransactionType($type);
                    $wt->setWarehouseFrom($warehouseFrom);
                    $wt->setWarehouseTo($warehouseTo);
                    $wt->setUser($this->identity());

                    // Admin e confirm action movimenta estoque
                    if($this->identity()->isAdmin() && $action == 'confirm'){

                        if($warehouseFrom){
                            $pwFrom = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $product, 'warehouse' => $warehouseFrom));
                            $pwFrom->subtract($wt->getAmount());
                            $this->getEntityManager()->persist($pwFrom);
                        }

                        if($warehouseTo){
                            $pwTo = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $product, 'warehouse' => $warehouseTo));
                            $pwTo->increase($wt->getAmount());
                            $this->getEntityManager()->persist($pwTo);
                        }

                    }

                    $this->getEntityManager()->persist($wt);
                }

                $this->getEntityManager()->flush();

            }else{

                $obj = $this->getEntityManager()->find('Model\Entity\WarehouseTransactionGroup', $id);
                if (is_object($obj) === false) {
                    throw new \Exception('Transação não encontrada');
                }

                $obj->setDescription($description);
                if ($this->identity()->isAdmin() && $action == 'confirm') //Set transaction confirmed if admin
                    $obj->setStatus(true);

                $this->getEntityManager()->persist($obj);

                $warehouseTransactions = array();
                $warehouseTransactionsIdToRemove = array();

                foreach($obj->getWarehouseTransactions() as $wt){
                    $warehouseTransactions[$wt->getId()] = $wt;
                }

                //Find product to update if value > 0 or set to remove if value == 0 or add if not exist
                foreach($products as $key => $value){

                    if (is_numeric($key) === false || $key <= 0) {
                        throw new \Exception("A quantidade precisa ser maior que zero");
                    }

                    $hasProduct = false;

                    foreach($warehouseTransactions as $wt){
                        if($wt->getProduct()->getId() == intval($key)){ //Find to update
                            $hasProduct = true;
                            if($value > 0){
                                $wt->setAmount($value);
                                $this->getEntityManager()->persist($wt);
                            }else{
                                $warehouseTransactionsIdToRemove[$wt->getId()] = $wt->getId();
                            }
                            break;
                        }
                    }

                    if(!$hasProduct){

                        $product = $this->getEntityManager()->find('Model\Entity\Product', $key);
                        if(!$product){
                            throw new \Exception('Erro ao adicionar produto');
                        }

                        $wt = new \Model\Entity\WarehouseTransaction();
                        $wt->setProduct($product);
                        $wt->setWarehouseTransactionGroup($obj);
                        $wt->setAmount($value);
                        $wt->setDescription($obj->getDescription());
                        $wt->setTransactionType($obj->getTransactionType());
                        $wt->setWarehouseFrom($obj->getWarehouseFrom());
                        $wt->setWarehouseTo($obj->getWarehouseTo());
                        $wt->setUser($this->identity());

                        $this->getEntityManager()->persist($wt);

                        $warehouseTransactions[] = $wt;

                    }

                }

                //List to remove or update stock if confirmed
                if (count($warehouseTransactions) > 0) {
                    foreach($warehouseTransactions as $wt){

                        if (is_object($wt) && isset($warehouseTransactionsIdToRemove[$wt->getId()]) === true) {

                            $this->getEntityManager()->remove($wt);

                        } else if (is_object($wt) && is_object($wt->getProduct()) && $this->identity()->isAdmin() && $action == 'confirm') {

                            $findProduct = false;
                            foreach($products as $key => $value){
                                if(
                                    $wt->getProduct()->getId() == $key
                                ){

                                    $findProduct = true;
                                    $product = $wt->getProduct();

                                    if($obj->getTransactionType() == \Model\Entity\WarehouseTransaction::TYPE_TRANSFERENCIA){

                                        $warehouseFrom = $wt->getWarehouseFrom();
                                        if($warehouseFrom){
                                            $pwFrom = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $product, 'warehouse' => $warehouseFrom));
                                            $pwFrom->subtract($wt->getAmount());
                                            $this->getEntityManager()->persist($pwFrom);
                                        }

                                    }

                                    $warehouseTo = $wt->getWarehouseTo();
                                    if($warehouseTo){
                                        $pwTo = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $product, 'warehouse' => $warehouseTo));
                                        $pwTo->increase($wt->getAmount());
                                        $this->getEntityManager()->persist($pwTo);
                                    }

                                }
                            }

                            if ($findProduct === false)
                                $this->getEntityManager()->remove($wt);

                        }

                    }
                }

                $this->getEntityManager()->flush();

            }

            $responseData['success'] = true;

        }catch(\Exception $ex){
            $responseData['message'] = $ex->getMessage();
        }

        return new JsonModel($responseData);

    }
    
    public function removeAction()
    {
        try{
            
            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new Exception('Código não encontrado.');
            }
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new Exception('Código não encontrado.');
            }
            
            $this->getEntityManager()->remove($entity);
            $this->getEntityManager()->flush();
            $this->flashMessenger()->addSuccessMessage('Registro removido com sucesso!');
            
            return $this->redirectToDefaultRoute();
        
        } catch (\Doctrine\DBAL\DBALException $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro<br/>Pode ser que o registro que você está tentando remover possua relações com outros registros que impedem sua remoção.");
        } catch (\Exception $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro: {$ex->getMessage()}");
        }
        
        return $this->redirectToDefaultRoute();
    }

    public function cancelAction()
    {
        try{

            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new Exception('Código não encontrado.');
            }

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new Exception('Código não encontrado.');
            }

            // Admin e confirm action movimenta estoque
            if($this->identity()->isAdmin()){

                foreach($entity->getWarehouseTransactions() as $wt){
                    if($wt->getWarehouseFrom()){
                        $pwFrom = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $wt->getProduct(), 'warehouse' => $wt->getWarehouseFrom()));
                        $pwFrom->increase($wt->getAmount());
                        $this->getEntityManager()->merge($pwFrom);
                    }

                    if($wt->getWarehouseTo()){
                        $pwTo = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $wt->getProduct(), 'warehouse' => $wt->getWarehouseTo()));
                        $pwTo->subtract($wt->getAmount());
                        $this->getEntityManager()->merge($pwTo);
                    }
                }

            }

            $entity->setStatus(false);
            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();
            $this->flashMessenger()->addSuccessMessage('O status da movimentação foi redefinido');

            return $this->redirectToDefaultRoute();

        } catch (\Doctrine\DBAL\DBALException $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro<br/>Pode ser que o registro que você está tentando remover possua relações com outros registros que impedem sua remoção.");
        } catch (\Exception $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro: {$ex->getMessage()}");
        }

        return $this->redirectToDefaultRoute();
    }
    
    public function printAction(){
        
        try{
            
            $this->layout('layout/print');
            
            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new \Exception("Id inválido");
            }
            
            $entity = $this->getEntityManager()->find('Model\Entity\WarehouseTransactionGroup', $id);
            if(!$entity){
                throw new \Exception("Nenhuma transação encontrada com este id");
            }
            
            $company = $this->getEntityManager()->getRepository('Model\Entity\Company')->getDefault();
            
            // Get products
            $products = array();
            foreach($entity->getWarehouseTransactions() as $tr){
                
                $whFrom = null;
                if($tr->getWarehouseFrom()){
                    $whFrom = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $tr->getProduct(), 'warehouse' => $tr->getWarehouseFrom()));
                }
                
                $whTo = null;
                if($tr->getWarehouseTo()){
                    $whTo = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $tr->getProduct(), 'warehouse' => $tr->getWarehouseTo()));
                }
                
                $products[] = array(
                    'id' => (string)$tr->getProduct()->getId(),
                    'product' => $tr->getProduct()->getName(),
                    'fromStock' => $whFrom ? $whFrom->getAmount() : "",
                    'toStock' => $whTo ? $whTo->getAmount() : "",
                    'amount' => round($tr->getAmount())
                );
            }
            
            return new ViewModel(array('entity' => $entity, 'company' => $company, 'products' => $products));
            
        }catch(\Exception $ex){
            
            $this->flashMessenger()->addErrorMessage("Ocorreu um erro ao processar sua solicitação. Descrição: " . $ex->getMessage());
            
        }
        
        return $this->redirectToDefaultRoute();
        
    }

}
