<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2014 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Model\Entity\User;
use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class UserController extends AbstractApplicationController
{   
    public function indexAction()
    {
        $data = $this->getEntityManager()->getRepository($this->getEntityClass())->findAll();
        return new ViewModel(array(
            'data' => $data,
            'isReachedUserLimit' => $this->isReachedUserLimit()
        ));
    }

    public function profileAction()
    {
        return new ViewModel();
    }
    
    public function changePasswordAction()
    {
        $id = $this->params()->fromRoute('id',false);
        $pwd = $this->params()->fromPost('password',false);
        
        if(!$id){
            $this->flashMessenger()->addErrorMessage('Id de usuário inválido');
            return $this->redirectToDefaultRoute();
        }
        
        if($this->getRequest()->isPost()){
            
            if(!$pwd){
                throw new \Exception('Senha inválida');
            }
            
            $user = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$user){
                throw new \Exception('Usuario nao encontrado');
            }
            
            $user->setPassword($pwd);
            $user->setSync(false); //Hiper
            
            $this->getEntityManager()->merge($user);
            $this->getEntityManager()->flush();
            
            $this->flashMessenger()->addSuccessMessage('Senha alterada com sucesso!');
            return $this->redirectToDefaultRoute();
            
        }
        
        return new ViewModel(array('userid' => $id));
    }
    
    public function updatePasswordAction()
    {
        return new ViewModel();
    }
    
    public function savePasswordAction()
    {
        if(!$this->getRequest()->isPost()){
            $this->redirectToDefaultRoute();
        }
        
        $pwd = $this->params()->fromPost('password', false);
        if(!$pwd){
            $this->flashMessenger()->addErrorMessage("Senha inválida");
            return $this->redirectToDefaultRoute('update-password');
        }
        
        $new = $this->params()->fromPost('newPassword', false);
        if(!$new){
            $this->flashMessenger()->addErrorMessage("Nova senha inválida");
            return $this->redirectToDefaultRoute('update-password');
        }
        
        $user = $this->getEntityManager()->find('Model\Entity\User', $this->identity()->getId());
        if(\Model\Entity\User::hashPassword($user, $pwd)){
            
            $user->setPassword($new);
            $user->setSync(false); //Hiper
            $this->getEntityManager()->merge($user);
            $this->getEntityManager()->flush();
            
            $this->flashMessenger()->addSuccessMessage("Senha alterada com sucesso!");
            return $this->redirectToDefaultRoute('update-password');
        }else{
            $this->flashMessenger()->addErrorMessage("Senha não confere");
            return $this->redirectToDefaultRoute('update-password');
        }
        
        
    }
    
    public function addAction()
    {
        if($this->isReachedUserLimit()){
            $this->redirectToDefaultRoute();
        }
        
        $entity = new $this->entityClass;
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));
        
        $request = $this->getRequest();
        
        if ($request->isPost()){
            
            $form->bind($entity);
            $form->setData($request->getPost());
            
            if($form->isValid()){
                
                $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
                $hydrator->hydrate($request->getPost()->toArray(), $entity);

                if (method_exists($entity, 'setSync')) //Hiper
                    $entity->setSync(false);
                
                $this->getEntityManager()->persist($entity);
                $this->getEntityManager()->flush();

                $this->flashMessenger()->addSuccessMessage('Registro inserido com sucesso!');
                
                return $this->redirectToDefaultRoute();
            }
            
            
        }
        
        return new ViewModel(array('form' => $form));
    }
    
    public function editAction()
    {
        $id = null;
        $request = $this->getRequest();
        
        if ($request->isPost()){
            $id = $this->params()->fromPost('id', false);
        }else{
            $id = $this->params()->fromRoute('id', false);
        }
        
        $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));
        $form->remove("password");

        if ($request->isPost()){
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $this->params()->fromPost('id'));
            
            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($request->getPost()->toArray(), $entity);
            //$usuario->populate($form->getData());

            if (method_exists($entity, 'setSync')) //Hiper
                $entity->setSync(false);

            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();

            $this->flashMessenger()->addSuccessMessage('Registro alterado com sucesso!');

            return $this->redirectToDefaultRoute();
            
        }else{
            $form->bind($entity);
        }
        
        return new ViewModel(array('form' => $form, 'entity' => $entity));
    }
    
    public function removeAction()
    {
        try{
            
            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new Exception('Código não encontrado.');
            }
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new Exception('Código não encontrado.');
            }
            
            $this->getEntityManager()->remove($entity);
            $this->getEntityManager()->flush();
            $this->flashMessenger()->addSuccessMessage('Registro removido com sucesso!');
            
            return $this->redirectToDefaultRoute();
        
        } catch (\Doctrine\DBAL\DBALException $ex) {

            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro<br/>Pode ser que o registro que você está tentando remover possua relações com outros registros que impedem sua remoção.");

        } catch (\Exception $ex) {

            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro: {$ex->getMessage()}");

        }
        
        return $this->redirectToDefaultRoute();
    }

    public function profilePictureAction(){

        try{

            $entity = $this->identity();
            if(!$entity){
                throw new \Exception("Nenhum usuário logado");
            }

            if(!$entity->getImage()){
                throw new \Exception("Image not found");
            }

            $filename = $entity->getProfilePicturePath();

            if(is_null($filename) || !file_exists($filename)){
                throw new \Exception("Image not found");
            }

            return $this->createFileResponse($filename, "image/jpg");

        }catch(\Exception $ex){

            return $this->createFileResponse(User::PATH_NO_PICTURE, "image/jpg");

        }

        return $this->createFileResponse(User::PATH_NO_PICTURE, "image/jpg");
    }

    public function meAction(){

        $serializer = $this->getServiceLocator()->get('jms_serializer.serializer');
        return $this->createCustomResponse( $serializer->serialize($this->identity(), "json") );

    }
}
