<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2014 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Zend\View\Model\JsonModel;
use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class UnitController extends AbstractApplicationController
{   
    public function indexAction()
    {
        $view = new ViewModel();
        //$view->setTerminal(true);
        return $view;
    }

    public function listAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from('Model\Entity\Unit', 'obj')
                ->getQuery()->getResult();

            $response = array();
            foreach($data as $obj){
                $response[] = $obj->getArrayCopyDT();
            }

        } catch (\Exception $ex) {
            $response['success'] = false;
            $response['message'] = $ex->getMessage();
        }

        return new \Zend\View\Model\JsonModel($response);

    }

    public function getAction(){

        try{

            $id = $this->params()->fromRoute('id',false);
            if(!$id){
                throw new \Exception('Invalid id');
            }

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            $response = array(
                'success' => true,
                'data' => $entity->getArrayCopy()
            );

        } catch (\Exception $ex) {
            $response['success'] = false;
            $response['message'] = $ex->getMessage();
        }

        return new JsonModel($response);

    }

    public function saveAction(){

        $response = array(
            'success' => false
        );

        try{

            $request = $this->getRequest();

            if (!$request->isPost()){
                throw new \Exception('Invalid request');
            }

            $postData = $request->getPost()->toArray();
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $postData['id']);
            if(!$entity){
                $entity = new $this->entityClass;
            }

            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($request->getPost()->toArray(), $entity);

            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();

            $response['success'] = true;

        }catch(\Exception $ex){
            $response['message'] = $ex->getMessage();
        }

        return new JsonModel($response);

    }
    
    public function addAction()
    {
        
        $entity = new $this->entityClass;
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));
        
        $request = $this->getRequest();
        
        if ($request->isPost()){
            
            $form->bind($entity);
            $form->setData($request->getPost());
            
            if($form->isValid()){
                
                $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
                $hydrator->hydrate($request->getPost()->toArray(), $entity);
                
                $this->getEntityManager()->persist($entity);
                $this->getEntityManager()->flush();

                $this->flashMessenger()->addSuccessMessage('Registro inserido com sucesso!');
                
                return $this->redirectToDefaultRoute();
            }
            
            
        }
        
        return new ViewModel(array('form' => $form));
    }
    
    public function editAction()
    {
        $id = null;
        $request = $this->getRequest();
        
        if ($request->isPost()){
            $id = $this->params()->fromPost('id', false);
        }else{
            $id = $this->params()->fromRoute('id', false);
        }
        
        $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));

        if ($request->isPost()){
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $this->params()->fromPost('id'));
            
            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($request->getPost()->toArray(), $entity);
            //$usuario->populate($form->getData());

            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();

            $this->flashMessenger()->addSuccessMessage('Registro alterado com sucesso!');

            return $this->redirectToDefaultRoute();
            
        }else{
            $form->bind($entity);
        }
        
        return new ViewModel(array('form' => $form, 'entity' => $entity));
    }

    public function removeAction(){

        try{

            $id = $this->params()->fromRoute('id',false);
            if(!$id){
                throw new \Exception('Invalid id');
            }

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new \Exception('Register not found');
            }

            $this->getEntityManager()->remove($entity);
            $this->getEntityManager()->flush();

            $response = array('success' => true);

        } catch (\Exception $ex) {
            $response['success'] = false;
            $response['message'] = $ex->getMessage();
        }

        return new JsonModel($response);

    }

}
