<?php

namespace Application\Controller;

use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class RepresentedCompanyController extends AbstractApplicationController
{   
    public function indexAction()
    {

        $data = $this->getEntityManager()->getRepository($this->getEntityClass())->findAll();
        return new ViewModel(array('data' => $data));
    }
    
    public function addAction()
    {
        
        $entity = new $this->entityClass;
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));
        
        $request = $this->getRequest();
        
        if ($request->isPost()){
            
            $post = $request->getPost()->toArray();
            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($post, $entity);

            $this->getEntityManager()->persist($entity);
            $this->getEntityManager()->flush();

            $file = $this->params()->fromFiles('imageFile');
            if($file['error'] == 0 && $file['size'] > 0){
                $imageName = 'represented_company_' . $entity->getId() . '.jpg';
                rename($file['tmp_name'], './data/images/' . $imageName);
                $entity->setImage($imageName);
            }

            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();

            $this->flashMessenger()->addSuccessMessage('Registro inserido com sucesso!');

            return $this->redirectToDefaultRoute();
            
        }
        
        return new ViewModel(array('form' => $form));
    }
    
    public function editAction()
    {
        $id = null;
        $request = $this->getRequest();
        
        if ($request->isPost()){
            $id = $this->params()->fromPost('id', false);
        }else{
            $id = $this->params()->fromRoute('id', false);
        }
        
        $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));

        if ($request->isPost()){
            
            $post = $request->getPost()->toArray();
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $this->params()->fromPost('id'));
            
            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($post, $entity);
            
            $file = $this->params()->fromFiles('imageFile');
            if($file['error'] == 0 && $file['size'] > 0){
                $imageName = 'represented_company_' . $entity->getId() . '.jpg';
                rename($file['tmp_name'], './data/images/' . $imageName);
                $entity->setImage($imageName);
            }
            
            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();
            
            $this->flashMessenger()->addSuccessMessage('Registro alterado com sucesso!');

            return $this->redirectToDefaultRoute();
            
        }else{
            $form->bind($entity);
        }
        
        return new ViewModel(array('form' => $form, 'entity' => $entity));
    }

    public function removeAction()
    {
        try{

            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new Exception('Código não encontrado.');
            }

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new Exception('Código não encontrado.');
            }

            $this->getEntityManager()->remove($entity);
            $this->getEntityManager()->flush();
            $this->flashMessenger()->addSuccessMessage('Registro removido com sucesso!');

            return $this->redirectToDefaultRoute();

        } catch (\Doctrine\DBAL\DBALException $ex) {

            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro<br/>Pode ser que o registro que você está tentando remover possua relações com outros registros que impedem sua remoção.");

        } catch (\Exception $ex) {

            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro: {$ex->getMessage()}");

        }

        return $this->redirectToDefaultRoute();
    }

    public function imageAction(){

        $id = $this->params()->fromRoute('id', false);

        try{

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new \Exception("Entity not found");
            }

            if(!$entity->getImage()){
                throw new \Exception("Image not found");
            }

            $filename = $entity->getFullImagePath();

            if(is_null($filename) || !file_exists($filename)){
                throw new \Exception("Image not found");
            }

            return $this->createFileResponse($filename, "image/jpg");

        }catch(\Exception $ex){
            return $this->createFileResponse(\Model\Entity\Product::NO_PICTURE_PATH, "image/jpg");
        }

        return $this->createFileResponse(\Model\Entity\Product::NO_PICTURE_PATH, "image/jpg");
    }

}
