<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2014 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Application\Form\ProductForm;
use Commons\Util\FileUtil;
use Commons\Util\StringUtils;
use Rhumsaa\Uuid\Console\Exception;
use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;
use Doctrine\ORM\Tools\Pagination\Paginator as ORMPaginator;
use DoctrineORMModule\Paginator\Adapter\DoctrinePaginator as DoctrineAdapter;
use Zend\Paginator\Paginator;

class ProductController extends AbstractApplicationController
{

    private $entities;

    public function indexAction()
    {
        $data = $this->getEntityManager()->getRepository($this->getEntityClass())->findAll();
        $hasRepresentedCompanies = $this->getEntityManager()->createQuery('SELECT COUNT(obj) FROM Model\Entity\RepresentedCompany obj')->getSingleScalarResult();
        return new ViewModel(array(
            'data' => $data,
            'hasRepresentedCompanies' => $hasRepresentedCompanies
        ));
    }

    public function indexNewAction()
    {
        $data = $this->getEntityManager()->getRepository($this->getEntityClass())->findAll();
        $hasRepresentedCompanies = $this->getEntityManager()->createQuery('SELECT COUNT(obj) FROM Model\Entity\RepresentedCompany obj')->getSingleScalarResult();
        return new ViewModel(array(
            'data' => $data,
            'hasRepresentedCompanies' => $hasRepresentedCompanies
        ));
    }

    /**
     * List products for datatable
     * @return \Zend\View\Model\JsonModel
     */
    public function listAction(){
        
        try{

            $active = $this->params()->fromQuery('active', null);
            $representedCompany = $this->params()->fromQuery('representedCompany', false);
            $sort = $this->params()->fromQuery('sort', false);
            $sortOrder = $this->params()->fromQuery('sortOrder', false);
            $search = $this->params()->fromQuery('search', false);

            $qb = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from('Model\Entity\Product', 'obj');
            // $data = $this->getEntityManager()->getRepository($this->getEntityClass())->findAll();

            if($active !== 'all'){
                $qb->andWhere('obj.active = :pActive');
                $qb->setParameter('pActive', $active);
            }

            if($representedCompany){
                $rc = $this->getEntityManager()->find('Model\Entity\RepresentedCompany', $representedCompany);
                if($rc){
                    $qb->andWhere(':rc MEMBER OF obj.representedCompanies');
                    $qb->setParameter('rc', $rc);
                }
            }

            if($sort){
                $qb->orderBy("obj.{$sort}", $sortOrder);
            }else{
                $qb->orderBy('obj.name', 'ASC');
            }

            if($search){
                $qb->andWhere("LOWER(obj.name) LIKE LOWER(:search) OR LOWER(obj.description) LIKE LOWER(:search)");
                $qb->setParameter('search', "%{$search}%");
            }

            $adapter = new DoctrineAdapter(new ORMPaginator($qb));
            $paginator = new Paginator($adapter);

            $limit = (int)$this->params()->fromQuery('limit', 10);
            $paginator->setDefaultItemCountPerPage($limit);

            $page = (int)$this->params()->fromQuery('page', false);
            if($page) $paginator->setCurrentPageNumber($page);

            /*
            $data = $qb->getQuery()->getResult();

            $results = array();
            foreach($data as $obj){
                $results[] = $obj->getArrayCopyDT();
            }
            */

            $results = array();
            if($paginator->getTotalItemCount() > 0){
                foreach($paginator as $obj){
                    $results[] = $obj->getArrayCopyDT();
                }
            }

            $response = array(
                'total' => $paginator->getTotalItemCount(),
                'pages' => $paginator->getPages(),
                'results' => $results

            );
            
        } catch (\Exception $ex) {
            $response['error'] = true;
            $response['message'] = $ex->getMessage();
        }
        
        return new \Zend\View\Model\JsonModel($response);
        
    }
    
    /* Get datatable JSON
    public function jsonAction(){
        
        $params = $this->params()->fromQuery();

        $entityManager = $this->getEntityManager()->getRepository('Model\Entity\Product');

        $dataTable = new \Model\Datatable\ProductDatatable($params);
        $dataTable->setEntityManager($entityManager);
        //$dataTable->findAll();

        return new \Zend\View\Model\JsonModel($dataTable->findAll());
        
    }
    */

    /**
     * Find warehouses for product
     * @return ViewModel
     */
    public function warehouseAction()
    {
        $data = array();
        $id = $this->params()->fromRoute('id', 0);
        $entity = $this->getEntityManager()->find('Model\Entity\Product', $id);
        $data = $this->getEntityManager()->getRepository('Model\Entity\ProductWarehouse')->findBy(array("product" => $entity));
        return new ViewModel(array('data' => $data, 'entity' => $entity));
    }

    /**
     * Add Product
     * @return \Zend\Http\Response|ViewModel
     */
    public function addAction()
    {
        $entity = new $this->entityClass;
        $form = new ProductForm($this->getEntityManager());

        $request = $this->getRequest();
        
        try{

            if ($request->isPost()){

                $post = $request->getPost()->toArray();

                $file = $this->params()->fromFiles('imageFile', false);
                if($file != false && $file['error'] == 0 && $file['size'] > 0)
                {
                    if(!FileUtil::isValid($file))
                    {
                        $form->setData($post);
                        throw new \Exception("Formato de arquivo inválido");
                    }
                }

                $post['price']      = StringUtils::moneyStrToDouble($post['price']);
                $post['priceMin']   = StringUtils::moneyStrToDouble($post['priceMin']);
                $post['cost']       = StringUtils::moneyStrToDouble($post['cost']);
                $post['commission'] = StringUtils::moneyStrToDouble($post['commission']);
                $post['groupRelatedByIdGroupPrimary']   = $post['groupPrimary'];
                $post['groupRelatedByIdGroupSecondary'] = $post['groupSecondary'];

                //------ CUSTOM SIZE/COLOR ------//
                $postAux = array();
                $postAux['color'] = isset($post['colors']) && is_array($post['colors']) ? $post['colors'] : array() ;
                $postAux['size'] = isset($post['sizes']) && is_array($post['sizes']) ? $post['sizes'] : array() ;

                unset($post['colors']);
                unset($post['sizes']);
                //------ CUSTOM SIZE/COLOR ------//

                $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
                $hydrator->hydrate($post, $entity);

                $this->getEntityManager()->persist($entity);
                $this->getEntityManager()->flush();

                if($file != false && $file['error'] == 0 && $file['size'] > 0){
                    $entity->setFileResource($file);
                }

                $this->getEntityManager()->merge($entity);

                //------ CUSTOM SIZE/COLOR ------//
                try {
                    foreach (array('Size', 'Color') as $relationName) {
                        $itemRelations = $this->getEntityManager()->getRepository('Model\Entity\Product'.$relationName)->findBy(array('product' => $entity->getId()));
                        if (count($itemRelations) > 0) {
                            foreach ($itemRelations as $itemRelation) {
                                $method = 'get'.$relationName;
                                if (is_object($itemRelation->$method()) && in_array($itemRelation->$method()->getId(), $postAux[strtolower($relationName)]) === false) {
                                    $this->getEntityManager()->remove($itemRelation);
                                } else {
                                    $k = array_search($itemRelation->$method()->getId(), $postAux[strtolower($relationName)]);
                                    unset($postAux[strtolower($relationName)][$k]);
                                }
                            }
                        }
                        if (count($postAux[strtolower($relationName)]) > 0) {
                            foreach ($postAux[strtolower($relationName)] as $idRelation) {
                                $objRelation = $this->getEntityManager()->getRepository('Model\Entity\\'.$relationName)->find($idRelation);
                                if (is_object($objRelation)) {
                                    $objName = '\Model\Entity\Product'.$relationName;
                                    $newRelation = new $objName();
                                    $newRelation->setProduct($entity);
                                    $method = 'set'.$relationName;
                                    $newRelation->$method($objRelation);
                                    $newRelation->setActive(true);
                                    $this->getEntityManager()->persist($newRelation);
                                }
                            }
                        }
                    }
                } catch (\Exception $e) {
                    //Do nothing
                }
                //------ CUSTOM SIZE/COLOR ------//

                $this->getEntityManager()->flush();

                // Create Warehouses
                $warehouses = $this->getEntityManager()->getRepository('Model\Entity\Warehouse')->findAll();
                foreach($warehouses as $ent){
                    $pw = new \Model\Entity\ProductWarehouse();
                    $pw->setProduct($entity);
                    $pw->setWarehouse($ent);
                    $pw->setAmount(0.0);
                    $this->getEntityManager()->persist($pw);
                }

                $this->getEntityManager()->flush();

                $this->flashMessenger()->addSuccessMessage('Registro inserido com sucesso!');

                return $this->redirectToDefaultRoute();

            }else{
                $form->get("active")->setValue(true);
            }
        }catch(\Exception $ex){
            $message = $ex->getMessage();
        }
        
        return new ViewModel(array(
            'form' => $form,
            "message" => isset($message) ? $message : ''
        ));
    }

    /**
     * Edit product
     * @return \Zend\Http\Response|ViewModel
     */
    public function editAction()
    {
        $id = null;
        $request = $this->getRequest();
        
        if ($request->isPost()){
            $id = $this->params()->fromPost('id', false);
        }else{
            $id = $this->params()->fromRoute('id', false);
        }
        
        $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
        $form = new ProductForm($this->getEntityManager());

        try{
            if ($request->isPost()){

                $post = $request->getPost()->toArray();

                $file = $this->params()->fromFiles('imageFile', false);
                if($file != false && $file['error'] == 0 && $file['size'] > 0)
                {
                    if(!FileUtil::isValid($file))
                    {
                        $form->setData($post);
                        throw new \Exception("Formato de arquivo inválido");
                    }
                }

                $post['price']      = StringUtils::moneyStrToDouble($post['price']);
                $post['priceMin']   = StringUtils::moneyStrToDouble($post['priceMin']);
                $post['cost']       = StringUtils::moneyStrToDouble($post['cost']);
                $post['commission'] = StringUtils::moneyStrToDouble($post['commission']);
                $post['groupRelatedByIdGroupPrimary']   = $post['groupPrimary'];
                $post['groupRelatedByIdGroupSecondary'] = $post['groupSecondary'];

                $entity = $this->getEntityManager()->find($this->getEntityClass(), $this->params()->fromPost('id'));

                //------ CUSTOM SIZE/COLOR ------//
                $postAux = array();
                $postAux['color'] = isset($post['colors']) && is_array($post['colors']) ? $post['colors'] : array() ;
                $postAux['size'] = isset($post['sizes']) && is_array($post['sizes']) ? $post['sizes'] : array() ;

                unset($post['colors']);
                unset($post['sizes']);
                //------ CUSTOM SIZE/COLOR ------//

                $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
                $hydrator->hydrate($post, $entity);

                if($file != false && $file['error'] == 0 && $file['size'] > 0){
                    $entity->setFileResource($file);
                }

                $this->getEntityManager()->merge($entity);

                //------ CUSTOM SIZE/COLOR ------//
                try {
                    foreach (array('Size', 'Color') as $relationName) {
                        $itemRelations = $this->getEntityManager()->getRepository('Model\Entity\Product'.$relationName)->findBy(array('product' => $entity->getId()));
                        if (count($itemRelations) > 0) {
                            foreach ($itemRelations as $itemRelation) {
                                $method = 'get'.$relationName;
                                if (is_object($itemRelation->$method()) && in_array($itemRelation->$method()->getId(), $postAux[strtolower($relationName)]) === false) {
                                    $this->getEntityManager()->remove($itemRelation);
                                } else {
                                    $k = array_search($itemRelation->$method()->getId(), $postAux[strtolower($relationName)]);
                                    unset($postAux[strtolower($relationName)][$k]);
                                }
                            }
                        }
                        if (count($postAux[strtolower($relationName)]) > 0) {
                            foreach ($postAux[strtolower($relationName)] as $idRelation) {
                                $objRelation = $this->getEntityManager()->getRepository('Model\Entity\\'.$relationName)->find($idRelation);
                                if (is_object($objRelation)) {
                                    $objName = '\Model\Entity\Product'.$relationName;
                                    $newRelation = new $objName();
                                    $newRelation->setProduct($entity);
                                    $method = 'set'.$relationName;
                                    $newRelation->$method($objRelation);
                                    $newRelation->setActive(true);
                                    $this->getEntityManager()->persist($newRelation);
                                }
                            }
                        }
                    }
                } catch (\Exception $e) {
                    //Do nothing
                }
                //------ CUSTOM SIZE/COLOR ------//

                $this->getEntityManager()->flush();

                $this->flashMessenger()->addSuccessMessage('Registro alterado com sucesso!');

                return $this->redirectToDefaultRoute();

            }else{
                $form->bind($entity);
                $form->get('cost')->setValue($entity->getCostCurrency());
                $form->get('price')->setValue($entity->getPriceCurrency());
                $form->get('priceMin')->setValue($entity->getPriceMinCurrency());
                
                //--------- CUSTOM COLOR/SIZE ---------//
                $colors = $entity->getColors();
                if (count($colors) > 0) {
                    $values = array();
                    foreach ($colors as $ent) {
                        if (is_object($ent->getColor()))
                         $values[] = $ent->getColor();
                    }
                    $form->get('colors')->setValue($values);
                }
                $sizes = $entity->getSizes();
                if (count($sizes) > 0) {
                    $values = array();
                    foreach ($sizes as $ent) {
                        if (is_object($ent->getSize()))
                            $values[] = $ent->getSize();
                    }
                    $form->get('sizes')->setValue($values);
                }
                //--------- CUSTOM COLOR/SIZE ---------//
            }
        }catch(\Exception $ex){
            $message = $ex->getMessage();
        }

        return new ViewModel(array(
            'form' => $form,
            'entity' => $entity,
            'message' => (isset($message) ? $message : '')
        ));
    }

    /**
     * Remove (deactivate) product
     * @return \Zend\Http\Response
     * @throws Exception
     */
    public function removeAction()
    {
        try{
            
            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new Exception('Código não encontrado.');
            }
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new Exception('Código não encontrado.');
            }

            //$this->getEntityManager()->remove($entity);
            $entity->setActive(false);
            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();
            $this->flashMessenger()->addSuccessMessage('Registro removido com sucesso!');
            
            return $this->redirectToDefaultRoute();
        
        } catch (\Doctrine\DBAL\DBALException $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro<br/>Pode ser que o registro que você está tentando remover possua relações com outros registros que impedem sua remoção.");
        } catch (\Exception $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro: {$ex->getMessage()}");
        }
        
        return $this->redirectToDefaultRoute();
    }

    /**
     * Get product image
     * @return \Zend\Http\Response\Stream
     */
    public function imageAction(){
        
        $id = $this->params()->fromRoute('id', false);
        
        try{
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new \Exception("Entity not found");
            }
            
            if(!$entity->getImage()){
                throw new \Exception("Image not found");
            }
            
            $filename   = $entity->getFullImagePath();
            $type       = $entity->getFullImagePathMimeType();
        
            if(is_null($filename) || !file_exists($filename)){
                throw new \Exception("Image not found");
            }
            
            return $this->createFileResponse($filename, $type);
            
            /*
            $response = new Stream();
            $response->setStream(fopen($filename, 'r'));
            $response->setStatusCode(200);

            $headers = new Headers();
            $headers->addHeaderLine('Content-Transfer-Encoding', 'binary')
                    ->addHeaderLine('Content-Type', 'image/jpg')
                    ->addHeaderLine('Content-Length', filesize($filename));

            $response->setContentLength(sizeof($data));
            $response->setHeaders($headers);
            
            return $response;
             */
            
        }catch(\Exception $ex){
            return $this->createFileResponse(\Model\Entity\Product::NO_PICTURE_PATH, "image/jpg");
        }
        
        return $this->createFileResponse(\Model\Entity\Product::NO_PICTURE_PATH, "image/jpg");
    }

    /**
     * Get product image thumb
     * @return \Zend\Http\Response\Stream
     */
    public function imageThumbAction(){

        $id = $this->params()->fromRoute('id', false);

        try{

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new \Exception("Entity not found");
            }

            if(!$entity->getImage()){
                throw new \Exception("Image not found");
            }

            $filename   = $entity->getFullThumbPath();
            $type       = $entity->getFullThumbPathMimeType();

            if(is_null($filename) || !file_exists($filename)){
                throw new \Exception("Image not found");
            }

            return $this->createFileResponse($filename, $type);

        }catch(\Exception $ex){
            return $this->createFileResponse(\Model\Entity\Product::NO_PICTURE_PATH, "image/jpg");
        }

        return $this->createFileResponse(\Model\Entity\Product::NO_PICTURE_PATH, "image/jpg");
    }

    /**
     * Return warehouse stats (qty) for specified product
     * @return \Zend\View\Model\JsonModel
     */
    public function warehouseStatsAction(){

        try{

            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new \Exception('Invalid product id');
            }

            $entity = $this->getEntityManager()->find('Model\Entity\Product', $id);
            if(!$entity){
                throw new \Exception('Product not found');
            }

            $retorno = $this->getEntityManager()->createQueryBuilder()
                ->select('obj','war')
                ->from('Model\Entity\ProductWarehouse', 'obj')
                ->join('obj.warehouse','war')
                ->where('obj.product = :pro')
                ->setParameter('pro', $entity)
                ->getQuery()->getArrayResult();
            return $this->createJsonResponse($retorno);

        }catch(\Exception $ex){
            return $this->createJsonResponse(array(
                'error' => true,
                'message' => $ex->getMessage()
            ));
        }

    }
    
    public function importAction() {

        $type = $this->params()->fromRoute('type', false);
        $id = $this->params()->fromRoute('id', false);

        $returnJsonEncode = function ($arr) {
            echo json_encode($arr);
            exit();
        };

        if (empty($type) || empty($id))
            $returnJsonEncode([
                'success' => false,
                'msg' => "Você precisa selecionar as ações para aos registros previamente cadastrados!",
            ]);

        $success = true;
        $keyFile = 'file';
        $newFilename = null;

        $uploadPath = ROOT_PATH."/data/import";

        if (!file_exists($uploadPath))
            mkdir($uploadPath);

        if (
            isset($_FILES[$keyFile]["type"])
            && !empty($_FILES[$keyFile]["type"])
            //&& in_array($_FILES[$keyFile]["type"], array('image/jpeg','image/jpg','image/png','image/gif'))
        ) {
            $newFilename = time().'_'.rand(100,999).".".substr($_FILES[$keyFile]["name"], strlen($_FILES[$keyFile]["name"]) - 3);
            if (file_exists($_FILES[$keyFile]["tmp_name"]) && move_uploaded_file($_FILES[$keyFile]["tmp_name"], $uploadPath."/".$newFilename))
                $success = true;
            else
                $success = false;
        }

        try {

            if ($success && file_exists($uploadPath."/".$newFilename)) {

                $regsImport = $regsImportEmpty = $regsCurrent = array();

                //Codigo Externo;Nome do Grupo;Nome do Subgrupo;Unidade de Medida;Nome do Produto;Referencia do Produto;
                //Descricao do Produto;Preco;Preco Minimo;Preco de Custo;Comissao;Codigo de Barras;Produto Ativo?;
                //Outras Informacoes;ID do Estoque;Quantidade do Estoque;ID Representada

                $position = 0;
                if ($id == 'reference')
                    $position = 5;

                $utf8Encode = function($value) {
                    return utf8_encode($value);
                };

                $fileHandle = fopen($uploadPath."/".$newFilename, "r");
                while (($row = fgetcsv($fileHandle, 0, ";")) !== FALSE) {

                    if (isset($row[0]) && trim(strtolower($row[0])) == 'codigo')
                        continue;

                    $row = array_map($utf8Encode, $row);

                    if (isset($row[$position]) && empty($row[$position]) === false) {
                        if ($id == 'reference')
                            $regsImport[trim($row[$position])] = $row;
                        else
                            $regsImport[trim($row[$position])] = $row;
                    } else {
                        $regsImportEmpty[] = $row;
                    }
                }

                if (count($regsImport) == 0)
                    $returnJsonEncode([
                        'success' => false,
                        'msg' => "Nenhum registro foi encontrado para importar! Verifique a estrutura do arquivo e tente novamente.",
                    ]);

                $registros = $this->getEntityManager()->getRepository($this->getEntityClass())->findBy(array(), array('id' => 'ASC'));
                if (count($registros) > 0) {
                    foreach ($registros as $registro) {
                        if ($id == 'reference')
                            $regsCurrent[trim($registro->getReference())] = $registro;
                        else
                            $regsCurrent[trim($registro->getCode())] = $registro;
                    }
                }

                foreach ($regsImport as $keyRegImport => $valRegImport) {

                    $entity = null;

                    if (isset($regsCurrent[$keyRegImport])) {
                        $entityCurrent = $regsCurrent[$keyRegImport];
                        if ($type == 'change') {
                            $entityCurrent->populateFromImport($valRegImport);
                            $entity = $entityCurrent;
                        } else if ($type == 'notchange') {
                            //Do nothing
                        }
                    } else {
                        $entity = new \Model\Entity\Product();
                        $entity->populateFromImport($valRegImport);
                    }

                    if (is_object($entity)) {
                        $this->checkRelationBeforeImport($entity, $valRegImport);
                        $this->getEntityManager()->persist($entity);
                    }
                }

                if (count($regsImportEmpty) > 0) {
                    foreach ($regsImportEmpty as $valRegImport) {
                        $entity = new \Model\Entity\Product();
                        $entity->populateFromImport($valRegImport);
                        $this->checkRelationBeforeImport($entity, $valRegImport);
                        $this->getEntityManager()->persist($entity);
                    }
                }

                $this->getEntityManager()->flush();

                $returnJsonEncode([
                    'success' => true,
                    'msg' => "A importação foi realizada com sucesso!",
                ]);

            } else {
                $returnJsonEncode([
                    'success' => false,
                    'msg' => "Não foi possível carregar o arquivo enviado!",
                ]);
            }

        } catch (\Exception $e) {
            $returnJsonEncode([
                'success' => false,
                'msg' => $e->getMessage(),
            ]);
        }
    }

    private function findItemInArrayOfEntities($keyword, $type) {
        if (is_array($this->entities) === false || isset($this->entities[$type]) === false || count($this->entities[$type]) === 0)
            return null;

        foreach ($this->entities[$type] as $entity) {

            if ($type == 'group' && strtolower(trim($entity->getDescription())) == strtolower(trim($keyword))) {
                return $entity;
            } else
            if (
                    $type == 'unit' &&
                    (
                        strtolower(trim($entity->getDescription())) == strtolower(trim($keyword)) ||
                        strtolower(trim($entity->getId())) == strtolower(trim($keyword))
                    )
            ) {
                return $entity;
            } else
            if (($type == 'warehouse' || $type == 'representend') && $entity->getId() == (int)$keyword) {
                return $entity;
            }
        }
    }

    private function checkRelationBeforeImport($entity, $valRegImport) {
        try {
                //Grupo
                if (isset($valRegImport[1]) && empty($valRegImport[1]) === false) {

                    if (is_array($this->entities) === false || isset($this->entities['group']) === false)
                        $this->entities['group'] = $this->getEntityManager()->getRepository("Model\\Entity\\Group")->findAll();

                    $registro = $this->findItemInArrayOfEntities($valRegImport[1], 'group');

                    if (is_object($registro)) {
                        $entity->setGroupRelatedByIdGroupPrimary($registro);
                    } else {
                        $registro = new \Model\Entity\Group();
                        $registro->setDescription(trim($valRegImport[1]));
                        $this->getEntityManager()->persist($registro);
                        $this->entities['group'][] = $registro;
                        $entity->setGroupRelatedByIdGroupPrimary($registro);
                    }
                }

                //Subgrupo
                if (isset($valRegImport[2]) && empty($valRegImport[2]) === false) {

                    if (is_array($this->entities) === false || isset($this->entities['group']) === false)
                        $this->entities['group'] = $this->getEntityManager()->getRepository("Model\\Entity\\Group")->findAll();

                    $registro = $this->findItemInArrayOfEntities($valRegImport[2], 'group');

                    if (is_object($registro)) {
                        $entity->setGroupRelatedByIdGroupSecondary($registro);
                    } else {
                        $registro = new \Model\Entity\Group();
                        $registro->setDescription(trim($valRegImport[2]));
                        $this->getEntityManager()->persist($registro);
                        $this->entities['group'][] = $registro;
                        $entity->setGroupRelatedByIdGroupSecondary($registro);
                    }
                }

                //Unidade
                if (isset($valRegImport[3]) && empty($valRegImport[3]) === false) {

                    //$registro = $this->getEntityManager()->createQuery("SELECT obj FROM Model\Entity\Unit obj WHERE (obj.id LIKE '".strtolower(trim($valRegImport[3]))."' OR obj.description LIKE '".trim($valRegImport[3])."')")->getOneOrNullResult();

                    if (is_array($this->entities) === false || isset($this->entities['unit']) === false)
                        $this->entities['unit'] = $this->getEntityManager()->getRepository("Model\\Entity\\Unit")->findAll();

                    $registro = $this->findItemInArrayOfEntities($valRegImport[3], 'unit');

                    if (is_object($registro)) {
                        $entity->setUnit($registro);
                    } else {
                        $registro = new \Model\Entity\Unit();
                        $registro->setId(strtolower(trim($valRegImport[3])));
                        $registro->setDescription(trim($valRegImport[3]));
                        $this->getEntityManager()->persist($registro);
                        $this->entities['unit'][] = $registro;
                        $entity->setUnit($registro);
                    }
                }

                //Estoque
                if (isset($valRegImport[14]) && empty($valRegImport[14]) === false && is_numeric($valRegImport[14]) && isset($valRegImport[15]) && empty($valRegImport[15]) === false && is_numeric($valRegImport[15])) {

                    if (is_array($this->entities) === false || isset($this->entities['warehouse']) === false)
                        $this->entities['warehouse'] = $this->getEntityManager()->getRepository("Model\\Entity\\Warehouse")->findAll();

                    $estoque = $this->findItemInArrayOfEntities((int)$valRegImport[14], 'warehouse');

                    if (is_object($estoque)) {
                        $productWarehouse = null;
                        if ($entity->getId() != null && $entity->getId() > 0)
                            $productWarehouse = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $entity, 'warehouse' => $estoque));
                        if (is_object($productWarehouse)) {
                            $productWarehouse->increase((int)$valRegImport[15]);
                            $this->getEntityManager()->persist($productWarehouse);
                        }else {
                            $productWarehouse = new \Model\Entity\ProductWarehouse();
                            $productWarehouse->setProduct($entity);
                            $productWarehouse->setWarehouse($estoque);
                            $productWarehouse->setAmount(floatval($valRegImport[15]));
                            $this->getEntityManager()->persist($productWarehouse);
                        }
                    }
                }

                //Representada
                if (isset($valRegImport[16]) && empty($valRegImport[16]) === false) {

                    if (is_array($this->entities) === false || isset($this->entities['representend']) === false)
                        $this->entities['representend'] = $this->getEntityManager()->getRepository("Model\\Entity\\RepresentedCompany")->findAll();

                    $representada = $this->findItemInArrayOfEntities((int)$valRegImport[16], 'representend');

                    if (is_object($representada) && $entity->hasCompany($representada) === false) {
                        $entity->addRepresentedCompanies(array($representada));
                    }
                }

        } catch (\Exception $e) {
            throw new \Exception($e->getMessage());
        }
    }

}
