<?php

namespace Application\Controller;

use Zend\View\Model\ViewModel;
use Zend\Http\Response\Stream;
use Zend\Http\Headers;

class DownloadController extends AbstractApplicationController
{
    /**
     * Index action
     * @return ViewModel
     */
    public function indexAction()
    {
        $file = './data/app/salestool.apk';
        $response = new Stream();
        $response->setStream(fopen($file, 'r'));
        $response->setStatusCode(200);
        $headers = new Headers();
        $headers->addHeaderLine('Content-Transfer-Encoding', 'binary')
            ->addHeaderLine('Content-Type', 'application/vnd.android.package-archive')
            ->addHeaderLine('Content-Disposition', "attachment; filename=".basename($file))
            ->addHeaderLine('Content-Length', filesize($file));

        $response->setHeaders($headers);
        return $response;
    }

}
