<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2014 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class DeviceController extends AbstractApplicationController
{   
    public function indexAction()
    {
        $data = $this->getEntityManager()->getRepository($this->getEntityClass())->findAll();
        return new ViewModel(array(
            'data' => $data,
            'isReachedDeviceLimit' => $this->isReachedDeviceLimit()
        ));
    }
    
    public function addAction()
    {

        if($this->isReachedDeviceLimit()){
            $this->redirectToDefaultRoute();
        }

        $entity = new $this->entityClass;
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));
        
        $request = $this->getRequest();
        
        if ($request->isPost()){
            
            $form->bind($entity);
            $form->setData($request->getPost());
            
            if($form->isValid()){
                
                $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
                $hydrator->hydrate($request->getPost()->toArray(), $entity);
                
                $this->getEntityManager()->persist($entity);
                $this->getEntityManager()->flush();

                $this->flashMessenger()->addSuccessMessage('Registro inserido com sucesso!');
                
                return $this->redirectToDefaultRoute();
            }
            
            
        }
        
        return new ViewModel(array('form' => $form));
    }
    
    public function editAction()
    {
        $id = null;
        $request = $this->getRequest();
        
        if ($request->isPost()){
            $id = $this->params()->fromPost('id', false);
        }else{
            $id = $this->params()->fromRoute('id', false);
        }
        
        $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));

        if ($request->isPost()){
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $this->params()->fromPost('id'));
            
            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($request->getPost()->toArray(), $entity);
            //$usuario->populate($form->getData());

            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();

            $this->flashMessenger()->addSuccessMessage('Registro alterado com sucesso!');

            return $this->redirectToDefaultRoute();
            
        }else{
            $form->bind($entity);
        }
        
        return new ViewModel(array('form' => $form, 'entity' => $entity));
    }
    
    public function removeAction()
    {
        try{
            
            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new Exception('Código não encontrado.');
            }
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new Exception('Código não encontrado.');
            }
            
            $this->getEntityManager()->remove($entity);
            $this->getEntityManager()->flush();
            $this->flashMessenger()->addSuccessMessage('Registro removido com sucesso!');
            
            return $this->redirectToDefaultRoute();
        
        } catch (\Doctrine\DBAL\DBALException $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro<br/>Pode ser que o registro que você está tentando remover possua relações com outros registros que impedem sua remoção.");
        } catch (\Exception $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro: {$ex->getMessage()}");
        }
        
        return $this->redirectToDefaultRoute();
    }
}
