<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2014 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Commons\Util\Geolocation;
use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;
use Commons\Service\CepService;

class CustomerController extends AbstractApplicationController
{   
    public function indexAction()
    {
        $data = $this->getEntityManager()->getRepository($this->getEntityClass())->findBy(array(), array('name' => 'ASC', 'companyName' => 'ASC'));

        /*
        foreach($data as $ent){
            
            $ent->setName(utf8_encode($ent->getName()));
            $ent->setCompanyName(utf8_encode($ent->getCompanyName()));
            $ent->setCity(utf8_encode($ent->getCity()));
            $this->getEntityManager()->merge($ent);
        }
        $this->getEntityManager()->flush();
        */
        
        return new ViewModel(array('data' => $data));
    }
    
    public function addAction()
    {
        
        $type = $this->params()->fromRoute('type', 'pf');
        
        $entity = new $this->entityClass;
        $form = new \Application\Form\CustomerForm($type, $this->getEntityManager());
        
        $request = $this->getRequest();
        
        if ($request->isPost()){
            
            $form->bind($entity);
            $form->setData($request->getPost());
            
            if($form->isValid()){
                
                $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
                $hydrator->hydrate($request->getPost()->toArray(), $entity);
                
                $this->getEntityManager()->persist($entity);
                $this->getEntityManager()->flush();

                $this->flashMessenger()->addSuccessMessage('Registro inserido com sucesso!');
                
                return $this->redirectToDefaultRoute();
            }
            
            
        }
        
        return new ViewModel(array('form' => $form, 'type' => $type));
    }
    
    public function editAction()
    {
        $id = null;
        $request = $this->getRequest();
        
        if ($request->isPost()){
            $id = $this->params()->fromPost('id', false);
        }else{
            $id = $this->params()->fromRoute('id', false);
        }
        
        $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
        
        $type = $this->params()->fromRoute('type', (is_object($entity)? $entity->getCustomerType() :'pf'));
        $form = new \Application\Form\CustomerForm($type, $this->getEntityManager());

        if ($request->isPost()){
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $this->params()->fromPost('id'));
            
            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($request->getPost()->toArray(), $entity);
            //$usuario->populate($form->getData());

            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();

            $this->flashMessenger()->addSuccessMessage('Registro alterado com sucesso!');

            return $this->redirectToDefaultRoute();
            
        }else{
            $form->bind($entity);
        }
        
        return new ViewModel(array('form' => $form, 'entity' => $entity));
    }
    
    public function removeAction()
    {
        try{
            
            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new Exception('Código não encontrado.');
            }
            
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new Exception('Código não encontrado.');
            }
            
            $this->getEntityManager()->remove($entity);
            $this->getEntityManager()->flush();
            $this->flashMessenger()->addSuccessMessage('Registro removido com sucesso!');
            
            return $this->redirectToDefaultRoute();
        
        } catch (\Doctrine\DBAL\DBALException $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro<br/>Pode ser que o registro que você está tentando remover possua pedidos ou relações com outros registros que impedem sua remoção.");
        } catch (\Exception $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro: {$ex->getMessage()}");
        }
        
        return $this->redirectToDefaultRoute();
    }

    public function importAction() {

        $type = $this->params()->fromRoute('type', false);
        $id = $this->params()->fromRoute('id', false);

        $returnJsonEncode = function ($arr) {
            echo json_encode($arr);
            exit();
        };

        if (empty($type) || empty($id))
            $returnJsonEncode([
                'success' => false,
                'msg' => "Você precisa selecionar as ações para aos registros previamente cadastrados!",
            ]);

        $success = true;
        $keyFile = 'file';
        $newFilename = null;

        $uploadPath = ROOT_PATH."/data/import";

        if (!file_exists($uploadPath))
            mkdir($uploadPath);

        if (
            isset($_FILES[$keyFile]["type"])
            && !empty($_FILES[$keyFile]["type"])
            //&& in_array($_FILES[$keyFile]["type"], array('image/jpeg','image/jpg','image/png','image/gif'))
        ) {
            $newFilename = time().'_'.rand(100,999).".".substr($_FILES[$keyFile]["name"], strlen($_FILES[$keyFile]["name"]) - 3);
            if (file_exists($_FILES[$keyFile]["tmp_name"]) && move_uploaded_file($_FILES[$keyFile]["tmp_name"], $uploadPath."/".$newFilename))
                $success = true;
            else
                $success = false;
        }

        try {

            if ($success && file_exists($uploadPath."/".$newFilename)) {

                $regsImport = $regsImportEmpty = $regsCurrent = array();

                $position = 1;
                if ($id == 'document')
                    $position = 5;
                elseif ($id == 'idsalestool')
                    $position = 0;

                $utf8Encode = function($value) {
                    return utf8_encode($value);
                };

                $isValidRow = function($row) {
                    return
                        count($row) >= 23 && //Number of columns
                        isset($row[21]) && empty($row[21]) === false && //Customer Type
                        (
                            (isset($row[2]) && empty($row[2]) === false) || //Name
                            (isset($row[3]) && empty($row[3]) === false)    //Company Name
                        );
                };

                $fileHandle = fopen($uploadPath."/".$newFilename, "r");
                while (($row = fgetcsv($fileHandle, 0, ";")) !== FALSE) {

                    if (isset($row[1]) && trim(strtolower($row[1])) == 'codigo')
                        continue;

                    if (!$isValidRow($row))
                        continue;

                    $row = array_map($utf8Encode, $row);

                    if (isset($row[$position]) && empty($row[$position]) === false) {
                        if ($id == 'document')
                            $regsImport[preg_replace('/\D/', '', $row[$position])] = $row;
                        else
                            $regsImport[trim($row[$position])] = $row;
                    } else {
                        $regsImportEmpty[] = $row;
                    }
                }

                if (count($regsImport) == 0 && count($regsImportEmpty) == 0)
                    $returnJsonEncode([
                        'success' => false,
                        'msg' => "Nenhum registro foi encontrado para importar! Verifique a estrutura do arquivo e tente novamente.",
                    ]);

                $registros = $this->getEntityManager()->getRepository($this->getEntityClass())->findBy(array(), array('id' => 'ASC'));
                if (count($registros) > 0) {
                    foreach ($registros as $registro) {
                        if ($id == 'document')
                            $regsCurrent[preg_replace('/\D/', '', $registro->getDocumentNumber())] = $registro;
                        elseif ($id == 'idsalestool')
                            $regsCurrent[trim($registro->getId())] = $registro;
                        else
                            $regsCurrent[trim($registro->getCode())] = $registro;
                    }
                }

                if (count($regsImport) > 0) {
                    foreach ($regsImport as $keyRegImport => $valRegImport) {

                        if (!$isValidRow($valRegImport))
                            continue;

                        $entity = null;

                        if (isset($regsCurrent[$keyRegImport])) {
                            $entityCurrent = $regsCurrent[$keyRegImport];
                            if ($type == 'change') {
                                $entity = $entityCurrent->populateFromImport($valRegImport);
                            } else if ($type == 'notchange') {
                                //Do nothing
                            }
                        } else {
                            $entity = new \Model\Entity\Customer();
                            $entity->populateFromImport($valRegImport);
                        }

                        if (is_object($entity))
                            $this->getEntityManager()->persist($entity);
                    }
                }

                if (count($regsImportEmpty) > 0) {
                    foreach ($regsImportEmpty as $valRegImport) {
                        $entity = new \Model\Entity\Customer();
                        $entity->populateFromImport($valRegImport);
                        $this->getEntityManager()->persist($entity);
                    }
                }

                $this->getEntityManager()->flush();

                $returnJsonEncode([
                    'success' => true,
                    'msg' => "A importação foi realizada com sucesso!",
                ]);

            } else {
                $returnJsonEncode([
                    'success' => false,
                    'msg' => "Não foi possível carregar o arquivo enviado!",
                ]);
            }

        } catch (\Exception $e) {
            $returnJsonEncode([
                'success' => false,
                'msg' => $e->getMessage(),
            ]);
        }
    }

    public function exportAction() {

        header('Content-type: text/csv');
        header('Content-Disposition: attachment; filename="clientes-salestool.csv"');

        //header('Pragma: no-cache');
        //header('Expires: 0');

        $returnJsonEncode = function ($arr) {
            echo json_encode($arr);
            exit();
        };

        $utf8Decode = function($value) {
            return utf8_decode($value);
        };


        try {

            //Codigo;Nome/Fantasia;Razao Social;Contato da Empresa;CNPJ/CPF;IE/RG;
            //CEP;Rua/Avenida;Numero;Bairro;Complemento;Estado (Sigla);Cidade;Telefone1;Telefone2;
            //Website;Email;Longitude;Latitude;Está ativo? (1 ou 0);Tipo de Pessoa (pf ou pj);Informacoes Gerais

            $dataToExport = array();

            $registros = $this->getEntityManager()->getRepository($this->getEntityClass())->findBy(array(), array('id' => 'DESC'));
            if (count($registros) > 0) {
                foreach ($registros as $registro) {

                    $row = array(
                        $registro->getId(),
                        $registro->getCode(),
                        $registro->getName(),
                        $registro->getCompanyName(),
                        $registro->getContact(),
                        $registro->getDocumentNumber(),
                        $registro->getSecondaryDocumentNumber(),
                        $registro->getZip(),
                        $registro->getAddress(),
                        $registro->getAddressNumber(),
                        $registro->getNeighbourhood(),
                        $registro->getAddressComplement(),
                        $registro->getState(),
                        $registro->getCity(),
                        $registro->getPhonePrimary(),
                        $registro->getPhoneSecondary(),
                        $registro->getWebsite(),
                        $registro->getEmail(),
                        $registro->getLongitude(),
                        $registro->getLatitude(),
                        $registro->getActive(),
                        $registro->getCustomerType(),
                        $registro->getInfo()
                    );

                    $row = array_map($utf8Decode, $row);

                    $dataToExport[] = $row;

                }

                $file = fopen('php://output', 'w');

                fputcsv($file, array_map($utf8Decode, array('ID Salestool','Codigo','Nome/Fantasia','Razao Social','Contato da Empresa','CNPJ/CPF','IE/RG',
                    'CEP','Rua/Avenida','Numero','Bairro','Complemento','Estado (Sigla)','Cidade','Telefone1','Telefone2',
                    'Website','Email','Longitude','Latitude','Está ativo? (1 ou 0)','Tipo de Pessoa (pf ou pj)','Informacoes Gerais')), ";");

                foreach ($dataToExport as $row) {
                    fputcsv($file, $row, ";");
                }

                fclose($file);

                exit();

            } else {
                $returnJsonEncode([
                    'success' => false,
                    'msg' => 'Nenhum registro foi encontrado para exportar.',
                ]);
            }

        } catch (\Exception $e) {
            $returnJsonEncode([
                'success' => false,
                'msg' => $e->getMessage(),
            ]);
        }
    }

    /*
    public function getAddressAction(){
        $returnData = array('success' => false);
        $address = null;
        try{
            $cep = $this->params()->fromPost('cep',false);
            if(!$cep){
                throw new \Exception('Invalid cep parameter');
            }
            $address = CepService::getAddress($cep);
            $returnData['data'] = $address;
            $returnData['success'] = true;
        }  catch (\Exception $ex){
            $returnData['message'] = $ex->getMessage();
        }
        return new \Zend\View\Model\JsonModel($returnData);
    }


    public function getCoordinatesAction(){
        $returnData = array('success' => false);
        try{
            $address = $this->params()->fromPost();
            if(!$address){
                throw new \Exception("Invalid address");
            }
            $geolocation = Geolocation::getCoordinates($address['address'], $address['addressNumber'], $address['city'], $address['zip'], 'Brasil');
            if(!$geolocation){
                throw new \Exception("Location not found");
            }
            $returnData['success'] = true;
            $returnData['data'] = $geolocation;
        }catch (\Exception $ex){
            $returnData['message'] = $ex->getMessage();
        }
        return new \Zend\View\Model\JsonModel($returnData);
    }
    */

}
