<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2014 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Commons\Crypt\DefaultCrypt;
use Zend\View\Model\ViewModel;

class ConfigController extends AbstractApplicationController
{
    public function indexAction()
    {
        $entity = $this->getEntityManager()->getRepository('Model\Entity\Config')->findOneBy(array());

        $array = array(
            'host' => $entity->getWsUrl(),
            'type' => $entity->getWsIntegration() == true ? 'integration' : 'regular'
            // 'user' => 'conex'
        );

        $json = json_encode($array);
        $qrcodeData = DefaultCrypt::aes128_cbc_encrypt($json);

        return new ViewModel(array('entity' => $entity, 'qrcode' => $qrcodeData));
    }

    public function saveAction(){

        try{

            $entity = $this->getEntityManager()->getRepository('Model\Entity\Config')->findOneBy(array());
            if($this->getRequest()->isPost()){

                $max = $this->params()->fromPost("maxDiscount", false);
                if(is_numeric($max)){
                    $entity->setMaxDiscount($max);
                }

                $wsUrl = $this->params()->fromPost("wsUrl", false);
                if($wsUrl){
                    $entity->setWsUrl($wsUrl);
                }

                $wsIntegration = $this->params()->fromPost("wsIntegration", false);
                if($wsIntegration){
                    $entity->setWsIntegration(true);
                }else{
                    $entity->setWsIntegration(false);
                }

                $syncCustomerInactive = $this->params()->fromPost("syncCustomerInactive", false);
                if($syncCustomerInactive){
                    $entity->setSyncCustomerInactive(true);
                }else{
                    $entity->setSyncCustomerInactive(false);
                }

                $orderCustomerInactive = $this->params()->fromPost("orderCustomerInactive", false);
                if($orderCustomerInactive){
                    $entity->setOrderCustomerInactive(true);
                }else{
                    $entity->setOrderCustomerInactive(false);
                }

                $orderCustomerInactive = $this->params()->fromPost("orderCustomerBlocked", false);
                if($orderCustomerInactive){
                    $entity->setOrderCustomerBlocked(true);
                }else{
                    $entity->setOrderCustomerBlocked(false);
                }

                $enableOrderProductPriceChange = $this->params()->fromPost("enableOrderProductPriceChange", false);
                if($enableOrderProductPriceChange){
                    $entity->setEnableOrderProductPriceChange(true);
                }else{
                    $entity->setEnableOrderProductPriceChange(false);
                }

                $enableOrderProductDivisionFunctionality = $this->params()->fromPost("enableOrderProductDivisionFunctionality", false);
                if($enableOrderProductDivisionFunctionality){
                    $entity->setEnableOrderProductDivisionFunctionality(true);
                }else{
                    $entity->setEnableOrderProductDivisionFunctionality(false);
                }

                $enableOrderProductUnitAmountFunctionality = $this->params()->fromPost("enableOrderProductUnitAmountFunctionality", false);
                if($enableOrderProductUnitAmountFunctionality){
                    $entity->setEnableOrderProductUnitAmountFunctionality(true);
                }else{
                    $entity->setEnableOrderProductUnitAmountFunctionality(false);
                }

                $enableCashierFunctionality = $this->params()->fromPost("enableCashierFunctionality", false);
                if($enableCashierFunctionality){
                    $entity->setEnableCashierFunctionality(true);
                }else{
                    $entity->setEnableCashierFunctionality(false);
                }

                $enableOrderUpdateFromClientFunctionality = $this->params()->fromPost("enableOrderUpdateFromClientFunctionality", false);
                if($enableOrderUpdateFromClientFunctionality){
                    $entity->setEnableOrderUpdateFromClientFunctionality(true);
                }else{
                    $entity->setEnableOrderUpdateFromClientFunctionality(false);
                }

                $enableOrderClassificationFunctionality = $this->params()->fromPost("enableOrderClassificationFunctionality", false);
                if($enableOrderClassificationFunctionality){
                    $entity->setEnableOrderClassificationFunctionality(true);
                }else{
                    $entity->setEnableOrderClassificationFunctionality(false);
                }

                $enableOrderTypeFunctionality = $this->params()->fromPost("enableOrderTypeFunctionality", false);
                if($enableOrderTypeFunctionality){
                    $entity->setEnableOrderTypeFunctionality(true);
                }else{
                    $entity->setEnableOrderTypeFunctionality(false);
                }

                $enableOrderSearchFunctionality = $this->params()->fromPost("enableOrderSearchFunctionality", false);
                if($enableOrderSearchFunctionality){
                    $entity->setEnableOrderSearchFunctionality(true);
                }else{
                    $entity->setEnableOrderSearchFunctionality(false);
                }

                $enablePriceListFunctionality = $this->params()->fromPost("enablePriceListFunctionality", false);
                if($enablePriceListFunctionality){
                    $entity->setEnablePriceListFunctionality(true);
                }else{
                    $entity->setEnablePriceListFunctionality(false);
                }

                $enablePriceListChangeAlert = $this->params()->fromPost("enablePriceListChangeAlertFunctionality", false);
                if($enablePriceListChangeAlert){
                    $entity->setEnablePriceListChangeAlertFunctionality(true);
                }else{
                    $entity->setEnablePriceListChangeAlertFunctionality(false);
                }

                $enablePriceListCustomer = $this->params()->fromPost("enablePriceListCustomerFunctionality", false);
                if($enablePriceListCustomer){
                    $entity->setEnablePriceListCustomerFunctionality(true);
                }else{
                    $entity->setEnablePriceListCustomerFunctionality(false);
                }

                $priceListChangeTime = $this->params()->fromPost("priceListChangeTime", false);
                if(is_numeric($priceListChangeTime)){
                    $entity->setPriceListChangeTime($priceListChangeTime);
                }

                $enableOrderCustomerTypeFunctionality = $this->params()->fromPost("enableOrderCustomerTypeFunctionality", false);
                if($enableOrderCustomerTypeFunctionality){
                    $entity->setEnableOrderCustomerTypeFunctionality(true);
                }else{
                    $entity->setEnableOrderCustomerTypeFunctionality(false);
                }

                $enableCustomerRegisterFullCheckFunctionality = $this->params()->fromPost("enableCustomerRegisterFullCheckFunctionality", false);
                if($enableCustomerRegisterFullCheckFunctionality){
                    $entity->setEnableCustomerRegisterFullCheckFunctionality(true);
                }else{
                    $entity->setEnableCustomerRegisterFullCheckFunctionality(false);
                }

                $enableOrderDiscountByUserFunctionality = $this->params()->fromPost("enableOrderDiscountByUserFunctionality", false);
                if($enableOrderDiscountByUserFunctionality){
                    $entity->setEnableOrderDiscountByUserFunctionality(true);
                }else{
                    $entity->setEnableOrderDiscountByUserFunctionality(false);
                }

                $enableProductListDiscountFunctionality = $this->params()->fromPost("enableProductListDiscountFunctionality", false);
                if($enableProductListDiscountFunctionality){
                    $entity->setEnableProductListDiscountFunctionality(true);
                }else{
                    $entity->setEnableProductListDiscountFunctionality(false);
                }

                $enableCustomerDirectRelationUserFunctionality = $this->params()->fromPost("enableCustomerDirectRelationUserFunctionality", false);
                if($enableCustomerDirectRelationUserFunctionality){
                    $entity->setEnableCustomerDirectRelationUserFunctionality(true);
                }else{
                    $entity->setEnableCustomerDirectRelationUserFunctionality(false);
                }

                $enableCustomerSyncUserAdminFunctionality = $this->params()->fromPost("enableCustomerSyncUserAdminFunctionality", false);
                if($enableCustomerSyncUserAdminFunctionality){
                    $entity->setEnableCustomerSyncUserAdminFunctionality(true);
                }else{
                    $entity->setEnableCustomerSyncUserAdminFunctionality(false);
                }

                $enableCustomerRelationUserFunctionality = $this->params()->fromPost("enableCustomerRelationUserFunctionality", false);
                if($enableCustomerRelationUserFunctionality){
                    $entity->setEnableCustomerRelationUserFunctionality(true);
                }else{
                    $entity->setEnableCustomerRelationUserFunctionality(false);
                }

                $disableCustomerRelationRepresentedFunctionality = $this->params()->fromPost("disableCustomerRelationRepresentedFunctionality", false);
                if($disableCustomerRelationRepresentedFunctionality){
                    $entity->setDisableCustomerRelationRepresentedFunctionality(true);
                }else{
                    $entity->setDisableCustomerRelationRepresentedFunctionality(false);
                }

                $enableCustomerAutoDiscountFunctionality = $this->params()->fromPost("enableCustomerAutoDiscountFunctionality", false);
                if($enableCustomerAutoDiscountFunctionality){
                    $entity->setEnableCustomerAutoDiscountFunctionality(true);
                }else{
                    $entity->setEnableCustomerAutoDiscountFunctionality(false);
                }

                $enableProductProgressiveDiscountFunctionality = $this->params()->fromPost("enableProductProgressiveDiscountFunctionality", false);
                if($enableProductProgressiveDiscountFunctionality){
                    $entity->setEnableProductProgressiveDiscountFunctionality(true);
                }else{
                    $entity->setEnableProductProgressiveDiscountFunctionality(false);
                }

                $enableProductLevelFunctionality = $this->params()->fromPost("enableProductLevelFunctionality", false);
                if($enableProductLevelFunctionality){
                    $entity->setEnableProductLevelFunctionality(true);
                }else{
                    $entity->setEnableProductLevelFunctionality(false);
                }

                $enableProductTwoLevelFunctionality = $this->params()->fromPost("enableProductTwoLevelFunctionality", false);
                if($enableProductTwoLevelFunctionality){
                    $entity->setEnableProductTwoLevelFunctionality(true);
                }else{
                    $entity->setEnableProductTwoLevelFunctionality(false);
                }

                $enableProductGridCenterFunctionality = $this->params()->fromPost("enableProductGridCenterFunctionality", false);
                if($enableProductGridCenterFunctionality){
                    $entity->setEnableProductGridCenterFunctionality(true);
                }else{
                    $entity->setEnableProductGridCenterFunctionality(false);
                }

                $enableOrderSyncFromTimeFunctionality = $this->params()->fromPost("enableOrderSyncFromTimeFunctionality", false);
                if($enableOrderSyncFromTimeFunctionality){
                    $entity->setEnableOrderSyncFromTimeFunctionality(true);
                }else{
                    $entity->setEnableOrderSyncFromTimeFunctionality(false);
                }

                $orderSyncTime = $this->params()->fromPost("orderSyncTime", false);
                if(is_numeric($orderSyncTime)){
                    $entity->setOrderSyncTime($orderSyncTime);
                }

                $this->getEntityManager()->merge($entity);
                $this->getEntityManager()->flush();

                $this->flashMessenger()->addSuccessMessage("Configurações alteradas com sucesso!");
                $this->redirectToDefaultRoute();

            }else{
                $this->redirectToDefaultRoute();
            }

        }catch(\Exception $ex){
            $this->flashMessenger()->addErrorMessage("Erro: " . $ex->getMessage());
            $this->redirectToDefaultRoute();
        }

    }

    public function fixAction()
    {
        // Fix Customer
//        $customers = $this->getEntityManager()->getRepository('Model\Entity\Customer')->findAll();
//        foreach($customers as $ent){
//            $ent->setName(utf8_encode($ent->getName()));
//            $this->getEntityManager()->merge($ent);
//        }
//
//        $this->getEntityManager()->flush();
//
//        $this->flashMessenger()->addSuccessMessage("OK");
//        $this->redirect()->toRoute('home');

    }
}
