<?php

namespace Application\Controller;

use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class CompanyController extends AbstractApplicationController
{   
    public function indexAction()
    {
        
        $entity = $this->getEntityManager()->getRepository($this->getEntityClass())->getDefault();
        if(!$entity){
            $entity = new $this->entityClass;
        }
        
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));
        
        if($entity->getId() != null){
            $form->bind($entity);
        }
        
        $request = $this->getRequest();
        
        if ($request->isPost()){
            
            $post = $request->getPost()->toArray();
            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($post, $entity);

            $entity->setCreated(new \Commons\Util\DateTimeBr());
            $file = $this->params()->fromFiles('imageFile');
            
            if($file['error'] == 0 && $file['size'] > 0){
                
                rename($file['tmp_name'], \Model\Entity\Company::LOGO_FILENAME);
                //$entity->setImage($imageName);
                $entity->setImage(\Model\Entity\Company::LOGO_FILENAME);
                
            }

            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();
            
            $this->flashMessenger()->addSuccessMessage('Registro inserido com sucesso!');
            return $this->redirectToDefaultRoute();
            
        }
        
        return new ViewModel(array('form' => $form, 'entity' => $entity));
    }
    
    public function addAction()
    {
        
        $entity = new $this->entityClass;
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));
        
        $request = $this->getRequest();
        
        if ($request->isPost()){
            
            $post = $request->getPost()->toArray();
            $post['price'] = str_replace(',', ".", str_replace(".", "", $post['price']));
            $post['priceMin'] = str_replace(',', ".", str_replace(".", "", $post['priceMin']));
            
            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($post, $entity);

            $this->getEntityManager()->persist($entity);
            $this->getEntityManager()->flush();

            $file = $this->params()->fromFiles('imageFile');
            if($file['error'] == 0 && $file['size'] > 0){
                $imageName = $entity->getId() . '.jpg';
                rename($file['tmp_name'], './data/images/' . $imageName);
                $entity->setImage($imageName);
            }

            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();
            
            // Create Warehouses
            $warehouses = $this->getEntityManager()->getRepository('Model\Entity\Warehouse')->findAll();
            foreach($warehouses as $ent){
                $pw = new \Model\Entity\ProductWarehouse();
                $pw->setProduct($entity);
                $pw->setWarehouse($ent);
                $pw->setAmount(0.0);
                $this->getEntityManager()->persist($pw);
            }
            
            $this->getEntityManager()->flush();
            
            $this->flashMessenger()->addSuccessMessage('Registro inserido com sucesso!');

            return $this->redirectToDefaultRoute();
            
        }
        
        return new ViewModel(array('form' => $form));
    }
    
    public function editAction()
    {
        $id = null;
        $request = $this->getRequest();
        
        if ($request->isPost()){
            $id = $this->params()->fromPost('id', false);
        }else{
            $id = $this->params()->fromRoute('id', false);
        }
        
        $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
        $builder = new \DoctrineORMModule\Form\Annotation\AnnotationBuilder($this->getEntityManager());
        $form = $builder->createForm($entity);
        $form->setHydrator(new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass()));

        if ($request->isPost()){
            
            $post = $request->getPost()->toArray();
            $post['price'] = str_replace(',', ".", str_replace(".", "", $post['price']));
            $post['priceMin'] = str_replace(',', ".", str_replace(".", "", $post['priceMin']));
            $entity = $this->getEntityManager()->find($this->getEntityClass(), $this->params()->fromPost('id'));
            
            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($post, $entity);
            
            $file = $this->params()->fromFiles('imageFile');
            if($file['error'] == 0 && $file['size'] > 0){
                $imageName = $entity->getId() . '.jpg';
                rename($file['tmp_name'], './data/images/' . $imageName);
                $entity->setImage($imageName);
            }
            
            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();
            
            $this->flashMessenger()->addSuccessMessage('Registro alterado com sucesso!');

            return $this->redirectToDefaultRoute();
            
        }else{
            $form->bind($entity);
        }
        
        return new ViewModel(array('form' => $form, 'entity' => $entity));
    }
    
    public function imageAction(){
        
        try{
            
            $filename = \Model\Entity\Company::LOGO_FILENAME;
        
            if(is_null($filename) || !file_exists($filename)){
                throw new \Exception("Image not found");
            }
            
            return $this->createFileResponse($filename, "image/jpg");
            
        }catch(\Exception $ex){
            return $this->createFileResponse(\Model\Entity\Product::NO_PICTURE_PATH, "image/jpg");
        }
        
        return $this->createFileResponse(\Model\Entity\Product::NO_PICTURE_PATH, "image/jpg");
    }
}
