<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2014 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Application\Controller;

use Commons\Util\GhostScriptUtil;
use Model\Entity\Catalog;
use Model\Entity\CatalogImage;
use Model\Entity\Product;
use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;
use ZF\Apigility\Documentation\JsonModel;

class CatalogController extends AbstractApplicationController
{   
    public function indexAction()
    {
        return new ViewModel();
    }

    public function addAction()
    {
        return new ViewModel();
    }

    public function editAction()
    {
        $id = null;
        $request = $this->getRequest();

        if ($request->isPost()){
            $id = $this->params()->fromPost('id', false);
        }else{
            $id = $this->params()->fromRoute('id', false);
        }

        $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);

        return new ViewModel(
            array(
                'entity' => $entity
            )
        );
    }

    public function addGalleryAction()
    {

        return new ViewModel();
    }
    
    public function editGalleryAction()
    {
        $id = null;
        $request = $this->getRequest();

        if ($request->isPost()){
            $id = $this->params()->fromPost('id', false);
        }else{
            $id = $this->params()->fromRoute('id', false);
        }

        $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);

        return new ViewModel(
            array(
                'entity' => $entity
            )
        );
    }

    public function addImagesAction(){

        try{

            $catalogID = $this->params()->fromPost('catalog', false);
            if(!$catalogID){
                throw new \Exception("Catalogo inválido");
            }

            $catalog = $this->getEntityManager()->find('Model\\Entity\\Catalog', $catalogID);

            $files = $this->params()->fromFiles('file', false);
            if(!$files){
                throw new \Exception("Nenhum arquivo enviado");
            }

            if(array_key_exists('name',$files)){
                $files = array($files);
            }

            $lastEntity = $this->getEntityManager()->getRepository("Model\\Entity\\CatalogImage")->findOneBy(array("catalog" => $catalog), array('order' => 'desc'));
            if($lastEntity){
                $order = $lastEntity->getOrder() + 1;
            }else{
                $order = 1;
            }

            foreach($files as $file){

                list($width, $height) = getimagesize($file['tmp_name']);

                $obj = new CatalogImage();
                $obj->setSize($file['size']);
                $obj->setType($file['type']);
                $obj->setWidth($width);
                $obj->setHeight($height);
                $obj->setCatalog($catalog);
                $obj->setOrder($order);
                $obj->setFileResource($file);

                $this->getEntityManager()->persist($obj);
                $order++;

            }

            $this->getEntityManager()->flush();

            return $this->createJsonResponse(array(
                'success' => true
            ));

        }catch(\Exception $ex){
            return $this->createJsonResponse(array(
                'success' => false,
                'error' => $ex->getMessage()
            ));
        }

    }

    /**
     * Reorder images
     * @return \Zend\View\Model\JsonModel
     */
    public function reorderImagesAction(){

        try{

            $images = $this->params()->fromPost("images", false);
            foreach($images as $img){
                $ent = $this->getEntityManager()->find("Model\\Entity\\CatalogImage", $img['id']);
                $ent->setOrder($img['order']);
                $this->getEntityManager()->merge($ent);
            }

            $this->getEntityManager()->flush();

            return $this->createJsonResponse(array(
                'success' => true
            ));

        }catch(\Exception $ex){

            return $this->createJsonResponse(array(
                'success' => false,
                'error' => $ex->getMessage()
            ));

        }

    }

    /**
     * Get image
     */
    public function fileAction(){

        try{

            $file   = $this->params()->fromRoute('id', false);
            $id     = $this->params()->fromQuery('catalog', false);

            if(!$id || !$file){
                throw new \Exception("File not found (1)");
            }

            $entity = $this->getEntityManager()->find('Model\\Entity\\Catalog', $id);
            if(!$entity){
                throw new \Exception("File not found (2)");
            }

            $path = Catalog::getPathForFile($file, $entity->getId());
            if(!file_exists($path)){
                throw new \Exception("File not found (3)");
            }

            $extension = pathinfo($file, PATHINFO_EXTENSION);
            switch($extension){
                case 'pdf':
                    $filetype = "application/pdf";
                    break;
                case 'jpeg':
                case 'jpg':
                    $filetype = "image/jpg";
                    break;
                case 'png':
                    $filetype = "image/png";
                    break;
            }

            $filename = $path;

            if(is_null($filename) || !file_exists($filename)){
                throw new \Exception("Image not found");
            }

            return $this->createFileResponse($filename, $filetype);

        }catch(\Exception $ex){

            return $this->createFileResponse(Product::NO_PICTURE_PATH, "image/jpg");

        }

        return $this->createFileResponse(Product::NO_PICTURE_PATH, "image/jpg");

    }

    /**
     * Catalogs thumb
     * @return mixed
     */
    public function thumbAction(){

        try{

            $id   = $this->params()->fromRoute('id', false);

            if(!$id){
                throw new \Exception("File not found (1)");
            }

            $entity = $this->getEntityManager()->find('Model\\Entity\\Catalog', $id);
            if(!$entity){
                throw new \Exception("File not found (2)");
            }

            if($entity->getType() == Catalog::TYPE_PDF){
                $file = $entity->getThumb();
                $path = $entity->getThumbPath();
            }else{
                if(count($entity->getCatalogImages()) <= 0){
                    throw new \Exception("File not found (3)");
                }
                $img = $entity->getCatalogImages()->get(0);
                $file = $img->getThumb();
                $path = $img->getThumbPath();
            }

            if(!file_exists($path)){
                throw new \Exception("File not found (3)");
            }

            $extension = pathinfo($file, PATHINFO_EXTENSION);
            switch($extension){
                case 'jpeg':
                case 'jpg':
                    $filetype = "image/jpg";
                    break;
                case 'png':
                    $filetype = "image/png";
                    break;
            }

            $filename = $path;

            if(is_null($filename) || !file_exists($filename)){
                throw new \Exception("File not found");
            }

            return $this->createFileResponse($filename, $filetype);

        }catch(\Exception $ex){
            return $this->createFileResponse(Product::NO_PICTURE_PATH, "image/jpg");
        }

        return $this->createFileResponse(Product::NO_PICTURE_PATH, "image/jpg");

    }
}
