<?php
/**
 * Order controller
 *
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Application\Controller;

use Rhumsaa\Uuid\Console\Exception;
use Zend\View\Model\JsonModel;
use Zend\View\Model\ViewModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class CashierController extends AbstractApplicationController
{

    public function indexAction()
    {
        $qb = $this->getEntityManager()->createQueryBuilder($this->getEntityClass())
            ->select('obj')
            ->from($this->getEntityClass(), 'obj');

        if(!$this->identity()->isAdmin()){
            $qb->where('obj.user = :user')
                ->setParameter('user', $this->identity());
        }

        $qb->orderBy('obj.id','DESC');

        $data = $qb->getQuery()->getResult();

        $users = array();
        if (count($data) > 0) {
            foreach ($data as $cashier) {
                if (is_object($cashier) && is_object($cashier->getUser()) && isset($users[$cashier->getUser()->getId()]) === false)
                    $users[$cashier->getUser()->getId()] = $cashier->getUser();
            }
        }

        $currentUser = $this->identity();

        $config = $this->getConfig();
        $cashierConfig = array();
        if (is_array($config) && isset($config['salestool']) && isset($config['salestool']['modules']) && isset($config['salestool']['modules']['cashier']))
            $cashierConfig = $config['salestool']['modules']['cashier'];

        return new ViewModel(array('data' => $data, 'users' => $users, 'currentUser' => $currentUser, 'cashierConfig' => $cashierConfig));
    }

    public function formAction()
    {
        $id = $this->params()->fromRoute('id',false);
        if (empty($id)) {
            $this->flashMessenger()->addErrorMessage("Um ou mais parâmetros não foram encontrados.");
            return $this->redirectToDefaultRoute();
        }

        $qb = $this->getEntityManager()->createQueryBuilder($this->getEntityClass())
            ->select('obj')
            ->from($this->getEntityClass(), 'obj')
            ->where('obj.id = :id')->setParameter('id', $id)
            ->orderBy('obj.id','DESC');

        if(!$this->identity()->isAdmin())
            $qb->where('obj.user = :user')->setParameter('user', $this->identity());

        $caixa = $qb->getQuery()->getOneOrNullResult();

        $itens = $caixa->getCashierExpenses();

        $currentUser = $this->identity();

        $config = $this->getConfig();
        $cashierConfig = array();
        if (is_array($config) && isset($config['salestool']) && isset($config['salestool']['modules']) && isset($config['salestool']['modules']['cashier']))
            $cashierConfig = $config['salestool']['modules']['cashier'];

        return new ViewModel(array('caixa' => $caixa, 'itens' => $itens, 'currentUser' => $currentUser, 'cashierConfig' => $cashierConfig));
    }

    public function removeAction()
    {

        $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro");
        return $this->redirectToDefaultRoute();

        try{

            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new Exception('Código não encontrado.');
            }

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new Exception('Código não encontrado.');
            }

            $this->getEntityManager()->remove($entity);
            $this->getEntityManager()->flush();
            $this->flashMessenger()->addSuccessMessage('Registro removido com sucesso!');

            return $this->redirectToDefaultRoute();

        } catch (\Doctrine\DBAL\DBALException $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro<br/>Pode ser que o registro que você está tentando remover possua relações com outros registros que impedem sua remoção.");
        } catch (\Exception $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro: {$ex->getMessage()}");
        }

        return $this->redirectToDefaultRoute();
    }

    public function removeItemAction()
    {

        $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro");
        return $this->redirectToDefaultRoute();

        try{

            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new Exception('Código não encontrado.');
            }

            if(!$this->identity()->isAdmin()){
                throw new Exception('Você não tem permissão para excluir este item.');
            }

            $entity = $this->getEntityManager()->find("\Model\Entity\CashierExpense", $id);
            if(!$entity){
                throw new Exception('Código não encontrado.');
            }

            $totalItem = $entity->getTotal();

            $caixa = $entity->getCashier();
            if(is_object($caixa) === false){
                throw new Exception('O caixa não foi encontrado.');
            }

            $sum = 0;
            if ($entity->getType() == \Model\Entity\CashierExpense::SAIDA) {

                $caixa->setTotalOutput($caixa->getTotalOutput() - $entity->getTotal());

            } else {

                $caixa->setTotalInput($caixa->getTotalInput() - $entity->getTotal());

            }

            $caixa->setTotal($caixa->getTotalInput() - $caixa->getTotalOutput());

            $this->getEntityManager()->persist($caixa);

            $this->getEntityManager()->remove($entity);

            $this->getEntityManager()->flush();

            $this->flashMessenger()->addSuccessMessage('Registro removido com sucesso!');

            $redirectUrl = @$_SERVER['HTTP_REFERER'];
            if (empty($redirectUrl) === false)
                return $this->redirect()->toUrl($redirectUrl);
            else
                return $this->redirectToDefaultRoute();

        } catch (\Doctrine\DBAL\DBALException $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro<br/>Pode ser que o registro que você está tentando remover possua relações com outros registros que impedem sua remoção.");
        } catch (\Exception $ex) {
            $this->flashMessenger()->addErrorMessage("Não foi possível remover o registro: {$ex->getMessage()}");
        }

        return $this->redirectToDefaultRoute();
    }

    public function printAction(){

        try{

            $this->layout('layout/print');

            $id = $this->params()->fromRoute('id', false);
            if(!$id){
                throw new \Exception("Id inválido");
            }

            $entity = $this->getEntityManager()->find('Model\Entity\Cashier', $id);
            if(!$entity){
                throw new \Exception("Nenhum caixa foi encontrado para este identificador!");
            }

            $company = $this->getEntityManager()->getRepository('Model\Entity\Company')->getDefault();

            // Get products
            $itens = array();
            foreach($entity->getCashierExpenses() as $tr){
                $itens[] = array(
                    'id' => (string)$tr->getId(),
                    'type' => $tr->getType(),
                    'date' => $tr->getExpenseDateFormatted(),
                    'description' => $tr->getDescription(),
                    'amount' => round($tr->getAmount()),
                    'price' => $tr->getPriceCurrencyBRL(),
                    'total' => $tr->getTotalCurrencyBRL(),
                    'obs' => $tr->getObs(),
                );
            }

            $config = $this->getConfig();
            $cashierConfig = array();
            if (is_array($config) && isset($config['salestool']) && isset($config['salestool']['modules']) && isset($config['salestool']['modules']['cashier']))
                $cashierConfig = $config['salestool']['modules']['cashier'];

            $viewData = array('entity' => $entity, 'company' => $company, 'itens' => $itens, 'cashierConfig' => $cashierConfig);

            return new ViewModel($viewData);

        }catch(\Exception $ex){

            $this->flashMessenger()->addErrorMessage("Ocorreu um erro ao processar sua solicitação.");

        }

        return $this->redirectToDefaultRoute();

    }

}
