<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of DataController
 *
 * @author renatopeterman
 */

namespace API\Controller;

use Zend\View\Model\ViewModel;

class OrderController extends AbstractApiActionController {

    protected $config;

    private function setConfig() {
        $this->config = $this->getEntityManager()->getRepository('Model\Entity\Config')->findOneBy(array());
        return $this->config;
    }

    private function checkOrderExists ($userId, $customerId, $json) {
        try {
            if (
                isset($json['dataPedido']) && empty($json['dataPedido']) === false &&
                isset($json['total']) && floatval($json['total']) >= 0.00
            ) {
                $queryCheck = $this->getEntityManager()->createQueryBuilder('Model\Entity\Order');
                $queryCheck->select('obj')
                    ->from('Model\Entity\Order','obj')
                    ->andWhere('obj.user = :userId')
                    ->andWhere('obj.customer = :customerId')
                    ->andWhere('obj.total = :totalJson')
                    ->orderBy('obj.id', 'DESC')
                    ->setParameter('userId', $userId)
                    ->setParameter('customerId', $customerId); 

                $ordersToCheck = $queryCheck->getQuery()->getResult();

                if (count($ordersToCheck) > 0) {
                    foreach ($ordersToCheck as $orderToCheck) {
                        $dateTimeOrder = \Commons\Util\DateTimeBr::createFromFormat("d/m/Y H:i", $json['dataPedido']);
                        if (
                            is_object($dateTimeOrder) &&
                            is_object($orderToCheck->getOrderDate()) &&
                            $orderToCheck->getOrderDate()->format('Ymdhi') === $dateTimeOrder->format('Ymdhi') &&
                            $orderToCheck->getTotal() > 0 &&
                            number_format($orderToCheck->getTotal(), 2, '.', '') === number_format(floatval($json['total']), 2, '.', '')
                        ) {
                            return $orderToCheck;
                        }
                    }
                }
                return false;
            }        
            return false;
        } catch (\Exception $e) {
            return false;
        }
    }

    public function sendAction() {

        try {

            $this->setConfig();

            $content = $this->getRequest()->getContent();
            if (!$content) {
                throw new \Exception("O conteúdo da requisição é inválido!");
            }

            error_log($content, 3, ROOT_PATH."/logs/php.log");

            $json = json_decode($content, true);
            if(json_last_error() != 0){
                throw new \Exception("Erro ao decodificar dados (Json error " . json_last_error() . ")");
            }

            // -------------- USER ---------------//

                if(isset($json['usuario']) === false){
                    throw new \Exception("O usuário inválido!");
                }

                $user = $this->getEntityManager()->find('Model\Entity\User', $json['usuario']);
                if(!$user){
                    throw new \Exception('Usuário não encontrado!');
                }

            // -------------- USER ---------------//

            // -------------- CUSTOMER ---------------//

                if(isset($json['cliente']) === false){
                    throw new \Exception("O cliente é inválido!");
                }

                $customerArr = $json['cliente'];
                $customer = null;
                if(isset($customerArr['id']) && $customerArr['id'] > 0){
                    $customer = $this->getEntityManager()->find('Model\Entity\Customer', $customerArr['id']);
                }

                if(is_object($customer) === false){

                    $dataToParse = $json['cliente'];
                    foreach ($dataToParse as $k => $d) {
                        if (is_string($d)) {
                            $json['cliente'][$k] = $this->removeAccent($d);
                        }
                    }

                    $customer = new \Model\Entity\Customer();
                    $customer->populateFromSync($json['cliente']);

                    $customerJson = $json['cliente'];

                    //Add price list
                    if(isset($customerJson['listaPreco']) && $customerJson['listaPreco'] > 0){
                        $priceList = $this->getEntityManager()->find('Model\Entity\PriceList', intval($customerJson['listaPreco']));           
                        $customer->setPriceList($priceList);                        
                    } 

                    //Add represented companies
                    if(is_array($customerJson['representadas']) && count($customerJson['representadas']) > 0){
                        $companies = array();
                        foreach($customerJson['representadas'] as $rCod){
                            $rep = $this->getEntityManager()->find('Model\Entity\RepresentedCompany', intval($rCod));
                            if($rep){
                                $companies[] = $rep;
                            }
                        }
                        $customer->addRepresentedCompanies($companies);
                    }

                    $this->getEntityManager()->persist($customer);

                    if (is_object($this->config) && is_object($user)) {
                        if ($this->config->getEnableCustomerRelationUserFunctionality()) {
                            $uc = new \Model\Entity\UserCustomer();
                            $uc->setCustomer($customer);
                            $uc->setUser($user);
                            $uc->setActive(true);
                            $this->getEntityManager()->persist($uc);
                        } else if ($this->config->getEnableCustomerDirectRelationUserFunctionality()) {
                            $customer->setUser($user);
                            $this->getEntityManager()->persist($customer);
                        }
                    }

                    $this->getEntityManager()->flush();

                } else if (is_object($this->config) && $this->config->getOrderCustomerInactive() === false && is_object($customer) && $customer->getActive() === false) {

                    return $this->createResponse(array('error' => true, 'message' => 'O cliente ('.$customer->getName().') está inativo!'));

                } else if (is_object($this->config) && $this->config->getOrderCustomerBlocked() === false && is_object($customer) && $customer->getBlocked() === true) {

                    return $this->createResponse(array('error' => true, 'message' => 'O cliente ('.$customer->getName().') está bloqueado!'));

                }

            // -------------- CUSTOMER ---------------//

            $warehouse = null;
            if(array_key_exists("estoque", $json) && (int)$json['estoque'] > 0){
                $warehouse = $this->getEntityManager()->find('Model\Entity\Warehouse', $json['estoque']);
            }else{
                $warehouse = $this->getEntityManager()->getRepository('Model\Entity\Warehouse')->findOneBy(array('main' => true));
            }

            if(is_object($warehouse) === false){
                throw new \Exception('Estoque não encontrado!');
            }

            if(isset($json['produtos']) === false || count($json['produtos']) <= 0){
                throw new \Exception('Não há produtos no pedido!');
            }

            $orderUpdate = false;
            $order = null;
            if (isset($json['id']) && empty($json['id']) === false)
                $order = $this->getEntityManager()->getRepository('Model\Entity\Order')->find((int)trim($json['id']));

            if (is_object($order) === false)
                $order = new \Model\Entity\Order();
            else
                $orderUpdate = true;

            if ($orderUpdate === false) {

                
                    // -------------- CHECK DUPLICATED NEW---------------//  

                    $checkOrderExist = $this->checkOrderExists($user->getId(), $customer->getId(), $json);
                    if ($checkOrderExist !== false && is_object($checkOrderExist) && $checkOrderExist->getId() > 0)
                        return $this->createResponse(array('success' => true, 'id' => $checkOrderExist->getId(), 'orderId' => $checkOrderExist->getId(), 'customerId' => (is_object($checkOrderExist->getCustomer()) ? $checkOrderExist->getCustomer()->getId() : null)));

                    // -------------- CHECK DUPLICATED NEW---------------//                
                

                $order->setCustomer($customer);
                $order->setWarehouse($warehouse); 
                $order->setUser($user);
                $order->setOrderDate(\Commons\Util\DateTimeBr::createFromFormat("d/m/Y H:i", $json['dataPedido']));

				//TODO Data de Envio -> date_delivery 
                $order->setDate_delivery(\Commons\Util\DateTimeBr::createFromFormat("d/m/Y H:i", $json['data_entrega'])); 

                //$cod_filial = $json['tipoCustomizado'] == '5' ? '300' : '100';  
                if( $json['tipoCustomizado'] == '2')
                    $cod_filial = '100';

                if( $json['tipoCustomizado'] == '3')
                $cod_filial = '200';

                if( $json['tipoCustomizado'] == '4')
                $cod_filial = '210';

                if( $json['tipoCustomizado'] == '5')
                $cod_filial = '300';

                if( $json['tipoCustomizado'] == '6')
                $cod_filial = '100';

                if( $json['tipoCustomizado'] == '7')
                $cod_filial = '200';

                if( $json['tipoCustomizado'] == '8')
                $cod_filial = '210';

                if( $json['tipoCustomizado'] == '9')
                $cod_filial = '300';

                if( $json['tipoCustomizado'] == '10')
                $cod_filial = '100';

                if( $json['tipoCustomizado'] == '11')
                $cod_filial = '200';

                if( $json['tipoCustomizado'] == '12')
                $cod_filial = '210';

                if( $json['tipoCustomizado'] == '13')
                $cod_filial = '300';

                if( $json['tipoCustomizado'] == '14')
                $cod_filial = '100';

                if( $json['tipoCustomizado'] == '15')
                $cod_filial = '200';

                if( $json['tipoCustomizado'] == '16')
                    $cod_filial = '210';

                if( $json['tipoCustomizado'] == '17')
                $cod_filial = '300';                    

                $order->setCod_filial($cod_filial);    

                // Representada
                if(isset($json['representada'])){
                    $rep = $this->getEntityManager()->find('Model\Entity\RepresentedCompany', intval($json['representada']));
                    if($rep){
                        $order->setRepresentedCompany($rep);
                    }
                }

                // Forma de Pagamento - Big Bem comentado o IF, depois de tratar no Sige, retirar
				/*
				$formaPagamento = $this->getEntityManager()->find('Model\Entity\PaymentMethod', intval(47));
				if($formaPagamento){
					$order->setPaymentMethod($formaPagamento);
				}
				*/

				//TODO Busca Condição de pagamento atrelado ao cadastro do cliente, feito para BigBemfoods
				//SQLBulder feito com createQueryBuilder
				/*
                $codeArr = (explode("-",$customer->getPayment_condition()));
                $code = trim($codeArr['0']);
                $queryPaymentCondition = $this->getEntityManager()->createQueryBuilder('Model\Entity\PaymentCondition');
                $queryPaymentCondition->select('obj')
                    ->from('Model\Entity\PaymentCondition','obj')
                    ->andWhere('obj.code = :cod')
                    ->setParameter('cod', $code); 
    
                $result = $queryPaymentCondition->getQuery()->setMaxResults(1)->getResult(); //->setMaxResults(1) 
                foreach ($result as $itemLocal) {  
                    $result = $itemLocal->getId();
                    //printf($count++.' -Teste imprimindo getCode()....... ' .$itemLocal->getId());  
                    //echo('<br/>');
                }
                
                //TODO Version: OR--04092023--105103
                if(empty($result)) 
                    $result = intval(375);

                // Condicao de Pagamento para Big Bem Foods
				$condPagamento = $this->getEntityManager()->find('Model\Entity\PaymentCondition', intval(trim($result)));
				if($condPagamento){
					$order->setPaymentCondition($condPagamento);
				}
				*/
				
				
                // Forma de Pagamento
                if(isset($json['formaPagamento'])){
                    $formaPagamento = $this->getEntityManager()->find('Model\Entity\PaymentMethod', intval($json['formaPagamento']));
                    if($formaPagamento){
                        $order->setPaymentMethod($formaPagamento);
                    }
                }

                // Condicao de Pagamento
                if(isset($json['condicaoPagamento'])){
                    $condPagamento = $this->getEntityManager()->find('Model\Entity\PaymentCondition', intval($json['condicaoPagamento']));
                    if($condPagamento){
                        $order->setPaymentCondition($condPagamento);
                    }
                }				


                // Classificacao
                if(isset($json['classificacao'])){
                    $rep = $this->getEntityManager()->find('Model\Entity\OrderCLassification', intval($json['classificacao']));
                    if(is_object($rep)){
                        $order->setOrderClassification($rep);
                    }
                }

                // Tipo Customizado
                if(isset($json['tipoCustomizado'])){
                    $rep = $this->getEntityManager()->find('Model\Entity\OrderType', intval($json['tipoCustomizado']));
                    if(is_object($rep)){
                        $order->setOrderType($rep);
                    }
                }

                // Tipo de Cliente para Pedido
                if(isset($json['pedidoClienteTipo'])){
                    $rep = $this->getEntityManager()->find('Model\Entity\OrderCustomerType', intval($json['pedidoClienteTipo']));
                    if(is_object($rep)){
                        $order->setOrderCustomerType($rep);
                    }
                }

            }

            $order->setActive(true); 
            $order->setSync(false);
            $order->setInfo($json['obs']);
            $order->setType($json['tipo']);
            $order->setDiscount($json['desconto']);
            $order->setSubtotal($json['subtotal']);
            $order->setTotal($json['total']);
            $order->setLatitude(isset($json['latitude']) ? $json['latitude'] : '');
            $order->setLongitude(isset($json['longitude']) ? $json['longitude'] : '');

            $order->setJson($content); // ADD the APP request to the order database 

            if (isset($json['descontoProgressivo1']) && $json['descontoProgressivo1'] > 0)
              $order->setDiscountPercent1(floatval($json['descontoProgressivo1']));

            if (isset($json['descontoProgressivo2']) && $json['descontoProgressivo2'] > 0)
              $order->setDiscountPercent2(floatval($json['descontoProgressivo2']));

            if (isset($json['descontoProgressivo3']) && $json['descontoProgressivo3'] > 0)
              $order->setDiscountPercent3(floatval($json['descontoProgressivo3']));

            if (isset($json['descontoProgressivo4']) && $json['descontoProgressivo4'] > 0)
              $order->setDiscountPercent4(floatval($json['descontoProgressivo4']));

            if (isset($json['descontoProgressivo5']) && $json['descontoProgressivo5'] > 0)
              $order->setDiscountPercent5(floatval($json['descontoProgressivo5']));

            if($order->getType() == \Model\Entity\Order::PEDIDO){

                $order->setStatus(\Model\Entity\Order::STATUS_WAITING);

            }else if($order->getType() == \Model\Entity\Order::VENDA){

                $order->setStatus(\Model\Entity\Order::STATUS_OK);

            }else if($orderUpdate === true && $order->getType() == \Model\Entity\Order::ATUALIZACAO){ //Test

                $order->setStatus(\Model\Entity\Order::STATUS_UPDATED);

                $order->setAppSync(true);
                $order->setAppSyncDatetime(\Commons\Util\DateTimeBr::createFromFormat("d/m/Y H:i", date("d/m/Y H:i")));

            }

            //------------------ CUSTOMER -------------//
                if (is_object($customer)) {
                    $customer->setLastOrderDate(\Commons\Util\DateTimeBr::createFromFormat("d/m/Y H:i", date("d/m/Y H:i")));
                    $this->getEntityManager()->persist($customer);
                }
            //------------------ CUSTOMER -------------//

            $this->getEntityManager()->persist($order);
            $this->getEntityManager()->flush();

            // Get user represented company values
            $userRepresentedCompany = null;
            if($order->getRepresentedCompany() && $order->getUser()){
                $userRepresentedCompany = $this->getEntityManager()->getRepository('Model\\Entity\\UserRepresentedCompany')->findOneBy(array(
                    'representedCompany' => $order->getRepresentedCompany(),
                    'user' => $order->getUser()
                ));
            }

            $totalCommission = 0;

            $cores = array();
            $tamanhos = array();
            $itensAdicionados = array();

            foreach($json['produtos'] as $item){

                $produto = $this->getEntityManager()->find('Model\Entity\Product', $item['codigo']);
                if($produto){
                    

                    if (in_array($item['codigo'], $itensAdicionados) && (!isset($item['variantes']) || !is_array($item['variantes']) || count($item['variantes']) === 0)) 
                    {
                        continue; // Pula para o proximo item do pedido pois ja foi adicionado o mesmo item anteriormente
                    }
                    
                    $itensAdicionados[] = $item['codigo'];                    
                    

                    $orderProductUpdate = false;
                    $op = null;
                    if (isset($item['id']) && empty($item['id']) === false)
                        $op = $this->getEntityManager()->getRepository('Model\Entity\OrderProduct')->find((int)trim($item['id']));

                    if (is_object($op) === false)
                        $op = new \Model\Entity\OrderProduct();
                    else
                        $orderProductUpdate = true;

                    if ($orderProductUpdate === false) {
                        $op->setOrder($order);
                        $op->setWarehouse($warehouse);
                        $op->setProduct($produto);
                    }

                    if ($produto->getCode() != '')
                        $op->setCodeProduct($produto->getCode());
                    
                    $op->setAmount($item['quantidade']);
                    $op->setSubtotal($item['subtotal']);
                    $op->setTotal($item['total']);
                    $op->setIcmsst($item['ICMSST']);
                    $op->setIpi($item['IPI']);        
                    $op->setPercIpi($item['percIpi']);
                    $op->setPrice($item['preco']);
                    
                    //$op->setDiscount($item['desconto']);		
                    $op->setDiscount(0.0);	
                    
			/*				
                    if (isset($item['desconto']) && !empty($item['desconto'])) {
                        $op->setDiscount($item['desconto']);
                    }
			*/
                    if (isset($item['desconto']) && !empty($item['desconto'])) {
                        $op->setDiscountaux($item['desconto']);
                    } 
            

                    if (isset($item['quantidadeUnidade']) && !empty($item['quantidadeUnidade'])) {  
                        $op->setAmountUnit(floatval($item['quantidadeUnidade'])); 
                        //$op->setAmountUnit(floatval($item['quantidade']));  
                    }


                    $code = $item['quantidadeUnidadeCodigo'];
                    $queryUnitAmount = $this->getEntityManager()->createQueryBuilder('Model\Entity\UnitAmount');
                    $queryUnitAmount->select('obj')
                        ->from('Model\Entity\UnitAmount','obj')
                        ->andWhere('obj.code = :cod')
                        ->setParameter('cod', $code); 
        
                    $result = $queryUnitAmount->getQuery()->setMaxResults(1)->getResult(); //->setMaxResults(1) 
                    foreach ($result as $itemLocal) {  
                        $result = $itemLocal->getDescription();
                        //printf($count++.' -Teste imprimindo getCode()....... ' .$itemLocal->getId());  
                        //echo('<br/>');
                    }
                    if (isset($item['quantidadeUnidadeCodigo']) && !empty($item['quantidadeUnidadeCodigo'])) {
                        $op->setAmountUnitCode(trim($result));
                    }

                    /* TRECHO DESCONTO 
                    if (isset($item['desconto']) && empty($item['desconto']) === false && floatval($item['desconto']) > 0) {

                        $discount = (floatval($item['desconto']) / 100) * floatval($item['subtotal']);

                        $op->setPrice($item['preco']);
                        $op->setDiscount($discount);
                    } else {
                        
                        $op->setPrice($item['preco']);
                        $op->setDiscount(0.0);
                    }
                    
                    */

            /* TRECHO DESCONTO FIM */
            
            
            

                    $op->setObs($item['obs']);
                    $op->setCost($item['cost']);


                    $op->setActive(true);
                    $op->setSync(false);

                    if (isset($item['quantidadeDevolvida']))
                        $op->setAmountDevolution($item['quantidadeDevolvida']);

                    if (isset($item['quantidadeDevolvidaNota']))
                        $op->setAmountDevolutionInvoice($item['quantidadeDevolvidaNota']);

                    if (isset($item['descontoProgressivo1']) && $item['descontoProgressivo1'] > 0)
                        $op->setDiscountPercent1(floatval($item['descontoProgressivo1']));

                    if (isset($item['descontoProgressivo2']) && $item['descontoProgressivo2'] > 0)
                        $op->setDiscountPercent2(floatval($item['descontoProgressivo2']));

                    if (isset($item['descontoProgressivo3']) && $item['descontoProgressivo3'] > 0)
                        $op->setDiscountPercent3(floatval($item['descontoProgressivo3']));

                    if (isset($item['descontoProgressivo4']) && $item['descontoProgressivo4'] > 0)
                        $op->setDiscountPercent4(floatval($item['descontoProgressivo4']));

                    if (isset($item['descontoProgressivo5']) && $item['descontoProgressivo5'] > 0)
                        $op->setDiscountPercent5(floatval($item['descontoProgressivo5']));

                    $this->getEntityManager()->persist($op);

                    // Stock and calculate commission
                    if($order->getType() == \Model\Entity\Order::VENDA){

                        $pw = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $produto, 'warehouse' => $warehouse));
                        $pw->subtract($item['quantidade']);
                        $this->getEntityManager()->merge($pw);

                        # Calculate commissions
                        $commissionValue = 0;
                        if($op->getProduct()->getCommission() && $op->getProduct()->getCommission() > 0){

                            $commissionValue = $op->getProduct()->getCommission();

                        }else if($userRepresentedCompany && $userRepresentedCompany->getCommission() > 0){

                            $commissionValue = $userRepresentedCompany->getCommission();

                        }

                        if($commissionValue && $commissionValue > 0){
                            $c = ($commissionValue / 100) * $op->getTotal();
                            $op->setCommission($c);
                            $totalCommission += $c;
                            $this->getEntityManager()->merge($op);
                        }

                    }

                      // Variantes
                    if (isset($item['variantes']) && is_array($item['variantes']) && count($item['variantes']) > 0) {

                        if (!(is_object($this->config) && $this->config->getEnableOrderProductDivisionFunctionality())) {
                            if (count($cores) == 0) {
                                $cores = $this->getKeyValEntities($this->getEntityManager()->getRepository('Model\\Entity\\Color')->findAll());
                            }
                            if (count($tamanhos) == 0) {
                                $tamanhos = $this->getKeyValEntities($this->getEntityManager()->getRepository('Model\\Entity\\Size')->findAll());
                            }
                        }

                        foreach ($item['variantes'] as $variante) {
                            if (
                                is_object($op) &&
                                isset($variante['quantidade']) && $variante['quantidade'] > 0 &&
                                (
                                    (is_object($this->config) && $this->config->getEnableOrderProductDivisionFunctionality()) ||
                                    (
                                        isset($variante['cor']) && isset($cores[trim($variante['cor'])]) && is_object($cores[trim($variante['cor'])]) &&
                                        isset($variante['tamanho']) && isset($tamanhos[trim($variante['tamanho'])]) && is_object($tamanhos[trim($variante['tamanho'])])
                                    )
                                )
                            ) {
                                $opv = new \Model\Entity\OrderProductVariant();
                                $opv->setOrderProduct($op);
                                $opv->setAmount((float)$variante['quantidade']);
                                if (is_object($this->config) && $this->config->getEnableOrderProductDivisionFunctionality()) {
                                    $opv->setValueIni((float)$variante['valorInicial']);
                                    $opv->setValueEnd((float)$variante['valorFinal']);
                                } else {
                                    $opv->setColor($cores[trim($variante['cor'])]);
                                    $opv->setSize($tamanhos[trim($variante['tamanho'])]);
                                }
                                $opv->setPrice((float)$variante['preco']);
                                $opv->setActive(true);
                                $opv->setSync(false);
                                $this->getEntityManager()->persist($opv);
                            }
                        }
                    }
                }

            }

            if ($orderUpdate === false)
              $order->setCommission($totalCommission);

            $this->getEntityManager()->merge($order);
            $this->getEntityManager()->flush();

            return $this->createResponse(array('success' => true, 'id' => $order->getId(), 'orderId' => $order->getId(), 'customerId' => (is_object($order->getCustomer()) ? $order->getCustomer()->getId() : null)));

        } catch(\Exception $ex) {
            error_log("\r\n\r\n".$ex->getMessage()."\r\n\r\n", 3, ROOT_PATH."/logs/php.log");
            return $this->createErrorResponse("Erro: " . $ex->getMessage());
        }

    }

    //--------------------------------- Raphael Vizoni do Prado 14/01/2016 ----------------------
    public function statusConfirmedAction() {

        $response = array(
            'success' => false
        );

        // recebe o id vindo da rota, setando valor falso por default
        $json['codigo'] = $this->params()->fromRoute('id', false);

        try{

            $this->setConfig();

            if(isset($json['codigo']) === false){
                throw new \Exception("Código invalido");
            }

            // variavel recebe o campo código vindo da API
            $orderArr['id'] = $json['codigo'];
            $order = null;
            // verifica se o campo código vindo está setado
            if(isset($orderArr['id']) && $orderArr['id'] > 0){
                // se estiver setado, armazena na variavel $order,
                $order = $this->getEntityManager()->find('Model\Entity\Order', $orderArr['id']);
                if(!$order) {
                    throw new \Exception("Pedido não encontrado");
                }
            }

            /* EXPLICAÇÃO REFERENTE AO CÓDIGO ABAIXO:
            - Pega a empresa e usuario da ordem
            - Pega porcentagem de desconto
            - P/ cada produto pedido ($op) pega o campo produto e campo armazem
                - Calcula a comissão baseada no produto (SE TIVER)
                - Calcula a comissão baseada na empreasa (SE TIVER)
                - Calcula o valor total da comissão
                - Calcula o desconto  (se tiver)
                - Seta o valor da comissão
            - Altera status do pedido para OK
            - Salva localmente
            - Envia p/ banco (flush)

            */
            $userRepresentedCompany = null;
            if($order->getRepresentedCompany() && $order->getUser()){
                //pega o user e represented company da entidade userRepresentedCompany
                $userRepresentedCompany = $this->getEntityManager()->getRepository('Model\\Entity\\UserRepresentedCompany')->findOneBy(array(
                    'representedCompany' => $order->getRepresentedCompany(),
                    'user' => $order->getUser()
                ));
            }

            //Check for order discount percent
            $orderDiscountPercent = $order->getDiscountPercent();

            $totalCommission = 0;
            // para cada pedido pedido ( $op )
            foreach($order->getOrderProducts() as $op){
                //product warehouse = produto e armazém da entidade product warehouse
                $pw = $this->getEntityManager()->find('Model\Entity\ProductWarehouse', array('product' => $op->getProduct(), 'warehouse' => $order->getWarehouse()));
                $pw->subtract($op->getAmount());
                $this->getEntityManager()->merge($pw);

                // Calculate commissions
                $commissionValue = 0;
                if($op->getProduct()->getCommission() && $op->getProduct()->getCommission() > 0){
                    // pega o valor de cada comissao por cada produto pedido ($op) se a comissão foi setada > 0
                    $commissionValue = $op->getProduct()->getCommission();

                }else if($userRepresentedCompany && $userRepresentedCompany->getCommission() > 0){
                    // se nao pega o valor de comissao definido por cada empresa
                    $commissionValue = $userRepresentedCompany->getCommission();

                }
                // se o valor da comissao for > 0
                if($commissionValue && $commissionValue > 0){
                    // total do pedido = ...
                    $opTotal = $op->getTotal();
                    // se o percentual de desconto for > 0
                    /*if($orderDiscountPercent > 0){
                        // total do pedido = total do pedido - a porcentagem definida * total
                        $opTotal = $opTotal - (($orderDiscountPercent/100) * $opTotal);
                    }*/
                    // valor da comissao é sua porcentagem * total
                    $c = ($commissionValue / 100) * $opTotal;
                    // seta o valor da comissao
                    $op->setCommission($c);
                    // incrementa o valor   T O T A L  da comissao com a nova comissao
                    $totalCommission += $c;
                    // $this->getEntityManager()->merge($op);
                }

            }

            // só depois que seta o status para "STATUS_OK"
            $order->setCommission($totalCommission);
            $order->setStatus(\Model\Entity\Order::STATUS_OK);

            //salva local e depois envia (flush)
            $this->getEntityManager()->merge($order);
            $this->getEntityManager()->flush();

            return $this->createResponse(array('success' => true, 'id' => $order->getId() ));

         }catch(\Exception $ex){
            //trigger_error($ex->getMessage());
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

    }
    //--------------------------------- Raphael Vizoni do Prado 14/01/2016 ----------------------

    public function findAction() {
        try {

            $this->layout('layout/print');

            $code = $this->params()->fromQuery('codigo', false);

            if (!$code) {
                throw new \Exception("Código inválido");
            }

            $entity = null;
            if (empty($code) === false) {
                $entity = $this->getEntityManager()->getRepository('Model\Entity\Order')->findOneBy(array('reference' => $code));
                if (is_object($entity) === false)
                    $entity = $this->getEntityManager()->getRepository('Model\Entity\Order')->findOneBy(array('code' => $code));
                if (is_object($entity) === false)
                    $entity = $this->getEntityManager()->getRepository('Model\Entity\Order')->findOneBy(array('id' => $code));
            }

            if (is_object($entity) === false) {
                throw new \Exception("Nenhum pedido foi encontrado para o código enviado.");
            }

            # Select products ordered by name
            $products = $this->getEntityManager()->createQueryBuilder()
                ->select("obj")
                ->from("Model\\Entity\\OrderProduct","obj")
                ->join("obj.product","prd")
                ->where("obj.order = :ord")
                ->orderBy("prd.name")
                ->setParameter("ord", $entity)
                ->getQuery()->getResult();

            $variants = array();
            if (count($products) > 0) {
                foreach ($products as $product) {
                    $variants[$product->getId()] = $product->getOrderProductVariants();
                }
            }

            return new ViewModel(array('error' => false, 'entity' => $entity, 'products' => $products, 'variants' => $variants));

        } catch(\Exception $ex) {

            return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));

        }
    }


    /*
    function searchUnitAmount($code){
            $code = "100003"; 
            $queryUnitAmount = $this->getEntityManager()->createQueryBuilder('Model\Entity\UnitAmount');
            $queryUnitAmount->select('obj')
                ->from('Model\Entity\UnitAmount','obj')
                ->andWhere('obj.code = :cod')
                ->setParameter('cod', $code); 

            $result = $queryUnitAmount->getQuery()->setMaxResults(1)->getResult(); //->setMaxResults(1) 
            foreach ($result as $itemLocal) {  
                $result = $itemLocal->getDescription();
                //printf($count++.' -Teste imprimindo getCode()....... ' .$itemLocal->getId());  
                //echo('<br/>');
            }

        return $result;
    }
    */
    



}

?>
