<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of DataController
 *
 * @author renatopeterman
 */

namespace API\Controller;

use Model\Entity\Catalog;
use Commons\Util\DateTimeBr;
use Rhumsaa\Uuid\Console\Exception;

class DataController extends AbstractApiActionController {

    protected $config;

    private function setConfig() {

        $this->config = $this->getEntityManager()->getRepository('Model\Entity\Config')->findOneBy(array());
        return $this->config;
    }

    private function checkIntegration($action) {
        try {
            $systemConfig = $this->getConfig();
            if (
              is_array($systemConfig)
              && isset($systemConfig['salestool'])
              && isset($systemConfig['salestool']['hasIntegration'])
              && $systemConfig['salestool']['hasIntegration']
              && isset($systemConfig['salestool']['integration'])
              && isset($systemConfig['salestool']['integration']['data'])
              && isset($systemConfig['salestool']['integration']['data'][$action])
              && empty($systemConfig['salestool']['integration']['data'][$action]) === false
            ) {
              return $systemConfig['salestool']['integration']['data'][$action];
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function configAction(){

        try{

            $entity = $this->setConfig();
            //$entity = new \Model\Entity\Config();

            $dataToReturn = array(
                'maxDiscount' => floatval($entity->getMaxDiscount()),
                'orderCustomerInactive' => $entity->getOrderCustomerInactive(),
                'orderCustomerBlocked' => $entity->getOrderCustomerBlocked(),
                'enableCashierFunctionality' => $entity->getEnableCashierFunctionality(),
                'enableOrderUpdateFromClientFunctionality' => $entity->getEnableOrderUpdateFromClientFunctionality(),
                'enableOrderClassificationFunctionality' => $entity->getEnableOrderClassificationFunctionality(),
                'enableOrderTypeFunctionality' => $entity->getEnableOrderTypeFunctionality(),
                'enableOrderSearchFunctionality' => $entity->getEnableOrderSearchFunctionality(),
                'enablePriceListFunctionality' => $entity->getEnablePriceListFunctionality(),
                'enablePriceListChangeAlertFunctionality' => ($entity->getPriceListChangeTime() > 0 ? $entity->getEnablePriceListChangeAlertFunctionality() : false),
                'priceListChangeTime' => ($entity->getPriceListChangeTime() > 0 ? $entity->getPriceListChangeTime() : 0),
                'enableOrderCustomerTypeFunctionality' => $entity->getEnableOrderCustomerTypeFunctionality(),
                'enableCustomerRegisterFullCheckFunctionality' => $entity->getEnableCustomerRegisterFullCheckFunctionality(),
                'enableProductProgressiveDiscountFunctionality' => $entity->getEnableProductProgressiveDiscountFunctionality(),
                'enableProductLevelFunctionality' => $entity->getEnableProductLevelFunctionality(),
                'enableProductTwoLevelFunctionality' => $entity->getEnableProductTwoLevelFunctionality(),
                'enableOrderSyncFromTimeFunctionality' => ($entity->getOrderSyncTime() > 0 ? $entity->getEnableOrderSyncFromTimeFunctionality() : false),
                'disableCustomerRelationRepresentedFunctionality' => $entity->getDisableCustomerRelationRepresentedFunctionality(),
                'enableCustomerAutoDiscountFunctionality' => $entity->getEnableCustomerAutoDiscountFunctionality(),
                'enableProductListDiscountFunctionality' => $entity->getEnableProductListDiscountFunctionality(),
                'enableOrderProductDivisionFunctionality' => $entity->getEnableOrderProductDivisionFunctionality(),
                'enableOrderProductUnitAmountFunctionality' => ($entity->getEnableOrderProductUnitAmountFunctionality() ? $entity->getEnableOrderProductUnitAmountFunctionality() : false),
                'enablePriceListCustomerFunctionality' => ($entity->getEnablePriceListCustomerFunctionality() ? $entity->getEnablePriceListCustomerFunctionality() : false),
                'syncTaxation' => ($entity->getSyncTaxation() ? $entity->getSyncTaxation() : false)

            );

            if ($entity->getEnableOrderDiscountByUserFunctionality() === true) {
                $user = $this->getUser();
                if (is_object($user)) {
                    if ($user->getDiscountMaximum() != null && $user->getDiscountMaximum() > 0) {
                        $dataToReturn['maxDiscount'] = floatval($user->getDiscountMaximum());
                    }
                }
            }

            return $this->createResponse($dataToReturn);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    public function orderAction(){

        try {

            $integrationRoute = $this->checkIntegration('order');
            if ($integrationRoute)
                return $this->forward()->dispatch('API\Controller\Custom\\'.$integrationRoute.'\Data', array(
                    'action' => 'order'
                ));

            $this->setConfig();

            $user = $this->getUser();
            if (is_object($user) === false) {
                throw new Exception('Usuário não encontrado!');
            }

            $query = $this->getEntityManager()->createQueryBuilder('Model\Entity\Order');

            $query->select('obj')
                ->from('Model\Entity\Order','obj')
                ->orderBy('obj.id', 'ASC')
                ->andWhere('obj.user = :userId')
                ->setParameter('userId', $user->getId());

            if ($this->config->getEnableOrderUpdateFromClientFunctionality()) {

                $query->andWhere('obj.appSync = :sync')
                      ->andWhere('obj.appDatetimeToSync IS NOT NULL')
                      ->andWhere('obj.appDatetimeToSync <= :datetime')
                      ->setParameter('sync', 0)
                      ->setParameter('datetime', new DateTimeBr());

            } else if ($this->config->getEnableOrderSyncFromTimeFunctionality() && $this->config->getOrderSyncTime() > 0) { //Test3

                $datetime = new \DateTime();
                $datetime->sub(new \DateInterval('P'.$this->config->getOrderSyncTime().'D'));
                $datetime->setTime(3, 0, 0);
                $datetime->setTimezone(new \DateTimeZone('America/Sao_Paulo'));

                $query->andWhere('obj.orderDate IS NOT NULL')
                      ->andWhere('obj.orderDate >= :datetime')
                      ->setParameter('datetime', $datetime);

            }

            $results = $query->getQuery()->getResult(); //->setMaxResults(1)

            $retorno = array();
            if (count($results) > 0) {
                $counter = 0;
                foreach ($results as $ent) {
                    $order = array(
                        'id' => $ent->getId(),
                        'userId' => (int)$user->getId(),
                        'userName' => $user->getName(),
                        'code' => $ent->getCode(),
                        'reference' => $ent->getReference(),
                        'type' => $ent->getType(),
                        'orderDate' => $ent->getOrderDate()->format('d/m/Y H:i'),
                        'expectedDelivery' => $ent->getExpectedDelivery(),
                        'subtotal' => $ent->getSubtotal(),
                        'discount' => $ent->getDiscount(),
                        'discountPercent1' => $ent->getDiscountPercent1(),
                        'discountPercent2' => $ent->getDiscountPercent2(),
                        'discountPercent3' => $ent->getDiscountPercent3(),
                        'discountPercent4' => $ent->getDiscountPercent4(),
                        'discountPercent5' => $ent->getDiscountPercent5(),
                        'total' => $ent->getTotal(),
                        'commission' => $ent->getCommission(),
                        'status' => $ent->getStatus(),
                        'info' => $ent->getInfo(),
                        'device' => '',
                        'customer' => (is_object($ent->getCustomer())?$ent->getCustomer()->getId():null),
                        'customerName' => (is_object($ent->getCustomer())?$ent->getCustomer()->getName():null),
                        'customerCity' => (is_object($ent->getCustomer())?$ent->getCustomer()->getCity():null),
                        'customerState' => (is_object($ent->getCustomer())?$ent->getCustomer()->getState():null),
                        'warehouse' => (is_object($ent->getWarehouse())?$ent->getWarehouse()->getId():null),
                        'warehouseDescription' => (is_object($ent->getWarehouse())?$ent->getWarehouse()->getDescription():null),
                        'representedCompany' => (is_object($ent->getRepresentedCompany())?$ent->getRepresentedCompany()->getId():null),
                        'representedCompanyName' => (is_object($ent->getRepresentedCompany())?$ent->getRepresentedCompany()->getCompanyName():null),
                        'paymentMethod' => (is_object($ent->getPaymentMethod())?$ent->getPaymentMethod()->getId():null),
                        'paymentMethodDescription' => (is_object($ent->getPaymentMethod())?$ent->getPaymentMethod()->getDescription():null),
                        'paymentCondition' => (is_object($ent->getPaymentCondition())?$ent->getPaymentCondition()->getId():null),
                        'paymentConditionDescription' => (is_object($ent->getPaymentCondition())?$ent->getPaymentCondition()->getDescription():null),

                        'orderType' => (is_object($ent->getOrderType())?$ent->getOrderType()->getId():null),
                        'orderTypeDescription' => (is_object($ent->getOrderType())?$ent->getOrderType()->getDescription():null),
                        'orderClassification' => (is_object($ent->getOrderClassification())?$ent->getOrderClassification()->getId():null),
                        'orderClassificationDescription' => (is_object($ent->getOrderClassification())?$ent->getOrderClassification()->getDescription():null),
                        'orderCustomerType' => (is_object($ent->getOrderCustomerType())?$ent->getOrderCustomerType()->getId():null),
                        'orderCustomerTypeDescription' => (is_object($ent->getOrderCustomerType())?$ent->getOrderCustomerType()->getDescription():null),

                        'longitude' => $ent->getLongitude(),
                        'latitude' => $ent->getLatitude(),
                        'orderProducts' => array()
                    );
                    $retorno[$counter] = $order;
                    $itens = $ent->getOrderProducts();
                    if (count($itens) > 0) {
                        $counterItem = 0;
                        foreach($itens as $item){
                            if (is_object($item->getProduct())) {

                                $discount = $price = 0;
                                /*
                                if ((float)$item->getTotal() != (float)$item->getSubtotal()) {
                                    $discount = 100 * (1 - ((float)$item->getTotal() / (float)$item->getSubtotal()));
                                    $price = (float)$item->getPrice() - (($discount / 100) * (float)$item->getPrice());
                                } else {
                                    $discount = (float)$item->getDiscount();
                                    $price = (float)$item->getPrice();
                                }
                                */
                                $discount = (float)$item->getDiscount();
                                $price = (float)$item->getPrice();
                                
                                $retorno[$counter]['orderProducts'][$counterItem] = array(
                                    'id' => $item->getId(),
                                    'code' => $item->getCode(),
                                    'codeProduct' => $item->getCodeProduct(),
                                    'reference' => $item->getReferenceProduct(),
                                    'product' => (is_object($item->getProduct())?$item->getProduct()->getId():null),
                                    'productName' => (is_object($item->getProduct())?$item->getProduct()->getName():null),
                                    'warehouse' => (is_object($item->getWarehouse())?$item->getWarehouse()->getId():null),
                                    'amount' => (int)$item->getAmount(),
                                    'price' => round($price, 4),
                                    'subtotal' => (float)$item->getSubtotal(),
                                    'discount' => round($discount, 4),
                                    'total' => (float)$item->getTotal(),
                                    'obs' => $item->getObs(),
                                    'icmsst' => (float)$item->getIcmsst(),
                                    'ipi' => (float)$item->getIpi(),
                                    'cost' => (float)$item->getCost(),
                                    'commission' => (float)$item->getCommission(),
                                    'perIpi' => (float)$item->getPercIpi(),
                                    'orderProductVariants' => array()
                                );
                            }
                            $counterItem++;
                        }
                    }
                    $counter++;
                }
            }

            return $this->createResponse($this->replaceUselessValues($retorno));

        } catch(\Exception $ex) {
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

    }

    public function orderTypeAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\OrderType')
                ->select('obj')
                ->from('Model\\Entity\\OrderType','obj')
                ->andWhere('obj.hidden = 0')
                ->andWhere('obj.active = 1')
                ->getQuery()->getArrayResult();

            $dataToPrint = array();
            if (count($data) > 0) {
                foreach ($data as $item) {
                  $dataToPrint[] = array(
                    'id' => $item['id'],
                    'code' => $item['code'],
                    'orderTypeIdChange' => $item['orderTypeIdChange'],
                    'description' => $item['description'],
                    'position' => (int)$item['position'],
                    'disableOrderMethod' => $item['disableOrderMethod'],
                    'disableOrderCondition' => $item['disableOrderCondition'],
                    'disableOrderValue' => $item['disableOrderValue'],
                    
                    'disableOrderDiscount' => $item['disableOrderDiscount'],
                    'disableOrderClassification' => $item['disableOrderClassification'],
                    'disableOrderClientType' => $item['disableOrderClientType'],

                    'disablePromotion' => $item['disablePromotion'],

                    'disableOrderObs' => $item['disableOrderObs'],
                    'codfilial' => $item['codfilial'],
                    'codlista' => $item['codlista'],
                  );
                }
            }

            return $this->createResponse($dataToPrint);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();
    }

    public function orderCustomerTypeAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\OrderCustomerType')
                ->select('obj')
                ->from('Model\\Entity\\OrderCustomerType','obj')
                ->where('obj.active = 1')
                ->getQuery()->getArrayResult();

            $dataToPrint = array();
            if (count($data) > 0) {
                foreach ($data as $item) {
                    $dataToPrint[] = array(
                        'id' => $item['id'],
                        'code' => $item['code'],
                        'description' => $item['description'],
                        'position' => (int)$item['position']
                    );
                }
            }

            return $this->createResponse($dataToPrint);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();
    }

    public function orderClassificationAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\OrderClassification')
                ->select('obj')
                ->from('Model\\Entity\\OrderClassification','obj')
                ->where('obj.active = 1')
                ->getQuery()->getArrayResult();

            $dataToPrint = array();
            if (count($data) > 0) {
                foreach ($data as $item) {
                  $dataToPrint[] = array(
                    'id' => $item['id'],
                    'code' => $item['code'],
                    'description' => $item['description']
                  );
                }
            }

            return $this->createResponse($dataToPrint);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    private function getCustomerList ($user, $getPriceList = null) {

        $query = $this->getEntityManager()->createQueryBuilder('Model\Entity\Customer');

        if ($getPriceList === true) {
            $query->select('obj');
            $query->andWhere('obj.priceList IS NOT NULL');
            $query->groupBy('obj.priceList');
        } else {
            $query->select('obj');
        }

        $query->from('Model\Entity\Customer','obj')
                ->orderBy('obj.name', 'ASC');

        if ($this->config->getSyncCustomerInactive() == false)
            $query->andWhere('obj.active = 1');

        $idCustomers = array();

        if ($this->config->getEnableCustomerSyncUserAdminFunctionality() && $user->isAdmin()) {

            //Do nothing

        } else if ($this->config->getEnableCustomerRelationUserFunctionality()) {

            if (is_object($user)) {
                $userCustomers = $user->getUserCustomers();
                if (count($userCustomers) > 0) {
                    foreach ($userCustomers as $userCustomer) {
                        if (is_object($userCustomer->getCustomer())) // && $userCustomer->getActive() //TESTAR
                            $idCustomers[] = $userCustomer->getCustomer()->getId();
                    }
                }
            }
            if (count($idCustomers) > 0)
                $query->andWhere('obj.id IN ('.implode(',', $idCustomers).')');
            else
                return false;

        } else if ($this->config->getEnableCustomerDirectRelationUserFunctionality() && is_object($user)) {

            $query->andWhere($query->expr()->orX(
                $query->expr()->eq('obj.user', $user->getId()),
                $query->expr()->isnull('obj.user')
            ));

        }

        return $query->getQuery()->getResult();
        
    }

    public function customerAction(){

        try {

            $integrationRoute = $this->checkIntegration('customer');
            if ($integrationRoute)
                return $this->forward()->dispatch('API\Controller\Custom\\' . $integrationRoute . '\Data', array(
                    'action' => 'customer'
                ));

            $this->setConfig();

            $user = $this->getUser();

            $results = $this->getCustomerList($user);

            if ($results === false) {
                return $this->createResponse(array());
            }

            $representedCompanies = array();
            if (is_object($user)) {
                foreach ($user->getRepresentedCompanies() as $rep) {
                    $representedCompanies[] = $rep->getRepresentedCompany()->getId();
                }
            }

            $retornoIds = $retornoCodes = $codeCustomers = $retornoKeys = $retornoKeysCode = $retorno = array();
            if (count($results) > 0) {
                $counter = 0;
                foreach ($results as $ent) {
                    $customer = $ent->getArrayCopy();
                    $customer['pending'] = false;
                    $customer['reference'] = isset($customer['reference']) && !empty($customer['reference']) && $customer['reference'] != "0" ? $customer['reference'] : (isset($customer['code']) && !empty($customer['code']) ? $customer['code'] : '');
                    if (
                        count($representedCompanies) > 0 &&
                        ($this->config->getEnableCustomerDirectRelationUserFunctionality() == false && $this->config->getEnableCustomerRelationUserFunctionality() == false) //TESTAR
                    ) {
                        if (
                            isset($customer['representedCompanies']) && is_array($customer['representedCompanies']) &&
                            count(array_intersect($representedCompanies, $customer['representedCompanies'])) > 0
                        ) {
                            $retornoKeys[$customer['id']] = $counter;
                            $retorno[$counter]            = $customer;
                            $retornoIds[$counter]         = $customer['id'];
                            if (isset($customer['code']) && empty($customer['code']) === false) {
                                $retornoCodes[] = $customer['code'];
                                $retornoKeysCode[$customer['code']] = $counter;
                            }
                        }
                    } else {
                        $retornoKeys[$customer['id']] = $counter;
                        $retorno[$counter]            = $customer;
                        $retornoIds[$counter]         = $customer['id'];
                        if (isset($customer['code']) && empty($customer['code']) === false) {
                            $retornoCodes[] = $customer['code'];
                            $retornoKeysCode[$customer['code']] = $counter;
                        }
                    }
                    $counter++;
                }
            }

            if (count($retornoIds) > 0) { //Check Financial Pendings

                $query = $this->getEntityManager()->createQueryBuilder('Model\Entity\FinancialPending');
                $query->select(array('cus.id', 'cus.code'))
                    ->from('Model\Entity\FinancialPending', 'obj')
                    ->innerJoin('obj.customer', 'cus')
                    ->andWhere('obj.status = 1')
                    ->andWhere('obj.active = 1')
                    ->groupBy('cus.id')
                    ->orderBy('cus.id', 'ASC');

				if (is_array($retornoCodes) && count($retornoCodes) > 0) { 
					$query->andWhere($query->expr()->orX(
						$query->expr()->in('cus.id', $retornoIds),
						$query->expr()->in('cus.code', $retornoCodes)
					));
				} else {
					$query->andWhere($query->expr()->in('cus.id', $retornoIds));
				}

                $pendings = $query->getQuery()->getResult();

                if (count($pendings) > 0) {
                    foreach($pendings as $ped){
                        if (isset($ped['id']) && isset($retornoKeys[$ped['id']]) && isset($retorno[$retornoKeys[$ped['id']]])) {

                            $retorno[$retornoKeys[$ped['id']]]['pending'] = true;

                        } else if (isset($ped['code']) && empty($ped['code']) === false && isset($retornoKeysCode[$ped['code']]) && isset($retorno[$retornoKeysCode[$ped['code']]])) {

                            $retorno[$retornoKeysCode[$ped['code']]]['pending'] = true;

                        }
                    }
                }
            }

            return $this->createResponse($retorno);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

    }

    public function financialPendingAction(){

        try{

            $this->setConfig();
            $user = $this->getUser();
            
            $query = $this->getEntityManager()->createQueryBuilder('Model\Entity\FinancialPending');
            $query->select('obj')
                ->from('Model\Entity\FinancialPending', 'obj')
                ->innerJoin('obj.customer', 'cus')
                ->andWhere('obj.status = 1')
                ->andWhere('obj.active = 1')
                ->orderBy('obj.id', 'DESC');

            if ($this->config->getSyncCustomerInactive() == false)
                $query->andWhere('cus.active = 1');

            $idCustomers = $codeCustomers = array();
            if ($this->config->getEnableCustomerRelationUserFunctionality()) {
                if (is_object($user)) {
                    $userCustomers = $user->getUserCustomers();
                    if (count($userCustomers) > 0) {
                        foreach ($userCustomers as $userCustomer) {
                            if (is_object($userCustomer->getCustomer())) {
                                $idCustomers[] = $userCustomer->getCustomer()->getId();
                                if ($userCustomer->getCustomer()->getCode() > 0)
                                    $codeCustomers[] = $userCustomer->getCustomer()->getCode();
                            }
                        }
                    }
                }
                if (count($idCustomers) > 0)
                    //$query->andWhere('cus.id IN ('.implode(',', $idCustomers).')');
                    $query->andWhere($query->expr()->orX(
                        $query->expr()->in('cus.id', $idCustomers),
                        $query->expr()->in('cus.code', $codeCustomers)
                    ));
                else
                    return $this->createResponse(array()); 
            }

            $results = $query->getQuery()->getResult();            

            $retorno = array();
            foreach ($results as $ent) {
                $retorno[] = $ent->getArrayCopy();
            }

            return $this->createResponse($retorno);

        } catch(\Exception $ex) {
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    /* 
    * Taxation
    */ 
    public function taxationAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\Taxation')
                ->select('obj')
                ->from('Model\\Entity\\Taxation','obj')
                ->where('obj.active = 1')
                ->getQuery()->getArrayResult();

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /* TAXATION END */
   
    
    /* 
    * Filial
    */ 
    public function filialAction(){
 
        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\Filial')
                ->select('obj')
                ->from('Model\\Entity\\Filial','obj') 
                ->where('obj.active = 1') 
                ->getQuery()->getArrayResult();

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /* FILIAL END */   
    
    
    /* 
    * Filialvendedor
    */ 
    public function filialvendedorAction(){
 
        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\FilialVendedor')
                ->select('obj')
                ->from('Model\\Entity\\FilialVendedor','obj') 
                ->where('obj.active = 1') 
                ->getQuery()->getArrayResult();

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /* FILIAL END */      

    public function productAction(){

        try {

            $integrationRoute = $this->checkIntegration('product');
            if ($integrationRoute)
              return $this->forward()->dispatch('API\Controller\Custom\\'.$integrationRoute.'\Data', array(
                   'action' => 'product'
                 ));

            $entityConfig = $this->setConfig();

            $qb = $this->getEntityManager()->createQueryBuilder("Model\\Entity\\Product")
                ->select('obj')
                ->from("Model\\Entity\\Product", "obj")
                ->andWhere("obj.active = :active")
                ->setParameter('active', true);

            $representedCompanies = array();
            foreach($this->getUser()->getRepresentedCompanies() as $rep){
                $representedCompanies[] = $rep->getRepresentedCompany()->getId();
            }

            $data = $qb->getQuery()->getResult();
            $retorno = array();
            foreach($data as $ent){
                $product = $ent->getArrayCopy($entityConfig);
                $product['reference'] = isset($product['reference']) && !empty($product['reference']) && $product['reference'] != "0" ? $product['reference'] : (isset($product['code']) && !empty($product['code']) ? $product['code'] : '');
                if (count($representedCompanies) > 0) {
                    if (
                        isset($product['representedCompanies']) && is_array($product['representedCompanies']) &&
                        count(array_intersect($representedCompanies, $product['representedCompanies'])) > 0
                    )
                        $retorno[] = $product;
                } else {
                    $retorno[] = $product;
                }
            }

            if (is_object($entityConfig) && $entityConfig->getEnableProductLevelFunctionality() && $entityConfig->getEnableProductTwoLevelFunctionality() && count($retorno) > 0) {
                foreach ($retorno as $key => $item) {
                    if (isset($retorno[$key]['groupSecondary']) && empty($retorno[$key]['groupSecondary']) === false)
                        $retorno[$key]['groupTertiary'] = $retorno[$key]['groupSecondary'];

                    if (isset($retorno[$key]['groupPrimary']) && empty($retorno[$key]['groupPrimary']) === false)
                        $retorno[$key]['groupSecondary'] = $retorno[$key]['groupPrimary'];

                    $retorno[$key]['groupPrimary'] = '';
                }
            }

            return $this->createResponse($retorno);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    public function priceListAction(){

        try {

            $userEntity = $this->getUser();
            if (is_object($userEntity) === false)
                throw new Exception("Seu usuário não foi encontrado!");

            $integrationRoute = $this->checkIntegration('priceList');
            if ($integrationRoute)
              return $this->forward()->dispatch('API\Controller\Custom\\'.$integrationRoute.'\Data', array(
                   'action' => 'priceList'
                 ));

            $priceLists = $userEntity->getUserPriceLists();
            if (count($priceLists) == 0)
                return $this->createResponse(array());

            $counter = -1;
            $retorno = array();
            foreach($priceLists as $userPriceList){

                if (
                    is_object($userPriceList) === false || $userPriceList->getActive() == false ||
                    is_object($userPriceList->getPriceList()) === false || $userPriceList->getPriceList()->getActive() == false
                )
                    continue;

                $counter++;

                $retorno[$counter] = array(
                    'id' => $userPriceList->getId(),
                    //'code' => $userPriceList->getCode(),
                    'description' => $userPriceList->getPriceList()->getDescription(),
                    'orderTypeId' => (is_object($userPriceList->getOrderType()) ? $userPriceList->getOrderType()->getId() : null),
                    'isDefault' => $userPriceList->getPriceList()->getIsDefault(),
                    'products' => array()
                );

                $priceListProducts = $userPriceList->getPriceList()->getPriceListProducts();
                if (count($priceListProducts) == 0)
                    continue;

                foreach ($priceListProducts as $priceListProduct) {
                    if (is_object($priceListProduct->getProduct()) && $priceListProduct->getActive())
                      $retorno[$counter]['products'][] = array(
                          'id' => $priceListProduct->getId(),
                          'productId' => $priceListProduct->getProduct()->getId(),
                          'price' => floatval($priceListProduct->getPrice()),
                          'priceMinimum' => floatval($priceListProduct->getPriceMinimum()),
                          'priceChangeDate' => (is_object($priceListProduct->getPriceChangeDate()) ? $priceListProduct->getPriceChangeDate()->format('d/m/Y H:i') : '') //Test5
                      );
                }

            }

            return $this->createResponse($retorno);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();
    }

    public function priceListV2Action(){

        try {

            $integrationRoute = $this->checkIntegration('priceList');
            if ($integrationRoute)
              return $this->forward()->dispatch('API\Controller\Custom\\'.$integrationRoute.'\Data', array(
                   'action' => 'priceList'
                 ));
            
            $this->setConfig();

            $userEntity = $this->getUser();
            if (is_object($userEntity) === false)
                throw new Exception("Seu usuário não foi encontrado!");

            $priceListIds = array();
            if ($this->config->getEnablePriceListCustomerFunctionality()) {
                $customers = $this->getCustomerList($userEntity, true);
                if (count($customers) > 0) {
                    foreach ($customers as $customer) {
                        if (
                            is_object($customer->getPriceList()) === false || $customer->getPriceList()->getActive() == false
                        ) {
                            continue;
                        }
                        $priceListIds[$customer->getPriceList()->getId()] = $customer->getPriceList()->getId();
                    }
                }
            }

            $orderTypeIds = array();
            $userPriceLists = $userEntity->getUserPriceLists();
            if (count($userPriceLists) > 0) {
                foreach($userPriceLists as $userPriceList) {

                    if (
                        is_object($userPriceList) === false || $userPriceList->getActive() == false ||
                        is_object($userPriceList->getPriceList()) === false || $userPriceList->getPriceList()->getActive() == false
                    ) {
                        continue;
                    }

                    $priceListIds[$userPriceList->getPriceList()->getId()] = $userPriceList->getPriceList()->getId();
                    
                    if (isset($orderTypeIds[$userPriceList->getPriceList()->getId()]) === false)
                        $orderTypeIds[$userPriceList->getPriceList()->getId()] = array();

                    if (is_object($userPriceList->getOrderType()))
                        $orderTypeIds[$userPriceList->getPriceList()->getId()][$userPriceList->getOrderType()->getId()] = $userPriceList->getOrderType()->getId();
                }
            }

            //--------------------//

            $query = $this->getEntityManager()->createQueryBuilder('Model\Entity\PriceList');
            $query->select('obj');
            $query->from('Model\Entity\PriceList','obj')
                    ->andWhere('obj.active = 1')
                    ->andWhere('obj.id IN ('.implode(',', $priceListIds).')');
            $priceLists = $query->getQuery()->getResult();

            $retorno = array();
            foreach($priceLists as $priceList){

                $retornoItem = array(
                    'id' => $priceList->getId(),
                    //'code' => $userPriceList->getCode(),
                    'description' => $priceList->getDescription(),
                    'orderTypeId' => null,
                    'orderTypes' => (isset($orderTypeIds[$priceList->getId()]) ? array_values($orderTypeIds[$priceList->getId()]) : array()),
                    'isDefault' => $priceList->getIsDefault(),
                    'products' => array()
                );

                $priceListProducts = $priceList->getPriceListProducts();
                if (count($priceListProducts) > 0) {
                    foreach ($priceListProducts as $priceListProduct) {
                        if (is_object($priceListProduct->getProduct()) && $priceListProduct->getActive())
                        $retornoItem['products'][] = array(
                            'id' => $priceListProduct->getId(),
                            'productId' => $priceListProduct->getProduct()->getId(),
                            'price' => floatval($priceListProduct->getPrice()),
                            'priceMinimum' => floatval($priceListProduct->getPriceMinimum()),
                            'priceChangeDate' => (is_object($priceListProduct->getPriceChangeDate()) ? $priceListProduct->getPriceChangeDate()->format('d/m/Y H:i') : '') //Test5
                        );
                    }
                }

                $retorno[] = $retornoItem;

            }

            return $this->createResponse($retorno);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();
    }

    /**
     * @api {get} /data/product-image/:id Product Image
     * @apiName GetProductImage
     * @apiGroup Data
     * @apiDescription Retorna a imagem de um produto
     *
     * @apiParam {Number} id ID do produto
     *
     * @apiSuccessExample {binary} Success-Response:
     *      HTTP/1.1 200 OK
     *      {binary file}
     *
     * @apiError NotFound Caso a imagem não seja encontrada
     *
     * @apiUse ErrorBlock
     *
     */
    public function productImageAction(){

        $id = $this->params()->fromRoute('id', false);

        try{

            $entity = $this->getEntityManager()->find('Model\Entity\Product', $id);
            if(!$entity){
                throw new \Exception("Entity not found");
            }

            if(!$entity->getImage()){
                throw new \Exception("Image not found");
            }

            $filename   = $entity->getFullImagePath();
            $type       = $entity->getFullImagePathMimeType();

            if(is_null($filename) || !file_exists($filename)){
                throw new \Exception("Image not found");
            }

            return $this->createFileResponse($filename, $type);

        }catch(\Exception $ex){
            return $this->createNotFoundResponse();
        }
    }

    /**
     * @api {get} /data/user User
     * @apiName GetUser
     * @apiGroup Data
     * @apiDescription Retorna a lista de usuários cadastrados para acesso no tablet
     *
     * @apiSuccess {Number} id Id do usuário
     * @apiSuccess {String} name Nome do usuário
     * @apiSuccess {String} email E-mail do usuário
     * @apiSuccess {String} username Nome de usuário
     * @apiSuccess {String} password Senha (hash)
     * @apiSuccess {Boolean} active Indica se o usuário está ativo
     * @apiSuccess {Boolean} admin Indica se o usuário é administrador
     * @apiSuccess {String} sellerId Campo utilizado em integrações para vincular um código de vendedor (ERP) ao usuário
     * @apiSuccess {Object} created Data de criação
     * @apiSuccess {Object} updated Data da última atualização
     *
     * @apiSuccessExample Success-Response:
     *      HTTP/1.1 200 OK
     *      [
     *          {
     *              "id": 1,
     *              "name": "Walter White",
     *              "email": "me@savewalterwhite.com",
     *              "username": "heisenberg",
     *              "password": "$2y$10$5HuY8E9RqqRvnAIdZL12093RUGg3GmlJkQxlIW3Ql1a3F6MALKKc3y",
     *              "active": true,
     *              "admin": true,
     *              "sellerId": null,
     *              "created": {
     *                  "data": "2010-11-13 00:00:00",
     *                  "timezone_type": 3,
     *                  "timezone": "America/Sao_Paulo"
     *              },
     *              "updated": null
     *          }
     *      ]
     *
     * @apiUse ErrorBlock
     *
     */
    public function userAction(){

        try{

            $results = $this->getEntityManager()->createQueryBuilder('Model\Entity\User')
                    ->select('obj')
                    ->from('Model\Entity\User','obj')
                    ->where('obj.active = 1')
                    ->getQuery()->getResult();

            $data = array();
            foreach($results as $ent){
                $userData = $ent->getArrayCopy();
                unset($userData['accessToken']);
                unset($userData['authorizationCode']);
                unset($userData['refreshToken']);
                unset($userData['locations']);
                unset($userData['client']);
                $reps = array();
                foreach($ent->getRepresentedCompanies() as $rep){
                    $reps[] = array(
                        'representedCompany' => $rep->getRepresentedCompany()->getId(),
                        'commission' => $rep->getCommission()
                    );
                }
                $userData['representedCompanies'] = $reps;
                $data[] = $userData;
            }

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /**
     * @api {post} /data/stock Stock
     * @apiName GetStock
     * @apiGroup Data
     * @apiDescription Retorna as quantidades de um produto em um determinado estoque
     *
     * @apiParam {Number} id ID do estoque
     *
     * @apiSuccess {Number} amount Quantidade
     * @apiSuccess {Number} product_id ID do produto
     * @apiSuccess {Number} warehouse_id ID do estoque (depósito)
     * @apiSuccess {Object} created Data de criação
     * @apiSuccess {Object} updated Data da última atualização
     *
     * @apiSuccessExample Success-Response:
     *      HTTP/1.1 200 OK
     *      [
     *          {
     *              "amount": 10,
     *              "product_id": 1,
     *              "warehouse_id": 1,
     *              "created": {
     *                  "data": "2010-11-13 00:00:00",
     *                  "timezone_type": 3,
     *                  "timezone": "America/Sao_Paulo"
     *              },
     *              "updated": null
     *          }
     *      ]
     *
     * @apiUse ErrorBlock
     *
     */
    public function stockAction(){

        try{

            $id = $this->params()->fromPost('id', false);
            if(!$id){
                return $this->createResponse(array());
                //throw new \Exception('Invalid stock ID');
            }

            $obj = $this->getEntityManager()->find('Model\Entity\Warehouse', $id);
            if(!$obj){
                return $this->createResponse(array());
                //throw new \Exception('Invalid stock object');
            }

            $data = $this->getEntityManager()->createQueryBuilder('Model\Entity\ProductWarehouse')
                    ->select('obj')
                    ->from('Model\Entity\ProductWarehouse','obj')
                    ->andWhere('obj.warehouse = :wh')
                    ->andWhere('obj.active = 1')
                    ->setParameter('wh',$obj)
                    ->getQuery()->getArrayResult();

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /**
     * @api {get} /data/group Group
     * @apiName GetGroups
     * @apiGroup Data
     * @apiDescription Retorna a lista dos grupos primários de produtos cadastros
     *
     * @apiSuccess {Number} id ID do grupo
     * @apiSuccess {String} description Descrição/Nome do grupo
     * @apiSuccess {Object} created Data de criação
     * @apiSuccess {Object} updated Data da última atualização
     *
     * @apiSuccessExample Success-Response:
     *      HTTP/1.1 200 OK
     *      [
     *          {
     *              id: 11,
     *              description: "ACHOCOLATADOS",
     *              id_group: null,
     *              created: {
     *                  date: "2015-02-23 08:24:47",
     *                  timezone_type: 3,
     *                  timezone: "Europe/Berlin"
     *              },
     *              updated: null
     *          },
     *          {
     *              id: 12,
     *              description: "ÁGUA",
     *              id_group: null,
     *              created: {
     *                  date: "2015-02-23 08:24:47",
     *                  timezone_type: 3,
     *                  timezone: "Europe/Berlin"
     *              },
     *              updated: null
     *          }
     *      ]
     *
     * @apiUse ErrorBlock
     *
     */
    public function groupAction(){

        try{

            $integrationRoute = $this->checkIntegration('group');
            if ($integrationRoute)
                return $this->forward()->dispatch('API\Controller\Custom\\'.$integrationRoute.'\Data', array(
                    'action' => 'group'
                ));

            $data = $this->getEntityManager()->createQueryBuilder('Model\Entity\Group')
                ->select('obj')
                ->from('Model\Entity\Group','obj')
                ->andWhere('obj.active = 1')
                ->andWhere('obj.blocked != 1')
                ->orderBy('obj.description', 'ASC')
                ->getQuery()->getArrayResult();

            $listToUse = array('id','description','level');
            foreach ($data as $r => $item) {
                foreach ($item as $key => $val) {
                    if (in_array($key, $listToUse) === false)
                        unset($data[$r][$key]);
                }
            }

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /**
     * @api {get} /data/represented-company Group
     * @apiName GetRepresentedCompany
     * @apiGroup Data
     * @apiDescription Retorna a lista de representadas cadastradas
     *
     * @apiSuccess {Number} id Id do cliente
     * @apiSuccess {String} companyName Razão Social
     * @apiSuccess {String} tradeName Nome fantasia
     * @apiSuccess {String} documentNumber CNPJ/CPF
     * @apiSuccess {String} secondaryDocumentNumber Documento secundário (IE)
     * @apiSuccess {String} zip Código postal (CEP)
     * @apiSuccess {String} address Logradouro
     * @apiSuccess {String} addressNumber Número do endereço
     * @apiSuccess {String} neighbourhood Bairro
     * @apiSuccess {String} addressComplement Complemento
     * @apiSuccess {String} state Estado
     * @apiSuccess {String} city Cidade
     * @apiSuccess {String} phonePrimary Telefone principal
     * @apiSuccess {String} phoneSecundary Telefone secundário
     * @apiSuccess {String} website Website
     * @apiSuccess {String} email E-mail
     * @apiSuccess {Boolean} active Indica se a representada está ativa ou não
     * @apiSuccess {Object} created Data de criação
     * @apiSuccess {Object} updated Data da última atualização
     *
     * @apiSuccessExample Success-Response:
     *      HTTP/1.1 200 OK
     *      [
     *          {
     *              "id": 1,
     *              "tradeName": "LOS POLLOS HERMANOS",
     *              "companyName": "LOS POLLOS HERMANOS INC.",
     *              "documentNumber":"12.345.678/00001-01",
     *              "secondaryDocumentNumber": "12345678",
     *              "zip": "12345-000",
     *              "address": "Isleta Blvd. SW",
     *              "addressNumber": "123",
     *              "neighbourhood": "",
     *              "addressComplement": "Complement",
     *              "state": "NM",
     *              "city": "Albuquerque",
     *              "phonePrimary": "(44) 1234-1122",
     *              "phoneSecundary": "(44) 1234-1122",
     *              "website": "http://www.lospolloshermanos.com",
     *              "email": "gus@lospolloshermanos.com",
     *              "active": true,
     *              "created": {
     *                  "data": "2010-11-13 00:00:00",
     *                  "timezone_type": 3,
     *                  "timezone": "America/Sao_Paulo"
     *              },
     *              "updated": null
     *          }
     *      ]
     *
     * @apiUse ErrorBlock
     *
     */
    public function representedCompanyAction(){

        try {
            $data = array();
            foreach($this->getUser()->getRepresentedCompanies() as $rep){

                // || $rep->getActive() == false
                if (
                    is_object($rep) === false ||
                    is_object($rep->getRepresentedCompany()) === false || $rep->getRepresentedCompany()->getActive() == false
                )
                    continue;

                $data[] = $rep->getRepresentedCompany()->getArrayCopy();
            }

            return $this->createResponse($data);

        } catch(\Exception $ex) {
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    /* */
    public function representedCompanyImageAction(){

        $id = $this->params()->fromRoute('id', false);

        try{

            $entity = $this->getEntityManager()->find('Model\Entity\RepresentedCompany', $id);
            if(!$entity){
                throw new \Exception("Entity not found");
            }

            if(!$entity->getImage()){
                throw new \Exception("Image not found");
            }

            $filename = $entity->getFullImagePath();

            if(is_null($filename) || !file_exists($filename)){
                throw new \Exception("Image not found");
            }

            return $this->createFileResponse($filename, "image/jpg");

        }catch(\Exception $ex){
            return $this->createNotFoundResponse();
        }

    }

    /**
     * @api {get} /data/payment-method Group
     * @apiName GetPaymentMethods
     * @apiGroup Data
     * @apiDescription Retorna a lista dos métodos de pagamento
     *
     * @apiSuccess {Number} id ID do método de pagamento
     * @apiSuccess {String} description Descrição/Nome do método de pagamento
     * @apiSuccess {Boolean} active Indica se o método de pagamento está ativo ou não
     * @apiSuccess {Object} created Data de criação
     * @apiSuccess {Object} updated Data da última atualização
     *
     * @apiSuccessExample Success-Response:
     *      HTTP/1.1 200 OK
     *      [
     *          {
     *              id: 11,
     *              description: "BOLETO",
     *              active: true,
     *              created: {
     *                  date: "2015-02-23 08:24:47",
     *                  timezone_type: 3,
     *                  timezone: "Europe/Berlin"
     *              },
     *              updated: null
     *          },
     *          {
     *              id: 12,
     *              description: "CARTAO DE CREDITO",
     *              active: true,
     *              created: {
     *                  date: "2015-02-23 08:24:47",
     *                  timezone_type: 3,
     *                  timezone: "Europe/Berlin"
     *              },
     *              updated: null
     *          }
     *      ]
     *
     * @apiUse ErrorBlock
     *
     */
    public function paymentMethodAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\Entity\PaymentMethod')
                ->select('obj')
                ->from('Model\Entity\PaymentMethod','obj')
                ->where('obj.active = 1')
                ->getQuery()->getArrayResult();

            $listToUse = array('id','description');
            foreach ($data as $r => $item) {
                foreach ($item as $key => $val) {
                    if (in_array($key, $listToUse) === false)
                        unset($data[$r][$key]);
                }
            }

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /**
     * @api {get} /data/payment-condition Group
     * @apiName GetPaymentConditions
     * @apiGroup Data
     * @apiDescription Retorna a lista das condições de pagamento
     *
     * @apiSuccess {Number} id ID do método de pagamento
     * @apiSuccess {String} description Descrição/Nome do método de pagamento
     * @apiSuccess {Boolean} active Indica se o método de pagamento está ativo ou não
     * @apiSuccess {Object} created Data de criação
     * @apiSuccess {Object} updated Data da última atualização
     *
     * @apiSuccessExample Success-Response:
     *      HTTP/1.1 200 OK
     *      [
     *          {
     *              id: 11,
     *              description: "A VISTA",
     *              active: true,
     *              created: {
     *                  date: "2015-02-23 08:24:47",
     *                  timezone_type: 3,
     *                  timezone: "Europe/Berlin"
     *              },
     *              updated: null
     *          },
     *          {
     *              id: 12,
     *              description: "30/60",
     *              active: true,
     *              created: {
     *                  date: "2015-02-23 08:24:47",
     *                  timezone_type: 3,
     *                  timezone: "Europe/Berlin"
     *              },
     *              updated: null
     *          }
     *      ]
     *
     * @apiUse ErrorBlock
     *
     */
    public function paymentConditionAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\Entity\PaymentCondition')
                ->select('obj')
                ->from('Model\Entity\PaymentCondition','obj')
                ->where('obj.active = 1')
                ->getQuery()->getArrayResult();

            $listToUse = array('id','description');
            foreach ($data as $r => $item) {
                foreach ($item as $key => $val) {
                    if (in_array($key, $listToUse) === false)
                        unset($data[$r][$key]);
                }
            }

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /**
     * FIXME: Refactor to unify methods of catalog image
     * Catalogs image
     * @return mixed
     */
    public function catalogFileAction(){

        try{

            $file   = $this->params()->fromRoute('id', false);
            $id     = $this->params()->fromQuery('catalog', false);

            if(!$id || !$file){
                throw new \Exception("File not found (1)");
            }

            $entity = $this->getEntityManager()->find('Model\\Entity\\Catalog', $id);
            if(!$entity){
                throw new \Exception("File not found (2)");
            }

            $path = Catalog::getPathForFile($file, $entity->getId());
            if(!file_exists($path)){
                throw new \Exception("File not found (3)");
            }

            $extension = pathinfo($file, PATHINFO_EXTENSION);
            switch($extension){
                case 'pdf':
                    $filetype = "application/pdf";
                    break;
                case 'jpeg':
                case 'jpg':
                    $filetype = "image/jpg";
                    break;
                case 'png':
                    $filetype = "image/png";
                    break;
            }

            $filename = $path;

            if(is_null($filename) || !file_exists($filename)){
                throw new \Exception("File not found");
            }

            return $this->createFileResponse($filename, $filetype);

        }catch(\Exception $ex){
            return $this->createNotFoundResponse();
        }

        return $this->createNotFoundResponse();

    }

    /**
     * Catalogs thumb
     * @return mixed
     */
    public function catalogThumbAction(){

        try{

            $id   = $this->params()->fromRoute('id', false);

            if(!$id){
                throw new \Exception("File not found (1)");
            }

            $entity = $this->getEntityManager()->find('Model\\Entity\\Catalog', $id);
            if(!$entity){
                throw new \Exception("File not found (2)");
            }

            if($entity->getType() == Catalog::TYPE_PDF){
                $file = $entity->getThumb();
                $path = $entity->getThumbPath();
            }else{
                if(count($entity->getCatalogImages()) <= 0){
                    throw new \Exception("File not found (3)");
                }
                $img = $entity->getCatalogImages()->get(0);
                $file = $img->getThumb();
                $path = $img->getThumbPath();
            }

            if(!file_exists($path)){
                throw new \Exception("File not found (3)");
            }

            $extension = pathinfo($file, PATHINFO_EXTENSION);
            switch($extension){
                case 'jpeg':
                case 'jpg':
                    $filetype = "image/jpg";
                    break;
                case 'png':
                    $filetype = "image/png";
                    break;
            }

            $filename = $path;

            if(is_null($filename) || !file_exists($filename)){
                throw new \Exception("File not found");
            }

            return $this->createFileResponse($filename, $filetype);

        }catch(\Exception $ex){
            return $this->createNotFoundResponse();
        }

        return $this->createNotFoundResponse();

    }

    /**
     * Catalogs
     * @return mixed
     */
    public function catalogAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\Entity\Catalog')
                ->select('obj')
                ->from('Model\Entity\Catalog','obj')
                ->where('obj.active = :active')
                ->setParameter('active',true)
                ->getQuery()->getArrayResult();

            $listToUse = array('id','description','type','file','active');
            foreach ($data as $r => $item) {
                foreach ($item as $key => $val) {
                    if (in_array($key, $listToUse) === false)
                        unset($data[$r][$key]);
                }
            }

            foreach($data as &$catalog){
                $imgs = $this->getEntityManager()->createQueryBuilder('Model\Entity\CatalogImage')
                    ->select('obj')
                    ->from('Model\Entity\CatalogImage','obj')
                    ->where('obj.catalog = :catalog')
                    ->setParameter('catalog', $catalog['id'])
                    ->getQuery()->getArrayResult();

                $listToUse = array('id','size','type','file','thumb','order');
                foreach ($imgs as $r => $item) {
                    foreach ($item as $key => $val) {
                        if (in_array($key, $listToUse) === false)
                            unset($imgs[$r][$key]);
                    }
                }

                $catalog['catalogImages'] = $imgs;
            }

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /**
     * Colors
     * @return mixed
     */
    public function colorAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\Color')
                ->select('obj')
                ->from('Model\\Entity\\Color','obj')
                ->where('obj.active = 1')
                ->getQuery()->getArrayResult();

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /**
     * Sizes
     * @return mixed
     */
    public function sizeAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\Size')
                ->select('obj')
                ->from('Model\\Entity\\Size','obj')
                ->where('obj.active = 1')
                ->getQuery()->getArrayResult();

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /**
     * UnitAmount
     * @return mixed
     */
    public function unitAmountAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\UnitAmount')
                ->select('obj')
                ->from('Model\\Entity\\UnitAmount','obj')
                ->where('obj.active = 1')
                ->getQuery()->getArrayResult();

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /**
     * Product Barcode
     * @return mixed
     */
    public function productBarcodeAction(){

        try{

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\ProductBarcode')
                ->select('obj')
                ->from('Model\\Entity\\ProductBarcode','obj')
                ->where('obj.active = 1')
                ->getQuery()->getResult();

            $dataToPrint = array();
            if (count($data) > 0) {
                foreach ($data as $item) {
                  $dataToPrint[] = array(
                    'id'      => $item->getId(),
                    'code'    => $item->getCode(),
                    'product' => (is_object($item->getProduct())?$item->getProduct()->getId():''),
                    'color'   => (is_object($item->getColor())?$item->getColor()->getId():''),
                    'size'    => (is_object($item->getSize())?$item->getSize()->getId():''),
                    'unit'    => (is_object($item->getUnit())?$item->getUnit()->getId():''),
                  );
                }
            }

            return $this->createResponse($dataToPrint);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    /**
     * Product Barcode
     * @return mixed
     */
    public function productCustomerDataAction(){

        try {

            $idCustomer = $this->params()->fromQuery('customer', false);
            $idProduct = $this->params()->fromQuery('product', false);
            if(!$idCustomer || !$idProduct){
                throw new \Exception('Invalid Params');
            }

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\OrderProduct')
                ->select(array('obj','o'))
                ->from('Model\\Entity\\OrderProduct', 'obj')
                ->innerJoin('obj.product', 'p')
                ->innerJoin('obj.order', 'o')
                ->innerJoin('o.customer', 'c')
                ->where('c.id = '.$idCustomer)
                ->andWhere('p.id = '.$idProduct)
                ->groupBy('o.id')
                ->orderBy('o.orderDate', 'DESC')
                ->setMaxResults(3)
                ->getQuery()
                ->getResult();

            $dataToPrint = array(); 
            if (count($data) > 0) {

                foreach ($data as $item) {
		
					$discount = $price = 0;
					/*if ((float)$item->getTotal() != (float)$item->getSubtotal()) {
						$discount = 100 * (1 - ((float)$item->getTotal() / (float)$item->getSubtotal()));
						$price = (float)$item->getPrice() - (($discount / 100) * (float)$item->getPrice());
					} else {
						$discount = (float)$item->getDiscount();
						$price = (float)$item->getPrice();
					}*/					
					$discount = (float)$item->getDiscount();
                    $price = (float)$item->getPrice();
                        
                    
                    $dataToPrint[] = array(
                        'amount'    => intval($item->getAmount()),
                        'price'     => round($price, 2),
						'discount'  => round($discount, 2),
                        'subtotal'  => floatval($item->getSubtotal()),
                        'total'     => floatval($item->getTotal()),
                        'orderDate' => (is_object($item->getOrder())?$item->getOrder()->getOrderDateFormatted():'')
                    );
                }
            }

            return $this->createResponse($dataToPrint);

        } catch(\Exception $ex) {
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    /**
     * Product Barcode
     * @return mixed
     */
    public function allProductCustomerDataAction(){

        try {

            $idCustomer = $this->params()->fromQuery('customer', false);
            if(!$idCustomer){
                throw new \Exception('Invalid Params');
            }

            $dataToPrint = $idProducts = array();

            $products = $this->getEntityManager()->createQueryBuilder("Model\\Entity\\Product")
                ->select('obj.id')
                ->from("Model\\Entity\\Product", "obj")
                ->andWhere("obj.active = :active")
                ->setParameter('active', true)
                ->getQuery()->getResult();

            foreach ($products as $prod) {
                $idProducts[] = (int)$prod['id'];
            }

            $data = $this->getEntityManager()->createQueryBuilder('Model\\Entity\\OrderProduct')
                ->select(array('obj','o'))
                ->from('Model\\Entity\\OrderProduct', 'obj')
                ->innerJoin('obj.product', 'p')
                ->innerJoin('obj.order', 'o')
                ->innerJoin('o.customer', 'c')
                ->where('c.id = '.$idCustomer)
                ->andWhere('p.id  IN ('.implode(',', $idProducts).')')
                //->groupBy('o.id')
                ->orderBy('o.orderDate', 'DESC')
                //->setMaxResults(3)
                ->getQuery()
                ->getResult();

            if (count($data) > 0) {

                foreach ($data as $item) {

                    $idProduct = $item->getProduct()->getId();

                    if (isset($dataToPrint[$idProduct]) === false)
                        $dataToPrint[$idProduct] = array(
                            'product' => $idProduct,
                            'items' => array()
                        );

                    if (count($dataToPrint[$idProduct]['items']) >= 3)
                        continue;

                    $dataToPrint[$idProduct]['items'][] = array(
                        'amount'    => intval($item->getAmount()),
                        'orderDate' => addslashes(is_object($item->getOrder())?$item->getOrder()->getOrderDateFormatted():'')
                    );
                }
            }

            return $this->createResponse(array_values($dataToPrint));

        } catch(\Exception $ex) {
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
    }

    /**
     * Helper to replace null values
     * @param $array
     */
    private function replaceNullValues($array){

        $retorno = array();
        foreach($array as $key => $value){
            if($value == null){
                $retorno[$key] = "";
            }else{
                $retorno[$key] = $value;
            }
        }

    }

    /**
     * Helper to replace useless values
     * @param $array
     */
    private function replaceUselessValues($array){

        $func = function (&$array, $func) {
            foreach ($array as $k => $v) {
                if (strstr($k, '__') !== false) {
                    unset($array[$k]);
                    continue;
                }
                if (is_array($v)) {
                    if (isset($v['date']))
                        $array[$k] = $v['date'];
                    else
                        $array[$k] = $func($v, $func);
                }
            }
            return $array;
        };

        $func($array, $func);

        return $array;

    }

}

?>
