<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of DataController
 *
 * @author renatopeterman
 */

namespace API\Controller;

class CustomerController extends AbstractApiActionController {

    protected $config;

    private function setConfig() {
        $this->config = $this->getEntityManager()->getRepository('Model\Entity\Config')->findOneBy(array());
        return $this->config;
    }

    public function sendAction(){
        
        try{

            $this->setConfig();
            
            $content = $this->getRequest()->getContent();
            if(!$content){
                throw new \Exception("Conteúdo da requisição inválido");
            }
            
            $json = json_decode($content, true);
            if(json_last_error() != 0){
                throw new \Exception("Erro ao decodificar dados (Json error " . json_last_error() . ")");
            }

            $dataToParse = $json;
            foreach ($dataToParse as $k => $d) {
                if (is_string($d)) {
                    $json[$k] = $this->removeAccent($d);
                }
            }

            $c = new \Model\Entity\Customer();
            $c->populateFromSync($json);

            //Add price list
            if(isset($json['listaPreco']) && $json['listaPreco'] > 0){
                $priceList = $this->getEntityManager()->find('Model\Entity\PriceList', intval($json['listaPreco']));
                if(is_object($priceList)){
                    $c->setPriceList($priceList);
                }                
            }            

            //Add represented companies
            if(is_array($json['representadas']) && count($json['representadas']) > 0){
                $companies = array();
                foreach($json['representadas'] as $rCod){
                    $rep = $this->getEntityManager()->find('Model\Entity\RepresentedCompany', intval($rCod));
                    if($rep){
                        $companies[] = $rep;
                    }
                }
                $c->addRepresentedCompanies($companies);
            }

            $c->setActive(true);
            $c->setSync(false);

            $this->getEntityManager()->persist($c);

            //$config = $this->getEntityManager()->getRepository('Model\Entity\Config')->findOneBy(array());

            $user = $this->getUser();
            if (is_object($this->config) && is_object($user)) {

                if ($this->config->getEnableCustomerRelationUserFunctionality()) {

                    $uc = new \Model\Entity\UserCustomer();
                    $uc->setCustomer($c);
                    $uc->setUser($user);
                    $uc->setActive(true);
                    $this->getEntityManager()->persist($uc);

                } else if ($this->config->getEnableCustomerDirectRelationUserFunctionality()) {

                    $c->setUser($user);

                    $this->getEntityManager()->persist($c);

                }

            }

            $this->getEntityManager()->flush();
            
            return $this->createResponse(array('success' => true, 'id' => $c->getId()));
            
        }catch(\Exception $ex){
            trigger_error($ex->getMessage());
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }
        
    }

    /**
     * Set user location (latitude and longitude) via API
     * @return mixed
     */
    public function setLocationAction(){

        try{

            $lat = $this->params()->fromPost("latitude", false);
            $lng = $this->params()->fromPost("longitude", false);
            $customerID = $this->params()->fromPost("customer", false);
            if(!$lat || !$lng || !$customerID){
                throw new \Exception("Invalid params");
            }

            $customer = $this->getEntityManager()->find("Model\\Entity\\Customer", $customerID);
            if(!$customer){
                throw new \Exception("Customer not found");
            }

            $customer->setLocation($lat, $lng);

            $this->getEntityManager()->merge($customer);
            $this->getEntityManager()->flush();

            return $this->createResponse(array(
                'success' => true,
                'id' => $customer->getId()
            ));

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }
    
}

?>
