<?php

namespace API\Controller\Custom\Hiper;

use API\Controller\AbstractApiActionController;
use Rhumsaa\Uuid\Console\Exception;
use Zend\Mvc\MvcEvent;
use Commons\Util\DateTimeBr;
use Model\Entity\Order;

class SyncController extends AbstractApiActionController
{
    
    /*

    -----------

    sa
    hiper
    localhost:1433

    admin
    hiperadm

    luan@crmti.com.br
    renato@crmti.com.br

    3 status de pedido (faturado, nao faturado, em cadastramento)
    * filiais para vendedores -> estoque separados
    -> nao faturado - pronta entrega
    -> em cadastramento - pedido

    Filial - Representada?

    -----------

    Boa tarde Fernando,
    Segue em anexo o endereço do servidor dele para acesso externo.
    santanaalimentos.ddns.net
    Usuario: Administrator
    Senha: S@ntana!

    -----------

    saldo estoque
    - grade diversos para sem grade
    - grade outro

    saldo estoque diario

    barras- produtos sinonimo

    DUVIDAS
    - Como vai funcionar a variação de produtos?
    - O código da barras vai ser unitário?

    - Sincronizar produto
    - Sincronizar filial como warehouse
    - Sincronizar item_tabela_variacao (id_tabela_variacao) como cor (X)
    - Sincronizar item_tabela_variacao (id_tabela_variacao) como tamanho (X)
    - Sincronizar saldo_estoque como product_warehouse_variant
    - Sincronizar saldo_estoque como product_warehouse_variant

    */
    
    private $entities;
    private $dbcon;
    private $codeUsed;
    private $connection;

    public function indexAction()
    {
        return $this->createResponse(array(
            'result' => true
        ));
    }

    public function onDispatch(MvcEvent $e) {
        $config = $this->getConfig();
        if (is_array($config) && isset($config['salestool']) && isset($config['salestool']['integration']) && isset($config['salestool']['integration']['config']))
            $this->connection = $config['salestool']['integration']['config'];
        parent::onDispatch($e);
    }

    //--------------------------------------------//

        public function uploadAction()
        {
            try {
                $this->connect();

                $data = array();

                $this->setLog('sync:upload:hiper', 'start');

                //$data['customer'] = $this->uploadCustomers();
                //$data['order'] = $this->uploadOrders();

                $this->setLog('sync:upload:hiper', serialize($data));
                $this->setLog('sync:upload:hiper', 'end');

                return $this->createResponse($data);
            } catch (\Exception $ex) {
                return $this->createErrorResponse("Ocorreu um erro: " . $ex->getMessage());
            }
        }

        public function uploadCustomers()
        {
            try {

                $customersToSync = $this->getEntityManager()->getRepository('Model\Entity\Customer')->findBy(array('sync' => false));
                if (count($customersToSync) == 0)
                    return true;

                $sqlQuery = array();

                foreach ($customersToSync as $key => $customer) {

                    /*
                    INSERT INTO [Hiper].[dbo].[entidade]
                       ([tipo_entidade]
                       ,[nome]
                       ,[id_usuario_cadastro]
                       ,[data_hora_cadastro]
                       ,[id_usuario_alteracao]
                       ,[data_hora_alteracao]
                       ,[logradouro]
                       ,[numero_endereco]
                       ,[bairro]
                       ,[complemento]
                       ,[cep]
                       ,[id_cidade]
                       ,[site]
                       ,[observacao]
                       ,[flag_fornecedor]
                       ,[flag_guia]
                       ,[flag_transportadora]
                       ,[flag_funcionario]
                       ,[situacao_replicacao_multiloja]
                       ,[limite_credito]
                       ,[fone_primario_ddd]
                       ,[fone_primario_numero]
                       ,[fone_secundario_ddd]
                       ,[fone_secundario_numero]
                       ,[email]
                       ,[fone_primario_nome_contato]
                       ,[fone_secundario_nome_contato]
                       ,[id_usuario_vendedor]
                       ,[id_tabela_preco_padrao]
                       ,[logradouro_cobranca]
                       ,[numero_endereco_cobranca]
                       ,[bairro_cobranca]
                       ,[complemento_cobranca]
                       ,[cep_cobranca]
                       ,[id_cidade_cobranca]
                       ,[documento_estrangeiro])
                 VALUES
                       (<tipo_entidade, smallint,>
                       ,<nome, varchar(80),>
                       ,<id_usuario_cadastro, smallint,>
                       ,<data_hora_cadastro, datetime,>
                       ,<id_usuario_alteracao, smallint,>
                       ,<data_hora_alteracao, datetime,>
                       ,<logradouro, varchar(80),>
                       ,<numero_endereco, varchar(7),>
                       ,<bairro, varchar(80),>
                       ,<complemento, varchar(80),>
                       ,<cep, varchar(8),>
                       ,<id_cidade, int,>
                       ,<site, varchar(80),>
                       ,<observacao, varchar(512),>
                       ,<flag_fornecedor, bit,>
                       ,<flag_guia, bit,>
                       ,<flag_transportadora, bit,>
                       ,<flag_funcionario, bit,>
                       ,<situacao_replicacao_multiloja, smallint,>
                       ,<limite_credito, decimal(12,2),>
                       ,<fone_primario_ddd, varchar(2),>
                       ,<fone_primario_numero, varchar(9),>
                       ,<fone_secundario_ddd, varchar(2),>
                       ,<fone_secundario_numero, varchar(9),>
                       ,<email, varchar(80),>
                       ,<fone_primario_nome_contato, varchar(40),>
                       ,<fone_secundario_nome_contato, varchar(40),>
                       ,<id_usuario_vendedor, smallint,>
                       ,<id_tabela_preco_padrao, smallint,>
                       ,<logradouro_cobranca, varchar(80),>
                       ,<numero_endereco_cobranca, varchar(7),>
                       ,<bairro_cobranca, varchar(80),>
                       ,<complemento_cobranca, varchar(80),>
                       ,<cep_cobranca, varchar(8),>
                       ,<id_cidade_cobranca, int,>
                       ,<documento_estrangeiro, varchar(20),>)
                    */

                    //BUSCAR CIDADE
                    //BUSCAR ESTADO
                    //CADASTRAR pessoa_fisica x pessoal_juridica

                    $sqlQuery[] = "INSERT INTO [".$this->connection['database']."].[dbo].[entidade]
                                       ([tipo_entidade]
                                       ,[nome]
                                       ,[id_usuario_cadastro]
                                       ,[data_hora_cadastro]
                                       ,[id_usuario_alteracao]
                                       ,[data_hora_alteracao]
                                       ,[logradouro]
                                       ,[numero_endereco]
                                       ,[bairro]
                                       ,[complemento]
                                       ,[cep]
                                       ,[id_cidade]
                                       ,[site]
                                       ,[observacao]
                                       ,[flag_fornecedor]
                                       ,[flag_guia]
                                       ,[flag_transportadora]
                                       ,[flag_funcionario]
                                       ,[situacao_replicacao_multiloja]
                                       ,[limite_credito]
                                       ,[fone_primario_ddd]
                                       ,[fone_primario_numero]
                                       ,[fone_secundario_ddd]
                                       ,[fone_secundario_numero]
                                       ,[email]
                                       ,[fone_primario_nome_contato]
                                       ,[fone_secundario_nome_contato]
                                       ,[id_usuario_vendedor]
                                       ,[id_tabela_preco_padrao]
                                       ,[logradouro_cobranca]
                                       ,[numero_endereco_cobranca]
                                       ,[bairro_cobranca]
                                       ,[complemento_cobranca]
                                       ,[cep_cobranca]
                                       ,[id_cidade_cobranca]
                                       ,[documento_estrangeiro])
                                 VALUES
                                       '" . ($customer->getCustomerType() != null && $customer->getCustomerType() == 'pf' ? 1 : 2) . "',
                                       '" . ($customer->getName() != null ? $customer->getName() : '') . "', 
                                       NULL,
                                       TO_DATE('" . ($customer->getCreatedFormat('Y-m-d')) . "', 'YYYY-MM-DD HH:II:SS'), 
                                       NULL,
                                       NULL,
                                       '" . ($customer->getAddress() != null ? $customer->getAddress() : ''). "', 
                                       '" . ($customer->getAddressNumber() != null ? $customer->getAddressNumber() : '') . "', 
                                       '" . ($customer->getNeighbourhood() != null ? $customer->getNeighbourhood() : '') . "',  
                                       '" . ($customer->getAddressComplement() != null ? $customer->getAddressComplement() : '') . "', 
                                       '" . ($customer->getZip() != null ? $customer->getZip() : '') . "', 
                                       '" . ($customer->getCity() != null ? $customer->getCity() : '') . "', 
                                       NULL,
                                       '" . ($customer->getInfo() != null ? $customer->getInfo() : '') . "', 
                                        0,
                                        0,
                                        0,
                                        0,
                                        NULL,
                                        NULL,
                                       '" . ($customer->getPhonePrimary() != null ? $customer->getPhonePrimary() : '') . "', 
                                       '" . ($customer->getPhonePrimary() != null ? $customer->getPhonePrimary() : '') . "', 
                                       '" . ($customer->getPhoneSecondary() != null ? $customer->getPhoneSecondary() : '') . "'
                                       '" . ($customer->getPhoneSecondary() != null ? $customer->getPhoneSecondary() : '') . "'
                                    );";

                    /*
                   '" . ($customer->getCompanyName() != null ? $customer->getCompanyName() : '') . "',
                   '" . ($customer->getState() != null ? $customer->getState() : '') . "',
                   '" . ($customer->getSecondaryDocumentNumber() != null ? $customer->getSecondaryDocumentNumber() : '') . "',
                   '" . ($customer->getSecondaryDocumentNumber() != null ? $customer->getSecondaryDocumentNumber() : '') . "',
                   TO_DATE('" . (date('Y-m-d')) . "','YYYY-MM-DD'),
                   '" . date('H:i') . "',
                   " . $newRecno . ",
                   '" . date('H:i') . "',
                    */

                    //$customer->setCode($newCode);
                    $customer->setSync(true);
                    $customer->setSyncDatetime(new DateTimeBr());

                    $this->getEntityManager()->persist($customer);

                }

                $result = $this->queryTransaction($sqlQuery);
                if ($result !== true)
                    throw new Exception('Não foi possível sincronizar os clientes novos com o banco de dados!');
                else
                    $this->getEntityManager()->flush();

                return true;

            } catch (Exception $e) {
                return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $e->getMessage());
            }
        }

        public function uploadOrders()
        {
            try {

                $ordersToSync = $this->getEntityManager()->getRepository('Model\Entity\Order')->findBy(array('sync' => false));
                if (count($ordersToSync) == 0)
                    return true;

                $sqlQuery = array();

                //$idOrderDb = 0;

                foreach ($ordersToSync as $key => $order) {

                    $orderItens = $order->getOrderProducts();
                    if (count($orderItens) > 0) {

                        try {

                            if (
                                is_object($order->getCustomer()) === false || $order->getCustomer()->getCode() == '' ||
                                is_object($order->getUser()) === false || $order->getUser()->getCode() == ''
                            )
                                continue;

                            /*
                            INSERT INTO [Hiper].[dbo].[pedido_venda]
                                   ([id_entidade_cliente]
                                   ,[tipo_frete]
                                   ,[valor_frete]
                                   ,[id_entidade_transportadora]
                                   ,[codigo_pedido_cliente]
                                   ,[id_representante]
                                   ,[data_previsao_entrega_inicial]
                                   ,[data_previsao_entrega_final]
                                   ,[data_previsao_faturamento]
                                   ,[observacao]
                                   ,[situacao]
                                   ,[id_usuario_geracao]
                                   ,[data_hora_geracao]
                                   ,[id_usuario_englobamento]
                                   ,[data_hora_englobamento]
                                   ,[id_englobamento]
                                   ,[operacao]
                                   ,[nome_cliente_orcamento]
                                   ,[nome_contato_cliente_orcamento]
                                   ,[cpf_cliente_orcamento]
                                   ,[cnpj_cliente_orcamento]
                                   ,[ie_cliente_orcamento]
                                   ,[logradouro_cliente_orcamento]
                                   ,[numero_endereco_cliente_orcamento]
                                   ,[bairro_cliente_orcamento]
                                   ,[complemento_cliente_orcamento]
                                   ,[cep_cliente_orcamento]
                                   ,[id_cidade_cliente_orcamento]
                                   ,[fone_ddd_cliente_orcamento]
                                   ,[fone_numero_cliente_orcamento]
                                   ,[celular_ddd_cliente_orcamento]
                                   ,[celular_numero_cliente_orcamento]
                                   ,[email_cliente_orcamento]
                                   ,[id_usuario_vendedor]
                                   ,[data_validade_orcamento]
                                   ,[id_filial_venda]
                                   ,[id_tabela_preco]
                                   ,[hash_md5]
                                   ,[situacao_impressao]
                                   ,[observacao_interna]
                                   ,[gerar_controle_entrega])
                             VALUES
                                   (<id_entidade_cliente, int,>
                                   ,<tipo_frete, smallint,>
                                   ,<valor_frete, decimal(12,2),>
                                   ,<id_entidade_transportadora, int,>
                                   ,<codigo_pedido_cliente, varchar(20),>
                                   ,<id_representante, smallint,>
                                   ,<data_previsao_entrega_inicial, datetime,>
                                   ,<data_previsao_entrega_final, datetime,>
                                   ,<data_previsao_faturamento, datetime,>
                                   ,<observacao, varchar(512),>
                                   ,<situacao, smallint,>
                                   ,<id_usuario_geracao, smallint,>
                                   ,<data_hora_geracao, datetime,>
                                   ,<id_usuario_englobamento, smallint,>
                                   ,<data_hora_englobamento, datetime,>
                                   ,<id_englobamento, int,>
                                   ,<operacao, smallint,>
                                   ,<nome_cliente_orcamento, varchar(80),>
                                   ,<nome_contato_cliente_orcamento, varchar(40),>
                                   ,<cpf_cliente_orcamento, varchar(11),>
                                   ,<cnpj_cliente_orcamento, varchar(14),>
                                   ,<ie_cliente_orcamento, varchar(14),>
                                   ,<logradouro_cliente_orcamento, varchar(80),>
                                   ,<numero_endereco_cliente_orcamento, varchar(7),>
                                   ,<bairro_cliente_orcamento, varchar(80),>
                                   ,<complemento_cliente_orcamento, varchar(80),>
                                   ,<cep_cliente_orcamento, varchar(8),>
                                   ,<id_cidade_cliente_orcamento, int,>
                                   ,<fone_ddd_cliente_orcamento, varchar(2),>
                                   ,<fone_numero_cliente_orcamento, varchar(9),>
                                   ,<celular_ddd_cliente_orcamento, varchar(2),>
                                   ,<celular_numero_cliente_orcamento, varchar(9),>
                                   ,<email_cliente_orcamento, varchar(80),>
                                   ,<id_usuario_vendedor, smallint,>
                                   ,<data_validade_orcamento, datetime,>
                                   ,<id_filial_venda, smallint,>
                                   ,<id_tabela_preco, smallint,>
                                   ,<hash_md5, varchar(32),>
                                   ,<situacao_impressao, bit,>
                                   ,<observacao_interna, varchar(512),>
                                   ,<gerar_controle_entrega, bit,>)
                            */

                            $sql = "INSERT INTO " . self::SCHEME . ".unipedc (
                                                    frotina,
                                                    fchave,
                                                    fclifor,
                                                    fpedido,
                                                    fdataped,
                                                    fcondpgto,
                                                    ftipomovto,
                                                    ftipopedel,
                                                    fvendedor,
                                                    ffilial,
                                                    fobs,
                                                    fstatus,
                                                    fvalortot,
                                                    exporta,
                                                    falthora,
                                                    faltusu,
                                                    fincusu,
                                                    fincdata,
                                                    finchora
                                                ) VALUES (
                                                    'SALESTOO',
                                                    '" . $order->getId() . "',
                                                    '" . (is_object($order->getCustomer()) ? $order->getCustomer()->getCode() : '') . "',
                                                    '" . $order->getId() . "',
                                                    TO_DATE('" . (date('Y-m-d')) . "','YYYY-MM-DD'),
                                                    '" . (is_object($order->getPaymentCondition()) ? $order->getPaymentCondition()->getCode() : '') . "',
                                                    'S',
                                                    '001',
                                                    '" . (is_object($order->getUser()) ? $order->getUser()->getCode() : '') . "',
                                                    '000',
                                                    '" . $order->getInfo() . "',
                                                    '1',
                                                    " . $order->getTotal() . ",
                                                    CURRENT_DATE,
                                                    CURRENT_TIME::CHAR(8),
                                                    'UNPEDEL',
                                                    'UNPEDEL',
                                                    CURRENT_DATE,
                                                    CURRENT_TIME::CHAR(5)                               
                                                )";

                            //$idOrderDb = $this->queryTransaction($sql, true);

                            if ($this->queryTransaction($sql)) {
                                //$qtdItens = 0;
                                foreach ($orderItens as $item) {

                                    if (
                                        is_object($item->getProduct()) === false
                                        || $item->getProduct()->getCode() == ''
                                    )
                                        continue;

                                    /*
                                    INSERT INTO [Hiper].[dbo].[item_pedido_venda]
                                           ([id_pedido_venda]
                                           ,[sequencia_item]
                                           ,[id_produto]
                                           ,[valor_unitario]
                                           ,[observacao]
                                           ,[valor_unitario_com_desconto]
                                           ,[cancelado]
                                           ,[hash_md5]
                                           ,[id_usuario_desconto])
                                     VALUES
                                           (<id_pedido_venda, int,>
                                           ,<sequencia_item, smallint,>
                                           ,<id_produto, int,>
                                           ,<valor_unitario, decimal(13,3),>
                                           ,<observacao, varchar(512),>
                                           ,<valor_unitario_com_desconto, decimal(14,6),>
                                           ,<cancelado, bit,>
                                           ,<hash_md5, varchar(32),>
                                           ,<id_usuario_desconto, smallint,>)
                                    */

                                    $sqlQuery[] = "INSERT INTO " . self::SCHEME . ".unipedi (
                                                frotina,
                                                fchave,
                                                fproduto,
                                                fsequencia,
                                                ftipoitem,
                                                fqtde,
                                                fvlrunit,
                                                fvlrtotal,
                                                fvdescnorm,
                                                fvdescprom
                                            ) VALUES (
                                                'SALESTOO',
                                                '" . $order->getId() . "',
                                                '" . (is_object($item->getProduct()) ? $item->getProduct()->getCode() : '') . "',
                                                '',
                                                'N',
                                                " . $item->getAmount() . ",
                                                " . $item->getPrice() . ",
                                                " . $item->getTotal() . ",
                                                " . ($item->getDiscount() > 0 ? round($item->getDiscount() / $item->getAmount(), 2) : 0) . ",
                                                " . ($item->getDiscount() > 0 ? (round($item->getDiscount() / $item->getTotal(), 2) * 100) : 0) . "
                                            )";

                                    $item->setSync(true);
                                    $item->setSyncDatetime(new DateTimeBr());
                                    $this->getEntityManager()->persist($item);
                                }

                                $this->queryTransaction($sqlQuery);

                                $sqlQuery = array();
                            }

                        } catch (\Exception $e) {
                            continue;
                        }

                        $order->setSync(true);
                        $order->setSyncDatetime(new DateTimeBr());
                        $this->getEntityManager()->persist($order);
                    }
                }

                $this->getEntityManager()->flush();

                return true;

            } catch (Exception $e) {
                return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $e->getMessage());
            }
        }

    //--------------------------------------------//

    //--------------------------------------------//

        public function downloadAction()
        {
            try{
                $this->connect();

                $data = array();

                $this->codeUsed = array();

                $this->setLog('sync:download:hiper', 'start');

                //$usedItens = $this->getOrdersRelations();

                $data['users'] = $this->syncUsers();
                $data['customer'] = $this->syncCustomers();
                $data['product'] = $this->syncProducts();
                $data['warehouse'] = $this->syncWarehouse();
                $data['productWarehouse'] = $this->syncProductsWarehouse();
                $data['financial'] = $this->syncFinancialPending();

                //--------- INACTIVE ITENS ------------//
                if (count($this->codeUsed) > 0) {
                    foreach ($this->codeUsed as $entityName => $codesUsed) {
                        if (count($this->entities[$entityName]) > 0) {
                            foreach ($this->entities[$entityName] as $itemEntity) {

                                if (method_exists($itemEntity, 'getCode') === false)
                                    break;

                                if (
                                    ($entityName != 'Order' && in_array($itemEntity->getCode(), $codesUsed) == false) &&
                                    ($entityName != 'User' || $itemEntity->getUsername() != 'admin')
                                ) {
                                    $itemEntity->setActive(false);
                                    $this->getEntityManager()->persist($itemEntity);
                                }

                            }
                        }
                    }
                    $this->getEntityManager()->flush();
                }
                //--------- INACTIVE ITENS ------------//

                $this->setLog('sync:download:hiper', serialize($data));
                $this->setLog('sync:download:hiper', 'end');

                return $this->createResponse($data);
            }catch(\Exception $ex){
                return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
            }
        }

        public function syncUsers()
        {
            try {

                $sql = "SELECT id_usuario
                              ,login
                              ,nome
                              ,ativo
                              ,senha
                              ,vendedor
                              ,email
                              ,id_entidade
                              ,percentual_maximo_desconto
                          FROM [".$this->connection['database']."].[dbo].[usuario]
                          WHERE ativo = 1 AND vendedor = 1 AND id_usuario IS NOT NULL AND login IS NOT NULL";

                $result = $this->query($sql);

                if (is_array($result) === false || count($result) == 0)
                    return false;

                $this->codeUsed['User'] = array();

                $checkDuplicatedLogin = array();
                $checkDuplicatedEmail = array();
                foreach ($result as $vendedor) {

                    if (
                      (empty($vendedor['login']) === false && in_array(trim($vendedor['login']), $checkDuplicatedLogin)) ||
                      (empty($vendedor['email']) === false && in_array(trim($vendedor['email']), $checkDuplicatedEmail))
                    ) {
                        continue;
                    }

                    if (empty($vendedor['login']) === false)
                        $checkDuplicatedLogin[] = trim($vendedor['login']);

                    if (empty($vendedor['email']) === false)
                        $checkDuplicatedEmail[] = trim($vendedor['email']);

                    $entity = $this->getEntityRelated('User', $vendedor['id_usuario']);

                    $this->codeUsed['User'][] = trim($vendedor['id_usuario']);

                    if ($entity->getId() > 0 && $entity->getSync() === false)
                        continue;

                    $entity->setCode(trim($vendedor['id_usuario']));
                    $entity->setName(trim($vendedor['nome']));
                    //--UNIQUE--//
                    $entity->setEmail(isset($vendedor['email']) && strstr($vendedor['email'], "@") !== false ? trim($vendedor['email']) : $vendedor['login']);
                    $entity->setUsername(empty($vendedor['login']) === false ? trim($vendedor['login']) : trim($vendedor['id_usuario']));
                    //--UNIQUE--//
                    //$entity->setPassword(empty($vendedor['senha']) === false ? trim($vendedor['senha']) : trim($vendedor['login']));
                    $entity->setPassword(empty($vendedor['login']) === false ? trim($vendedor['login']) : trim($vendedor['id_usuario']));
                    $entity->setDiscountMaximum(empty($vendedor['percentual_maximo_desconto']) === false ? floatval($vendedor['percentual_maximo_desconto']) : 0.00 );
                    $entity->setActive(true);
                    $entity->setAdmin(false);
                    $entity->setSync(true);
                    $entity->setSyncDatetime(new DateTimeBr());

                    $this->getEntityManager()->persist($entity);
                }

                $this->getEntityManager()->flush();

                return true;

            }  catch(Exception $e)  {
                return $e->getMessage();
            }
        }

        public function syncCustomers()
        {
            try {

                $sqlComp = '';

                $sql = "
                    SELECT 
                           F.cpf
                          ,F.rg
                          ,F.data_nascimento
                          ,J.cnpj
                          ,J.ie
                          ,J.nome_fantasia
                          ,E.id_entidade
                          ,E.tipo_entidade
                          ,E.nome
                          ,C.nome cidade
                          ,C.uf                      
                          ,E.logradouro
                          ,E.numero_endereco
                          ,E.bairro
                          ,E.complemento
                          ,E.cep
                          ,E.id_cidade
                          ,E.observacao
                          ,E.situacao_replicacao_multiloja
                          ,E.limite_credito
                          ,E.fone_primario_ddd
                          ,E.fone_primario_numero
                          ,E.fone_primario_nome_contato
                          ,E.fone_secundario_ddd
                          ,E.fone_secundario_numero
                          ,E.email
                          ,E.id_usuario_vendedor
                          ,E.id_tabela_preco_padrao
                      FROM [".$this->connection['database']."].[dbo].[entidade] E
                          LEFT JOIN [".$this->connection['database']."].[dbo].[pessoa_fisica] F ON F.id_entidade = E.id_entidade
                          LEFT JOIN [".$this->connection['database']."].[dbo].[pessoa_juridica] J ON J.id_entidade = E.id_entidade
                          LEFT JOIN [".$this->connection['database']."].[dbo].[cidade] C ON C.id_cidade = E.id_cidade
                      WHERE E.nome IS NOT NULL AND E.nome <> ''
                ".$sqlComp;

                $result = $this->query($sql, array(), false);

                if (is_array($result) === false || count($result) == 0)
                    throw new Exception('Nenhum cliente foi encontrado!');

                $this->codeUsed['Customer'] = array();

                foreach ($result as $cliente) {

                    $pj = $cliente['tipo_entidade'] == 2 ? true : false;

                    $entity = $this->getEntityRelated('Customer', $cliente['id_entidade']);

                    $this->codeUsed['Customer'][] = trim($cliente['id_entidade']);

                    if ($entity->getId() > 0 && $entity->getSync() === false)
                        continue;

                    $entity->populateFromSync(array(
                        'code' => trim($cliente['id_entidade']),
                        'nome' => ($pj === true && empty($cliente['nome_fantasia']) === false ? $cliente['nome_fantasia'] : $cliente['nome']),
                        'nickname' => '',
                        'razaoSocial' => ($pj === true ? $cliente['nome'] : ''),
                        'contato' => $cliente['fone_primario_nome_contato'],
                        'documentoNacional' => ($pj === true ? $cliente['cnpj'] : $cliente['cpf']),
                        'documentoEstadual' => ($pj === true ? $cliente['rg'] : $cliente['ie']),
                        'email' => $cliente['email'],
                        'cep' => $cliente['cep'],
                        'endereco' => $cliente['logradouro'],
                        'numero' => $cliente['numero_endereco'],
                        'complemento' => $cliente['complemento'],
                        'bairro' => $cliente['bairro'],
                        'cidade' => $cliente['cidade'],
                        'estado' => $cliente['uf'],
                        'tipo' => ($pj === true ? 'pj' : 'pf'),
                        'telefonePrincipal' => $cliente['fone_primario_ddd'].$cliente['fone_primario_numero'],
                        'telefoneSecundario' => $cliente['fone_secundario_ddd'].$cliente['fone_secundario_numero'],
                        'info' => $cliente['observacao'],
                        'active' => 1,
                        'latitude' => '',
                        'longitude' => '',
                    ));

                    if (!$entity->getId()) {
                        $entity->setBlocked(false);
                    }

                    $entity->setActive(true);
                    $entity->setSync(true);
                    $entity->setSyncDatetime(new DateTimeBr());

                    $this->getEntityManager()->persist($entity);
                }

                $this->getEntityManager()->flush();

                return true;

            }  catch(Exception $e)  {
                return $e->getMessage();
            }
        }

        public function syncProducts()
        {
            try {

                $sqlComp = '';

                $sql = "
                    SELECT P.id_produto
                          ,P.nome
                          ,P.situacao
                          ,P.id_entidade_fornecedor
                          ,P.id_marca_produto
                          ,P.id_unidade_medida
                          ,P.id_hierarquia_produto
                          ,P.tipo_variacao
                          ,P.id_tabela_variacao_a
                          ,P.id_tabela_variacao_b
                          ,P.referencia_interna_produto
                          ,P.preco_custo
                          ,P.preco_venda
                          ,P.preco_minimo_venda
                          ,P.tipo_item
                          ,P.informacao_adicional
                          ,P.id_imagem
                          ,M.nome nome_marca
                          ,M.marca_propria
                          ,U.sigla
                          ,U.nome nome_unidade
                          ,U.casas_decimais
                          ,U.controlar_volume
                          ,C.nome nome_grupo
                          ,C.sequencia sequencia_grupo
                          ,C.id_hierarquia_produto_pai
                          ,C2.nome nome_grupo_pai
                          ,C2.sequencia sequencia_grupo_pai
                          ,I.imagem
                      FROM [".$this->connection['database']."].[dbo].[produto] P
                          LEFT JOIN [".$this->connection['database']."].[dbo].[marca_produto] M ON M.id_marca_produto = P.id_marca_produto
                          LEFT JOIN [".$this->connection['database']."].[dbo].[unidade_medida] U ON U.id_unidade_medida = P.id_unidade_medida
                          LEFT JOIN [".$this->connection['database']."].[dbo].[hierarquia_produto] C ON C.id_hierarquia_produto = P.id_hierarquia_produto
                          LEFT JOIN [".$this->connection['database']."].[dbo].[hierarquia_produto] C2 ON C2.id_hierarquia_produto = C.id_hierarquia_produto_pai
                          LEFT JOIN [".$this->connection['database']."].[dbo].[imagem] I ON I.id_imagem = P.id_imagem
                      WHERE P.situacao = 1
                ".$sqlComp;

                $result = $this->query($sql, array(), true);

                if (is_array($result) === false || count($result) == 0)
                    throw new Exception('Nenhum produto foi encontrado!');

                $this->codeUsed['Product'] = array();
                $this->codeUsed['Group'] = array();
                $this->codeUsed['Unit'] = array();

                foreach ($result as $produto) {

                    $grupo = null;
                    if (empty($produto['id_hierarquia_produto']) === false && empty($produto['nome_grupo']) === false) {
                        try {
                            $grupo = $this->getEntityRelated('Group', $produto['id_hierarquia_produto']);

                            $this->codeUsed['Group'][] = trim($produto['id_hierarquia_produto']);

                            $grupo->setCode(trim($produto['id_hierarquia_produto']));
                            $grupo->setDescription($produto['nome_grupo']);
                            $grupo->setActive(true);
                            $grupo->setSync(true);
                            $grupo->setSyncDatetime(new DateTimeBr());
                            $this->getEntityManager()->persist($grupo);
                        } catch (Exception $e) {
                            //Do nothing
                        }
                    }

                    $subgrupo = null;
                    if (empty($produto['id_hierarquia_produto_pai']) === false && empty($produto['nome_grupo_pai']) === false) {
                        try {
                            $subgrupo = $this->getEntityRelated('Group', $produto['id_hierarquia_produto_pai']);

                            $this->codeUsed['Group'][] = trim($produto['id_hierarquia_produto_pai']);

                            $subgrupo->setCode(trim($produto['id_hierarquia_produto_pai']));
                            $subgrupo->setDescription($produto['nome_grupo_pai']);
                            $subgrupo->setActive(true);
                            $subgrupo->setSync(true);
                            $subgrupo->setSyncDatetime(new DateTimeBr());
                            $this->getEntityManager()->persist($subgrupo);
                        } catch (Exception $e) {
                            //Do nothing
                        }
                    }

                    $unidade = null;
                    if (empty($produto['sigla']) === false && empty($produto['nome_unidade']) === false) {
                        try {
                            $unidade = $this->getEntityRelated('Unit', strtolower($produto['sigla']), true);

                            $this->codeUsed['Unit'][] = trim(strtolower($produto['sigla']));

                            $unidade->setId(trim(strtolower($produto['sigla'])));
                            $unidade->setDescription($produto['nome_unidade']);
                            $unidade->setActive(true);
                            $unidade->setSync(true);
                            $unidade->setSyncDatetime(new DateTimeBr());
                            $this->getEntityManager()->persist($unidade);
                        } catch (Exception $e) {
                            //Do nothing
                        }
                    }

                    $entity = $this->getEntityRelated('Product', $produto['id_produto']);

                    $this->codeUsed['Product'][] = trim($produto['id_produto']);

                    if (
                        ($entity->getId() > 0 && $entity->getSync() === false)
                        //|| $entity->getId() > 0
                    )
                        continue;

                    $entity->populateFromSync(array(
                        'code' => trim($produto['id_produto']),
                        'name' => $produto['nome'],
                        'reference' => $produto['referencia_interna_produto'],
                        'description' => '',
                        'barcode' => '',
                        'info' => '',
                        'unit' => $unidade,
                        'groupPrimary' => $grupo,
                        'groupSecondary' => $subgrupo,
                        'cost' => floatval($produto['preco_custo']),
                        'price' => floatval($produto['preco_venda']),
                        'priceMin' => floatval($produto['preco_minimo_venda']),
                        'commission' => 0.00,
                        'descriptionGrid' => '',
                        'amountMinimal' => 0,
                        'pricePromotional' => 0
                    ));

                    $entity->setActive(true);
                    $entity->setSync(true);
                    $entity->setSyncDatetime(new DateTimeBr());

                    $this->getEntityManager()->persist($entity);
                }

                $this->getEntityManager()->flush();

                return true;

            }  catch(Exception $e)  {
                return $e->getMessage();
            }
        }

        public function syncWarehouse()
        {
            try {

                $sqlComp = '';

                $sql = "SELECT F.id_filial
                              ,F.nome_fantasia
                          FROM [".$this->connection['database']."].[dbo].[filial] F
                    ".$sqlComp;

                $result = $this->query($sql, array(), false);

                if (is_array($result) === false || count($result) == 0)
                    throw new Exception('Nenhum estoque foi encontrado!');

                $this->codeUsed['Warehouse'] = array();

                foreach ($result as $filial) {

                    $entity = $this->getEntityRelated('Warehouse', trim($filial['id_filial']));

                    $this->codeUsed['Warehouse'][] = trim($filial['id_filial']);

                    if ($entity->getId() > 0 && $entity->getSync() === false)
                        continue;

                    $entity->setCode(trim($filial['id_filial']));
                    $entity->setDescription(trim($filial['nome_fantasia']));
                    $entity->setMain(false);
                    $entity->setActive(true);
                    $entity->setSync(true);
                    $entity->setSyncDatetime(new DateTimeBr());

                    $this->getEntityManager()->persist($entity);
                }

                $this->getEntityManager()->flush();

                return true;

            }  catch(Exception $e)  {
                return $e->getMessage();
            }
        }

        public function syncProductsWarehouse()
        {
            try {

                $sqlComp = '';

                $sql = "SELECT SE.id_produto
                            ,SE.id_variacao
                            ,SE.id_endereco_estoque
                            ,SE.quantidade
                            ,ES.id_filial
                            ,FI.nome_Fantasia filial
                            ,PV.nome
                            ,PV.situacao
                            ,PV.id_item_tabela_variacao_a
                            ,PV.id_item_tabela_variacao_b
                            ,PV.referencia_interna_variacao
                            ,PV.nome_variacao_a
                            ,PV.nome_variacao_b
                        FROM [".$this->connection['database']."].[dbo].[saldo_estoque] SE
                            INNER JOIN [".$this->connection['database']."].[dbo].[produto_variacao] PV ON PV.id_produto = SE.id_produto AND PV.id_variacao = SE.id_variacao
                            INNER JOIN [".$this->connection['database']."].[dbo].[endereco_estoque] ES ON ES.id_endereco_estoque = SE.id_endereco_estoque
                            INNER JOIN [".$this->connection['database']."].[dbo].[filial] FI ON FI.id_filial = ES.id_filial
                        WHERE PV.situacao = 1
                        ORDER BY id_produto DESC, id_variacao ASC, SE.id_endereco_estoque ASC                       
                        ".$sqlComp;

                $result = $this->query($sql, array(), false);

                if (is_array($result) === false || count($result) == 0)
                    throw new Exception('Nenhum estoque foi encontrado!');

                //$this->codeUsed['Product'] = array();
                //$this->codeUsed['Warehouse'] = array();
                $this->codeUsed['Color'] = array();
                $this->codeUsed['Size'] = array();
                $this->codeUsed['ProductWarehouseVariant'] = array();

                foreach ($result as $estoqueItem) {

                    $code = trim($estoqueItem['id_produto'])."#".trim($estoqueItem['id_variacao'])."#".trim($estoqueItem['id_filial']);

                    $entity = $this->getEntityRelated('ProductWarehouseVariant', $code);
                    $entityProduct = $this->getEntityRelated('Product', trim($estoqueItem['id_produto']));
                    $entityWarehouse = $this->getEntityRelated('Warehouse', trim($estoqueItem['id_filial']));

                    if (
                        is_object($entity) === false ||
                        is_object($entityProduct) === false ||
                        is_object($entityWarehouse) === false ||
                        $entity->getSync() === false
                    )
                        continue;

                    try {
                        $color = null;
                        if (empty($estoqueItem['id_item_tabela_variacao_a']) === false) {
                            $color = $this->getEntityRelated('Color', trim($estoqueItem['id_item_tabela_variacao_a']));

                            $this->codeUsed['Color'][] = trim($estoqueItem['id_item_tabela_variacao_a']);

                            $color->setCode(trim($estoqueItem['id_item_tabela_variacao_a']));
                            $color->setDescription(trim($estoqueItem['nome_variacao_a']));
                            $color->setActive(true);
                            $color->setSync(true);
                            $color->setSyncDatetime(new DateTimeBr());
                            $this->getEntityManager()->persist($color);
                        }
                    } catch (Exception $e) {
                        //Do nothing
                    }

                    try {
                        $size = null;
                        if (empty($estoqueItem['id_item_tabela_variacao_b']) === false) {
                            $size = $this->getEntityRelated('Size', trim($estoqueItem['id_item_tabela_variacao_b']));

                            $this->codeUsed['Size'][] = trim($estoqueItem['id_item_tabela_variacao_b']);

                            $size->setCode(trim($estoqueItem['id_item_tabela_variacao_b']));
                            $size->setDescription(trim($estoqueItem['nome_variacao_b']));
                            $size->setActive(true);
                            $size->setSync(true);
                            $size->setSyncDatetime(new DateTimeBr());
                            $this->getEntityManager()->persist($size);
                        }
                    } catch (Exception $e) {
                        //Do nothing
                    }

                    $entity->setCode($code);
                    $entity->setProduct($entityProduct);
                    $entity->setColor($color);
                    $entity->setSize($size);
                    $entity->setWarehouse($entityWarehouse);
                    $entity->setAmount((int)$estoqueItem['quantidade']);

                    $entity->setActive(true);
                    $entity->setSync(true);
                    $entity->setSyncDatetime(new DateTimeBr());

                    $this->getEntityManager()->persist($entity);

                    $this->codeUsed['ProductWarehouseVariant'][] = trim($code);
                }

                $this->getEntityManager()->flush();

                return true;

            }  catch(Exception $e)  {
                return $e->getMessage();
            }
        }

        public function syncFinancialPending()
        {
            try {

                $sqlComp = '';

                $sql = "
                    SELECT DR.id_documento_receber
                          ,DR.id_entidade
                          ,DR.data_hora_cadastro
                          ,DR.data_emissao
                          ,DR.data_vencimento
                          ,DR.data_vencimento_original
                          ,DR.data_quitacao
                          ,DR.valor
                          ,DR.saldo
                          ,DR.situacao
                          ,DR.numero_documento_receber
                          ,DR.descricao
                    FROM [".$this->connection['database']."].[dbo].[documento_receber] DR
                    WHERE DR.situacao = 1
                ".$sqlComp;

                $result = $this->query($sql, array(), true);

                if (is_array($result) === false || count($result) == 0)
                    throw new Exception('Nenhuma pendencia financeira foi encontrada!');

                foreach ($result as $pendencia) {

                    $entity = $this->getEntityRelated('FinancialPending', $pendencia['id_documento_receber']);

                    $entityCustomer = $this->getEntityRelated('Customer', $pendencia['id_entidade']);

                    $this->codeUsed['FinancialPending'][] = trim($pendencia['id_documento_receber']);

                    $modelDescription = empty($pendencia['descricao']) === false ?
                        trim($pendencia['descricao']).(
                        empty($pendencia['numero_documento_receber']) === false ?
                            ' '.($pendencia['numero_documento_receber']) : ''
                        ) : '';

                    if (
                        ($entity->getId() > 0 && $entity->getSync() === false) ||
                        is_object($entityCustomer) === false ||
                        empty($modelDescription)
                    )
                        continue;

                    $entity->setCode(trim($pendencia['id_documento_receber']));
                    $entity->setDescription($modelDescription);
                    $entity->setCustomer($entityCustomer);
                    $entity->setTotal(floatval($pendencia['valor']));

                    if (isset($pendencia['data_vencimento']) && preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", substr(trim($pendencia['data_vencimento']),0,10))) {
                        $entity->setDate(\DateTime::createFromFormat('Y-m-d', substr($pendencia['data_vencimento'],0,10)));
                    } else {
                        continue;
                    }

                    $entity->setStatus(true);
                    $entity->setActive(true);
                    $entity->setSync(true);
                    $entity->setSyncDatetime(new DateTimeBr());

                    $this->getEntityManager()->persist($entity);
                }

                $this->getEntityManager()->flush();

                return true;

            }  catch(Exception $e)  {
                return $e->getMessage();
            }
        }

        /*
         * INACTIVE
         */
        public function syncOrders($ids)
        {
            try {

                return false;

                if (is_array($ids) === false || count($ids) == 0)
                    throw new Exception('Nenhum id de pedido foi encontrado!');

                $sqlComp = ' AND P.CD_PEDIDO IN ('.implode(",", $ids).') ';

                $sql = "SELECT P.CD_PEDIDO
                              ,P.CD_CARTEIRA
                              ,FC.DS_CARTEIRA
                              ,P.CD_FORMA_PAGAMENTO
                              ,FP.DS_FORMA_PAGAMENTO
                              ,P.CD_STATUS
                              ,S.DS_STATUS
                              ,S.CD_STATUS STATUS_GLOBAL
                              ,P.CD_VENDEDOR
                              ,VE.DS_ENTIDADE VENDEDOR_COMPLETO
                              ,VE.DS_FANTASIA VENDEDOR_NOME
                              ,P.DT_EMISSAO
                              ,CONVERT(VARCHAR(10),P.DT_ENTREGA,126) as DT_ENTREGA
                              ,P.DT_CADASTRO
                              ,P.DS_OBS
                              ,P.NR_ITENS
                              ,P.VL_TOTAL
                              ,P.CD_CLIENTE
                              ,CL.DS_ENTIDADE CLIENTE_COMPLETO
                              ,CL.DS_FANTASIA CLIENTE_NOME
                              ,P.VL_DESCONTO
                              ,P.CD_TRANSPORTADOR
                              ,P.NR_ORDEM_COMPRA
                              ,P.VL_PRODUTOS
                              ,P.NR_QUANTIDADE
                              ,P.VL_MATERIAIS
                              ,P.DS_VALIDADE
                              ,P.VL_DESCONTO_ITENS
                              ,P.DS_OBS_INTERNA
                              ,P.PR_DESCONTO
                              ,P.CD_ORCAMENTO
                              ,P.CD_TIPO_PEDIDO
                              ,TP.DS_TIPO_PEDIDO
                              ,P.CD_INTEGRACAO
                        FROM [".$this->connection['database']."].[dbo].[TBL_PEDIDOS] P
                        LEFT JOIN [".$this->connection['database']."].[dbo].[TBL_FINANCEIRO_CARTEIRA] FC 		    ON FC.CD_CARTEIRA = P.CD_CARTEIRA
                        LEFT JOIN [".$this->connection['database']."].[dbo].[TBL_FINANCEIRO_FORMAS_PAGAMENTO] FP  ON FP.CD_FORMA_PAGAMENTO = P.CD_FORMA_PAGAMENTO
                        LEFT JOIN [".$this->connection['database']."].[dbo].[TBL_TIPO_PEDIDO] TP 				    ON TP.CD_TIPO_PEDIDO = P.CD_TIPO_PEDIDO
                        LEFT JOIN [".$this->connection['database']."].[dbo].[TBL_STATUS_GLOBAL] S 				ON S.CD_STATUS = P.CD_STATUS
                        LEFT JOIN [".$this->connection['database']."].[dbo].[TBL_ENTIDADES] CL 					ON CL.CD_ENTIDADE = P.CD_CLIENTE
                        LEFT JOIN [".$this->connection['database']."].[dbo].[TBL_ENTIDADES] VE 					ON VE.CD_ENTIDADE = P.CD_VENDEDOR
                        WHERE S.CD_STATUS = ".self::ID_STATUS_PULL_ORDER."
                              ".$sqlComp."
                        ORDER BY P.CD_PEDIDO DESC";

                $result = $this->query($sql, array(), false);

                if (is_array($result) === false || count($result) == 0)
                    throw new Exception('Nenhum pedido foi encontrado!');

                $this->codeUsed['Order'] = array();
                $this->codeUsed['OrderProduct'] = array();
                $this->codeUsed['PaymentMethod'] = array();
                $this->codeUsed['PaymentCondition'] = array();

                $listIdPedidos = array();
                foreach ($result as $pedido) {
                    $listIdPedidos[$pedido['CD_PEDIDO']] = trim($pedido['CD_PEDIDO']);
                }

                $resultItens = $this->query("SELECT [CD_PEDIDO]
                                               ,[CD_ITEM]
                                               ,[CD_MATERIAL]
                                               ,[DS_MATERIAL]
                                               ,[DS_UNIDADE]
                                               ,[NR_QUANTIDADE]
                                               ,[VL_UNITARIO]
                                               ,[VL_TOTAL]
                                               ,[NR_PESO]
                                               ,[CD_ID]
                                               ,[PR_COMISSAO]
                                               ,[PR_DESCONTO]
                                               ,[VL_DESCONTO]
                                               ,[CD_VENDEDOR]
                                               ,CONVERT(VARCHAR(10),DT_ENTREGA,126) as DT_ENTREGA
                                               ,[DS_OBS]
                                               ,[VL_COMISSAO]
                                               ,[VL_DESCONTO_ITEM]
                                               ,[VL_FRETE]
                                               ,[VL_UNITARIO_MOEDA]
                                               ,[VL_TOTAL_MOEDA]
                                               ,[NR_QUANTIDADE_VOLUME]
                                               ,[NR_QUANTIDADE_FATURADA]
                                               ,[VL_UNITARIO_VENDA]
                                               ,[DS_MODELO]
                                               ,[VL_UNITARIO_LIQUIDO]
                                               ,[VL_TOTAL_LIQUIDO]
                                               ,[DS_DESCONTO_CASCATA]
                                               ,[DS_PEDIDO_COMPRA]
                                               ,[NR_ITEM_ORDEM_COMPRA]
                                        FROM [".$this->connection['database']."].[dbo].[TBL_PEDIDOS_ITENS] PI
                                        WHERE CD_PEDIDO IN (".implode(",", $listIdPedidos).")
                                        ORDER BY CD_PEDIDO DESC
                                      ", array(), false); //(5694)

                if (is_array($resultItens) === false || count($resultItens) == 0)
                    throw new Exception('Nenhum item de pedido foi encontrado!');

                $listPedidosItens = array();
                foreach ($resultItens as $pedidoItem) {

                    if (isset($listPedidosItens[$pedidoItem['CD_PEDIDO']]) === false)
                        $listPedidosItens[$pedidoItem['CD_PEDIDO']] = array();

                    $listPedidosItens[$pedidoItem['CD_PEDIDO']][] = $pedidoItem;
                }

                try {
                    //$user = $this->getUser();
                    $warehouse = $this->getEntityManager()->find('Model\Entity\Warehouse', 1);
                } catch (Exception $e) {
                    throw new Exception('Seu usuário não foi encontrado!');
                }

                $checkDuplicate = array();

                foreach ($result as $pedido) {

                    /* WILL ONLY INACTIVE EXISTENT
                    if (isset($pedido['STATUS_GLOBAL']) && trim($pedido['STATUS_GLOBAL']) == self::ID_STATUS_REMOVE_ORDER) { //Remove Order

                        $entity = $this->getEntityRelated('Order', $pedido['CD_PEDIDO']);
                        if (is_object($entity) && $entity->getId() > 0)
                            $this->getEntityManager()->remove($entity);

                        continue;
                    }
                    */

                    $customer = $this->getEntityRelated('Customer', $pedido['CD_CLIENTE']);
                    if (is_object($customer) === false || $customer->getId() == null)
                        throw new Exception('O cliente Cód.:'.$pedido['CD_CLIENTE'].' não foi encontrado!');

                    try {
                        $formaPagamento = $this->getEntityRelated('PaymentMethod', $pedido['CD_CARTEIRA']);

                        $this->codeUsed['PaymentMethod'][] = trim($pedido['CD_CARTEIRA']);

                        $formaPagamento->setCode(trim($pedido['CD_CARTEIRA']));
                        $formaPagamento->setDescription($pedido['DS_CARTEIRA']);
                        $formaPagamento->setActive(true);
                        $formaPagamento->setSync(true);
                        $formaPagamento->setSyncDatetime(new DateTimeBr());
                        $this->getEntityManager()->persist($formaPagamento);
                    } catch (Exception $e) {
                        throw new Exception('A forma de pagamento Cód.:'.$pedido['CD_CARTEIRA'].' não foi encontrada!');
                    }

                    try {
                        $condPagamento = $this->getEntityRelated('PaymentCondition', $pedido['CD_FORMA_PAGAMENTO']);

                        $this->codeUsed['PaymentCondition'][] = trim($pedido['CD_FORMA_PAGAMENTO']);

                        $condPagamento->setCode(trim($pedido['CD_FORMA_PAGAMENTO']));
                        $condPagamento->setDescription($pedido['DS_FORMA_PAGAMENTO']);
                        $condPagamento->setActive(true);
                        $condPagamento->setSync(true);
                        $condPagamento->setSyncDatetime(new DateTimeBr());
                        $this->getEntityManager()->persist($condPagamento);
                    } catch (Exception $e) {
                        throw new Exception('A condição de pagamento Cód.:'.$pedido['CD_FORMA_PAGAMENTO'].' não foi encontrada!');
                    }

                    $pedido['CD_PEDIDO'] = trim($pedido['CD_PEDIDO']);

                    $entity = $this->getEntityRelated('Order', $pedido['CD_PEDIDO']);

                    if (
                        ($entity->getId() > 0 && $entity->getSync() === false)
                        || isset($listPedidosItens[$pedido['CD_PEDIDO']]) === false
                        || count($listPedidosItens[$pedido['CD_PEDIDO']]) == 0
                    )
                        continue;

                    //--------------------//

                    $this->codeUsed['Order'][] = trim($pedido['CD_PEDIDO']);

                    $entity->setCode(trim($pedido['CD_PEDIDO']));
                    $entity->setReference($pedido['NR_ORDEM_COMPRA']);
                    $entity->setCustomer($customer);
                    $entity->setWarehouse($warehouse);
                    //$entity->setUser($user);
                    $entity->setInfo($pedido['DS_OBS']);
                    $entity->setType(Order::ATUALIZACAO);

                    if (isset($pedido['DT_ENTREGA']) && preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", substr(trim($pedido['DT_ENTREGA']),0,10))) {
                        $entity->setOrderDate(\DateTime::createFromFormat('Y-m-d', substr($pedido['DT_ENTREGA'],0,10)));
                    } else {
                        continue;
                    }

                    $entity->setDiscount($pedido['VL_DESCONTO']);
                    $entity->setSubtotal(floatval($pedido['VL_TOTAL']) + floatval($pedido['VL_DESCONTO']));
                    $entity->setTotal($pedido['VL_TOTAL']);
                    //$entity->setLatitude(isset($pedido['latitude']) ? $pedido['latitude'] : '');
                    //$entity->setLongitude(isset($pedido['longitude']) ? $pedido['longitude'] : '');

                    $entity->setStatus(Order::STATUS_TO_UPDATE);

                    // Forma de Pagamento
                    $entity->setPaymentMethod($formaPagamento);

                    // Condicao de Pagamento
                    $entity->setPaymentCondition($condPagamento);

                    $entity->setActive(true);
                    $entity->setSync(true);
                    $entity->setSyncDatetime(new DateTimeBr());
                    $entity->setCommission(0);

                    $this->getEntityManager()->persist($entity);

                    foreach ($listPedidosItens[$pedido['CD_PEDIDO']] as $item) {

                        $key = $pedido['CD_PEDIDO']." - ".trim($item['CD_MATERIAL']);
                        if (isset($checkDuplicate[$key]) === false)
                            $checkDuplicate[$key] = 1;
                        else
                            continue;

                        $product = $this->getEntityRelated('Product', $item['CD_MATERIAL']);
                        if (
                            $product->getId() == null
                            || $product->getId() <= 0
                        )
                            throw new Exception('O produto Cód.:'.$pedido['CD_MATERIAL'].' não foi encontrado!');

                        $orderProduct = $this->getEntityRelated('OrderProduct', $key);

                        $this->codeUsed['OrderProduct'][] = trim($key);

                        $orderProduct->setCode(trim($key));
                        $orderProduct->setOrder($entity);
                        $orderProduct->setWarehouse($warehouse);
                        $orderProduct->setProduct($product);
                        $orderProduct->setPrice($item['VL_UNITARIO']);
                        $orderProduct->setAmount($item['NR_QUANTIDADE']);
                        $orderProduct->setSubtotal(floatval($item['VL_TOTAL']) + floatval($item['VL_DESCONTO']));
                        $orderProduct->setDiscount($item['VL_DESCONTO']);
                        $orderProduct->setTotal($item['VL_TOTAL']);
                        $orderProduct->setObs($item['DS_OBS']);
                        $orderProduct->setActive(true);
                        $orderProduct->setSync(true);
                        $orderProduct->setSyncDatetime(new DateTimeBr());

                        $this->getEntityManager()->persist($orderProduct);
                    }

                    //--------------------//

                }

                $this->getEntityManager()->flush();

                return true;

            }  catch(Exception $e)  {
                return $e->getMessage();
            }
        }

    //--------------------------------------------//

    private function connect()
    {
        try {

            if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
                //$this->dbcon = new \PDO("sqlsrv:Server=".$this->connection['host'].",".$this->connection['port'].";Database=".$this->connection['database'], $this->connection['user'], $this->connection['password']);
                $this->dbcon = new \PDO("sqlsrv:Server=".$this->connection['host'].";Database=".$this->connection['database'], $this->connection['user'], $this->connection['password']);
            } else {
                putenv('ODBCSYSINI=/etc');
                putenv('ODBCINI=/etc/odbc.ini');
                $this->dbcon = new \PDO("dblib:host=".$this->connection['host'].":".$this->connection['port'].";dbname=".$this->connection['database'], $this->connection['user'], $this->connection['password']);
            }

            $this->dbcon->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        }  catch(Exception $e)  {
            return $this->createErrorResponse("Ocorreu um erro: " . $e->getMessage());
        }
    }

    private function queryTransaction($sqlQueries = array())
    {
        try {
            if (is_array($sqlQueries) === false && empty($sqlQueries) === false)
                $sqlQueries = array($sqlQueries);

            if (is_array($sqlQueries) === false || count($sqlQueries) === 0)
                return false;

            $this->dbcon->beginTransaction();

            foreach ($sqlQueries as $sqlQuery) {
                $ret = $this->dbcon->exec($sqlQuery);
            }

            $this->dbcon->commit();

            return true;

        } catch(Exception $e) {
            $this->dbcon->rollback();
            return $this->createErrorResponse("Ocorreu um erro: " . $e->getMessage());
        }
    }

    private function query($sql, $execList = array(), $hasImage = false)
    {
        try {
            $stmt = $this->dbcon->prepare($sql);
            $stmt->execute($execList); //IM_FOTO
            /*
            $image = null;
            $stmt->bindColumn(2, $image, \PDO::PARAM_LOB, 0, \PDO::SQLSRV_ENCODING_BINARY);
            var_dump($image);
            //$return = $stmt->fetch(PDO::FETCH_BOUND);
            $return = array();
            $stmt->execute();
            while ($row = $stmt->fetch(\PDO::FETCH_ASSOC)) {
                var_dump($image);
                $return[] = $row;
            }
            */
            $return = $stmt->fetchAll(\PDO::FETCH_SERIALIZE);
            return $return;
        } catch(Exception $e) {
            return $this->createErrorResponse("Ocorreu um erro: " . $e->getMessage());
        }
    }

    private function getEntityRelated($entityName, $syncCode, $compareIdColumn = false)
    {
        $entity = "Model\Entity\\".$entityName;
        if (isset($this->entities[$entityName]) === false) {
            $this->entities[$entityName] = $this->getEntityManager()
                ->createQueryBuilder($entity)
                ->select('obj')
                ->from($entity,'obj')
                ->getQuery()->getResult();
        }

        if (count($this->entities[$entityName]) > 0) {
            foreach ($this->entities[$entityName] as $item) {
                if (
                    ($compareIdColumn === true && $item->getId() == trim($syncCode))
                    ||
                    (method_exists($item, 'getCode') && trim($item->getCode()) == trim($syncCode))
                )
                    return $item;
            }
        }

        $newEntity = new $entity();
        $this->entities[$entityName][] = $newEntity;

        return $newEntity;
    }

    private function getLowercase($list)
    {
        $response = array();
        if (is_array($list) && count($list) > 0) {
            foreach ($list as $key => $val) {
                $response[trim(strtolower($key))] = $val;
            }
        }
        return $response;
    }
}
