<?php

namespace API\Controller\Custom\Atual;

use Zend\View\Model\ViewModel;
use API\Controller\AbstractApiActionController;
use Commons\Util\DateTimeBr;
  
class ReportController extends AbstractApiActionController
{

    const URL_API_CLIENT_DEBT = "/consulta/RREC020?filtro=cod_cliente={cod_cliente} and data_emissao >= '{data_emissao_ini}' and data_emissao <= '{data_emissao_end}' and cod_vendedor = {cod_vendedor}";
    const URL_API_CLIENT_OUTPUTS = "/consulta/RMOV038?filtro=cod_cli_for = {cod_cli_for} and cod_vendedor = {cod_vendedor}";
    const URL_API_USER_CREDIT_DEBT = "/consulta/RMOV116?filtro=cod_cadastro = {cod_cadastro}";
    const URL_API_USER_CHANGES = "/consulta/RMOV548?filtro=cod_cadastro = {cod_cadastro}";
    const URL_API_USER_LAST_ORDERS = "/consulta/RMOV558?filtro=cod_vendedor = {cod_vendedor} and dias_sem_compra >= {dias_sem_compra}&ordem=dias_sem_compra";
    const URL_API_CLIENT_DEBT00 = "/consulta/RREC000?filtro=cod_cliente={cod_cliente} and data_emissao >= '{data_emissao_ini}' and data_emissao <= '{data_emissao_end}' and cod_vendedor = {cod_vendedor}";  
    const URL_API_CLIENT_DESC_PROD =  "/consulta/RMOV520?filtro=cod_cli_for = {cod_cli_for} and cod_vendedor = {cod_vendedor}";
    const URL_API_CLIENT_CRM =  "/consulta/RMOV550?filtro=cod_cli_for = {cod_cli_for} and cod_vendedor = {cod_vendedor}";
    const URL_API_CLIENT_RMOV554 = "/consulta/RMOV554?filtro=cod_vendedor = {cod_vendedor}";
    const URL_API_CLIENT_RMOV107 = "/consulta/RMOV107?filtro=cod_cli_for = {cod_cli_for} and data_emissao >= '{data_emissao_ini}' and data_emissao <= '{data_emissao_end}' and cod_vendedor = {cod_vendedor}";

    const URL_API_CLIENT_CLI1 = "/consulta/RRECCLI1?filtro=cpf_cnpj='{cpf_cnpj}'";


    public function indexAction()
    {
        return new ViewModel();
    }

    public function clientDebtAction()
    {
        $this->layout('layout/print');

        $report = 'ClientDebt';

        $customerId = $this->params()->fromQuery('customer');
        $dateIni = $this->params()->fromQuery('date_ini');
        $dateEnd = $this->params()->fromQuery('date_end');

        $user = $this->getUser();

        if (
            empty($customerId) || (int)$customerId <= 0 ||
            empty($dateIni) ||
            is_object($user) === false
        )
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'info' => false, 'msg' => '', 'customer' => null, 'list' => array());

        $data['customer'] = $this->getEntityManager()->getRepository('Model\Entity\Customer')->find($customerId);

        if (is_object($data['customer']) === false)
            return new ViewModel(array('error' => true, 'msg' => 'O cadastro do cliente não foi encontrado!'));

        //--------- GET DATA FROM WS ----------//

            try {

                $this->setLog('report'.$report, 'start');

                /*
                $url = str_replace(array('{cod_cliente}', '{data_emissao_ini}', '{data_emissao_end}', '{cod_vendedor}'),
                                   array($data['customer']->getCode(), $this->getDateDb($dateIni), $this->getDateDb($dateEnd), $user->getCode()),
                                   self::URL_API_CLIENT_DEBT);
                                   */

                $url = str_replace(array('{cod_cliente}', '{data_emissao_ini}', '{data_emissao_end}', '{cod_vendedor}'),
                   array($data['customer']->getCode(), $this->getDateDb($dateIni), $this->getDateDb($dateEnd), $user->getCode()),
                   self::URL_API_CLIENT_DEBT);


                //$apiReturn = $this->get($url);
                $apiReturn = $this->get($url);

                if (is_array($apiReturn) === false)
                    throw new \Exception('Nao foi possivel sincronizar os registros com o webservice. Verifique a URL: '.$this->getUrl().$url);

                if (count($apiReturn) == 0)
                    return new ViewModel(array('info' => true, 'msg' => 'Nenhum registro foi encontrado.'));

                $this->setLog('report'.$report, 'data');

                /*-----*/

                    $data['list'] = $apiReturn;

                /*-----*/

                $this->setLog('report'.$report, 'end');


            } catch(\Exception $ex) {
                $this->setLog('report'.$report, $ex->getMessage());
                return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));
            }

        //--------- GET DATA FROM WS ----------//

        return new ViewModel($data);
    }

    
	//TODO Report search Customer Sige ERP
	public function clientCli1Action()
    {
        $this->layout('layout/print');

        $report = 'ClientCli1';

        $cpf_cnpj = $this->params()->fromQuery('cpf_cnpj');

        $user = $this->getUser();

        if (
            empty($cpf_cnpj) || (int)$cpf_cnpj <= 0
        )
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'info' => false, 'msg' => '', 'cpf_cnpj' => null, 'list' => array());

        //$data['customer'] = $this->getEntityManager()->getRepository('Model\Entity\Customer')->find($customerId);

		$code = trim($cpf_cnpj);
		$queryPaymentCondition = $this->getEntityManager()->createQueryBuilder('Model\Entity\Customer');
		$queryPaymentCondition->select('obj')
			->from('Model\Entity\Customer','obj')
			->andWhere('obj.documentNumber = :cpf') 
			->setParameter('cpf', $code);  

		$data['customer'] = $queryPaymentCondition->getQuery()->setMaxResults(1)->getResult(); //->setMaxResults(1) 
		
		foreach ($data['customer'] as $itemLocal) {  
			$result = $itemLocal; 
			//printf($count++.' -Teste imprimindo getCode()....... ' .$itemLocal->getId());  
			//echo('<br/>');
		}				

		//var_dump($result);

        if (is_object($result) === false) 
            return new ViewModel(array('error' => true, 'msg' => 'O cadastro do cliente não foi encontrado! ' .$cpf_cnpj. ' / Result::: ' .$result));

        //--------- GET DATA FROM WS ----------//

            try {

                $this->setLog('report'.$report, 'start');

                /*
                $url = str_replace(array('{cod_cliente}', '{data_emissao_ini}', '{data_emissao_end}', '{cod_vendedor}'),
                                   array($data['customer']->getCode(), $this->getDateDb($dateIni), $this->getDateDb($dateEnd), $user->getCode()),
                                   self::URL_API_CLIENT_DEBT);
                                   */

                $url = str_replace(array('{cpf_cnpj}'),
                   array($result->getDocumentNumber()),
                   self::URL_API_CLIENT_CLI1);

				//print_r($url);

                //$apiReturn = $this->get($url);
                $apiReturn = $this->get($url);
				//var_dump($apiReturn); 

                if (is_array($apiReturn) === false)
                    throw new \Exception('Nao foi possivel sincronizar os registros com o webservice. Verifique a URL: '.$this->getUrl().$url);

                if (count($apiReturn) == 0)
                    return new ViewModel(array('info' => true, 'msg' => 'Nenhum registro foi encontrado.'));

                $this->setLog('report'.$report, 'result');

                /*-----*/

                    $data['list'] = $apiReturn; 

                /*-----*/

                $this->setLog('report'.$report, 'end');


            } catch(\Exception $ex) {
                $this->setLog('report'.$report, $ex->getMessage());
                return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));
            }
			//var_dump($result); 
        //--------- GET DATA FROM WS ----------//

        return new ViewModel($data);
    }
	
	//FIM Report search Customer Sige ERP	
	
	public function clientOutputsAction()
    {
        $this->layout('layout/print');

        $report = 'ClientOutputs';

        $customerId = $this->params()->fromQuery('customer');

        $user = $this->getUser();

        if (
            empty($customerId) || (int)$customerId <= 0 ||
            is_object($user) === false
        )
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'info' => false, 'msg' => '', 'customer' => null, 'list' => array());

        $data['customer'] = $this->getEntityManager()->getRepository('Model\Entity\Customer')->find($customerId);

        if (is_object($data['customer']) === false)
            return new ViewModel(array('error' => true, 'msg' => 'O cadastro do cliente não foi encontrado!'));

        //--------- GET DATA FROM WS ----------//

        try {

            $this->setLog('report'.$report, 'start');

            $url = str_replace(array('{cod_cli_for}', '{cod_vendedor}'),
                array($data['customer']->getCode(), $user->getCode()),
                self::URL_API_CLIENT_OUTPUTS);

            $apiReturn = $this->get($url);

            if (is_array($apiReturn) === false)
                throw new \Exception('Nao foi possivel sincronizar os registros com o webservice. Verifique a URL: '.$this->getUrl().$url);

            if (count($apiReturn) == 0)
                return new ViewModel(array('info' => true, 'msg' => 'Nenhum registro foi encontrado.'));

            $this->setLog('report'.$report, 'data');

            /*-----*/

            $data['list'] = $apiReturn;

            /*-----*/

            $this->setLog('report'.$report, 'end');


        } catch(\Exception $ex) {
            $this->setLog('report'.$report, $ex->getMessage());
            return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));
        }

        //--------- GET DATA FROM WS ----------//

        return new ViewModel($data);
    }

    public function userCreditDebitAction()
    {
        $this->layout('layout/print');

        $report = 'UserCreditDebit';

        $user = $this->getUser();

        if (
            is_object($user) === false
        )
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'info' => false, 'msg' => '', 'customer' => null, 'list' => array());

        //--------- GET DATA FROM WS ----------//

        try {

            $this->setLog('report'.$report, 'start');

            $url = str_replace(array('{cod_cadastro}'),
                array($user->getCode()),
                self::URL_API_USER_CREDIT_DEBT);

            $apiReturn = $this->get($url);

            if (is_array($apiReturn) === false)
                throw new \Exception('Nao foi possivel sincronizar os registros com o webservice. Verifique a URL: '.$this->getUrl().$url);

            if (count($apiReturn) == 0)
                return new ViewModel(array('info' => true, 'msg' => 'Nenhum registro foi encontrado.'));

            $this->setLog('report'.$report, 'data');

            /*-----*/

            $data['list'] = $apiReturn;

            /*-----*/

            $this->setLog('report'.$report, 'end');


        } catch(\Exception $ex) {
            $this->setLog('report'.$report, $ex->getMessage());
            return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));
        }

        //--------- GET DATA FROM WS ----------//

        return new ViewModel($data);
    }

    public function userChangesAction()
    {
        $this->layout('layout/print');

        $report = 'UserChanges';

        $user = $this->getUser();

        if (
            is_object($user) === false
        )
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'info' => false, 'msg' => '', 'customer' => null, 'list' => array());

        //--------- GET DATA FROM WS ----------//

        try {

            $this->setLog('report'.$report, 'start');

            $url = str_replace(array('{cod_cadastro}'),
                array($user->getCode()),
                self::URL_API_USER_CHANGES);

            $apiReturn = $this->get($url);

            if (is_array($apiReturn) === false)
                throw new \Exception('Nao foi possivel sincronizar os registros com o webservice. Verifique a URL: '.$this->getUrl().$url);

            if (count($apiReturn) == 0)
                return new ViewModel(array('info' => true, 'msg' => 'Nenhum registro foi encontrado.'));

            $this->setLog('report'.$report, 'data');

            /*-----*/

            $data['list'] = $apiReturn;

            /*-----*/

            $this->setLog('report'.$report, 'end');


        } catch(\Exception $ex) {
            $this->setLog('report'.$report, $ex->getMessage());
            return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));
        }

        //--------- GET DATA FROM WS ----------//

        return new ViewModel($data);
    }

    public function clientLastOrdersAction()
    {
        $this->layout('layout/print');

        $report = 'ClientLastOrders';

        $daysBefore = $this->params()->fromQuery('days_before');

        $user = $this->getUser();

        if (
            empty($daysBefore) || (int)$daysBefore <= 0 ||
            is_object($user) === false
        )
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'info' => false, 'msg' => '', 'customer' => null, 'list' => array());

        //--------- GET DATA FROM WS ----------//

        try {

            $this->setLog('report'.$report, 'start');

            $url = str_replace(array('{dias_sem_compra}', '{cod_vendedor}'),
                array($daysBefore, $user->getCode()),
                self::URL_API_USER_LAST_ORDERS);

            $apiReturn = $this->get($url);

            if (is_array($apiReturn) === false)
                throw new \Exception('Nao foi possivel sincronizar os registros com o webservice. Verifique a URL: '.$this->getUrl().$url);

            if (count($apiReturn) == 0)
                return new ViewModel(array('info' => true, 'msg' => 'Nenhum registro foi encontrado.'));

            $this->setLog('report'.$report, 'data');

            /*-----*/

            $data['list'] = $apiReturn;

            /*-----*/

            $this->setLog('report'.$report, 'end');


        } catch(\Exception $ex) {
            $this->setLog('report'.$report, $ex->getMessage());
            return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));
        }

        //--------- GET DATA FROM WS ----------//

        return new ViewModel($data);
    }

    public function clientDebt00Action()
    {
        $this->layout('layout/print');

        $report = 'ClientDebt00';

        $customerId = $this->params()->fromQuery('customer');
        $dateIni = $this->params()->fromQuery('date_ini');
        $dateEnd = $this->params()->fromQuery('date_end');

        $user = $this->getUser();

        if (
            empty($customerId) || (int)$customerId <= 0 ||
            empty($dateIni) ||
            is_object($user) === false
        )
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'info' => false, 'msg' => '', 'customer' => null, 'list' => array());

        $data['customer'] = $this->getEntityManager()->getRepository('Model\Entity\Customer')->find($customerId);

        if (is_object($data['customer']) === false)
            return new ViewModel(array('error' => true, 'msg' => 'O cadastro do cliente não foi encontrado!'));

        //--------- GET DATA FROM WS ----------//

            try {

                $this->setLog('report'.$report, 'start');

                /*
                $url = str_replace(array('{cod_cliente}', '{data_emissao_ini}', '{data_emissao_end}', '{cod_vendedor}'),
                                   array($data['customer']->getCode(), $this->getDateDb($dateIni), $this->getDateDb($dateEnd), $user->getCode()),
                                   self::URL_API_CLIENT_DEBT);
                                   */

                $url = str_replace(array('{cod_cliente}', '{data_emissao_ini}', '{data_emissao_end}', '{cod_vendedor}'),
                   array($data['customer']->getCode(), $this->getDateDb($dateIni), $this->getDateDb($dateEnd), $user->getCode()),
                   self::URL_API_CLIENT_DEBT00);


                //$apiReturn = $this->get($url);
                $apiReturn = $this->get($url);

                if (is_array($apiReturn) === false)
                    throw new \Exception('Nao foi possivel sincronizar os registros com o webservice. Verifique a URL: '.$this->getUrl().$url);

                if (count($apiReturn) == 0)
                    return new ViewModel(array('info' => true, 'msg' => 'Nenhum registro foi encontrado.'));

                $this->setLog('report'.$report, 'data');

                /*-----*/

                    $data['list'] = $apiReturn;

                /*-----*/

                $this->setLog('report'.$report, 'end');


            } catch(\Exception $ex) {
                $this->setLog('report'.$report, $ex->getMessage());
                return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));
            }

        //--------- GET DATA FROM WS ----------//

        return new ViewModel($data);
    }  


    //URL_API_CLIENT_DESC_PROD
    public function clientDescrmov520Action()
    {
        $this->layout('layout/print');

        $report = 'ClientDescrmov520';

        $customerId = $this->params()->fromQuery('customer');

        $user = $this->getUser();

        if (
            empty($customerId) || (int)$customerId <= 0 ||
            is_object($user) === false
        )
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'info' => false, 'msg' => '', 'customer' => null, 'list' => array());

        $data['customer'] = $this->getEntityManager()->getRepository('Model\Entity\Customer')->find($customerId);

        if (is_object($data['customer']) === false)
            return new ViewModel(array('error' => true, 'msg' => 'O cadastro do cliente não foi encontrado!'));

        //--------- GET DATA FROM WS ----------//

        try {

            $this->setLog('report'.$report, 'start');

            $url = str_replace(array('{cod_cli_for}', '{cod_vendedor}'),
                array($data['customer']->getCode(), $user->getCode()),
                self::URL_API_CLIENT_DESC_PROD);

            $apiReturn = $this->get($url);

            if (is_array($apiReturn) === false)
                throw new \Exception('Nao foi possivel sincronizar os registros com o webservice. Verifique a URL: '.$this->getUrl().$url);

            if (count($apiReturn) == 0)
                return new ViewModel(array('info' => true, 'msg' => 'Nenhum registro foi encontrado.'));

            $this->setLog('report'.$report, 'data');

            /*-----*/

            $data['list'] = $apiReturn;

            /*-----*/

            $this->setLog('report'.$report, 'end');


        } catch(\Exception $ex) {
            $this->setLog('report'.$report, $ex->getMessage());
            return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));
        }

        //--------- GET DATA FROM WS ----------//

        return new ViewModel($data);
    } 


    //URL_API_CLIENT_CRM      
    public function clientDescrmov550Action()
    {
        $this->layout('layout/print');

        $report = 'ClientDescrmov550';

        $customerId = $this->params()->fromQuery('customer');

        $user = $this->getUser();

        if (
            empty($customerId) || (int)$customerId <= 0 ||
            is_object($user) === false
        )
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'info' => false, 'msg' => '', 'customer' => null, 'list' => array());

        $data['customer'] = $this->getEntityManager()->getRepository('Model\Entity\Customer')->find($customerId);

        if (is_object($data['customer']) === false)
            return new ViewModel(array('error' => true, 'msg' => 'O cadastro do cliente não foi encontrado!'));

        //--------- GET DATA FROM WS ----------//

        try {

            $this->setLog('report'.$report, 'start');

            $url = str_replace(array('{cod_cli_for}', '{cod_vendedor}'),
                array($data['customer']->getCode(), $user->getCode()),
                self::URL_API_CLIENT_CRM);

            $apiReturn = $this->get($url);

            if (is_array($apiReturn) === false)
                throw new \Exception('Nao foi possivel sincronizar os registros com o webservice. Verifique a URL: '.$this->getUrl().$url);

            if (count($apiReturn) == 0)
                return new ViewModel(array('info' => true, 'msg' => 'Nenhum registro foi encontrado.'));

            $this->setLog('report'.$report, 'data');

            /*-----*/

            $data['list'] = $apiReturn;

            /*-----*/

            $this->setLog('report'.$report, 'end');


        } catch(\Exception $ex) {
            $this->setLog('report'.$report, $ex->getMessage());
            return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));
        }

        //--------- GET DATA FROM WS ----------//

        return new ViewModel($data);
    } 

    //URL_API_CLIENT_RMOV554
    public function clientRmov554Action()
    {
        $this->layout('layout/print');

        $report = 'ClientRmov554';

        //$customerId = $this->params()->fromQuery('customer');
        //$dateIni = $this->params()->fromQuery('date_ini');
        //$dateEnd = $this->params()->fromQuery('date_end');

        $user = $this->getUser();

        if (is_object($user) === false)
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'info' => false, 'msg' => '', 'customer' => null, 'list' => array());

        //$data['customer'] = $this->getEntityManager()->getRepository('Model\Entity\Customer')->find($customerId);

        // Passando os parametros para o report
        //$data['dataI']  = $dateIni;
        //$data['dataF']  = $dateEnd;
        $data['usr']    = $user->getCode(). ' - ' .$user->getName();

        //if (is_object($data['customer']) === false)
            //return new ViewModel(array('error' => true, 'msg' => 'O cadastro do cliente não foi encontrado!'));

        //--------- GET DATA FROM WS ----------//

            try {

                $this->setLog('report'.$report, 'start');

                /*
                $url = str_replace(array('{cod_cliente}', '{data_emissao_ini}', '{data_emissao_end}', '{cod_vendedor}'),
                                   array($data['customer']->getCode(), $this->getDateDb($dateIni), $this->getDateDb($dateEnd), $user->getCode()),
                                   self::URL_API_CLIENT_DEBT);
                                   */

                $url = str_replace(array('{cod_vendedor}'),
                   array($user->getCode()),
                   self::URL_API_CLIENT_RMOV554);


                //$apiReturn = $this->get($url);
                $apiReturn = $this->get($url);

                if (is_array($apiReturn) === false)
                    throw new \Exception('Nao foi possivel sincronizar os registros com o webservice. Verifique a URL: '.$this->getUrl().$url);

                if (count($apiReturn) == 0)
                    return new ViewModel(array('info' => true, 'msg' => 'Nenhum registro foi encontrado.'));

                $this->setLog('report'.$report, 'data');

                /*-----*/
                    $data['list'] = $apiReturn;
                /*-----*/

                $this->setLog('report'.$report, 'end');


            } catch(\Exception $ex) {
                $this->setLog('report'.$report, $ex->getMessage());
                return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));
            }

        //--------- GET DATA FROM WS ----------//

        return new ViewModel($data);
    }  

    //URL_API_CLIENT_RMOV107
    public function clientRmov107Action()
    {
        $this->layout('layout/print');

        $report = 'ClientRmov107';

        //$customerId = $this->params()->fromQuery('customer');
        $dateIni = $this->params()->fromQuery('date_ini');
        $dateEnd = $this->params()->fromQuery('date_end');

        $user = $this->getUser();

        if (
            empty($dateIni) ||
            is_object($user) === false
        )
            return new ViewModel(array('error' => true, 'msg' => 'Um ou mais parâmetros são inválidos. Tente novamente ou entre em contato com o suporte técnico.'));

        $data = array('error' => false, 'info' => false, 'msg' => '', 'list' => array());

        //$data['customer'] = $this->getEntityManager()->getRepository('Model\Entity\Customer')->find($customerId);
        $data['usr']    = $user->getCode(). ' - ' .$user->getName();
        

        //if (is_object($data['customer']) === false)
            //return new ViewModel(array('error' => true, 'msg' => 'O cadastro do cliente não foi encontrado!'));

        //--------- GET DATA FROM WS ----------//

            try {

                $this->setLog('report'.$report, 'start');

                /*
                $url = str_replace(array('{cod_cliente}', '{data_emissao_ini}', '{data_emissao_end}', '{cod_vendedor}'),
                                    array($data['customer']->getCode(), $this->getDateDb($dateIni), $this->getDateDb($dateEnd), $user->getCode()),
                                    self::URL_API_CLIENT_RMOV107);   
                                    */

                $url = str_replace(array('{data_emissao_ini}', '{data_emissao_end}', '{cod_vendedor}'),
                array($this->getDateDb($dateIni), $this->getDateDb($dateEnd), $user->getCode()),
                self::URL_API_CLIENT_RMOV107);   


                $apiReturn = $this->get($url);

                if (is_array($apiReturn) === false)
                    throw new \Exception('Nao foi possivel sincronizar os registros com o webservice. Verifique a URL: '.$this->getUrl().$url);

                if (count($apiReturn) == 0)
                    return new ViewModel(array('info' => true, 'msg' => 'Nenhum registro foi encontrado.'));

                $this->setLog('report'.$report, 'data');





                // Dados de autenticação
                $username = 'CONEX';
                $password = 'C0N3X';

                // Parâmetros da consulta
                //$customerId = $data['customer']->getCode();
                $dateIni = $this->getDateDb($dateIni);
                $dateEnd = $this->getDateDb($dateEnd) ;
                $vendorId = $user->getCode();
 
                // URL da consulta
                $url = 'http://179.109.200.203:9000/consulta/RMOV107';
                //'filtro' => "cod_cliente=$customerId and data_emissao >= '$dateIni' and data_emissao <= '$dateEnd' and cod_vendedor = $vendorId"
                $queryParams = http_build_query([
                    'filtro' => "data_emissao >= '$dateIni' and data_emissao <= '$dateEnd' and cod_vendedor = $vendorId"
                ]);
                $url = "$url?$queryParams";

                // Configuração da requisição cURL
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_USERPWD, "$username:$password");
                curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);

                // Executa a requisição
                $response = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

                // Verifica se houve erro na requisição
                if ($response === false) {
                    $error = curl_error($ch);
                    // Trate o erro aqui
                    echo "Erro na requisição cURL: $error";
                } else {
                    // Verifica o código de resposta
                    if ($httpCode >= 200 && $httpCode < 300) {
                        // Sucesso! Você tem a resposta da API em $response
                        $data['list'] = json_decode($response, true); // Decodifica a resposta JSON para um array associativo
                        // Faça o que for necessário com $data['list']
                        //var_dump($data['list']); // Exemplo: Mostra os dados recebidos
                        //echo "Resposta da API: $response";
                    } else {
                        // Trate os códigos de erro
                        echo "Erro na resposta da API. Código HTTP: $httpCode, Resposta: $response";
                    }
                }

                // Fecha a conexão cURL
                curl_close($ch);
                /*-----*/

                    //$data['list'] = $apiReturn;

                /*-----*/

                $this->setLog('report'.$report, 'end');


            } catch(\Exception $ex) {
                $this->setLog('report'.$report, $ex->getMessage());
                return new ViewModel(array('error' => true, 'msg' => $ex->getMessage()));
            }

        //--------- GET DATA FROM WS ----------//

        return new ViewModel($data);
    }      
}
