<?php

namespace API\Controller\Custom\Atual;

use API\Controller\AbstractApiActionController;

class DataController extends AbstractApiActionController {

    protected $config;

    private function setConfig() {

        $this->config = $this->getEntityManager()->getRepository('Model\Entity\Config')->findOneBy(array());
        return $this->config;
    }

    private function getProduct($onlyIds = false) {

        try {

            $this->setConfig();
            $user = $this->getUser();
            if (is_object($user) === false)
                throw new \Exception("Usuário não encontrado!");

            $productPromotionList = array();
            $userPriceList = $this->getEntityManager()->getRepository('Model\Entity\UserPriceList')->findOneBy(array('user' => $user->getId(), 'orderType' => 7, 'active' => 1));
            if (is_object($userPriceList) && is_object($userPriceList->getPriceList())) {
                $list = $userPriceList->getPriceList()->getPriceListProducts();
                if (count($list) > 0) {
                    foreach ($list as $item) {
                        if (is_object($item->getProduct()))
                            $productPromotionList[$item->getProduct()->getId()] = array(
                                'price' => $item->getPrice(),
                                'priceMin' => $item->getPriceMinimum(),
                            );
                    }
                }
            }

            $productIdList = array();
            if ($this->config->getEnablePriceListFunctionality()) {
                $qb = $this->getEntityManager()->createQueryBuilder("Model\\Entity\\UserPriceList")
                    ->select('obj')
                    ->from("Model\\Entity\\UserPriceList", "obj")
                    ->innerJoin("obj.user", "usr")
                    ->andWhere('obj.active = 1')
                    ->andWhere("usr.id = :usr")
                    ->setParameter('usr', $user->getId());

                $data = $qb->getQuery()->getResult();
                foreach($data as $upl){

                    if (is_object($upl->getPriceList()) === false)
                        continue;

                    $priceListProducts = $upl->getPriceList()->getPriceListProducts();
                    if (count($priceListProducts) > 0) {
                        foreach ($priceListProducts as $priceListProduct) {
                            if (is_object($priceListProduct->getProduct()))
                                $productIdList[$priceListProduct->getProduct()->getId()] = $priceListProduct->getProduct()->getId();
                        }
                    }
                }
            }

            $qb = $this->getEntityManager()->createQueryBuilder("Model\\Entity\\Product")
                ->select('obj')
                ->from("Model\\Entity\\Product", "obj")
                ->andWhere("obj.active = :active")
                ->setParameter('active', true);

            $representedCompanies = array();
            foreach($this->getUser()->getRepresentedCompanies() as $rep){
                $representedCompanies[] = $rep->getRepresentedCompany()->getId();
            }

            if (count($productIdList) > 0)
                $qb->andWhere('obj.id IN ('.implode(',', $productIdList).')');

            $data = $qb->getQuery()->getResult();

            $retorno = array();

            $count = 0;
            foreach($data as $ent){
                $product = $ent->getArrayCopy();
                $product['reference'] = isset($product['reference']) && !empty($product['reference']) && $product['reference'] != "0" ? $product['reference'] : (isset($product['code']) && !empty($product['code']) ? $product['code'] : '');

                if (isset($productPromotionList[$product['id']])) {
                    $product['pricePromotional'] = $productPromotionList[$product['id']]['price'] > 0 ? floatval($productPromotionList[$product['id']]['price']) : 0.0;
                    $product['pricePromotionalMin'] = $productPromotionList[$product['id']]['priceMin'] > 0 ? floatval($productPromotionList[$product['id']]['priceMin']) : 0.0;
                }

                if (count($representedCompanies) > 0) {
                    if (
                        isset($product['representedCompanies']) && is_array($product['representedCompanies']) &&
                        count(array_intersect($representedCompanies, $product['representedCompanies'])) > 0
                    )
                        $retorno[] = $onlyIds === true ? $product['id'] : $product;
                } else {
                    $retorno[] = $onlyIds === true ? $product['id'] : $product;
                }

                $count++;
                if ($count == 100 && (int)date('Ymd') <= 20160330) {
                    break;
                }
            }

            if ($onlyIds === true)
                return $retorno;

            $listToUse = array('id','name','barcode','reference','active','groupPrimary','groupSecondary','groupTertiary','image','unit','amountMinimal','price','priceMin','pricePromotional','pricePromotionalMin','representedCompanies','colors','sizes','useValueWeight');
            foreach ($retorno as $r => $item) {
                $retorno[$r]['name'] = preg_replace("/[^a-zA-Z0-9 \/\-]+/", "", $retorno[$r]['name']);
                foreach ($item as $key => $val) {
                    if (in_array($key, $listToUse) === false)
                        unset($retorno[$r][$key]);
                }
            }

            return $retorno;

        }catch(\Exception $ex){
            throw new \Exception($ex->getMessage());
        }
    }

    public function productAction(){

        try {

            $retorno = $this->getProduct(false);

            return $this->createResponse($retorno);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

    //Not Used
    public function groupAction(){

        try{

            $productIds = $this->getProduct(true);
            if (is_array($productIds) === false || count($productIds) === 0)
                return $this->createResponse(array());

            $data = array();

            $products = $this->getEntityManager()->createQueryBuilder('Model\Entity\Product')
                ->select(array('obj'))
                ->from('Model\Entity\Product','obj')
                ->orderBy('obj.description', 'ASC')
                ->getQuery()->getResult();

            foreach ($products as $product) {
                //$data[][] =
            }

            return $this->createResponse($data);

        }catch(\Exception $ex){
            return $this->createErrorResponse("Ocorreu um erro desconhecido: " . $ex->getMessage());
        }

        return $this->createNotFoundResponse();

    }

}
