<?php

namespace Rest\Service;

use JMS\Serializer\Handler\SubscribingHandlerInterface;
use JMS\Serializer\GraphNavigator;
use JMS\Serializer\JsonSerializationVisitor;
use JMS\Serializer\Context;
use Zend\ServiceManager\ServiceLocatorAwareInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class DateTimeLocaleHandler implements SubscribingHandlerInterface, ServiceLocatorAwareInterface {

    protected $services;

    public function __construct($sm){
        $this->services = $sm;
    }

    public function setServiceLocator(ServiceLocatorInterface $serviceLocator)
    {
        $this->services = $serviceLocator;
    }

    public function getServiceLocator()
    {
        return $this->services;
    }

    public static function getSubscribingMethods()
    {
        return array(
            array(
                'direction' => GraphNavigator::DIRECTION_SERIALIZATION,
                'format' => 'json',
                'type' => 'DateTime',
                'method' => 'serializeDateTimeToJson',
            ),
        );
    }

    public function serializeDateTimeToJson(JsonSerializationVisitor $visitor, \DateTime $date, array $type, Context $context)
    {
        /* Accessing entity manager
        $ent = $this->getServiceLocator()->get('Doctrine\ORM\EntityManager')->find('Model\Entity\Unit','PC');
        return $ent->getDescription();
        */


        if(count($type['params']) > 0){ # $type['params'][0] -> format / $type['params'][1] -> timezone
            return $date->format($type['params'][0]);
        }else{
            //return $date->format('d/m/Y H:i');
            return $date->format(\DateTime::ISO8601);
        }

    }

}