<?php

/**
 * User restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Model\Entity\UserRepresentedCompany;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class UserController extends AbstractApplicationRestfulController {

    /**
     * Get entity list
     * @override
     * @return mixed|JsonModel
     */
    public function getList()
    {
        try{

            $qb = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj');

            $firstResult = $this->params()->fromQuery('offset',false);
            if($firstResult){
                $qb->setFirstResult($firstResult);
            }

            $maxResults = $this->params()->fromQuery('limit',false);
            if($maxResults){
                $qb->setMaxResults($maxResults);
            }

            $query = $this->params()->fromQuery('query',false);
            if($query){
                $qb->andWhere('obj.name LIKE :query');
                $qb->setParameter('query', '%' . $query . '%');
            }

            $search = $this->params()->fromQuery('search',false);
            if($search){
                $qb->andWhere('obj.name LIKE :search OR obj.username LIKE :search');
                $qb->setParameter('search', '%' . $search . '%');
            }

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($qb);
    }

    /**
     * Create entity
     * @param mixed $data
     * @return mixed|JsonModel
     */
    public function create($data)
    {
        try{

            if (!$data){
                throw new ApiBadRequestException('Nenhuma informação enviada');
            }

            $entity = array_key_exists('id', $data) && $data['id'] ? $this->getEntityManager()->find($this->getEntityClass(), $data['id']) : null;
            if(!$entity){
                $entity = new $this->entityClass;
            }

            // Remove dates
            unset($data['created']);
            unset($data['updated']);

            if(array_key_exists("representedCompanies", $data)){
                $representedCompanies = $data['representedCompanies'];
                unset($data['representedCompanies']);
            }

            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($data, $entity);

            $userRepresentedCompanies = $this->getEntityManager()->getRepository("Model\\Entity\\UserRepresentedCompany")->findBy(array('user' => $entity));
            $companiesToRemove = array();
            foreach($userRepresentedCompanies as $uRep){
                $hasRep = false;
                foreach($representedCompanies as $r){
                    if($r['id']){
                        if($uRep->getId() == $r['id']){
                            $uRep->setCommission($r['commission']);
                            $this->getEntityManager()->merge($uRep);
                            $hasRep = true;
                            break;
                        }
                    }
                }
                if(!$hasRep && $r['id']){
                    $this->getEntityManager()->remove($uRep);
                    //$companiesToRemove[] = $uRep;
                }
            }

            //$entity->removeRepresentedCompanies($companiesToRemove);

            foreach($representedCompanies as $rep){
                if(!$rep['id']){
                    $ent = new UserRepresentedCompany();
                    $hyd = new DoctrineHydrator($this->getEntityManager(), "Model\\Entity\\UserRepresentedCompany");
                    $hyd->hydrate($rep, $ent);
                    //$entity->getRepresentedCompanies()->add($ent);
                    $this->getEntityManager()->persist($ent);
                }
            }

            if (method_exists($entity, 'setSync')) //Hiper
                $entity->setSync(false);

            if($entity->getId()){
                $this->getEntityManager()->merge($entity);
            }else{
                $this->getEntityManager()->persist($entity);
            }
            $this->getEntityManager()->flush();

            return $this->createResponse( $entity );

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex) {

            return $this->createGenericApiExceptionResponse($ex);

        }
    }

}