<?php

/**
 * Unit restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class UnitController extends AbstractApplicationRestfulController {

    /**
     * Get entity list
     * @return mixed|JsonModel
     */
    public function getList()
    {
        try{

            $data = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj')
                ->getQuery()->getResult();
                //->getQuery()->getArrayResult();

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($data);
    }

    /**
     * Get entity
     * @param mixed $id
     * @return mixed|JsonModel
     */
    public function get($id)
    {
        try{

            $data = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj')
                ->where('obj.id = :objId')
                ->setParameter("objId",$id)
                ->getQuery()->getOneOrNullResult(Query::HYDRATE_ARRAY);

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($data);
    }

    /**
     * Create and update entity
     * @param mixed $data
     * @return JsonModel
     * @throws \ApiBadRequestException
     */
    public function create($data)
    {
        try{

            if (!$data){
                throw new ApiBadRequestException('Nenhuma informação enviada');
            }

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $data['id']);
            if(!$entity){
                $entity = new $this->entityClass;
            }

            // Remove dates
            unset($data['created']);
            unset($data['updated']);

            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($data, $entity);

            $this->getEntityManager()->persist($entity);
            $this->getEntityManager()->flush();

            return $this->createResponse( $entity->getArrayCopy() );

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex) {

            return $this->createGenericApiExceptionResponse($ex);

        }
    }

    /**
     * Update entity (not used)
     * @param mixed $id
     * @param mixed $data
     * @return JsonModel
     * @throws \ApiBadRequestException
     */
    public function update($id, $data)
    {
        return $this->createMethodNotAllowedResponse();
        /*
        try{

            if (!$data){
                throw new ApiBadRequestException('Nenhuma informação enviada');
            }

            if (!$id){
                throw new ApiBadRequestException('Código inválido');
            }

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                $entity = new $this->entityClass;
            }

            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($data, $entity);

            $this->getEntityManager()->merge($entity);
            $this->getEntityManager()->flush();

            return $this->createResponse(array(
                'success' => true
            ));

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex) {

            return $this->createGenericApiExceptionResponse($ex);

        }
        */

    }

    /**
     * Delete entity
     * @param mixed $id
     * @return mixed|JsonModel
     */
    public function delete($id)
    {

        try{

            if (!$id){
                throw new ApiBadRequestException('Código inválido');
            }

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new ApiNotFoundException('Register not found');
            }

            $this->getEntityManager()->remove($entity);
            $this->getEntityManager()->flush();

            return $this->createResponse(array(
                'success' => true
            ));

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex) {

            return $this->createGenericApiExceptionResponse($ex);

        }

    }

}