<?php

/**
 * Represented Company restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class RepresentedCompanyController extends AbstractApplicationRestfulController {

    /**
     * Get entity list
     * @override
     * @return mixed|JsonModel
     */
    public function getList()
    {
        try{

            $qb = $this->getEntityManager()->createQueryBuilder()
                ->select('obj')
                ->from($this->getEntityClass(),'obj');

            $query = $this->params()->fromQuery('search', false);
            if($query){
                $qb->where('obj.tradeName LIKE :query OR obj.companyName LIKE :query OR obj.city LIKE :query OR obj.documentNumber LIKE :query OR obj.id = :query');
                $qb->setParameter('query', '%' . $query . '%');
            }

            $qb->orderBy('obj.tradeName', 'ASC');

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex){

            return $this->createGenericApiExceptionResponse($ex);

        }

        return $this->createResponse($qb);
    }

}