<?php

/**
 * Catalog restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Model\Entity\CatalogImage;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class CatalogImageController extends AbstractApplicationRestfulController {

    /**
     * Create catalog
     * @override
     * @param mixed $data
     * @return JsonModel
     * @throws \ApiBadRequestException
     */
    public function create($data)
    {
        try{

            if (!$data){
                throw new ApiBadRequestException('Nenhuma informação enviada');
            }

            if(!$data['catalog']){
                throw new ApiBadRequestException('Catalog não informado');
            }

            $catalog = $this->getEntityManager()->find('Model\\Entity\\Catalog',$data['catalog']);

            $entity = array_key_exists('id', $data) && $data['id'] ? $this->getEntityManager()->find($this->getEntityClass(), $data['id']) : null;
            if(!$entity){
                $entity = new $this->entityClass;
            }

            // Remove dates
            unset($data['created']);
            unset($data['updated']);

            // Check for next
            $lastEntity = $this->getEntityManager()->getRepository("Model\\Entity\\CatalogImage")->findOneBy(array("catalog" => $catalog), array('order' => 'desc'));
            if($lastEntity){
                $data['order'] = $lastEntity->getOrder() + 1;
            }else{
                $data['order'] = 1;
            }

            $hydrator = new DoctrineHydrator($this->getEntityManager(), $this->getEntityClass());
            $hydrator->hydrate($data, $entity);

            $this->getEntityManager()->persist($entity);
            $this->getEntityManager()->flush();

            //Save image
            $file = $this->params()->fromFiles('file', false);
            if(!$data['id'] && !$file){
                $this->getEntityManager()->remove($entity);
                $this->getEntityManager()->flush();
                throw new \Exception("Nenhum arquivo enviado");
            }

            list($width, $height) = getimagesize($file['tmp_name']);

            $entity->setSize($file['size']);
            $entity->setType($file['type']);
            $entity->setWidth($width);
            $entity->setHeight($height);
            $entity->setFileResource($file);

            $this->getEntityManager()->flush();

            return $this->createResponse( $entity );

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex) {

            return $this->createGenericApiExceptionResponse($ex);

        }
    }

    /**
     * Delete entity
     * @param mixed $id
     * @return mixed|JsonModel
     */
    public function delete($id)
    {

        try{

            if (!$id){
                throw new ApiBadRequestException('Código inválido');
            }

            $entity = $this->getEntityManager()->find($this->getEntityClass(), $id);
            if(!$entity){
                throw new ApiNotFoundException('Register not found');
            }

            $catalog = $entity->getCatalog();

            $this->getEntityManager()->remove($entity);
            $this->getEntityManager()->flush();

            // Reorder images
            $images = $this->getEntityManager()->getRepository('Model\\Entity\\CatalogImage')->findBy(array('catalog' => $catalog), array('order' => 'ASC'));
            $index = 1;
            if($images){
                foreach($images as $img){
                    $img->setOrder($index);
                    $index++;
                }
            }
            $this->getEntityManager()->flush();

            return $this->createResponse(array(
                'success' => true
            ));

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex) {

            return $this->createGenericApiExceptionResponse($ex);

        }

    }

}