<?php

/**
 * Catalog restful controller
 * @author Renato Peterman <renato.pet@gmail.com>
 */

namespace Rest\Controller;

use API\Exceptions\ApiBadRequestException;
use API\Exceptions\ApiException;
use API\Exceptions\ApiNotFoundException;
use Doctrine\ORM\Query;
use Model\Entity\CatalogImage;
use Zend\View\Model\JsonModel;
use DoctrineModule\Stdlib\Hydrator\DoctrineObject as DoctrineHydrator;

class CatalogController extends AbstractApplicationRestfulController {

    /**
     * Create catalog
     * @override
     * @param mixed $data
     * @return JsonModel
     * @throws \ApiBadRequestException
     */
    public function create($data)
    {
        try{

            if (!$data){
                throw new ApiBadRequestException('Nenhuma informação enviada');
            }

            if(is_array($data) && isset($data['id'])){
                unset($data['created']);
                unset($data['updated']);
                unset($data['file']);
                $entity = $this->getEntityManager()->find('Model\\Entity\\Catalog', $data['id']);
            }else{
                $entity = new \Model\Entity\Catalog();
            }

            $hydrator = new DoctrineHydrator($this->getEntityManager(), "Model\\Entity\\Catalog");
            $hydrator->hydrate($data, $entity);
            $entity->setActive($data['active'] == 'true' ? true : false);
            
            if(is_array($data) === false || isset($data['id']) === false){
                $this->getEntityManager()->persist($entity);
                $this->getEntityManager()->flush();
            }

            if($data['type'] == 'pdf'){

                $file = $this->params()->fromFiles('file', false);
                if($file && $file['error'] == UPLOAD_ERR_OK){

                    $entity->setFileResource($file);
                    /*
                    $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
                    $hash = md5(uniqid(rand(), true));
                    $filename = 'pdf_' . $hash  . '.' . $extension;
                    move_uploaded_file($file['tmp_name'], \Model\Entity\Catalog::getPathForFile($filename, $entity->getId()));
                    $entity->setFile($filename);
                    */

                }

                $this->getEntityManager()->flush();
                return $this->createResponse( $entity );

            }else if($data['type'] == 'image') {

                $files = $this->params()->fromFiles('file', false);
                if(!$data['id'] && !$files){
                    $this->getEntityManager()->remove($entity);
                    $this->getEntityManager()->flush();
                    throw new \Exception("Nenhum arquivo enviado");
                }

                if(array_key_exists('name',$files)){
                    $files = array($files);
                }

                $order = 1;
                foreach($files as $file){

                    list($width, $height) = getimagesize($file['tmp_name']);

                    $obj = new CatalogImage();
                    $obj->setSize($file['size']);
                    $obj->setType($file['type']);
                    $obj->setWidth($width);
                    $obj->setHeight($height);
                    $obj->setCatalog($entity);
                    $obj->setOrder($order);
                    $obj->setFileResource($file);

                    $this->getEntityManager()->persist($obj);
                    $order++;

                }

                $this->getEntityManager()->flush();

                return $this->createResponse( $entity );

            }

        }catch (ApiException $ex){

            return $this->createApiExceptionResponse($ex);

        }catch (\Exception $ex) {

            return $this->createGenericApiExceptionResponse($ex);

        }
    }

}