<?php

return array(
    'controllers' => array(
        'invokables' => array(
            'Rest\Controller\Unit' => 'Rest\Controller\UnitController',
            'Rest\Controller\Group' => 'Rest\Controller\GroupController',
            'Rest\Controller\Profile' => 'Rest\Controller\ProfileController',
            'Rest\Controller\Order' => 'Rest\Controller\OrderController',
            'Rest\Controller\Customer' => 'Rest\Controller\CustomerController',
            'Rest\Controller\User' => 'Rest\Controller\UserController',
            'Rest\Controller\ProductWarehouse' => 'Rest\Controller\ProductWarehouseController',
            'Rest\Controller\RepresentedCompany' => 'Rest\Controller\RepresentedCompanyController',
            'Rest\Controller\PaymentMethod' => 'Rest\Controller\PaymentMethodController',
            'Rest\Controller\PaymentCondition' => 'Rest\Controller\PaymentConditionController',
            'Rest\Controller\Catalog' => 'Rest\Controller\CatalogController',
            'Rest\Controller\CatalogImage' => 'Rest\Controller\CatalogImageController',
            'Rest\Controller\Client' => 'Rest\Controller\ClientController',
            'Rest\Controller\Device' => 'Rest\Controller\DeviceController',
            'Rest\Controller\Warehouse' => 'Rest\Controller\WarehouseController',
            'Rest\Controller\UserLocation' => 'Rest\Controller\UserLocationController',
            'Rest\Controller\UserRepresentedCompany' => 'Rest\Controller\UserRepresentedCompanyController',
            'Rest\Controller\Product' => 'Rest\Controller\ProductController',
            'Rest\Controller\Color' => 'Rest\Controller\ColorController',
            'Rest\Controller\Size' => 'Rest\Controller\SizeController',
            'Rest\Controller\SellerMap' => 'Rest\Controller\SellerMapController',
            'Rest\Controller\Config' => 'Rest\Controller\ConfigController'
        ),
    ),
    
    'router' => array(
        'routes' => array(

            'rest-controllers' => array(
                'type' => 'Literal',
                'options' => array(
                    'route' => '/rest',
                    'defaults' => array(
                        '__NAMESPACE__' => 'Rest\Controller',
                        'controller' => 'Index',
                        'format' => 'json'
                    ),
                ),
                'may_terminate' => true,
                'child_routes' => array(
                    'default' => array(
                        'type' => 'Segment',
                        'options' => array(
                            'route' => '/[:controller][.:format][/:id]',
                            'constraints' => array(
                                'controller' => '[a-zA-Z][a-zA-Z0-9_-]*',
                                'format' => '(xml|json)',
                                'id' => '(.*)',
                            )
                        ),
                    ),
                ),
            ),

//            'app-rest-order' => array(
//                'type' => 'segment',
//                'options' => array(
//                    'route' => '/rest/order[.:format][/:id][/:dateType][/:startDate][/:endDate]',
//                    'constraints' => array(
//                        'format'    => '(xml|json)',
//                        'id'        => '(.*)',
//                        'dateType'  => '(.*)',
//                        'startDate' => '(.*)',
//                        'endDate'   => '(.*)'
//                    ),
//                    'defaults' => array(
//                        '__NAMESPACE__' => 'Rest\Controller',
//                        'controller' => 'Order',
//                        'format' => 'json'
//                    ),
//                ),
//            ),

        ),
    ),

    'view_manager' => array(
        'template_path_stack' => array(
            'api' => __DIR__ . '/../view',
        ),
        'strategies' => array(
            'ViewJsonStrategy',
            'ViewFeedStrategy',
            'ViewXmlStrategy',
        ),
    ),

);