<?php

/**
 * AbstractEnum
 * 
 * Abstract class to create PHP Enums
 *
 * @author Renato Peterman <renato.pet at gmail.com>
 */

namespace Model\Enum;

abstract class AbstractEnum {
    
    public static function description($value){
        $array = self::toArray();
        return $array[$value];
    }
    
    public static function valueFromDescription($value){
        return array_search($value, self::toArray());
    }
    
    public static function toArray(){
        
        $reflect = new \ReflectionClass(get_class($this));
        $constants = array();
        foreach($reflect->getConstants() as $key => $value){
            $constants[$value] = str_replace('_', ' ', $key); // Format name
        }
        return $constants;
    }
    
    public static function values(){
        
        $reflect = new \ReflectionClass(get_class($this));
        $constants = array();
        foreach($reflect->getConstants() as $key => $value){
            $constants[] = $value;
        }
        return $constants;
    }
    
}

?>
