<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use Zend\Form\Annotation;

/**
 * Model\Entity\WarehouseTransaction
 *
 * @ORM\Entity()
 * @ORM\Table(name="warehouse_transaction_group")
 */
class WarehouseTransactionGroup extends AbstractEntity
{
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="transactionType", type="integer", nullable=false)
     * @Annotation\Exclude()
     */
    protected $transactionType;
    
    /**
     * @ORM\Column(name="description", type="string", nullable=true)
     */
    protected $description;

    /**
     * @ORM\Column(name="status", type="boolean", nullable=true)
     */
    protected $status;
    
    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\Warehouse")
     * @ORM\JoinColumn(name="id_warehouse_from", referencedColumnName="id", nullable=true)
     */
    protected $warehouseFrom;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\Warehouse")
     * @ORM\JoinColumn(name="id_warehouse_to", referencedColumnName="id")
     */
    protected $warehouseTo;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="warehouseTransactions")
     * @ORM\JoinColumn(name="id_user", referencedColumnName="id")
     */
    protected $user;
    
    /**
     * @ORM\OneToMany(targetEntity="Model\Entity\WarehouseTransaction", mappedBy="warehouseTransactionGroup", cascade={"persist", "merge", "remove"})
     * @ORM\JoinColumn(name="id", referencedColumnName="id_warehouse_transaction_group")
     */
    protected $warehouseTransactions;

    public function __construct()
    {
        parent::__construct();
    }
    
    public function getId() {
        return $this->id;
    }

    public function setId($id) {
        $this->id = $id;
    }

    public function getTransactionType() {
        return $this->transactionType;
    }

    public function setTransactionType($transactionType) {
        $this->transactionType = $transactionType;
    }

    public function getDescription() {
        return $this->description;
    }

    public function setDescription($description) {
        $this->description = $description;
    }

    public function getStatus() {
        return $this->status;
    }

    public function setStatus($status) {
        $this->status = $status;
    }

    public function getWarehouseFrom() {
        return $this->warehouseFrom;
    }

    public function setWarehouseFrom($warehouseFrom) {
        $this->warehouseFrom = $warehouseFrom;
    }

    public function getWarehouseTo() {
        return $this->warehouseTo;
    }

    public function setWarehouseTo($warehouseTo) {
        $this->warehouseTo = $warehouseTo;
    }

    public function getUser() {
        return $this->user;
    }

    public function setUser($user) {
        $this->user = $user;
    }
    
    public function getWarehouseTransactions() {
        return $this->warehouseTransactions;
    }

    public function setWarehouseTransactions($warehouseTransactions) {
        $this->warehouseTransactions = $warehouseTransactions;
    }
    
}