<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use Zend\Form\Annotation;

/**
 * Model\Entity\WarehouseTransaction
 *
 * @ORM\Entity()
 * @ORM\Table(name="warehouse_transaction")
 * @Annotation\Name("warehouse-transaction")
 * @Annotation\Attributes({"class":"form-horizontal form-validate"})
 */
class WarehouseTransaction extends AbstractEntity
{
    
    const TYPE_ENTRADA          = 1;
    const TYPE_TRANSFERENCIA    = 2;
    const TYPE_AJUSTE           = 3;
    const TYPE_SAIDA            = 4;
    
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Annotation\Exclude()
     */
    protected $id;

    /**
     * @ORM\Column(name="transactionType", type="integer", nullable=false)
     * @Annotation\Exclude()
     */
    protected $transactionType;
    
    /**
     * @ORM\Column(name="description", type="string", nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":""})
     * @Annotation\Options({"label":"Descrição:"})
     */
    protected $description;

    /**
     * @ORM\Column(name="status", type="boolean", nullable=true)
     * @Annotation\Exclude()
     */
    protected $status;
    
    /**
     * @ORM\ManyToOne(targetEntity="Product", inversedBy="warehouseTransactions")
     * @ORM\JoinColumn(name="id_product", referencedColumnName="id")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"readonly":"false", "class":"form-control select2"})
     * @Annotation\Type("DoctrineModule\Form\Element\ObjectSelect")
     * @Annotation\Options({"label":"Produto:", "target_class":"Model\Entity\Product", "empty_option":"---", "disable_inarray_validator":true})
     */
    protected $product;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\Warehouse", inversedBy="warehouseTransactionRelatedByIdWarehouseFroms")
     * @ORM\JoinColumn(name="id_warehouse_from", referencedColumnName="id", nullable=true)
     * @Annotation\Attributes({"readonly":"false", "class":"form-control select2"})
     * @Annotation\Type("Commons\Form\Element\OptionalObjectSelect")
     * @Annotation\Options({"label":"Origem:", "target_class":"Model\Entity\Warehouse", "empty_option":"---", "disable_inarray_validator":true})
     */
    protected $warehouseFrom;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\Warehouse", inversedBy="warehouseTransactionRelatedByIdWarehouseTos")
     * @ORM\JoinColumn(name="id_warehouse_to", referencedColumnName="id")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"readonly":"false", "class":"form-control select2"})
     * @Annotation\Type("DoctrineModule\Form\Element\ObjectSelect")
     * @Annotation\Options({"label":"Destino:", "target_class":"Model\Entity\Warehouse", "empty_option":"---", "disable_inarray_validator":true})
     */
    protected $warehouseTo;
    
    /**
     * @ORM\Column(type="decimal", precision=19, scale=2, nullable=false)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":""})
     * @Annotation\Options({"label":"Quantidade:"})
     */
    protected $amount;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="warehouseTransactions")
     * @ORM\JoinColumn(name="id_user", referencedColumnName="id")
     * @Annotation\Exclude()
     */
    protected $user;
    
    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\WarehouseTransactionGroup", inversedBy="warehouseTransactions")
     * @ORM\JoinColumn(name="id_warehouse_transaction_group", referencedColumnName="id", nullable=true)
     * @Annotation\Exclude()
     */
    protected $warehouseTransactionGroup;

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\WarehouseTransaction
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }
    
    public function getWarehouseTransactionGroup() {
        return $this->warehouseTransactionGroup;
    }

    public function setWarehouseTransactionGroup($warehouseTransactionGroup) {
        $this->warehouseTransactionGroup = $warehouseTransactionGroup;
    }
    
    /**
     * Get the value of id.
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }
    
    public function getDescription() {
        return $this->description;
    }

    public function setDescription($description) {
        $this->description = $description;
    }
    
    public function getTransactionType() {
        return $this->transactionType;
    }

    public function setTransactionType($transactionType) {
        $this->transactionType = $transactionType;
    }
    
    /**
     * Set the value of amount.
     *
     * @param float $amount
     * @return \Model\Entity\WarehouseTransaction
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * Get the value of amount.
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * Set the value of status.
     *
     * @param string $status
     * @return \Model\Entity\WarehouseTransaction
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get the value of status.
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    
    public function getWarehouseFrom() {
        return $this->warehouseFrom;
    }

    public function setWarehouseFrom($warehouseFrom) {
        $this->warehouseFrom = $warehouseFrom;
    }

    public function getWarehouseTo() {
        return $this->warehouseTo;
    }

    public function setWarehouseTo($warehouseTo) {
        $this->warehouseTo = $warehouseTo;
    }

    /**
     * Set User entity (many to one).
     *
     * @param \Model\Entity\User $user
     * @return \Model\Entity\WarehouseTransaction
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get User entity (many to one).
     *
     * @return \Model\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set Product entity (many to one).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\WarehouseTransaction
     */
    public function setProduct(Product $product = null)
    {
        $this->product = $product;

        return $this;
    }

    /**
     * Get Product entity (many to one).
     *
     * @return \Model\Entity\Product
     */
    public function getProduct()
    {
        return $this->product;
    }

    public function __sleep()
    {
        return array('id', 'type', 'amount', 'id_warehouse_from', 'id_warehouse_to', 'id_user', 'id_product', 'status');
    }
    
    public static function types(){
        return array(
            WarehouseTransaction::TYPE_ENTRADA => 'Entrada',
            WarehouseTransaction::TYPE_TRANSFERENCIA => 'Transferência',
            WarehouseTransaction::TYPE_AJUSTE => 'Ajuste'
        );
    }
}