<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\Warehouse
 *
 * @ORM\Entity()
 * @ORM\Table(name="warehouse")
 * @Annotation\Name("user")
 * @Annotation\Attributes({"class":"form-horizontal form-validate"})
 */
class Warehouse extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Annotation\Exclude()
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"false" })
     * @Annotation\Attributes({"type":"text", "class":"form-control"})
     * @Annotation\Options({"label":"Código Externo:"})
     */    
    protected $code;

    /**
     * @ORM\Column(type="string", length=255)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Descrição:"})
     */
    protected $description;
    
    /**
     * @ORM\Column(name="main", type="boolean", nullable=true)
     * @Annotation\Type("Zend\Form\Element\Checkbox")
     * @Annotation\Options({"label":"Principal?:"})
     */
    protected $main;

    /**
     * @ORM\OneToMany(targetEntity="OrderProduct", mappedBy="warehouse")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_warehouse")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $orderProducts;

    /**
     * @ORM\OneToMany(targetEntity="ProductWarehouse", mappedBy="warehouse")
     * @ORM\JoinColumn(name="id", referencedColumnName="warehouse_id")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $productWarehouses;

    /**
     * @ORM\OneToMany(targetEntity="ProductWarehouseVariant", mappedBy="warehouse")
     * @ORM\JoinColumn(name="id", referencedColumnName="warehouse_id")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $productWarehouseVariants;
    
    /**
     * @ORM\OneToMany(targetEntity="WarehouseTransaction", mappedBy="warehouseRelatedByIdWarehouseFrom")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_warehouse_from")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $warehouseTransactionRelatedByIdWarehouseFroms;

    /**
     * @ORM\OneToMany(targetEntity="WarehouseTransaction", mappedBy="warehouseRelatedByIdWarehouseTo")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_warehouse_to")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $warehouseTransactionRelatedByIdWarehouseTos;

    public function __construct()
    {
        parent::__construct();
        $this->orderProducts = new ArrayCollection();
        $this->productWarehouses = new ArrayCollection();
        $this->productWarehouseVariants = new ArrayCollection();
        $this->warehouseTransactionRelatedByIdWarehouseFroms = new ArrayCollection();
        $this->warehouseTransactionRelatedByIdWarehouseTos = new ArrayCollection();
    }
    
    public function isMain() {
        return $this->main;
    }
    
    public function getMain() {
        return $this->main;
    }

    public function setMain($main) {
        $this->main = $main;
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\Warehouse
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }
    
    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Warehouse
     */
    public function setCode($code)
    {
        $this->code = $code;
        
        return $this;
    }
    
    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of description.
     *
     * @param string $description
     * @return \Model\Entity\Warehouse
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get the value of description.
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Add OrderProduct entity to collection (one to many).
     *
     * @param \Model\Entity\OrderProduct $orderProduct
     * @return \Model\Entity\Warehouse
     */
    public function addOrderProduct(OrderProduct $orderProduct)
    {
        $this->orderProducts[] = $orderProduct;

        return $this;
    }

    /**
     * Remove OrderProduct entity from collection (one to many).
     *
     * @param \Model\Entity\OrderProduct $orderProduct
     * @return \Model\Entity\Warehouse
     */
    public function removeOrderProduct(OrderProduct $orderProduct)
    {
        $this->orderProducts->removeElement($orderProduct);

        return $this;
    }

    /**
     * Get OrderProduct entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOrderProducts()
    {
        return $this->orderProducts;
    }

    /**
     * Add ProductWarehouse entity to collection (one to many).
     *
     * @param \Model\Entity\ProductWarehouse $productWarehouse
     * @return \Model\Entity\Warehouse
     */
    public function addProductWarehouse(ProductWarehouse $productWarehouse)
    {
        $this->productWarehouses[] = $productWarehouse;

        return $this;
    }

    /**
     * Remove ProductWarehouse entity from collection (one to many).
     *
     * @param \Model\Entity\ProductWarehouse $productWarehouse
     * @return \Model\Entity\Warehouse
     */
    public function removeProductWarehouse(ProductWarehouse $productWarehouse)
    {
        $this->productWarehouses->removeElement($productWarehouse);

        return $this;
    }

    /**
     * Get ProductWarehouse entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProductWarehouses()
    {
        return $this->productWarehouses;
    }
    
    /**
     * Add ProductWarehouseVariant entity to collection (one to many).
     *
     * @param \Model\Entity\ProductWarehouseVariant $productWarehouseVariant
     * @return \Model\Entity\Warehouse
     */
    public function addProductWarehouseVariants(ProductWarehouseVariant $productWarehouseVariant)
    {
        $this->productWarehouseVariants[] = $productWarehouseVariant;
        
        return $this;
    }
    
    /**
     * Remove ProductWarehouseVariant entity from collection (one to many).
     *
     * @param \Model\Entity\ProductWarehouseVariant $productWarehouseVariant
     * @return \Model\Entity\Warehouse
     */
    public function removeProductWarehouseVariants(ProductWarehouseVariant $productWarehouseVariant)
    {
        $this->productWarehouseVariants->removeElement($productWarehouseVariant);
        
        return $this;
    }
    
    /**
     * Get ProductWarehouseVariant entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProductWarehouseVariants()
    {
        return $this->productWarehouseVariants;
    }    
    
    /**
     * Add WarehouseTransaction entity related by `id_warehouse_from` to collection (one to many).
     *
     * @param \Model\Entity\WarehouseTransaction $warehouseTransaction
     * @return \Model\Entity\Warehouse
     */
    public function addWarehouseTransactionRelatedByIdWarehouseFrom(WarehouseTransaction $warehouseTransaction)
    {
        $this->warehouseTransactionRelatedByIdWarehouseFroms[] = $warehouseTransaction;

        return $this;
    }

    /**
     * Remove WarehouseTransaction entity related by `id_warehouse_from` from collection (one to many).
     *
     * @param \Model\Entity\WarehouseTransaction $warehouseTransaction
     * @return \Model\Entity\Warehouse
     */
    public function removeWarehouseTransactionRelatedByIdWarehouseFrom(WarehouseTransaction $warehouseTransaction)
    {
        $this->warehouseTransactionRelatedByIdWarehouseFroms->removeElement($warehouseTransaction);

        return $this;
    }

    /**
     * Get WarehouseTransaction entity related by `id_warehouse_from` collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getWarehouseTransactionRelatedByIdWarehouseFroms()
    {
        return $this->warehouseTransactionRelatedByIdWarehouseFroms;
    }

    /**
     * Add WarehouseTransaction entity related by `id_warehouse_to` to collection (one to many).
     *
     * @param \Model\Entity\WarehouseTransaction $warehouseTransaction
     * @return \Model\Entity\Warehouse
     */
    public function addWarehouseTransactionRelatedByIdWarehouseTo(WarehouseTransaction $warehouseTransaction)
    {
        $this->warehouseTransactionRelatedByIdWarehouseTos[] = $warehouseTransaction;

        return $this;
    }

    /**
     * Remove WarehouseTransaction entity related by `id_warehouse_to` from collection (one to many).
     *
     * @param \Model\Entity\WarehouseTransaction $warehouseTransaction
     * @return \Model\Entity\Warehouse
     */
    public function removeWarehouseTransactionRelatedByIdWarehouseTo(WarehouseTransaction $warehouseTransaction)
    {
        $this->warehouseTransactionRelatedByIdWarehouseTos->removeElement($warehouseTransaction);

        return $this;
    }
    
    public function getProductsSum(){
        
        $sum = 0;
        foreach($this->getProductWarehouses() as $ent){
            $sum += $ent->getAmount();
            /*
            if($ent->getAmount() > 0){
                $sum += $ent->getAmount();
            }
             */
        }
        
        return $sum;
    }

    /**
     * Get WarehouseTransaction entity related by `id_warehouse_to` collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getWarehouseTransactionRelatedByIdWarehouseTos()
    {
        return $this->warehouseTransactionRelatedByIdWarehouseTos;
    }

    public function __sleep()
    {
        return array('id', 'description');
    }
    
    public function __toString() {
        return $this->getDescription();
    }
    
}