<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Zend\Form\Annotation;

/**
 * @ORM\Entity
 * @ORM\Table(name="user_represented_company", uniqueConstraints={@ORM\UniqueConstraint(name="user_represented_company_unique", columns={"id_user", "id_represented_company"})})
 */
class UserRepresentedCompany extends AbstractEntity {

    /**
     * @ORM\Id
     * @ORM\Column(name="id", type="bigint")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;
    
    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(name="commission", type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $commission;

    /**
     * @ORM\ManyToOne(targetEntity="RepresentedCompany", inversedBy="representedCompanies")
     * @ORM\JoinColumn(name="id_represented_company", referencedColumnName="id")
     *
     * @JMS\Type("Model\Entity\RepresentedCompany")
     */
    protected $representedCompany;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="locations")
     * @ORM\JoinColumn(name="id_user", referencedColumnName="id")
     *
     * @JMS\Type("Model\Entity\User")
     */
    protected $user;
    
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\UserRepresentedCompany
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * @return mixed
     */
    public function getRepresentedCompany()
    {
        return $this->representedCompany;
    }

    /**
     * @param mixed $representedCompany
     */
    public function setRepresentedCompany($representedCompany)
    {
        $this->representedCompany = $representedCompany;
    }

    /**
     * @return mixed
     */
    public function getCommission()
    {
        return $this->commission;
    }

    /**
     * @param mixed $commission
     */
    public function setCommission($commission)
    {
        $this->commission = $commission;
    }

}   

?>
