<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Zend\Form\Annotation;

/**
 * @ORM\Entity
 * @ORM\Table(name="user_customer", uniqueConstraints={@ORM\UniqueConstraint(name="user_customer_unique", columns={"id_user", "id_customer"})})
 */
class UserCustomer extends AbstractEntity {

    /**
     * @ORM\Id
     * @ORM\Column(name="id", type="bigint")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="userCustomers")
     * @ORM\JoinColumn(name="id_user", referencedColumnName="id", nullable=false)
     *
     * @JMS\Type("Model\Entity\User")
     */
    protected $user;

    /**
     * @ORM\ManyToOne(targetEntity="Customer", inversedBy="userCustomers", cascade={"persist"})
     * @ORM\JoinColumn(name="id_customer", referencedColumnName="id", nullable=false)
     *
     * @JMS\Type("Model\Entity\Customer")
     */
    protected $customer;


    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\UserCustomer
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * @return mixed
     */
    public function getCustomer()
    {
        return $this->customer;
    }

    /**
     * @param mixed $customer
     */
    public function setCustomer($customer)
    {
        $this->customer = $customer;
    }

}

?>
