<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\Unit
 * Product measure unit
 *
 * @ORM\Entity()
 * @ORM\Table(name="unit")
 * @Annotation\Name("unit")
 * @Annotation\Attributes({"class":"form-horizontal form-validate"})
 */
class Unit extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="string", length=20)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Simbolo:"})
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(type="string", length=100)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Descrição:"})
     */
    protected $description;

    /**
     * @ORM\OneToMany(targetEntity="Product", mappedBy="unit")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_unit")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $products;

    public function __construct()
    {
        parent::__construct();
        $this->products = new ArrayCollection();
    }

    /**
     * Set the value of id.
     *
     * @param string $id
     * @return \Model\Entity\Unit
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Unit
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of description.
     *
     * @param string $description
     * @return \Model\Entity\Unit
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get the value of description.
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Add Product entity to collection (one to many).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\Unit
     */
    public function addProduct(Product $product)
    {
        $this->products[] = $product;

        return $this;
    }

    /**
     * Remove Product entity from collection (one to many).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\Unit
     */
    public function removeProduct(Product $product)
    {
        $this->products->removeElement($product);

        return $this;
    }

    /**
     * Get Product entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProducts()
    {
        return $this->products;
    }

    public function __sleep()
    {
        return array('id', 'description');
    }

    public function __toString() {
        return $this->getId() . ' - ' .  $this->getDescription();
    }

    /**
     * Get array copy for datatable
     * @return array
     */
    public function getArrayCopyDT(){
        $array = parent::getArrayCopy();
        unset($array['products']);
        $array['created'] = $this->getCreatedDatetimeStr();
        $array['updated'] = $this->getCreatedDatetimeStr();
        return $array;
    }
}
