<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\Size
 *
 * @ORM\Entity()
 * @ORM\Table(name="`size`")
 */
class Size extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(type="string", length=100)
     */
    protected $description;
    
    /**
     * @ORM\OneToMany(targetEntity="ProductWarehouseVariant", mappedBy="size")
     * @ORM\JoinColumn(name="id", referencedColumnName="size_id", nullable=true)
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $productWarehouseVariants;
    
    
    public function __construct()
    {
        parent::__construct();
        $this->productWarehouseVariants = new ArrayCollection();
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\Group
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Size
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of description.
     * @param string $description
     * @return \Model\Entity\Group
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get the value of description.
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    
    /**
     * Add ProductWarehouseVariant entity to collection (one to many).
     *
     * @param \Model\Entity\ProductWarehouseVariant $productWarehouseVariant
     * @return \Model\Entity\Size
     */
    public function addProductWarehouseVariants(ProductWarehouseVariant $productWarehouseVariant)
    {
        $this->productWarehouseVariants[] = $productWarehouseVariant;
        
        return $this;
    }
    
    /**
     * Remove ProductWarehouseVariant entity from collection (one to many).
     *
     * @param \Model\Entity\ProductWarehouseVariant $productWarehouseVariant
     * @return \Model\Entity\Size
     */
    public function removeProductWarehouseVariants(ProductWarehouseVariant $productWarehouseVariant)
    {
        $this->productWarehouseVariants->removeElement($productWarehouseVariant);
        
        return $this;
    }
    
    /**
     * Get ProductWarehouseVariant entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProductWarehouseVariants()
    {
        return $this->productWarehouseVariants;
    }
    
    /**
     * To string
     * @return string
     */
    public function __toString() {
        return $this->getDescription();
    }
}
