<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Model\Entity\ProductWarehouseVariant
 *
 * @ORM\Entity()
 * @ORM\Table(name="product_warehouse_variant")
 */
class ProductWarehouseVariant extends AbstractEntity
{

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Id
     * @ORM\ManyToOne(targetEntity="Model\Entity\Product", inversedBy="productWarehouseVariants")
     * @ORM\JoinColumn(name="product_id", referencedColumnName="id")
     */
    protected $product;
    
    /**
     * @ORM\Id
     * @ORM\ManyToOne(targetEntity="Model\Entity\Color", inversedBy="productWarehouseVariants")
     * @ORM\JoinColumn(name="color_id", referencedColumnName="id", nullable=true)
     */
    protected $color;
    
    /**
     * @ORM\Id
     * @ORM\ManyToOne(targetEntity="Model\Entity\Size", inversedBy="productWarehouseVariants")
     * @ORM\JoinColumn(name="size_id", referencedColumnName="id", nullable=true)
     */
    protected $size;
    
    /**
     * @ORM\Id
     * @ORM\ManyToOne(targetEntity="Model\Entity\Warehouse", inversedBy="productWarehouseVariants")
     * @ORM\JoinColumn(name="warehouse_id", referencedColumnName="id")
     */
    protected $warehouse;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2, nullable=false)
     */
    protected $amount;

    public function __construct()
    {
        parent::__construct();
    }

    public function subtract($amount){
        $this->setAmount( $this->getAmount() - $amount );
    }

    public function increase($amount){
        $this->setAmount( $this->getAmount() + $amount );
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\ProductWarehouseVariant
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of product_id.
     *
     * @param integer $product_id
     * @return \Model\Entity\ProductWarehouseVariant
     */
    public function setProductId($product_id)
    {
        $this->product_id = $product_id;

        return $this;
    }

    /**
     * Get the value of product_id.
     *
     * @return integer
     */
    public function getProductId()
    {
        return $this->product_id;
    }

    /**
     * Set the value of warehouse_id.
     *
     * @param integer $warehouse_id
     * @return \Model\Entity\ProductWarehouseVariant
     */
    public function setWarehouseId($warehouse_id)
    {
        $this->warehouse_id = $warehouse_id;

        return $this;
    }

    /**
     * Get the value of warehouse_id.
     *
     * @return integer
     */
    public function getWarehouseId()
    {
        return $this->warehouse_id;
    }

    /**
     * Set the value of amount.
     *
     * @param float $amount
     * @return \Model\Entity\ProductWarehouseVariant
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * Get the value of amount.
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    public function getAmountRound()
    {
        return number_format($this->amount, 0);
    }

    /**
     * Set Product entity (many to one).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\ProductWarehouseVariant
     */
    public function setProduct(Product $product = null)
    {
        $this->product = $product;

        return $this;
    }

    /**
     * Get Product entity (many to one).
     *
     * @return \Model\Entity\Product
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * Set Warehouse entity (many to one).
     *
     * @param \Model\Entity\Warehouse $warehouse
     * @return \Model\Entity\ProductWarehouseVariant
     */
    public function setWarehouse(Warehouse $warehouse = null)
    {
        $this->warehouse = $warehouse;

        return $this;
    }

    /**
     * Get Warehouse entity (many to one).
     *
     * @return \Model\Entity\WarehouseVariant
     */
    public function getWarehouse()
    {
        return $this->warehouse;
    }

    /**
     * Set Color entity (many to one).
     *
     * @param \Model\Entity\Color $color
     * @return \Model\Entity\ProductWarehouseVariant
     */
    public function setColor(Color $color = null)
    {
        $this->color = $color;

        return $this;
    }

    /**
     * Get Color entity (many to one).
     *
     * @return \Model\Entity\Product
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Set Size entity (many to one).
     *
     * @param \Model\Entity\Size $size
     * @return \Model\Entity\ProductWarehouseVariant
     */
    public function setSize(Size $size = null)
    {
        $this->size = $size;

        return $this;
    }

    /**
     * Get Size entity (many to one).
     *
     * @return \Model\Entity\Size
     */
    public function getSize()
    {
        return $this->size;
    }

    public function __sleep()
    {
        return array('product_id', 'warehouse_id', 'amount');
    }
}