<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;

/**
 * Model\Entity\ProductBarcode
 *
 * @ORM\Entity()
 * @ORM\Table(name="product_barcode")
 */
class ProductBarcode extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=255)
     */
    protected $code;

    /**
     * @ORM\ManyToOne(targetEntity="Product", inversedBy="productBarcode")
     * @ORM\JoinColumn(name="id_product", referencedColumnName="id", nullable=false)
     *
     * @JMS\Exclude()
     */
    protected $product;

    /**
     * @ORM\ManyToOne(targetEntity="Color")
     * @ORM\JoinColumn(name="id_color", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\Color")
     */
    protected $color;

    /**
     * @ORM\ManyToOne(targetEntity="Size")
     * @ORM\JoinColumn(name="id_size", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\Size")
     */
    protected $size;

    /**
     * @ORM\ManyToOne(targetEntity="Unit")
     * @ORM\JoinColumn(name="id_unit", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\Unit")
     */
    protected $unit;


    public function __construct()
    {
        parent::__construct();
    }


    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\ProductBarcode
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return mixed
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * @param mixed $product
     */
    public function setProduct($product)
    {
        $this->product = $product;
    }

    /**
     * @return mixed
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * @param mixed $color
     */
    public function setColor($color)
    {
        $this->color = $color;
    }

    /**
     * @return mixed
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * @param mixed $size
     */
    public function setSize($size)
    {
        $this->size = $size;
    }

    /**
     * @return mixed
     */
    public function getUnit()
    {
        return $this->unit;
    }

    /**
     * @param mixed $unit
     */
    public function setUnit($unit)
    {
        $this->unit = $unit;
    }

}
