<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Commons\Util\FileUtil;
use Commons\Util\ImageUtil;
use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\Product
 *
 * @ORM\Entity(repositoryClass="Model\Repository\ProductRepository")
 * @ORM\Table(name="product", indexes={@ORM\Index(name="fk_product_group1_idx", columns={"id_group_primary"}), @ORM\Index(name="fk_product_unit1_idx", columns={"id_unit"}), @ORM\Index(name="fk_product_group2_idx", columns={"id_group_secondary"})})
 * @Annotation\Name("product")
 * @Annotation\Attributes({"class":"form-horizontal form-validate"})
 * @ORM\HasLifecycleCallbacks
 */
class Product extends AbstractEntity
{
    const NO_PICTURE_PATH = "./data/images/no-photo.jpg";
    const DEFAULT_PATH = './data/images/product';

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Annotation\Exclude()
     */
    protected $id;

    /**
     * @ORM\Column(name="image", type="string", nullable=true)
     * @Annotation\Exclude()
     */
    protected $image;

    /**
     * @Annotation\Type("Zend\Form\Element\File")
     * @Annotation\Attributes({"id":"imageFile"})
     * @Annotation\Options({"label":"Imagem:"})
     */
    protected $imageFile;

    /**
     * @ORM\Column(name="`code`", type="string", length=40, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"false" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Código de Integração:"})
     */
    protected $code;

    /**
     * @ORM\Column(name="`name`", type="string", length=255)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Nome:"})
     */
    protected $name;

    /**
     * @ORM\Column(type="string", length=100, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":""})
     * @Annotation\Options({"label":"Referência:"})
     */
    protected $reference;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":""})
     * @Annotation\Options({"label":"Descrição:"})
     */
    protected $description;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2, nullable=true, options={"default" = 0.0})
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control mask-money", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Custo:"})
     */
    protected $cost;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control mask-money", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Preço:"})
     */
    protected $price;

    /**
     * @ORM\Column(name="price_min", type="decimal", precision=19, scale=2, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control mask-money", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Preço Mínimo:"})
     */
    protected $priceMin;

    /**
     * @ORM\Column(name="`price_promotional`", type="decimal", precision=19, scale=2, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $pricePromotional;

    /**
     * @ORM\Column(name="`price_promotional_min`", type="decimal", precision=19, scale=2, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $pricePromotionalMin;

    /**
     * @ORM\Column(name="commission", type="decimal", precision=19, scale=2, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Attributes({"type":"text", "class":"form-control mask-money", "placeholder":"Obrigatório"})
     * @Annotation\Options({"label":"Comissão:"})
     */
    protected $commission;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Annotation\Type("Zend\Form\Element\Text")
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":""})
     * @Annotation\Options({"label":"Código de Barras:"})
     */
    protected $barcode;

    /**
     * @ORM\Column(name="stock", type="integer", nullable=true)
     */
     protected $stock;


    /**
     * @ORM\OneToMany(targetEntity="OrderProduct", mappedBy="product")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_product")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $orderProducts;

    /**
     * @ORM\OneToMany(targetEntity="ProductImage", mappedBy="product")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_product")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $productImages;

    /**
     * @ORM\OneToMany(targetEntity="ProductWarehouse", mappedBy="product")
     * @ORM\JoinColumn(name="id", referencedColumnName="product_id")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $productWarehouses;

    /**
     * @ORM\OneToMany(targetEntity="ProductWarehouseVariant", mappedBy="product")
     * @ORM\JoinColumn(name="id", referencedColumnName="product_id")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $productWarehouseVariants;

    /**
     * @ORM\OneToMany(targetEntity="WarehouseTransaction", mappedBy="product")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_product")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $warehouseTransactions;

    /**
     * @ORM\ManyToOne(targetEntity="Group", inversedBy="productRelatedByIdGroupPrimaries")
     * @ORM\JoinColumn(name="id_group_primary", referencedColumnName="id", nullable=true)
     * @Annotation\Attributes({"readonly":"false", "class":"form-control select2"})
     * @Annotation\Type("Application\Form\Element\OptionalObjectSelect")
     * @Annotation\Options({"label":"Grupo Primário:", "target_class":"Model\Entity\Group", "empty_option":"---", "disable_inarray_validator":true})
     *
     * @JMS\Exclude()
     */
    protected $groupRelatedByIdGroupPrimary;

    /**
     * @ORM\ManyToOne(targetEntity="Group", inversedBy="productRelatedByIdGroupSecondaries")
     * @ORM\JoinColumn(name="id_group_secondary", referencedColumnName="id", nullable=true)
     * @Annotation\Attributes({"readonly":"false", "class":"form-control select2"})
     * @Annotation\Type("Application\Form\Element\OptionalObjectSelect")
     * @Annotation\Options({"label":"Grupo Secundário:", "target_class":"Model\Entity\Group", "empty_option":"---", "disable_inarray_validator":true})
     *
     * @JMS\Exclude()
     */
    protected $groupRelatedByIdGroupSecondary;

    /**
     * @ORM\ManyToOne(targetEntity="Group", inversedBy="productRelatedByIdGroupTertiaries")
     * @ORM\JoinColumn(name="id_group_tertiary", referencedColumnName="id", nullable=true)
     * @Annotation\Attributes({"readonly":"false", "class":"form-control select2"})
     * @Annotation\Type("Application\Form\Element\OptionalObjectSelect")
     * @Annotation\Options({"label":"Grupo Terciário:", "target_class":"Model\Entity\Group", "empty_option":"---", "disable_inarray_validator":true})
     *
     * @JMS\Exclude()
     */
    protected $groupRelatedByIdGroupTertiary;

    /**
     * @ORM\ManyToOne(targetEntity="Unit", inversedBy="products")
     * @ORM\JoinColumn(name="id_unit", referencedColumnName="id")
     * @Annotation\Attributes({"readonly":"false", "class":"form-control select2"})
     * @Annotation\Type("Application\Form\Element\OptionalObjectSelect")
     * @Annotation\Required({"required":"true" })
     * @Annotation\Options({"label":"Unidade de Medida:", "target_class":"Model\Entity\Unit", "empty_option":"---", "disable_inarray_validator":true})
     *
     * @JMS\Type("Model\Entity\Unit")
     */
    protected $unit;

    /**
     * @ORM\Column(name="`unit_custom`", type="string", length=40, nullable=true)
     */
    protected $unitCustom;

    /**
     * @ORM\Column(name="info", type="text", nullable=true)
     * @Annotation\Type("Zend\Form\Element\Textarea")
     * @Annotation\Attributes({"type":"text", "class":"form-control", "placeholder":""})
     * @Annotation\Options({"label":"Informações Adicionais:"})
     */
    protected $info;

    /**
     * @ORM\Column(name="`description_grid`", type="string", length=255, nullable=true)
     */
    protected $descriptionGrid;

    /**
     * @ORM\Column(name="`amount_minimal`", type="decimal", precision=12, scale=2, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $amountMinimal;

    /**
     * @ORM\ManyToMany(targetEntity="Model\Entity\RepresentedCompany", cascade={"persist", "merge"})
     * @ORM\JoinTable(name="product_represented_company",
     *      joinColumns={@ORM\JoinColumn(name="id_product", referencedColumnName="id")},
     *      inverseJoinColumns={@ORM\JoinColumn(name="id_represented_company", referencedColumnName="id")}
     *      )
     *
     * @Annotation\Attributes({"readonly":"false", "class":"form-control select2"})
     * @Annotation\Type("Application\Form\Element\OptionalObjectSelect")
     * @Annotation\Options({"label":"Representadas:", "target_class":"Model\Entity\RepresentedCompany", "empty_option":"---", "disable_inarray_validator":true})
     */
    protected $representedCompanies;

    /**
     * @ORM\OneToMany(targetEntity="ProductColor", mappedBy="product")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_product")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $colors;

    /**
     * @ORM\OneToMany(targetEntity="ProductSize", mappedBy="product")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_product")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $sizes;

     /**
      * @ORM\OneToMany(targetEntity="PriceListProduct", mappedBy="product")
      * @ORM\JoinColumn(name="id", referencedColumnName="id_product")
      * @Annotation\Exclude()
      *
      * @JMS\Exclude()
      */
    protected $priceListProducts;

    /**
     * @ORM\ManyToOne(targetEntity="GridColor", inversedBy="products")
     * @ORM\JoinColumn(name="id_grid_color", referencedColumnName="id", nullable=true)
     */
    protected $gridColor;

    /**
     * @ORM\ManyToOne(targetEntity="GridSize", inversedBy="products")
     * @ORM\JoinColumn(name="id_grid_size", referencedColumnName="id", nullable=true)
     */
    protected $gridSize;
	
    /**
     * @ORM\OneToMany(targetEntity="ProductBarcode", mappedBy="product")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_product")
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $barcodes;

    /**
     * @ORM\Column(name="use_value_weight", type="boolean", nullable=true, options={"default" = 1})
     * @JMS\Type("boolean")
     */
    protected $useValueWeight;

    /**
     * @ORM\Column(name="code_unit_primary", type="string", length=40, nullable=true)
     */
    protected $codeUnitPrimary;


    /**
     * @ORM\PreRemove()
     */
    public function preDelete() {
        if(file_exists($this->getFullImagePath())){
            unlink($this->getFullImagePath());
        }
        if(file_exists($this->getFullThumbPath())){
            unlink($this->getFullThumbPath());
        }
    }

    public function __construct()
    {
        parent::__construct();
        $this->orderProducts = new ArrayCollection();
        $this->productImages = new ArrayCollection();
        $this->productWarehouses = new ArrayCollection();
        $this->productWarehouseVariants = new ArrayCollection();
        $this->warehouseTransactions = new ArrayCollection();
        $this->representedCompanies = new ArrayCollection();
        $this->priceListProducts = new ArrayCollection();
        $this->colors = new ArrayCollection();
        $this->sizes = new ArrayCollection();
        $this->barcodes = new ArrayCollection();
    }

    public function getInfo() {
        return $this->info;
    }

    public function setInfo($info) {
        $this->info = $info;
    }

    public function getImage() {
        return $this->image;
    }

    public function setImage($image) {
        $this->image = $image;
    }

    public function getImageFile() {
        return $this->imageFile;
    }

    public function setImageFile($imageFile) {
        $this->imageFile = $imageFile;
    }

    public function getPriceMin() {
        return $this->priceMin;
    }

    public function getPriceMinCurrency() {
        return \Commons\Util\StringUtils::formatMoney($this->priceMin);
    }

    public function setPriceMin($priceMin) {
        $this->priceMin = $priceMin;
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\Product
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the value of reference.
     *
     * @param string $reference
     * @return \Model\Entity\Product
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get the value of reference.
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\Product
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of name.
     *
     * @param string $name
     * @return \Model\Entity\Product
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get the value of name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set the value of description.
     *
     * @param string $description
     * @return \Model\Entity\Product
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get the value of description.
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set the value of price.
     *
     * @param float $price
     * @return \Model\Entity\Product
     */
    public function setPrice($price)
    {
        $this->price = $price;

        return $this;
    }

    /**
     * Get the value of price.
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    public function getPriceCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->price);
    }

    /**
     * Set the value of barcode.
     *
     * @param string $barcode
     * @return \Model\Entity\Product
     */
    public function setBarcode($barcode)
    {
        $this->barcode = $barcode;

        return $this;
    }

    /**
     * Get the value of barcode.
     *
     * @return string
     */
    public function getBarcode()
    {
        return $this->barcode;
    }

   /**
     * Set the value of stock.
     *
     * @param integer $stock
     * @return \Model\Entity\Product
     */
    public function setStock($stock)
    {
        $this->stock = $stock;

        return $this;
    }

    /**
     * Get the value of stock.
     *
     * @return integer
     */
    public function getStock()
    {
        return $this->stock;
    }


    /**
     * Add OrderProduct entity to collection (one to many).
     *
     * @param \Model\Entity\OrderProduct $orderProduct
     * @return \Model\Entity\Product
     */
    public function addOrderProduct(OrderProduct $orderProduct)
    {
        $this->orderProducts[] = $orderProduct;

        return $this;
    }

    /**
     * Remove OrderProduct entity from collection (one to many).
     *
     * @param \Model\Entity\OrderProduct $orderProduct
     * @return \Model\Entity\Product
     */
    public function removeOrderProduct(OrderProduct $orderProduct)
    {
        $this->orderProducts->removeElement($orderProduct);

        return $this;
    }

    /**
     * Get OrderProduct entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOrderProducts()
    {
        return $this->orderProducts;
    }

    /**
     * Add ProductImage entity to collection (one to many).
     *
     * @param \Model\Entity\ProductImage $productImage
     * @return \Model\Entity\Product
     */
    public function addProductImage(ProductImage $productImage)
    {
        $this->productImages[] = $productImage;

        return $this;
    }

    /**
     * Remove ProductImage entity from collection (one to many).
     *
     * @param \Model\Entity\ProductImage $productImage
     * @return \Model\Entity\Product
     */
    public function removeProductImage(ProductImage $productImage)
    {
        $this->productImages->removeElement($productImage);

        return $this;
    }

    /**
     * Get ProductImage entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProductImages()
    {
        return $this->productImages;
    }

    /**
     * Add ProductWarehouse entity to collection (one to many).
     *
     * @param \Model\Entity\ProductWarehouse $productWarehouse
     * @return \Model\Entity\Product
     */
    public function addProductWarehouse(ProductWarehouse $productWarehouse)
    {
        $this->productWarehouses[] = $productWarehouse;

        return $this;
    }

    /**
     * Remove ProductWarehouse entity from collection (one to many).
     *
     * @param \Model\Entity\ProductWarehouse $productWarehouse
     * @return \Model\Entity\Product
     */
    public function removeProductWarehouse(ProductWarehouse $productWarehouse)
    {
        $this->productWarehouses->removeElement($productWarehouse);

        return $this;
    }

    /**
     * Get ProductWarehouse entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProductWarehouses()
    {
        return $this->productWarehouses;
    }

    /**
     * Add ProductWarehouseVariant entity to collection (one to many).
     *
     * @param \Model\Entity\ProductWarehouseVariant $productWarehouseVariant
     * @return \Model\Entity\Product
     */
    public function addProductWarehouseVariant(ProductWarehouseVariant $productWarehouseVariant)
    {
        $this->productWarehouseVariants[] = $productWarehouseVariant;

        return $this;
    }

    /**
     * Remove ProductWarehouseVariant entity from collection (one to many).
     *
     * @param \Model\Entity\ProductWarehouseVariant $productWarehouseVariant
     * @return \Model\Entity\Product
     */
    public function removeProductWarehouseVariant(ProductWarehouseVariant $productWarehouseVariant)
    {
        $this->productWarehouseVariants->removeElement($productWarehouseVariant);

        return $this;
    }

    /**
     * Get ProductWarehouse entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProductWarehouseVariants()
    {
        return $this->productWarehouseVariants;
    }
    
    /**
     * Add WarehouseTransaction entity to collection (one to many).
     *
     * @param \Model\Entity\WarehouseTransaction $warehouseTransaction
     * @return \Model\Entity\Product
     */
    public function addWarehouseTransaction(WarehouseTransaction $warehouseTransaction)
    {
        $this->warehouseTransactions[] = $warehouseTransaction;

        return $this;
    }

    /**
     * Remove WarehouseTransaction entity from collection (one to many).
     *
     * @param \Model\Entity\WarehouseTransaction $warehouseTransaction
     * @return \Model\Entity\Product
     */
    public function removeWarehouseTransaction(WarehouseTransaction $warehouseTransaction)
    {
        $this->warehouseTransactions->removeElement($warehouseTransaction);

        return $this;
    }

    /**
     * Get WarehouseTransaction entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getWarehouseTransactions()
    {
        return $this->warehouseTransactions;
    }

    /**
     * Set Group entity related by `id_group_primary` (many to one).
     *
     * @param \Model\Entity\Group $group
     * @return \Model\Entity\Product
     */
    public function setGroupRelatedByIdGroupPrimary(Group $group = null)
    {
        $this->groupRelatedByIdGroupPrimary = $group;

        return $this;
    }

    /**
     * Get Group entity related by `id_group_primary` (many to one).
     *
     * @return \Model\Entity\Group
     */
    public function getGroupRelatedByIdGroupPrimary()
    {
        return $this->groupRelatedByIdGroupPrimary;
    }

    /**
     * Set Group entity related by `id_group_secondary` (many to one).
     *
     * @param \Model\Entity\Group $group
     * @return \Model\Entity\Product
     */
    public function setGroupRelatedByIdGroupSecondary(Group $group = null)
    {
        $this->groupRelatedByIdGroupSecondary = $group;

        return $this;
    }

    /**
     * Get Group entity related by `id_group_secondary` (many to one).
     *
     * @return \Model\Entity\Group
     */
    public function getGroupRelatedByIdGroupSecondary()
    {
        return $this->groupRelatedByIdGroupSecondary;
    }

    /**
     * Set Group entity related by `id_group_tertiary` (many to one).
     *
     * @param \Model\Entity\Group $group
     * @return \Model\Entity\Product
     */
    public function setGroupRelatedByIdGroupTertiary(Group $group = null)
    {
        $this->groupRelatedByIdGroupTertiary = $group;

        return $this;
    }

    /**
     * Get Group entity related by `id_group_tertiary` (many to one).
     *
     * @return \Model\Entity\Group
     */
    public function getGroupRelatedByIdGroupTertiary()
    {
        return $this->groupRelatedByIdGroupTertiary;
    }

    /**
     * Set Unit entity (many to one).
     *
     * @param \Model\Entity\Unit $unit
     * @return \Model\Entity\Product
     */
    public function setUnit(Unit $unit = null)
    {
        $this->unit = $unit;
        return $this;
    }

    /**
     * Get Unit entity (many to one).
     *
     * @return \Model\Entity\Unit
     */
    public function getUnit()
    {
        return $this->unit;
    }

    /**
     * Set the value of unitCustom.
     *
     * @param string $unitCustom
     * @return \Model\Entity\Product
     */
    public function setUnitCustom($unitCustom)
    {
        $this->unitCustom = $unitCustom;

        return $this;
    }

    /**
     * Get the value of descriptionGrid.
     *
     * @return string
     */
    public function getUnitCustom()
    {
        return $this->unitCustom;
    }

    /**
     * @return mixed
     */
    public function getCost()
    {
        return $this->cost;
    }

    /**
     * @param mixed $cost
     */
    public function setCost($cost)
    {
        $this->cost = $cost;
    }

    /**
     * @return string
     */
    public function getCostCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->cost);
    }

    /**
     * @return mixed
     */
    public function getRepresentedCompanies()
    {
        return $this->representedCompanies;
    }

    /**
     * @param mixed $representedCompanies
     */
    public function setRepresentedCompanies($representedCompanies)
    {
        $this->representedCompanies = $representedCompanies;
    }

    /**
     * @param $list
     */
    public function addRepresentedCompanies($list){
        foreach($list as $obj){
            $this->representedCompanies->add($obj);
        }
    }

    /**
     * @param $list
     */
    public function removeRepresentedCompanies($list){
        foreach($list as $obj){
            $this->representedCompanies->removeElement($obj);
        }
    }

    /**
     * @param $obj
     * @return bool
     */
    public function hasCompany($obj){

        if($obj){
            foreach($this->getRepresentedCompanies() as $entity){
                if($entity->getId() == $obj->getId()){
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * @return mixed
     */
    public function getCommission()
    {
        return $this->commission;
    }

    /**
     * @param mixed $commission
     */
    public function setCommission($commission)
    {
        $this->commission = $commission;
    }

    /**
     * @param mixed $commission
     */
    public function getCommissionCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->getCommission());
    }

    /**
     * @return mixed
     */
    public function getSizes()
    {
        return $this->sizes;
    }

    /**
     * @param mixed $sizes
     */
    public function setSizes($sizes)
    {
        $this->sizes = $sizes;
    }

    /**
     * @param $list
     */
    public function addSizes($list){
        foreach($list as $obj){
            $this->sizes->add($obj);
        }
    }

    /**
     * @param $list
     */
    public function removeSizes($list){
        foreach($list as $obj){
            $this->sizes->removeElement($obj);
        }
    }

    /**
     * @param $obj
     * @return bool
     */
    public function hasSize($obj){

        if($obj){
            foreach($this->getSizes() as $entity){
                if($entity->getId() == $obj->getId()){
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * @return mixed
     */
    public function getColors()
    {
        return $this->colors;
    }

    /**
     * @param mixed $colors
     */
    public function setColors($colors)
    {
        $this->colors = $colors;
    }

    /**
     * @param $list
     */
    public function addColors($list){
        foreach($list as $obj){
            $this->colors->add($obj);
        }
    }

    /**
     * @param $list
     */
    public function removeColors($list){
        foreach($list as $obj){
            $this->colors->removeElement($obj);
        }
    }

    /**
     * @param $obj
     * @return bool
     */
    public function hasColors($obj){

        if($obj){
            foreach($this->getColors() as $entity){
                if($entity->getId() == $obj->getId()){
                    return true;
                }
            }
        }

        return false;
    }

	/**
     * @return mixed
     */
    public function getBarcodes()
    {
        return $this->barcodes;
    }

    /**
     * @param mixed $barcodes
     */
    public function setBarcodes($barcodes)
    {
        $this->barcodes = $barcodes;
    }

    /**
     * @param $list
     */
    public function addBarcodes($list){
        foreach($list as $obj){
            $this->barcodes->add($obj);
        }
    }

    /**
     * @param $list
     */
    public function removeBarcodes($list){
        foreach($list as $obj){
            $this->barcodes->removeElement($obj);
        }
    }

    /**
     * @param $obj
     * @return bool
     */
    public function hasBarcode($obj){

        if($obj){
            foreach($this->getBarcodes() as $entity){
                if($entity->getId() == $obj->getId()){
                    return true;
                }
            }
        }

        return false;
    }
	
    /**
     * Get full path for image
     * @return string
     */
    public function getFullImagePath(){
        return static::DEFAULT_PATH . "/" . $this->getImage();
    }

    public function getFullImagePathExtension(){
        return pathinfo($this->getFullImagePath(), PATHINFO_EXTENSION);
    }

    public function getFullImagePathMimeType(){
        return FileUtil::getMimeTypeForExtension($this->getFullImagePathExtension());
    }

    /**
     * Get full path for thumb image
     * @return string
     */
    public function getFullThumbPath(){
        //return static::DEFAULT_PATH . "/product_" . $this->getId() . '_thumb.jpg';
        return static::DEFAULT_PATH . "/" . $this->getId() . '_thumb.' . $this->getFullImagePathExtension();
    }

    public function getFullThumbPathExtension(){
        return pathinfo($this->getFullImagePath(), PATHINFO_EXTENSION);
    }

    public function getFullThumbPathMimeType(){
        return FileUtil::getMimeTypeForExtension($this->getFullImagePathExtension());
    }

    /**
     * Set file resource
     * @param $file
     * @throws \Exception
     */
    public function setFileResource($file, $base64 = false, $extension = "jpg"){

        if(empty($file))
            throw new \Exception("Invalid file");

        if(!file_exists(static::DEFAULT_PATH)){
            mkdir(static::DEFAULT_PATH, 0777, true);
        }

        if ($base64 === true) {

            $imageName = $this->getId() . '.' . $extension;
            $data = base64_decode($file); // base64 decoded image data
            file_put_contents($this->getPathForFile($imageName), $data);

        } else {
            switch($file['type']){
                case "image/jpeg":
                case "image/jpg":
                    $extension = "jpg";
                    break;
                case "image/png":
                    $extension = "png";
                    break;
                case "image/gif":
                    $extension = "gif";
                    break;
                default:
                    throw new \Exception("Formato de arquivo inválido");
            }

            $imageName = $this->getId() . '.' . $extension;
            rename($file['tmp_name'], $this->getPathForFile($imageName));
        }

        $this->setImage($imageName);

        // Resize image
        ImageUtil::resize($this->getFullImagePath(), $this->getFullImagePath(), $extension, 800, 900, 80);

        // Generate thumb
        ImageUtil::resize($this->getFullImagePath(), $this->getFullThumbPath(), $extension, 160, 240, 50);
    }

    /**
     * Get path for file
     * @param $file
     * @return string
     */
    public function getPathForFile($file = ''){
        return static::DEFAULT_PATH . '/' . $file;
    }

    /**
     * Set the value of nickname.
     *
     * @param string $nickname
     * @return \Model\Entity\Product
     */
    public function setNickname($nickname)
    {
        $this->nickname = $nickname;

        return $this;
    }

    /**
     * Get the value of nickname.
     *
     * @return string
     */
    public function getNickname()
    {
        return $this->nickname;
    }

    /**
     * Set the value of descriptionGrid.
     *
     * @param string $descriptionGrid
     * @return \Model\Entity\Product
     */
    public function setDescriptionGrid($descriptionGrid)
    {
        $this->descriptionGrid = $descriptionGrid;

        return $this;
    }

    /**
     * Get the value of descriptionGrid.
     *
     * @return string
     */
    public function getDescriptionGrid()
    {
        return $this->descriptionGrid;
    }

    /**
     * Set the value of amountMinimal.
     *
     * @param float $amountMinimal
     * @return \Model\Entity\Product
     */
    public function setAmountMinimal($amountMinimal)
    {
        $this->amountMinimal = $amountMinimal;

        return $this;
    }

    /**
     * Get the value of amountMinimal.
     *
     * @return float
     */
    public function getAmountMinimal()
    {
        return $this->amountMinimal;
    }

    /**
     * Set the value of pricePromotional.
     *
     * @param float $pricePromotional
     * @return \Model\Entity\Product
     */
    public function setPricePromotional($pricePromotional)
    {
        $this->pricePromotional = $pricePromotional;

        return $this;
    }

    /**
     * Get the value of pricePromotional.
     *
     * @return float
     */
    public function getPricePromotional()
    {
        return $this->pricePromotional;
    }

    /**
     * Set the value of pricePromotionalMin.
     *
     * @param float $pricePromotionalMin
     * @return \Model\Entity\Product
     */
    public function setPricePromotionalMin($pricePromotionalMin)
    {
        $this->pricePromotionalMin = $pricePromotionalMin;

        return $this;
    }

    /**
     * Get the value of pricePromotionalMin.
     *
     * @return float
     */
    public function getPricePromotionalMin()
    {
        return $this->pricePromotionalMin;
    }


    /**
     * Set GridColor entity (many to one).
     *
     * @param \Model\Entity\GridColor $gridColor
     * @return \Model\Entity\GridColorItem
     */
    public function setGridColor(GridColor $gridColor = null)
    {
        $this->gridColor = $gridColor;

        return $this;
    }

    /**
     * Get GridColor entity (many to one).
     *
     * @return \Model\Entity\GridColor
     */
    public function getGridColor()
    {
        return $this->gridColor;
    }

    /**
     * Set GridSize entity (many to one).
     *
     * @param \Model\Entity\GridSize $gridSize
     * @return \Model\Entity\GridSizeItem
     */
    public function setGridSize(GridSize $gridSize = null)
    {
        $this->gridSize = $gridSize;

        return $this;
    }

    /**
     * Get GridSize entity (many to one).
     *
     * @return \Model\Entity\GridSize
     */
    public function getGridSize()
    {
        return $this->gridSize;
    }

    public function setUseValueWeight($useValueWeight)
    {
        $this->useValueWeight = $useValueWeight;

        return $this;
    }

    public function getUseValueWeight()
    {
        return $this->useValueWeight;
    }

    /**
     * Set the value of codeUnitPrimary.
     *
     * @param string $codeUnitPrimary
     * @return \Model\Entity\Product
     */
    public function setCodeUnitPrimary($codeUnitPrimary)
    {
        $this->codeUnitPrimary = $codeUnitPrimary;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCodeUnitPrimary()
    {
        return $this->codeUnitPrimary;
    }


    /**
     * @return array
     */
    public function __sleep()
    {
        return array('id', 'reference', 'code', 'name', 'description', 'id_unit', 'price', 'price_min', 'barcode', 'stock',  'active', 'description_grid', 'amount_minimal', 'price_promotional');
    }

    /**
     * Get array copy
     * @return array
     */
    public function getArrayCopy($entityConfig = null) {

        $arr = array();
        $arr['id'] = $this->getId();
        $arr['image'] = $this->getImage() ? $this->getImage() : "";
        $arr['code'] = $this->getCode() ? $this->getCode() : "";
        $arr['name'] = $this->getName() ? $this->getName() : "";
        $arr['reference'] = $this->getReference() ? $this->getReference() : "";
        $arr['description'] = $this->getDescription() ? $this->getDescription() : "";
        $arr['barcode'] = $this->getBarcode() ? $this->getBarcode() : "";
        $arr['stock'] = $this->getStock() ? $this->getStock() : "";
        $arr['info'] = $this->getInfo() ? $this->getInfo() : "";
        $arr['unit'] = $this->getUnitCustom() ? $this->getUnitCustom() : ($this->getUnit() ? $this->getUnit()->getId() : "");
        $arr['groupPrimary'] = $this->getGroupRelatedByIdGroupPrimary() ? $this->getGroupRelatedByIdGroupPrimary()->getId() : "";
        $arr['groupSecondary'] = $this->getGroupRelatedByIdGroupSecondary() ? $this->getGroupRelatedByIdGroupSecondary()->getId() : "";
        $arr['groupTertiary'] = $this->getGroupRelatedByIdGroupTertiary() ? $this->getGroupRelatedByIdGroupTertiary()->getId() : "";
        $arr['cost'] = (double) $this->getCost();
        $arr['amountMinimal'] = (double) $this->getAmountMinimal();
        $arr['price'] = (double) $this->getPrice();
        $arr['priceMin'] = (double) $this->getPriceMin();
        $arr['commission'] = (double) $this->getCommission();
        $arr['active'] = $this->getActive();
        $arr['created'] = $this->getCreated();
        $arr['updated'] = $this->getUpdated();

        $arr['descriptionGrid'] = $this->getDescriptionGrid();
        $arr['amountMinimal'] = (double) $this->getAmountMinimal();
        $arr['pricePromotional'] = (double) $this->getPricePromotional();
        $arr['pricePromotionalMin'] = (double) $this->getPricePromotionalMin();
        $arr['sync'] = $this->getSync();
        $arr['syncDatetime'] = $this->getSyncDatetime();

        $arr['useValueWeight'] = $this->getUseValueWeight();

        $arr['codeUnitPrimary'] = $this->getCodeUnitPrimary();

        $arrayCompanies = array();
        if(count($this->getRepresentedCompanies()) > 0){
            foreach($this->getRepresentedCompanies() as $rc){
                $arrayCompanies[] = $rc->getId();
            }
        }
        $arr['representedCompanies'] = $arrayCompanies;


        if (is_object($entityConfig) && $entityConfig->getEnableProductGridCenterFunctionality()) {

            if (is_object($this->getGridColor())) {
                $arrayColors = array();
                try {
                    $gridItens = $this->getGridColor()->getGridColorItems();
                    if(count($gridItens) > 0){
                        foreach($gridItens as $ent){
                            if (is_object($ent->getColor()))
                                $arrayColors[] = $ent->getColor()->getId();
                        }
                    }
                    $arr['colors'] = $arrayColors;
                } catch (\Exception $e) {
                    var_dump($e->getMessage());
                }
            }

            if (is_object($this->getGridSize())) {
                $arraySizes = array();
                try {
                    $gridItens = $this->getGridSize()->getGridSizeItems();
                    if(count($gridItens) > 0){
                        foreach($gridItens as $ent){
                            if (is_object($ent->getSize()))
                                $arraySizes[] = $ent->getSize()->getId();
                        }
                    }
                    $arr['sizes'] = $arraySizes;
                } catch (\Exception $e) {
                    var_dump($e->getMessage());
                }
            }

        } else {

            $arrayColors = array();
            if(count($this->getColors()) > 0){
                foreach($this->getColors() as $ent){
                    if (is_object($ent->getColor()))
                        $arrayColors[] = $ent->getColor()->getId();
                }
            }
            $arr['colors'] = $arrayColors;

            $arraySizes = array();
            if(count($this->getSizes()) > 0){
                foreach($this->getSizes() as $ent){
                    if (is_object($ent->getSize()))
                        $arraySizes[] = $ent->getSize()->getId();
                }
            }
            $arr['sizes'] = $arraySizes;

        }
	
		$barcodes = $this->getBarcodes();
		if (count($barcodes) > 0) {
			foreach($barcodes as $ent){
				if ($ent->getCode() != null && $ent->getCode() != "")
					$arr['barcode'] = $arr['barcode'] . (empty($arr['barcode']) ? $ent->getCode() : ",".$ent->getCode());
			}
		}			

        return $arr;
    }

    /**
     * Get array copy datatable
     * @return array
     */
    public function getArrayCopyDT() {

        $arr = array();
        $arr['id'] = $this->getId();
        $arr['code'] = $this->getCode() ? $this->getCode() : "";
        $arr['name'] = $this->getName() ? $this->getName() : "";
        $arr['reference'] = $this->getReference() ? $this->getReference() : "";
        $arr['description'] = $this->getDescription() ? $this->getDescription() : "";
        $arr['barcode'] = $this->getBarcode() ? $this->getBarcode() : "";
        $arr['stock'] = $this->getStock() ? $this->getStock() : "";
        $arr['info'] = $this->getInfo() ? $this->getInfo() : "";
        $arr['unit'] = $this->getUnit() ? $this->getUnit()->getId() : "";
        $arr['groupPrimary'] = $this->getGroupRelatedByIdGroupPrimary() ? $this->getGroupRelatedByIdGroupPrimary()->getId() : "";
        $arr['groupSecondary'] = $this->getGroupRelatedByIdGroupSecondary() ? $this->getGroupRelatedByIdGroupSecondary()->getId() : "";
        $arr['groupTertiary'] = $this->getGroupRelatedByIdGroupTertiary() ? $this->getGroupRelatedByIdGroupTertiary()->getId() : "";
        $arr['cost'] = $this->getCostCurrency();
        $arr['price'] = $this->getPriceCurrency();
        $arr['priceMin'] = $this->getPriceMinCurrency();
        $arr['commission'] = $this->getCommissionCurrency();
        $arr['active'] = $this->getActive();
        $arr['created'] = $this->getCreated() ? $this->getCreated()->format('d/m/Y H:i') : "";
        $arr['updated'] = $this->getUpdated() ? $this->getUpdated()->format('d/m/Y H:i') : "";

        $arr['descriptionGrid'] = $this->getDescriptionGrid() ? $this->getDescriptionGrid() : "";
        $arr['amountMinimal'] = $this->getAmountMinimal();
        $arr['pricePromotional'] = $this->getPricePromotional();
        $arr['sync'] = $this->getSync();
        $arr['syncDatetime'] = $this->getSyncDatetime() ? $this->getSyncDatetime()->format('d/m/Y H:i') : "";

        return $arr;
    }

    public function populateFromSync($arr){

        $this->setName($arr['name']);

        if (isset($arr['code']) && !empty($arr['code']))
            $this->setCode($arr['code']);
        if (isset($arr['reference']) && !empty($arr['reference']))
            $this->setReference($arr['reference']);
        if (isset($arr['description']) && !empty($arr['description']))
            $this->setDescription($arr['description']);
        if (isset($arr['barcode']) && !empty($arr['barcode']))
            $this->setBarcode($arr['barcode']);
        if (isset($arr['stock']) && !empty($arr['stock']))
            $this->setStock($arr['stock']);
        if (isset($arr['info']) && !empty($arr['info']))
            $this->setInfo($arr['info']);
        if (isset($arr['unit']) && is_object($arr['unit']))
            $this->setUnit($arr['unit']);
        if (isset($arr['groupPrimary']) && is_object($arr['groupPrimary']))
            $this->setGroupRelatedByIdGroupPrimary($arr['groupPrimary']);
        if (isset($arr['groupSecondary']) && is_object($arr['groupSecondary']))
            $this->setGroupRelatedByIdGroupSecondary($arr['groupSecondary']);
        if (isset($arr['groupTertiary']) && is_object($arr['groupTertiary']))
            $this->setGroupRelatedByIdGroupTertiary($arr['groupTertiary']);
        if (isset($arr['cost']) && !empty($arr['cost']))
            $this->setCost(floatval($arr['cost']));
        if (isset($arr['price']) && !empty($arr['price']))
            $this->setPrice(floatval($arr['price']));
        if (isset($arr['priceMin']) && !empty($arr['priceMin']))
            $this->setPriceMin(floatval($arr['priceMin']));
        if (isset($arr['pricePromotional']) && !empty($arr['pricePromotional']))
            $this->setPricePromotional(floatval($arr['pricePromotional']));
        if (isset($arr['commission']) && !empty($arr['commission']))
            $this->setCommission(floatval($arr['commission']));
        if (isset($arr['amountMinimal']) && !empty($arr['amountMinimal']))
            $this->setAmountMinimal(floatval($arr['amountMinimal']));
        if (isset($arr['descriptionGrid']) && !empty($arr['descriptionGrid']))
            $this->setDescriptionGrid($arr['descriptionGrid']);

        $this->setSync(false);
    }

    public function populateFromImport($arr) {

        //Codigo Externo;Nome do Grupo;Nome do Subgrupo;Unidade de Medida;Nome do Produto;Referencia do Produto;
        //Descricao do Produto;Preco;Preco Minimo;Preco de Custo;Comissao;Codigo de Barras;Produto Ativo?;
        //Outras Informacoes;ID do Estoque;Quantidade do Estoque

        if (isset($arr[0]))
            $this->setCode(trim($arr[0]));
        //if (isset($arr[1]))
            //Grupo
        //if (isset($arr[2]))
            //Subgrupo
        //if (isset($arr[3]))
            //Unidade
        if (isset($arr[4]))
            $this->setName(trim($arr[4]));
        if (isset($arr[5]))
            $this->setReference(trim($arr[5]));
        if (isset($arr[6]))
            $this->setDescription(trim($arr[6]));
        if (isset($arr[7]))
            $this->setPrice(trim(str_replace(",",".",$arr[7])));
        if (isset($arr[8]))
            $this->setPriceMin(trim(str_replace(",",".",$arr[8])));
        if (isset($arr[9]))
            $this->setCost(trim(str_replace(",",".",$arr[9])));
        if (isset($arr[10]))
            $this->setCommission(trim(str_replace(",",".",$arr[10])));
        if (isset($arr[11]))
            $this->setBarcode(trim($arr[11]));
        if (isset($arr[12]))
            $this->setActive($arr[12]?1:0);
        if (isset($arr[13]))
            $this->setInfo(trim($arr[13]));
        //if (isset($arr[14]))
            //ID estoque
        //if (isset($arr[15]))
            //Qtd estoque

    }

    /**
     * toString method
     * @return string
     */
    public function __toString() {
        return $this->getId() . ' - ' . $this->getName();
    }
}
