<?php

namespace Model\Entity\OAuth2;

use Doctrine\ORM\Mapping as ORM;

/**
 * Jwt
 *
 * @ORM\Entity()
 * @ORM\Table(name="oauth2_jwt")
 */
class Jwt
{
    /**
     * @ORM\Column(name="subject", type="string", length=255, nullable=true)
     *
     * @var string
     */
    private $subject;

    /**
     * @ORM\Column(name="public_key", type="text", nullable=true)
     *
     * @var string
     */
    private $publicKey;

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @var integer
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\OAuth2\Client", inversedBy="jwt")
     * @ORM\JoinColumn(name="client_id", referencedColumnName="id")
     *
     * @var Client
     */
    private $client;

    public function getArrayCopy()
    {
        return array(
            'id' => $this->getId(),
            'client' => $this->getClient(),
            'subject' => $this->getSubject(),
            'publicKey' => $this->getPublicKey(),
        );
    }

    /**
     * Set subject
     *
     * @param string $subject
     * @return Jwt
     */
    public function setSubject($subject)
    {
        $this->subject = $subject;

        return $this;
    }

    /**
     * Get subject
     *
     * @return string
     */
    public function getSubject()
    {
        return $this->subject;
    }

    /**
     * Set publicKey
     *
     * @param string $publicKey
     * @return Jwt
     */
    public function setPublicKey($publicKey)
    {
        $this->publicKey = $publicKey;

        return $this;
    }

    /**
     * Get publicKey
     *
     * @return string
     */
    public function getPublicKey()
    {
        return $this->publicKey;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set client
     *
     * @param Client $client
     * @return Jwt
     */
    public function setClient(Client $client)
    {
        $this->client = $client;

        return $this;
    }

    /**
     * Get client
     *
     * @return Client
     */
    public function getClient()
    {
        return $this->client;
    }
}
