<?php

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;
use Zend\Form\Annotation;

/**
 * Model\Entity\GridSize
 *
 * @ORM\Entity()
 * @ORM\Table(name="`grid_size`")
 */
class GridSize extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="code", type="string", length=40, nullable=true)
     */
    protected $code;

    /**
     * @ORM\Column(type="string", length=100)
     */
    protected $description;
    
    /**
     * @ORM\OneToMany(targetEntity="GridSizeItem", mappedBy="gridSize")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_grid_size", nullable=true)
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $gridSizeItems;

    /**
     * @ORM\OneToMany(targetEntity="Product", mappedBy="gridSize")
     * @ORM\JoinColumn(name="id", referencedColumnName="id_grid_size", nullable=true)
     * @Annotation\Exclude()
     *
     * @JMS\Exclude()
     */
    protected $products;


    public function __construct()
    {
        parent::__construct();
        $this->gridSizeItems = new ArrayCollection();
        $this->products = new ArrayCollection();
    }

    /**
     * Set the value of id.
     *
     * @param integer $id
     * @return \Model\Entity\GridSize
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get the value of id.
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set the value of code.
     *
     * @param string $code
     * @return \Model\Entity\GridSize
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get the value of code.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of description.
     * @param string $description
     * @return \Model\Entity\GridSize
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get the value of description.
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    
    /**
     * Add GridSizeItem entity to collection (one to many).
     *
     * @param \Model\Entity\GridSizeItem $gridSizeItem
     * @return \Model\Entity\GridSize
     */
    public function addGridSizeItem(GridSizeItem $gridSizeItem)
    {
        $this->gridSizeItems[] = $gridSizeItem;
        
        return $this;
    }
    
    /**
     * Remove GridSizeItem entity from collection (one to many).
     *
     * @param \Model\Entity\GridSizeItem $gridSizeItem
     * @return \Model\Entity\GridSize
     */
    public function removeGridSizeItem(GridSizeItem $gridSizeItem)
    {
        $this->gridSizeItems->removeElement($gridSizeItem);
        
        return $this;
    }
    
    /**
     * Get GridSizeItem entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGridSizeItems()
    {
        return $this->gridSizeItems;
    }

    /**
     * Add Product entity to collection (one to many).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\GridSize
     */
    public function addProduct(Product $product)
    {
        $this->products[] = $product;

        return $this;
    }

    /**
     * Remove Product entity from collection (one to many).
     *
     * @param \Model\Entity\Product $product
     * @return \Model\Entity\GridSize
     */
    public function removeProduct(Product $product)
    {
        $this->products->removeElement($product);

        return $this;
    }

    /**
     * Get Product entity collection (one to many).
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProducts()
    {
        return $this->products;
    }

    /**
     * To string
     * @return string
     */
    public function __toString() {
        return $this->getDescription();
    }

    public function __sleep()
    {
        return array('id', 'code', 'description');
    }
}
