<?php

/**
 * Auto generated by MySQL Workbench Schema Exporter.
 * Version 2.1.5-dev (doctrine2-annotation) on 2014-10-22 00:16:27.
 * Goto https://github.com/johmue/mysql-workbench-schema-exporter for more
 * information.
 */

namespace Model\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Model\Entity\Cashier
 *
 * @ORM\Entity()
 * @ORM\Table(name="`cashier`", indexes={ @ORM\Index(name="filter_idx", columns={"cashierDate"}) })
 */
class Cashier extends AbstractEntity
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(name="description", length=100, type="string", nullable=true)
     */
    protected $description;

    /**
     * @ORM\Column(type="datetime")
     */
    protected $cashierDate;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $totalInput;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $totalOutput;

    /**
     * @ORM\Column(type="decimal", precision=19, scale=2)
     *
     * @JMS\Type("double")
     */
    protected $total;

    /**
     * @ORM\Column(name="info", type="text", nullable=true)
     */
    protected $info;

    /**
     * @ORM\OneToMany(targetEntity="CashierExpense", mappedBy="cashier", cascade={"persist", "merge", "remove"})
     * @ORM\JoinColumn(name="id", referencedColumnName="id_cashier")
     *
     * @JMS\Type("Model\Entity\CashierExpense")
     */
    protected $cashierExpenses;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="orders")
     * @ORM\JoinColumn(name="id_user", referencedColumnName="id", nullable=false)
     *
     * @JMS\Type("Model\Entity\User")
     */
    protected $user;
    
    /**
     * @ORM\ManyToOne(targetEntity="Model\Entity\Device")
     * @ORM\JoinColumn(name="id_device", referencedColumnName="id", nullable=true)
     *
     * @JMS\Type("Model\Entity\Device")
     */
    protected $device;

    /**
     * @ORM\Column(name="longitude", type="decimal", precision=19, scale=8, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $longitude;

    /**
     * @ORM\Column(name="latitude", type="decimal", precision=19, scale=8, nullable=true)
     *
     * @JMS\Type("double")
     */
    protected $latitude;


    public function __construct()
    {
        parent::__construct();
        $this->cashierProducts = new ArrayCollection();
    }


    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    public function getId()
    {
        return $this->id;
    }

    public function getDescription() {
        return $this->description;
    }

    public function setDescription($description) {
        $this->description = $description;
    }

    public function setCashierDate($cashierDate)
    {
        $this->cashierDate = $cashierDate;

        return $this;
    }

    public function getCashierDate()
    {
        return $this->cashierDate;
    }

    public function getCashierDateFormatted()
    {
        return $this->cashierDate ? $this->cashierDate->format('d/m/Y H:i') : "";
    }


    public function setTotalInput($totalInput)
    {
        $this->totalInput = $totalInput;

        return $this;
    }

    public function getTotalInput()
    {
        return $this->totalInput;
    }

    public function getTotalInputCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->totalInput);
    }

    public function getTotalInputCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->totalInput);
    }


    public function setTotalOutput($totalOutput)
    {
        $this->totalOutput = $totalOutput;

        return $this;
    }

    public function getTotalOutput()
    {
        return $this->totalOutput;
    }

    public function getTotalOutputCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->totalOutput);
    }

    public function getTotalOutputCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->totalOutput);
    }


    public function setTotal($total)
    {
        $this->total = $total;

        return $this;
    }

    public function getTotal()
    {
        return $this->total;
    }

    public function getTotalCurrency()
    {
        return \Commons\Util\StringUtils::formatMoney($this->total);
    }

    public function getTotalCurrencyBRL()
    {
        return \Commons\Util\StringUtils::formatMoneyBRL($this->total);
    }

    public function getInfo() {
        return $this->info;
    }

    public function setInfo($info) {
        $this->info = $info;
    }

    public function addCashierExpense(CashierExpense $cashierExpense)
    {
        $this->cashierExpenses[] = $cashierExpense;

        return $this;
    }

    public function removeCashierExpense(CashierExpense $cashierExpense)
    {
        $this->cashierExpenses->removeElement($cashierExpense);

        return $this;
    }

    public function getCashierExpenses()
    {
        return $this->cashierExpenses;
    }

    public function getDevice() {
        return $this->device;
    }

    public function setDevice($device) {
        $this->device = $device;
    }

    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    public function getUser()
    {
        return $this->user;
    }

    public function getLatitude()
    {
        return $this->latitude;
    }

    public function setLatitude($latitude)
    {
        $this->latitude = $latitude;
    }

    public function getLongitude()
    {
        return $this->longitude;
    }

    public function setLongitude($longitude)
    {
        $this->longitude = $longitude;
    }

    public function __sleep()
    {
        return array('id', 'cashierDate', 'totalInput', 'totalOutput', 'total');
    }
}