<?php
/**
 * Description of AbstractEntity
 *
 * @author renatopeterman
 */

namespace Model\Entity;

use Commons\Util\DateTimeBr;
use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation as JMS;
use Zend\Form\Annotation;

/** 
 * @ORM\MappedSuperclass
 * @ORM\HasLifecycleCallbacks
 */
class AbstractEntity {

    /*
     * @Annotation\Type("Zend\Form\Element\Checkbox")
     * @Annotation\Options({"label":"Ativo?:"})
     * @Annotation\Exclude()
     * */

    /**
     * @ORM\Column(name="active", type="boolean", nullable=true, options={"default" = 1})
     * @JMS\Type("boolean")
     */
    protected $active;

    /**
     * @ORM\Column(name="created", type="datetime")
     * @Annotation\Exclude()
     *
     * @JMS\Type("DateTime")
     */
    protected $created;
    
    /**
     * @ORM\Column(name="updated", type="datetime", nullable=true)
     * @Annotation\Exclude()
     *
     * @JMS\Type("DateTime")
     */
    protected $updated;

    /**
     * @ORM\Column(name="sync", type="boolean", nullable=true)
     * @Annotation\Exclude()
     *
     * @JMS\Type("boolean")
     */
    protected $sync;

    /**
     * @ORM\Column(name="sync_datetime", type="datetime", nullable=true)
     * @Annotation\Exclude()
     *
     * @JMS\Type("DateTime")
     */
    protected $syncDatetime;

    /**
     * @ORM\PreUpdate
     */
    public function preUpdate()
    {
        $this->setUpdated(new DateTimeBr());
    }

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->setCreated(new DateTimeBr());
        if ($this->getSync() !== true)
            $this->setSync(false);
    }

    public function __construct(){

    }

    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    public function getActive()
    {
        return $this->active;
    }

    public function getCreated() {
        return $this->created;
    }

    public function setCreated($created) {
        $this->created = $created;
    }

    public function getUpdated() {
        return $this->updated;
    }

    public function setUpdated($updated) {
        $this->updated = $updated;
    }

    public function getSync() {
        return $this->sync;
    }

    public function setSync($sync) {
        $this->sync = $sync;
    }

    public function getSyncDatetime() {
        return $this->syncDatetime;
    }

    public function setSyncDatetime($syncDatetime) {
        $this->syncDatetime = $syncDatetime;
    }

    public function getCreatedFormat($format = 'd/m/Y H:i'){
        return $this->getCreated() ? $this->getCreated()->format($format) : "";
    }

    public function getUpdatedFormat($format = 'd/m/Y H:i'){
        return $this->getUpdated() ? $this->getUpdated()->format($format) : "";
    }

    public function getCreatedDatetimeStr(){
        return $this->getCreatedFormat('d/m/Y H:i');
    }

    public function getUpdatedDatetimeStr(){
        return $this->getUpdatedFormat('d/m/Y H:i');
    }

    /* Commons Methods */
    
    public function populate($data){
        foreach($data as $key => $value){
            $this->__set($key, $value);
        }
    }
    
    public function getArrayCopy(){
        $array = get_object_vars($this);
        unset($array['__initializer__']);
        unset($array['__cloner__']);
        unset($array['__isInitialized__']);
        return $array;
    }
    
    public function __get($name) {
        if(property_exists($this, $name)){
            return $this->$name;
        }
        return null;
    }
    
    public function __set($name, $value) {
        if(property_exists($this, $name)){
            return $this->$name = $value;
        }
        return null;
    }
}

?>
