<?php

/**
 * Description of Validator
 *
 * @author Renato Peterman <renato.pet at gmail.com>
 */

namespace Commons\Util;

class Validator {

    public static function cnpj($cnpj) {
        $cnpj = str_pad(str_replace(array('.', '-', '/'), '', $cnpj), 14, '0', STR_PAD_LEFT);
        if (strlen($cnpj) != 14) {
            return false;
        } else {
            for ($t = 12; $t < 14; $t++) {
                for ($d = 0, $p = $t - 7, $c = 0; $c < $t; $c++) {
                    $d += $cnpj{$c} * $p;
                    $p = ($p < 3) ? 9 : --$p;
                }
                $d = ((10 * $d) % 11) % 10;
                if ($cnpj{$c} != $d) {
                    return false;
                }
            }
            return true;
        }
    }

}

?>
