<?php

/**
 * Url checks methods
 *
 * @author renatopeterman
 */

namespace Commons\Util;

class UrlChecker {

    public static function isAlive($url) {

        # check, if a valid url is provided
        if (!filter_var($url, FILTER_VALIDATE_URL)) {
            return false;
        }
        
        # Parse URL
        $url = parse_url($url);
        $urlToRequest = $url['scheme'] . '://' . $url['host'];
        
        # initialize curl
        $curlInit = curl_init($urlToRequest);
        curl_setopt($curlInit, CURLOPT_PORT, $url['port']);
        curl_setopt($curlInit, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($curlInit, CURLOPT_HEADER, true);
        curl_setopt($curlInit, CURLOPT_NOBODY, true);
        curl_setopt($curlInit, CURLOPT_RETURNTRANSFER, true);

        # get answer
        $response = curl_exec($curlInit);

        curl_close($curlInit);

        if ($response)
            return true;

        return false;
    }

}

?>
